
//VARIABLES GLOBALES
const actvenv = 'prd';
const env = {
    'local': {
        url: 'https://vpskromasys2.hostnetcom.com/~hipicas/dev/',
        redirecturl: './'
    },
    'dev': {
        url: './',
        redirecturl: './'
    },
    'prd': {
        url: './',
        redirecturl: './'
    }
};
const globalurl = env[actvenv]['url'];
const redirecturl = env[actvenv]['redirecturl'];
//Asignamos un evento a la carga del main
document.addEventListener("DOMContentLoaded", function () {
    //Validamos que la pantalla activa pertenezca al home
    if (['home', 'system', 'masters','records','reports'].indexOf(getParameterByName("id")) > -1) {
        menuInit();
    }
});

//Esta función valida si los registros exceden el tamaño de la tabla y si es así reduce el width del header para alinear las columnas
function validTblScroll(cnt) {
    let tbl = cnt.querySelector("#pgTbl");
    if (tbl != null && tbl != undefined) {
        let tblsize = tbl.querySelector("tbody,.tbody").offsetHeight;
        let scrollsize = tbl.querySelector("tbody,.tbody").scrollHeight;
        if (tblsize < scrollsize) {
            tbl.querySelector("thead,.thead").style.width = "calc(100% - 7px)";
        } else {
            tbl.querySelector("thead,.thead").style.width = "";
        }
    }
}

// MANEJO DEL WAITSCREEN
var waiting = [];//CONTROLAMOS CANTIDAD DE SERVICIOS QUE SE LLAMAN
//MOSTRAMOS EL WAIT
function wsOn(id) {
    /*WAIT on*/
    var wait = document.createElement("div");
    wait.classList.add("waitScreen");
    wait.innerHTML = '<i class="fas fa-circle-notch fa-spin"></i>';
    wait.setAttribute("id", "waitScreen");
    setTimeout(function () {
        wait.style.opacity = "1";
    }, 300, wait);
    //Si es la primera carga mostramos el wait, si no, solo lo insertamos al arreglo controlador
    if (waiting.length == 0) document.body.appendChild(wait);

    waiting.push(id);
}
//OCULTAMOS EL WAIT
function wsOff() {
    setTimeout(function () {

        //Borramos la carga de uno de los wait pero no ocultamos hasta que sea el último
        waiting.splice(-1, 1);
        if (waiting.length > 0) return;
        var waitScreen = document.getElementById("waitScreen");
        waitScreen.style.opacity = "";
        setTimeout(function () {
            document.body.removeChild(waitScreen);
        }, 300, waitScreen);
    }, 500);
}
//-------//

//MENU - FUNCIONES ASOCIADAS AL MANEJO DEL MENU LATERAL
//Inicializar eventos y primera carga
function menuInit() {
    //Si detectamos un nombre y el campo para mostrarlo se agrega
    if (localStorage.getItem("name") != undefined && document.getElementById("lgtName") != undefined) {
        document.getElementById("lgtName").innerText = localStorage.getItem("name");
    }
    //Asignamos el evento al logout del "header"
    let logout = document.getElementById("logoutBtn")
    if (logout != undefined && logout != null) {
        logout.addEventListener("click", function () {
            showPopup("popupLogout");
            //Si el usuario pulsa el logout mostramos la confirmación
            //showPopup("popLogoutCnf");
        });
    }
    //EVENTO DE BOTONES DEL POPUP DE LOGOUT CONFIRMACIÓN Y CANCELAR
    let logoutPopup = document.getElementById("popupLogout");
    if (logoutPopup != undefined && logoutPopup != null) {
        document.getElementById("lgtBtnCnf").addEventListener("click", function () {
            //En caso de todo exitoso con el logout api redireccionará hacia el login
            logoutAPI();
        });
        document.getElementById("lgtBtnBack").addEventListener("click", function () {
            //Cierra los popups activos en este caso el logout
            closePopups();
        });
    }


    //Asignamos volver al home si le da al logo
    let logobtn = document.getElementById("menuLogo")
    if (logobtn != undefined && logobtn != null) {
        logobtn.addEventListener("click", function () {
            gotoPage('home', '', {});

        });
    }


    //Cargamos las opciones del menú
    menuAPI();
}
//Lamamaos al servicio que nos retorna las opciones a pintar en el menu
function menuAPI() {
    //Definimos los parámetros
    var par = {};
    par.sessionid = localStorage.sessionid;
    //Funcion si todo en la llamada al servicio y se obtiene respuesta
    let onsuccess = (rsp) => {
        switch (rsp.status) {
            case 200:
                data = JSON.parse(rsp.response);
                //Pintamos las opciones del menú
                menuDraw(data.options);
                console.log(data);
                break;
            case 401:
                localStorage.clear();
                gotoPage('login', '', {});
                break;
            default:
                data = JSON.parse(rsp.response);
                break;
        }
    }
    //Lamamos al servicio si todo sale ok se ejecuta el onsuccess si falla sale por el catch
    callWS("POST", "menus/list", par).then(onsuccess).catch((e) => { console.log("Ocurrió un error " + e) });
}
//Pintamos las opciones en el menú lateral una vez que recibimos la data
function menuDraw(rsp) {
    var tbl = document.getElementById("optsTblMenu");
    var ele = tbl.children[0].cloneNode(true);
    tbl.innerHTML = "";
    if (rsp.length > 0) {
        for (var i = 0; i < rsp.length; i++) {
            var clone = ele.cloneNode(true);
            clone.style.display = "";
            clone.removeAttribute("selected");
            clone.removeAttribute("disabled");
            clone.removeAttribute("open");
            clone.removeAttribute("id");
            clone.querySelectorAll(".menuSuboptCnt")[0].style.height = "";
            if (rsp[i].content == getParameterByName("id")) clone.setAttribute("selected", 1);
            //Asignamos la opción del menú que corresponde y el evento de abrir y cerrar el submenu para cada uno
            clone.querySelectorAll(".menuOpt")[0].firstElementChild.innerHTML = rsp[i].imgfont;
            clone.querySelectorAll(".menuOpt")[0].lastElementChild.innerText = rsp[i].dsc;

            if (rsp[i].access) {
                clone.querySelectorAll(".menuOpt")[0].addEventListener("click", function () {
                    handlerMenuOpt(this.parentElement)
                });
            } else {
                clone.setAttribute("disabled", "");
            }

            clone.querySelectorAll(".menuSuboptCnt")[0].innerHTML = "";
            rsp[i].submenu.forEach(ele => {
                //Aca pintamos las opciones dentro de cada menu
                var submenu = document.createElement("div");
                submenu.classList.add("menuSubopt");
                submenu.innerText = ele.dsc;
                submenu.removeAttribute("selected");
                submenu.removeAttribute("disabled");

                //Asignamos la referencia a los archivos para redireccionar a la pagina que corresponde
                if (ele.submenu.length > 0) {
                    //Definimos el sid para redireccionar al submenu que correpondas
                    let validsumenus = ele.submenu.filter(e => e.access);
                    if (validsumenus.length > 0 && ele.access) {
                        if ((rsp[i].content == getParameterByName("id")) && (ele.content == getParameterByName("sid").split("/")[0]) && (getParameterByName("sid") != '')) {
                            submenu.setAttribute("selected", 1);//Validamos la opción seleccionada
                            //Si la opcione valida contiene submenu pintamos las opciones al header
                            menuHeadDraw(ele, ele.submenu);
                        }

                        let filename = (ele.content) + "/" + validsumenus[0].content;
                        if (ele.content != "") submenu.setAttribute("url", (rsp[i].content + "/" + filename));
                    } else {
                        submenu.setAttribute("disabled", "");
                    }
                } else {
                    if ((rsp[i].content == getParameterByName("id")) && ele.content == getParameterByName("sid") && getParameterByName("sid") != "") submenu.setAttribute("selected", 1);//Validamos la opción seleccionada
                    submenu.setAttribute("url", (rsp[i].content + "/" + ele.content));


                    if (!ele.access) submenu.setAttribute("disabled", "");
                }

                //Asignamos el evento al click de las opciones del menu
                submenu.addEventListener("click", function () {
                    //Si el usuario pulsa una opción del menú redireccionamos 
                    if (this.getAttribute("url") != "/" && this.getAttribute("url") != undefined && this.getAttribute("disabled") == undefined) {
                        let arrurl = this.getAttribute("url").split("/");
                        gotoPage(arrurl[0], (arrurl.length >= 3) ? arrurl[1] + "/" + arrurl[2] : arrurl[1], {});
                    }
                });
                //Insertamos la opcion
                clone.querySelectorAll(".menuSuboptCnt")[0].appendChild(submenu);
            });


            tbl.appendChild(clone);
        }
    } else {
        ele.style.display = "none";
        tbl.appendChild(ele);
    }

    //ALWAYS insert close btn
    var clone = ele.cloneNode(true);
    clone.style.display = "";
    clone.removeAttribute("selected");
    clone.removeAttribute("disabled");
    clone.removeAttribute("open");
    clone.setAttribute("id", "closeMenuBtn");
    clone.querySelectorAll(".menuSuboptCnt")[0].style.height = "";
    clone.querySelectorAll(".menuOpt")[0].addEventListener("click", function () {
        showHideMenu()
    });
    //Asignamos la opción del menú que corresponde y el evento de abrir y cerrar el submenu para cada uno
    clone.querySelectorAll(".menuOpt")[0].firstElementChild.innerHTML = '<i class="fa-solid fa-angle-left"></i>';
    clone.querySelectorAll(".menuOpt")[0].lastElementChild.innerText = 'Colapsar';
    tbl.appendChild(clone);
    
    //Ocultamos el menu por default
    if(getParameterByName("id") != 'home') showHideMenu();

}
//Pintamos las opciones del header menú "pestañas" en caso de que existan
function menuHeadDraw(menu, rsp) {
    var tbl = document.getElementById("headSubmenuTbl");
    tbl.innerHTML = "";//Blanqueamos las opciones del menu del header
    if (rsp.length > 0) {
        for (var i = 0; i < rsp.length; i++) {
            //Pintamos las opciones del submenu
            var clone = document.createElement("div");
            clone.classList.add("headSubmOpt");
            clone.innerText = rsp[i].dsc;
            //Atributo URL
            clone.setAttribute("url", menu.content + "/" + rsp[i].content);
            if (rsp[i].access) {
                //Asignamos el evento al click de las opciones del menu
                clone.addEventListener("click", function () {
                    //Si el usuario pulsa una opción del menú redireccionamos 
                    if (this.getAttribute("url") != "/" && this.getAttribute("url") != undefined && this.getAttribute("selected") != 1) {
                        let arrurl = this.getAttribute("url").split("/");
                        gotoPage(getParameterByName("id"), (arrurl.length >= 2) ? arrurl[0] + "/" + arrurl[1] : arrurl[1], {});
                    }

                });
            } else {
                clone.setAttribute("disabled", "");
            }
            //Marcamos la seleccionada
            let sidarr = getParameterByName("sid").split("/");
            if (((sidarr.length > 1) ? sidarr[1] : sidarr[0]) == rsp[i].content) clone.setAttribute("selected", 1);

            tbl.appendChild(clone);
        }
    }
}
//Funcion para el manejo abrir y cerrar opciones del menu
function handlerMenuOpt(ele) {
    if (Boolean(parseFloat(ele.getAttribute("open")))) {
        ele.setAttribute("open", 0);
        ele.querySelectorAll(".menuSuboptCnt")[0].style.height = "0";
    } else {
        ele.setAttribute("open", 1);

        var height = 0;
        ele.querySelectorAll(".menuSubopt").forEach(e => {
            height = height + ele.offsetHeight;
        });
        ele.querySelectorAll(".menuSuboptCnt")[0].style.height = height + "px";

        let cnt = document.querySelector(".menuCnt");
        if (cnt.classList.contains("closed")) { 
            showHideMenu();
        }
    }
}
//Función que valida si existe el header para colocar el titulo e inserta el valor que recibe
function setHeadTit(tit) {
    let headtit = document.getElementById("headTit");
    if (headtit != undefined && headtit != null) {
        headtit.innerText = tit;
    }
}
function showHideMenu() {
    let cnt = document.querySelector(".menuCnt");
    if (cnt.classList.contains("closed")) {
        cnt.classList.remove("closed");
        document.getElementById("closeMenuBtn").querySelector(".menuOpt").firstElementChild.innerHTML = '<i class="fa-solid fa-angle-left"></i>';
    } else {
        cnt.classList.add("closed");
        document.getElementById("closeMenuBtn").querySelector(".menuOpt").firstElementChild.innerHTML = '<i class="fa-solid fa-angle-right"></i>';
        document.querySelectorAll(".menuSuboptCnt").forEach(sbm => {
            sbm.style.height = "";
        });

    }
}
//-----hasta acá-------//

//POPUPS - FUNCIONES ASOCIADAS AL MANEJO DE POPUPS
//ABRIR POPUP
async function showPopup(id, hideall = true) {
    if(hideall) await closePopups();//Cerramos primero el popupanterior, una vez cerrado cambiamos el display
    var activo = document.getElementById(id);
    activo.style.display = "flex";
    return new Promise((todook, todonook) => {
        setTimeout(() => {
            //Es peramos un para de miliseg y añadimos la clase del opacity y que determina el a
            document.getElementById(id).style.opacity = "1";
            let fields = document.getElementById(id).querySelectorAll("input:not([readonly])");
            if (fields.length > 0) {
                focusIn(fields[0]);
            }
            todook("abierto: " + id);
        }, 100, id);
    });
}
//CERRAR POPUP
function closePopups() {
    //Se cierran todos
    return new Promise((todook, todonook) => {
        //Obtenemos todos los formularios y los ocultamos llevandolos al estilo por default (removiendo styles)
        var forms = document.getElementsByClassName("popup");
        //Ocultamos primero el opacity para efecto de transicion
        for (var i = 0; i < forms.length; i++) {
            forms[i].style.opacity = "";
        }
        setTimeout(() => {
            //Luego quitamos el display pasados los 3s de la transición
            for (var i = 0; i < forms.length; i++) {
                forms[i].style.display = "";
            }
            todook("Todo ok");
        }, 300, forms)
    });

    //Si se cierra todo ok, el then abre el activo
    //return (Promise.all([cerrarP]).then(values => { }));
}
//-----hasta acá------//

//FUNCION GLOBAR PARA MANEJO DE ERROR EN FRONT, MOSTRAR MENSAJE Y REMARCAR CAMPO 
//Recibe un id o un campo, el mensaje y la duración por default 5s si es 0 se mantiene fijo
function errInpt(id, msg, time = 5000) {
    let inptcnt = (typeof id === "string") ? document.getElementById(id).parentElement : id;
    let timeout = false;
    //Validamos que el inpt cumple el formato
    if (inptcnt.classList.contains("logInptCnt") || inptcnt.classList.contains("popInptCnt") ||
        inptcnt.classList.contains("poupDelItemLbl") || inptcnt.classList.contains("searchSct") ||
        inptcnt.classList.contains("errmsgSct") || inptcnt.classList.contains("vscomp-toggle-button")
    ) {
        let msgLbl = document.createElement("div");
        msgLbl.innerText = msg;
        msgLbl.classList.add("errMsgLbl");
        //Validamos que solo se inserte una vez por campo
        if (inptcnt.querySelectorAll('.errMsgLbl').length == 0) {
            timeout = true;
            inptcnt.appendChild(msgLbl);
        } else if (inptcnt.querySelectorAll('.errMsgLbl').length > 0) {
            //Si ya existe cambiamos el mensaje
            inptcnt.querySelectorAll('.errMsgLbl')[0].innerText = msg;
        }
    } else {
        console.log("Campo no contiene formato válido");
        return;
    }

    if (time > 0 && timeout) {
        setTimeout(function () {
            errBlank(id);
        }, time, id);
    }
}
//Remueve el formato de error de un campo y el mensaje
function errBlank(id) {
    let inptcnt = (typeof id === "string") ? document.getElementById(id).parentElement : id;
    //Si existe el mensaje de error lo removemos
    if (inptcnt.querySelectorAll('.errMsgLbl').length > 0)
        inptcnt.removeChild(inptcnt.querySelectorAll('.errMsgLbl')[0]);
}
//Recibe un campo y lo resaltat en rojo formato de valor invalido en edición de lineas por tabla
function errRowInpt(id, time = 5000) {
    let inptcnt = (typeof id === "string") ? document.getElementById(id).parentElement : id;
    let timeout = false;
    //Validamos que el inpt cumple el formato
    if (inptcnt.classList.contains("popInpt") || inptcnt.classList.contains("tblInpt") || inptcnt.classList.contains("vscomp-toggle-button")) {
        timeout = true;
        inptcnt.style.borderColor = "var(--errColor)";
    } else {
        console.log("Campo no contiene formato válido");
        return;
    }

    if (time > 0 && timeout) {
        setTimeout(function () {
            errRowBlank(id);
        }, time, id);
    }
}
//Remueve el formato de error de un campo y el mensaje
function errRowBlank(id) {
    let inptcnt = (typeof id === "string") ? document.getElementById(id).parentElement : id;
    inptcnt.removeAttribute("style");
}
//Función para mostrar un mensaje de error en la parte superior de la tabla
function errTbl(cnt, msg, time = -1) {
    var padre = document.createElement("div");
    padre.classList.add("tblMsgErr");
    var span = document.createElement("span");
    span.classList.add("errMsgLbl");
    span.innerText = msg;
    padre.appendChild(span);
    //Si no fue insertado ya en este momento, se agrega
    if (!cnt.parentElement.children[0].classList.contains("tblMsgErr")) {
        cnt.parentElement.insertBefore(padre, cnt.parentElement.children[0]);
        if (time > 0) {
            setTimeout(function () {
                errTblBlank(cnt.parentElement);
            }, time, cnt.parentElement);
        }
    }
}
function errTblBlank(cnt) {
    if (cnt.querySelector(".tblMsgErr")) {
        cnt.removeChild(cnt.querySelector(".tblMsgErr"));
    }
}
//---hasta acá---///

//Validamos si a un campo le faltan los privilegios para mostrar los datos y se muestra el mensaje
function hasPrivileges(id, msg) {
    //Validamos si no tiene privilegios para ver estados y lo marcamos
    if (document.getElementById(id).getAttribute("privileges") == '-1') {
        errInpt(id, msg, 0);
    }
}
//FUNCION GLOBAL PARA MENSAJE DE ACCIÓN EXITOSA - tiempo en milisegundos 
function successMsgShow(msg = "Evento ejecutado con éxito", time = 5000) {
    var msgbox = document.createElement("div");
    msgbox.classList.add("successMsgBox");
    msgbox.style.animationDuration = (time / 1000) + "s";
    var iccnt = document.createElement("span");
    iccnt.innerHTML = '<i class="fa-solid fa-circle-check"></i>';
    var msgcnt = document.createElement("span");
    msgcnt.innerHTML = msg;
    msgbox.appendChild(iccnt); msgbox.appendChild(msgcnt);
    document.body.appendChild(msgbox);
    if (time > 0) {
        setTimeout(function () {
            document.body.removeChild(document.body.querySelector(".successMsgBox"));
        }, time);
    }
}
//FUNCIÓN PARA PINTAR EL FORMATO DE LAS PAGINAS EN BASE A LA UBICACIÓN ACTUAL Y NRO DE RECORDS
const range = (start, end, length = end - start + 1) => Array.from({ length }, (_, i) => start + i);
function drawPags(tbl, numofrec, recpage = 10, actpage = 1, onsuccess = () => { }) {
    actpage = parseFloat(actpage);
    let totpages = Math.ceil(numofrec / recpage);
    let pagcnt = tbl.querySelector(".pagSct");
    if (pagcnt != null || pagcnt != undefined) {
        //Si no tiene más de una pagina no se muestra el paginado
        if (totpages > 1) pagcnt.style.visibility = "";
        else pagcnt.style.visibility = "hidden";
        //Siempre que pintamos blanqueamos nuevamente las paginas
        let pageNumcnt = pagcnt.querySelector(".pagBoxNums");
        pageNumcnt.innerHTML = "";

        //FUNCION PARA INSERTAR LOS VALORES
        let insertNum = (n) => {
            var nwPag = document.createElement("span");
            nwPag.classList.add("pagNum");
            if (n == actpage) nwPag.setAttribute("selected", "1");
            if (!isNaN(n)) {
                nwPag.addEventListener("click", function () {
                    drawPags(document.querySelector(".pgSctTbl"), parseFloat(document.getElementById("pagTotrec").innerText), 10, parseFloat(this.innerText));
                    onsuccess();
                });
            }
            nwPag.innerText = n;
            pageNumcnt.appendChild(nwPag);
        }

        //SE CALCULAN LOS VALORES, EL TOTAL DEL RANGO Y SE INSERTA EL FORMATO
        let max = (totpages > 6) ? ((actpage + 2) < 6 ? 6 : (actpage + 2)) : totpages;
        if (totpages > 6 && actpage >= 4) insertNum('...');
        let rango = range((totpages > 6 && actpage >= 4) ? ((actpage + 2) < totpages ? max - 4 : totpages - 5) : 1, ((actpage + 2) < totpages ? max : totpages));
        rango.forEach(n => {
            insertNum(n);
        });

        if (totpages > 6 && (actpage + 2) < totpages) insertNum('...');

        //Valdamos la nueva posición de la página para desactivar las flechas si está al incio o al final
        if (actpage == totpages) tbl.querySelector(".pagBoxNext").classList.add("arrowDis");
        else tbl.querySelector(".pagBoxNext").classList.remove("arrowDis");
        //Valdamos la nueva posición de la página para desactivar las flechas si está al incio o al final
        if (actpage == 1) tbl.querySelector(".pagBoxPrev").classList.add("arrowDis");
        else tbl.querySelector(".pagBoxPrev").classList.remove("arrowDis");
    }

    //Se setean los valores del lbl del paginado. Rango que se muestra y total de registros
    let pagrange = document.getElementById("pagRange");
    if (pagrange != null) pagrange.innerText = (actpage * recpage) - (recpage - 1) + " - " + (numofrec < (actpage * recpage) ? numofrec : (actpage * recpage));

    let totrec = document.getElementById("pagTotrec");
    if (totrec != null) totrec.innerText = numofrec;

    //Validamos el scroll
    validTblScroll(tbl);
}
//FUNCIÓN PARA ASIGNACIÓN DE EVENTOS ARROW DEL PAGINADO
function initPagsEvent(tbl, onsuccess) {
    let movePage = (val) => {
        let recpage = 10;
        let actpage = parseFloat(tbl.querySelector(".pagNum[selected]").innerText);
        let lastpage = Math.ceil(parseFloat(document.getElementById("pagTotrec").innerText) / recpage);
        var pag = 1;
        if (val == 'last') {
            pag = lastpage;
            drawPags(tbl, parseFloat(document.getElementById("pagTotrec").innerText), recpage, pag);
        } else if (val == 'first') {
            pag = 1;
            drawPags(tbl, parseFloat(document.getElementById("pagTotrec").innerText), recpage, pag);
        } else {
            pag = actpage + (parseFloat(val));

            tbl.querySelector(".pagNum[selected]").removeAttribute("selected");
            tbl.querySelectorAll(".pagNum").forEach((p) => {
                if (parseFloat(p.innerText) == pag) p.setAttribute("selected", "");
            });
        }

        onsuccess();
    }
    tbl.querySelectorAll(".pagArrow").forEach((pag) => {
        pag.addEventListener("click", function () {
            if (!this.parentElement.classList.contains("arrowDis")) {
                movePage(this.getAttribute("value"));
            }
        });
    });
}
//FUNCION GLOBAL PARA MANEJO DE ORDENAMIENTO DE LAS TABLAS
function initOrders(tbl, onsuccess) {
    //Buscamos todas las columnas con valor de ordenamiento
    tbl.querySelectorAll(".orderCol[colval]").forEach((e) => {
        //Asignamos el evento click al orden
        e.addEventListener("click", function () {
            //Siempre que clickeamos se remueve el icono antes de validarse nuevamente
            tbl.querySelectorAll(".orderCol i").forEach(i => { i.parentElement.removeChild(i) });

            //Se valida si se pulsa la misma columna o una nueva
            if (this.getAttribute("selected") != null && this.getAttribute("selected") != undefined) {
                this.setAttribute("colval", this.getAttribute("colval") * -1);
            } else {
                //Si es una columna nueva se resetean los valores de las demás
                tbl.querySelectorAll(".orderCol[colval]").forEach((col) => {
                    col.removeAttribute("selected");
                    col.setAttribute("colval", Math.abs(col.getAttribute("colval")));
                });
                //Se setea el nuevo valor seleccionado en caso de cambio
                this.setAttribute("selected", "");
            }
            //Se valida el sentido del orden que se está calculando y se inserta el icono correspondiente
            let dir = (tbl.querySelector(".orderCol[selected]").getAttribute("colval") * 1) > 0;
            let ic = document.createElement("i");
            ic.classList.add("fa-solid", (dir ? "fa-sort-up" : "fa-sort-down"));
            tbl.querySelector(".orderCol[selected]").appendChild(ic);
            //Se ejecuta la función de "refrescamiento" que se recibe como parametro si el proceso de ordenamiento funciona todo ok
            onsuccess();
        });
    });
}
//FUNCION PARA REINICIAR EL ORDEN AL  AÑADIR / O INGRESAR FECHA DE CREACIÓN
function resetOrder(tbl) {
    return new Promise((resolve, reject) => {
        //Buscamos todas las columnas con valor de ordenamiento
        tbl.querySelectorAll(".orderCol[colval]").forEach((col) => {
            col.removeAttribute("selected");
            col.setAttribute("colval", Math.abs(col.getAttribute("colval")));
            var ic = col.querySelector("i");
            if (ic != null && ic != undefined) col.removeChild(ic);
        });

        resolve();
    });
}
//FUNCIÓN PARA LLAMAR EL SERVICIO DE LOGOUT UNA VEZ SE CONFIRMA LA SALIDA
function logoutAPI() {
    //Parametros
    var par = {};
    //Si pasa las validaciones asignamos los parametros
    par.sessionid = localStorage.getItem("sessionid");
    //Funcion si todo en la llamada al servicio y se obtiene respuesta
    let onsuccess = (rsp) => {
        switch (rsp.status) {
            case 200:
                //Si todo está ok blanqueamos la sesión local
                localStorage.clear();
                //Redireccionamos al dashboard
                gotoPage('login', '', {});
                break;
            default:
                console.log(rsp);
                break;
        }
    }
    //Lamamos al servicio si todo sale ok se ejecuta el onsuccess si falla sale por el catch
    callWS("POST", "security/logout", par).then(onsuccess).catch((e) => { console.log("Ocurrió un error " + e) })
}
//FUNCION GLOBAL PARA BLANQUEAR LOS CAMPOS DE UN PADRE (formulario)
//Se recibe el id del formulario y el tipo de elemento o ids a blanquear.
//Esta funcion tambien remueve el formato de "error" si un campo lo poseía
function blankForm(id, elements = [], ids = []) {
    let parent = document.getElementById(id);
    //Recorremos y blanqueamos global mente los elementos de este arreglo
    elements.forEach((e) => {
        switch (e) {
            case 'input':
            case 'select':
                parent.querySelectorAll(e).forEach((e) => {
                    e.value = "";
                    if (e.getAttribute("type") == "checkbox") e.checked = true; //default
                    //Si el elemento tiene su id blanqueamos los "errores que pueda tener"
                    if (e.id != null && e.id != "" && e.id != undefined) errBlank(e.id);
                });
                break;
            case 'textarea':
                parent.querySelectorAll(e).forEach((e) => {
                    e.value = "";
                    //Si el elemento tiene su id blanqueamos los "errores que pueda tener"
                    if (e.id != null && e.id != "" && e.id != undefined) errBlank(e.id);
                });
                break;
            case '.errmsgSct':
                parent.querySelectorAll(e).forEach((e) => {
                    //Manejo de campo de mensaje global
                    errBlank(e);
                });
                break;
            default:
                parent.querySelectorAll(e).forEach((e) => {
                    e.innerText = ""
                    //Si el elemento tiene su id blanqueamos los "errores que pueda tener"
                    if (e.id != null && e.id != "" && e.id != undefined) errBlank(e.id);
                });
                break;

        }
    });
    //Se identifican por id los elementos a blanquear
    ids.forEach((e) => {
        var ele = document.querySelector(e);
        switch (ele.tagName) {
            case 'input':
            case 'select':
                ele.value = "";
                if (e.getAttribute("type") == "checkbox") e.checked = true; //default

                break;
            default:
                ele.innerText = "";
                break;

        }
        //Si el elemento tiene su id blanqueamos los "errores que pueda tener"
        errBlank(e);
    });
}
//ESTA FUNCION PERMITE DESHABILITAR TODOS LOS CAMPOS ESPECIFICADOS DEL FORMULARIO 
//Recibe si es editable o no para remover los campos en caso contrario
function editableForm(id, editable, elements = [], ids = []) {
    let parent = document.getElementById(id);
    //Recorremos y blanqueamos global mente los elementos de este arreglo
    elements.forEach((e) => {
        switch (e) {
            case 'input':
            case 'select':
            case 'textarea':
                parent.querySelectorAll(e).forEach((e) => {
                    if (!editable) e.setAttribute("disabled", "");
                    else e.removeAttribute("disabled");
                });
                break;
            default:
                parent.querySelectorAll(e).forEach((e) => {
                    if (!editable) e.setAttribute("disabled", "");                                        
                    else e.removeAttribute("disabled");

                });
                break;

        }
    });
    //Se identifican por id los elementos a blanquear
    ids.forEach((e) => {
        var ele = document.querySelector(e);
        switch (ele.tagName) {
            case 'input':
            case 'select':
            case 'textarea':
                parent.querySelectorAll(e).forEach((e) => {
                    if (!editable) e.setAttribute("disabled", "");
                    else e.removeAttribute("disabled");
                });
                break;
            default:
                parent.querySelectorAll(e).forEach((e) => {
                    if (!editable) e.setAttribute("disabled", "");                                        
                    else e.removeAttribute("disabled");

                });
                break;

        }
        //Si el elemento tiene su id blanqueamos los "errores que pueda tener"
        errBlank(e);
    });

    if (parent.querySelector(".saveExitBtn") != undefined && !editable) {
        parent.querySelector(".saveExitBtn").style.display = "none";
    } else if (parent.querySelector(".saveExitBtn") != undefined) {
        parent.querySelector(".saveExitBtn").style.display = "";
    }
    if (parent.querySelector(".saveBtn") != undefined && !editable) {
        parent.querySelector(".saveBtn").style.display = "none";
    } else if (parent.querySelector(".saveBtn") != undefined) {
        parent.querySelector(".saveBtn").style.display = "";
    }
    if (parent.querySelector(".backBtn") != undefined && !editable) {
        parent.querySelector(".backBtn").innerText = "Volver";
    } else if(parent.querySelector(".backBtn") != undefined) {
        parent.querySelector(".backBtn").innerText = "Cancelar";
    }
    if (parent.querySelector(".processBtn") != undefined && !editable) {
        parent.querySelector(".processBtn").style.display = "none";
    } else if(parent.querySelector(".processBtn") != undefined) {
        parent.querySelector(".processBtn").style.display = "";
    }
    if (parent.querySelector(".revertirBtn") != undefined && !editable) {
        parent.querySelector(".revertirBtn").style.display = "none";
    } else if(parent.querySelector(".revertirBtn") != undefined) {
        parent.querySelector(".revertirBtn").style.display = "";
    }
}
//Función que da formateo a un número en frontend
function number_format(amount, decimals) {
    amount += ''; // por si pasan un numero en vez de un string
    amount = parseFloat(amount.replace(/[^0-9\\.\\-]/g, '')); // elimino cualquier cosa que no sea numero o punto

    decimals = decimals || 0; // por si la variable no fue fue pasada

    // si no es un numero o es igual a cero retorno el mismo cero
    if (isNaN(amount) || amount === 0)
        return (parseFloat(0).toFixed(decimals)).replace(".",",");//Parseando los decimales con coma

    // si es mayor o menor que cero retorno el valor formateado como numero
    amount = '' + amount.toFixed(decimals);

    var amount_parts = amount.split('.'),
        regexp = /(\d+)(\d{3})/;

    while (regexp.test(amount_parts[0]))
        amount_parts[0] = amount_parts[0].replace(regexp, '$1' + '.' + '$2');

    return amount_parts.join(',');
}
//FUNCIÓN GLOBAL PARA VALIDAR UN FORMATO DE CAMPO ESPECIFICO
//Recibe un string a validar y el formato que se necesita validar
function hasFormat(txt, format) {
    //Definimos las funciones validadoras
    let validarCorreo = (correo) => {
        // Expresion regular para validar un correo electrónico
        let regex = /^(\w+([.\-_+]?\w+)*@)(?=[^@]|$)\w+([.\-_+]?\w+)*(\.\w{2,6})+$/;
        // Si el correo electrónico coincide con la expresión regular, es válido
        return regex.test(correo);
    }
    let validarPassword = (password) => {
        let regex = /^[a-zA-Z0-9_#$.\-]{8,}$/;
        // Si la clave es coincide con la expresión regular, es válido
        return regex.test(password);
    }

    //Se valida el tipo deseado y se retorna una respuesta
    let rsp = false;
    switch (format) {
        case 'email':
            rsp = validarCorreo(txt);
            break;
        case 'password':
            rsp = validarPassword(txt);
            break;
    }
    return rsp;
}
//FUNCIÓN PARA LLAMADAS DE LOS SERVICIOS
function callWS(type, service, params, wait = true) {
    return new Promise((resolve, reject) => {
        if (wait) wsOn(service);
        var url = globalurl + "api/" + service + ".php";
        var xhttp = new XMLHttpRequest();
        xhttp.onreadystatechange = function () {
            if (this.readyState == 4) {
                var rsp = {
                    'status': this.status,
                    'response': this.responseText
                };
                wsOff();
                if (this.status !== -1) {
                    resolve(rsp);
                } else {
                    reject(rsp);
                }
            }
        };
        switch (type) {
            case "POST":
                xhttp.open("POST", url, true);
                var formdata = new FormData();
                for (var key in params) {
                    formdata.append(key, params[key]);
                }
                xhttp.send(formdata);
                break;
            case "JSON":
                xhttp.open("POST", url, true);
                var data = JSON.stringify(params);
                xhttp.send(data);
                break;
            case "GET":
            case "DELETE":
                var parsedPars = Object.keys(params).map(function (k) {
                    return encodeURIComponent(k) + "=" + encodeURIComponent(params[k]);
                }).join("&");
                xhttp.open(type.toUpperCase(), url + "?" + parsedPars, true);
                xhttp.send();
                break;            
        }
    });
}
//FUNCION PARA CAMBIAR DE VISTA/PANTALLA
function gotoPage(id, sid = '', params, target = '_self') {
    var url = redirecturl;
    var parsedPars = Object.keys(params).map(function (k) {
        return encodeURIComponent(k) + '=' + encodeURIComponent(params[k]);
    }).join('&');
    if (parsedPars.length)
        parsedPars = "&" + parsedPars;

    let sidpar = '';
    if (sid != '') sidpar = "&sid=" + sid;

    window.open(url + "?id=" + id + sidpar + parsedPars, target);
}
//OBTENER UN PARAMETRO DE LA URL
function getParameterByName(name) {
    name = name.replace(/[\[]/, "\\[").replace(/[\]]/, "\\]");
    var regex = new RegExp("[\\?&]" + name + "=([^&#]*)"),
        results = regex.exec(location.search);
    return results === null ? "" : decodeURIComponent(results[1].replace(/\+/g, " "));
}
//FUNCION PARA CREAR UN SELECT
function drawSelect(rsp, select, id, dsc, first = "", selected = "") {
    select.innerHTML = "";
    var opt;
    if (first !== "" && first !== null && first !== undefined) {
        opt = document.createElement("option");
        opt.setAttribute("value", "");
        opt.innerHTML = first;
        select.appendChild(opt);
    }
    for (var i = 0; i < rsp.length; i++) {
        opt = document.createElement("option");
        opt.setAttribute("value", rsp[i][id]);
        if (id.indexOf("err") > -1) {
            opt.setAttribute("errid", id);
        }
        if (rsp[i][id] == selected) opt.setAttribute("selected", "");
        if (rsp[i].disabled) opt.setAttribute("disabled", "");
        if (dsc != "" && dsc != undefined) {
            var dscarr = dsc.split("+");
            var dscmsg = "";
            for (var x = 0; x < dscarr.length; x++) {
                if (typeof rsp[i] == 'object') {
                    let val = rsp[i].jsonget(dscarr[x]);
                    if (val == null || val == undefined)
                        dscmsg += dscarr[x] + " ";
                    else
                        dscmsg += val + " ";
                } else {
                    dscmsg += dscarr[x] + " ";
                }

            }
        }
        opt.innerHTML = dscmsg;
        select.appendChild(opt);
    }
}
//FUNCION PARA CREAR UN SELECT CON BUSQUEDA. SE AÑADE MANEJO DE CLICK EN OPCIONES Y ESTILOS NECESARIOS
//SE MANTIENE LA BASE DE LA FUNCION QUE GENERA LOS SELECTS
//Formato de atributos arreglo con objetos ej: [{'abbr':'nombre en json'}]
function drawSrchSelect(rsp, select, id, dsc, first = "", selected = "", onclick, attrs = [], fixed = false) {
    select.innerHTML = "";
    var opt;
    if (first !== "" && first !== null && first !== undefined) {
        opt = document.createElement("option");
        opt.setAttribute("value", "");
        opt.innerHTML = first;
        select.appendChild(opt);
    }
    for (var i = 0; i < rsp.length; i++) {
        opt = document.createElement("option");
        opt.setAttribute("value", rsp[i][id]);
        attrs.forEach((atr) => {
            opt.setAttribute(Object.keys(atr)[0], rsp[i][atr[Object.keys(atr)[0]]]);
        });
        opt.addEventListener("click", function () {
            onclick(this);
        });
        if (id.indexOf("err") > -1) {
            opt.setAttribute("errid", id);
        }
        if (rsp[i][id] == selected) opt.setAttribute("selected", "");
        if (rsp[i].disabled) opt.setAttribute("disabled", "");
        if (dsc != "" && dsc != undefined) {
            var dscarr = dsc.split("+");
            var dscmsg = "";
            for (var x = 0; x < dscarr.length; x++) {
                if (typeof rsp[i] == 'object') {
                    let val = rsp[i].jsonget(dscarr[x]);
                    if (val == null || val == undefined)
                        dscmsg += dscarr[x] + "";
                    else
                        dscmsg += val + "";
                } else {
                    dscmsg += dscarr[x] + "";
                }

            }
        }
        opt.innerHTML = dscmsg;
        select.appendChild(opt);
    }

    if (fixed) {
        let inpt = select.previousElementSibling;
        select.style.top = (inpt.getBoundingClientRect().y + inpt.offsetHeight) + "px";
        select.style.left = (inpt.getBoundingClientRect().x) + "px";
        select.style.maxWidth = (inpt.offsetWidth*2)+"px";
        select.style.position = "fixed";
        if((select.offsetHeight+select.offsetTop)>window.innerHeight){
            let inpth = select.previousElementSibling.offsetHeight;
            select.style.top = (select.offsetTop - (select.offsetHeight+inpth+10))+"px";
        }
        select.display = "";
    }
}
//FUNCIÓN UTILITARIA QUE RECIBE UN STRING Y DEVUELVE UN MD5
function MD5(word) {
    function md5cycle(x, k) {
        var a = x[0], b = x[1], c = x[2], d = x[3];

        a = ff(a, b, c, d, k[0], 7, -680876936);
        d = ff(d, a, b, c, k[1], 12, -389564586);
        c = ff(c, d, a, b, k[2], 17, 606105819);
        b = ff(b, c, d, a, k[3], 22, -1044525330);
        a = ff(a, b, c, d, k[4], 7, -176418897);
        d = ff(d, a, b, c, k[5], 12, 1200080426);
        c = ff(c, d, a, b, k[6], 17, -1473231341);
        b = ff(b, c, d, a, k[7], 22, -45705983);
        a = ff(a, b, c, d, k[8], 7, 1770035416);
        d = ff(d, a, b, c, k[9], 12, -1958414417);
        c = ff(c, d, a, b, k[10], 17, -42063);
        b = ff(b, c, d, a, k[11], 22, -1990404162);
        a = ff(a, b, c, d, k[12], 7, 1804603682);
        d = ff(d, a, b, c, k[13], 12, -40341101);
        c = ff(c, d, a, b, k[14], 17, -1502002290);
        b = ff(b, c, d, a, k[15], 22, 1236535329);

        a = gg(a, b, c, d, k[1], 5, -165796510);
        d = gg(d, a, b, c, k[6], 9, -1069501632);
        c = gg(c, d, a, b, k[11], 14, 643717713);
        b = gg(b, c, d, a, k[0], 20, -373897302);
        a = gg(a, b, c, d, k[5], 5, -701558691);
        d = gg(d, a, b, c, k[10], 9, 38016083);
        c = gg(c, d, a, b, k[15], 14, -660478335);
        b = gg(b, c, d, a, k[4], 20, -405537848);
        a = gg(a, b, c, d, k[9], 5, 568446438);
        d = gg(d, a, b, c, k[14], 9, -1019803690);
        c = gg(c, d, a, b, k[3], 14, -187363961);
        b = gg(b, c, d, a, k[8], 20, 1163531501);
        a = gg(a, b, c, d, k[13], 5, -1444681467);
        d = gg(d, a, b, c, k[2], 9, -51403784);
        c = gg(c, d, a, b, k[7], 14, 1735328473);
        b = gg(b, c, d, a, k[12], 20, -1926607734);

        a = hh(a, b, c, d, k[5], 4, -378558);
        d = hh(d, a, b, c, k[8], 11, -2022574463);
        c = hh(c, d, a, b, k[11], 16, 1839030562);
        b = hh(b, c, d, a, k[14], 23, -35309556);
        a = hh(a, b, c, d, k[1], 4, -1530992060);
        d = hh(d, a, b, c, k[4], 11, 1272893353);
        c = hh(c, d, a, b, k[7], 16, -155497632);
        b = hh(b, c, d, a, k[10], 23, -1094730640);
        a = hh(a, b, c, d, k[13], 4, 681279174);
        d = hh(d, a, b, c, k[0], 11, -358537222);
        c = hh(c, d, a, b, k[3], 16, -722521979);
        b = hh(b, c, d, a, k[6], 23, 76029189);
        a = hh(a, b, c, d, k[9], 4, -640364487);
        d = hh(d, a, b, c, k[12], 11, -421815835);
        c = hh(c, d, a, b, k[15], 16, 530742520);
        b = hh(b, c, d, a, k[2], 23, -995338651);

        a = ii(a, b, c, d, k[0], 6, -198630844);
        d = ii(d, a, b, c, k[7], 10, 1126891415);
        c = ii(c, d, a, b, k[14], 15, -1416354905);
        b = ii(b, c, d, a, k[5], 21, -57434055);
        a = ii(a, b, c, d, k[12], 6, 1700485571);
        d = ii(d, a, b, c, k[3], 10, -1894986606);
        c = ii(c, d, a, b, k[10], 15, -1051523);
        b = ii(b, c, d, a, k[1], 21, -2054922799);
        a = ii(a, b, c, d, k[8], 6, 1873313359);
        d = ii(d, a, b, c, k[15], 10, -30611744);
        c = ii(c, d, a, b, k[6], 15, -1560198380);
        b = ii(b, c, d, a, k[13], 21, 1309151649);
        a = ii(a, b, c, d, k[4], 6, -145523070);
        d = ii(d, a, b, c, k[11], 10, -1120210379);
        c = ii(c, d, a, b, k[2], 15, 718787259);
        b = ii(b, c, d, a, k[9], 21, -343485551);

        x[0] = add32(a, x[0]);
        x[1] = add32(b, x[1]);
        x[2] = add32(c, x[2]);
        x[3] = add32(d, x[3]);

    }

    function cmn(q, a, b, x, s, t) {
        a = add32(add32(a, q), add32(x, t));
        return add32((a << s) | (a >>> (32 - s)), b);
    }

    function ff(a, b, c, d, x, s, t) {
        return cmn((b & c) | ((~b) & d), a, b, x, s, t);
    }

    function gg(a, b, c, d, x, s, t) {
        return cmn((b & d) | (c & (~d)), a, b, x, s, t);
    }

    function hh(a, b, c, d, x, s, t) {
        return cmn(b ^ c ^ d, a, b, x, s, t);
    }

    function ii(a, b, c, d, x, s, t) {
        return cmn(c ^ (b | (~d)), a, b, x, s, t);
    }

    function md51(s) {
        txt = '';
        var n = s.length,
            state = [1732584193, -271733879, -1732584194, 271733878], i;
        for (i = 64; i <= s.length; i += 64) {
            md5cycle(state, md5blk(s.substring(i - 64, i)));
        }
        s = s.substring(i - 64);
        var tail = [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0];
        for (i = 0; i < s.length; i++)
            tail[i >> 2] |= s.charCodeAt(i) << ((i % 4) << 3);
        tail[i >> 2] |= 0x80 << ((i % 4) << 3);
        if (i > 55) {
            md5cycle(state, tail);
            for (i = 0; i < 16; i++) tail[i] = 0;
        }
        tail[14] = n * 8;
        md5cycle(state, tail);
        return state;
    }

    /* there needs to be support for Unicode here,
    * unless we pretend that we can redefine the MD-5
    * algorithm for multi-byte characters (perhaps
    * by adding every four 16-bit characters and
    * shortening the sum to 32 bits). Otherwise
    * I suggest performing MD-5 as if every character
    * was two bytes--e.g., 0040 0025 = @%--but then
    * how will an ordinary MD-5 sum be matched?
    * There is no way to standardize text to something
    * like UTF-8 before transformation; speed cost is
    * utterly prohibitive. The JavaScript standard
    * itself needs to look at this: it should start
    * providing access to strings as preformed UTF-8
    * 8-bit unsigned value arrays.
    */
    function md5blk(s) { /* I figured global was faster.   */
        var md5blks = [], i; /* Andy King said do it this way. */
        for (i = 0; i < 64; i += 4) {
            md5blks[i >> 2] = s.charCodeAt(i)
                + (s.charCodeAt(i + 1) << 8)
                + (s.charCodeAt(i + 2) << 16)
                + (s.charCodeAt(i + 3) << 24);
        }
        return md5blks;
    }

    var hex_chr = '0123456789abcdef'.split('');

    function rhex(n) {
        var s = '', j = 0;
        for (; j < 4; j++)
            s += hex_chr[(n >> (j * 8 + 4)) & 0x0F]
                + hex_chr[(n >> (j * 8)) & 0x0F];
        return s;
    }

    function hex(x) {
        for (var i = 0; i < x.length; i++)
            x[i] = rhex(x[i]);
        return x.join('');
    }

    function md5(s) {
        return hex(md51(s));
    }

    /* this function is much faster,
    so if possible we use it. Some IEs
    are the only ones I know of that
    need the idiotic second function,
    generated by an if clause.  */

    function add32(a, b) {
        return (a + b) & 0xFFFFFFFF;
    }

    return md5(word);
}
//Recibe una cadena y un formato esperado, aplica el blanqueo esperado para el formato y retorna la cadena blanqueada
function fieldFormat(txt, format, replace) {
    switch (format) {
        case 'specialname':
            //Este incluye los apostrofes
            txt = txt.replace(/[^a-zA-Z0-9áéíóúñüÁÉÍÓÚÑÜ \'\`.,:\-()+*\/]/g,"");
        break;
        case 'search':
            // Creamos una expresión regular que coincida con todos los caracteres especiales que queremos eliminar.
            txt = txt.replace(/[^a-zA-Z0-9áéíóúñüÁÉÍÓÚÑÜ .,:\-()+*\/]/g,"");
            break;
        case 'name':
            // Admite texto y numeros sin espacios ni caracteres especiales
            txt = txt.replace(/[^a-zA-Z0-9áéíóúñüÁÉÍÓÚÑÜ .,:\-()+*\/]/g,"");
            break;
        case 'namecomillas':
            // Admite texto igual al name superior pero con comillas
            txt = txt.replace(/[^a-zA-Z0-9áéíóúñüÁÉÍÓÚÑÜ \`\'\".,:\-()+*\/]/g,"");
            break;
        case 'abbr':
            // Admite texto y numeros sin espacios ni caracteres especiales
            txt = txt.replace(/[^a-zA-Z0-9áéíóúñüÁÉÍÓÚÑÜ .,:\-()+*\/]/g,"");
            break;
        case 'validtime':
            //Limitamos primera parte de la cadena a 2 digitos o 100 y que opcionalmente tenga decimales, limitando maximo a 2
            txt = (txt.replace(/[^0-9.,]/g,"")).replace(/^((\d{1,3})(?:[.,]\d{0,2})?).*/g, "$1");
            break;
        case 'amount':
            //Pasamos cualquier digito segido de cóma o punto, seguido de números limitado a máximo 2 decimales
            txt = (txt.replace(/[^0-9.,]/g,"")).replace(/(\d(?:[.,]\d{0,2})).*$/, "$1");
            break;
        case 'intnumber':
            //Pasamos cualquier digito segido de cóma o punto, seguido de números limitado a máximo 2 decimales
            txt = txt.replace(/[^0-9]/g, "");
            break;
        case 'uniquereplace':
            //Permitimos definir un formato de remplazamiento personalizado para que reciba los campos definidos por el backend en casos especiales
            txt = replace;
            break;
    }
    // Reemplazamos los caracteres especiales por espacios.
    return txt;
}
/*AJUSTE PARA CAER SIEMPRE CON CURSOR A LA DERECHA AGREGADO-PROBAR*/
function formatPercent(ele,decimCoin = 2){
//for(var i=0;i<fields.length;i++){
    //var ele = document.getElementById(eleid);
    ele.addEventListener("keyup",function(e){
    if(e.keyCode!==190 && e.keyCode !== 188 && e.keyCode !== 8 && e.keyCode !== 46){
        var newval = fieldFormat(this.value,"amount");
        this.value = newval;
        this.setAttribute("datanum", (!isNaN(getNum(newval)) ? getNum(newval) : ""));
    }
    });
    ele.addEventListener("focusin",function(){
        var val = this.getAttribute("datanum");
        this.value = !isNaN(getNum(val)) ? getNum(val) : "";        
        this.selectionStart = 0;
        this.selectionEnd = this.value.length;
    });
    ele.setAttribute("decim",decimCoin);
    ele.addEventListener("focusout",function(){
        this.setAttribute("datanum",getNum(this.value));
        this.value = "";
        //this.setAttribute("type","text");
        if(this.getAttribute("datanum") !== null && this.getAttribute("datanum") !== undefined && !isNaN(this.getAttribute("datanum"))){
        this.value = number_format(this.getAttribute("datanum"),this.getAttribute("decim"))+"%";
        }else{
        this.value = "";
        }
    });
}  
function formatAmount(ele,decimCoin = 2,size = 12){
  //for(var i=0;i<fields.length;i++){
      //var ele = document.getElementById(eleid);
    ele.addEventListener("keyup",function(e){
        if (e.keyCode !== 190 && e.keyCode !== 188 && e.keyCode !== 8 && e.keyCode !== 46) {
            let regex = new RegExp(`^((\\d{1,${size}})(?:[.,]\\d{0,${decimCoin}})?).*`,"g");
            var newval = fieldFormat(this.value, "uniquereplace", this.value.replace(regex, "$1"));
            this.value = newval;
            this.setAttribute("datanum", (!isNaN(getNum(newval)) ? getNum(newval) : ""));
        }
    });
    ele.addEventListener("focusin",function(){
        var val = this.getAttribute("datanum");
        this.value = !isNaN(getNum(val)) ? getNum(val) : "";
        this.selectionStart = 0;
        this.selectionEnd = this.value.length;
        //this.setAttribute("type","number");
    });
    ele.setAttribute("decim",decimCoin);
    ele.addEventListener("focusout",function(){
        this.setAttribute("datanum",getNum(this.value));
        this.value = "";
        //this.setAttribute("type","text");
        if(this.getAttribute("datanum") !== null && this.getAttribute("datanum") !== undefined && !isNaN(this.getAttribute("datanum"))){
        this.value = number_format(this.getAttribute("datanum"),this.getAttribute("decim"));
        }else{
        this.value = "";
        }
    });
}
function formatTime(ele){
  //for(var i=0;i<fields.length;i++){
    //var ele = document.getElementById(eleid);
    ele.addEventListener("keyup",function(e){
    if (e.keyCode !== 190 && e.keyCode !== 188 && e.keyCode !== 8 && e.keyCode !== 46) {
        if (this.value != "") {
            var newval = fieldFormat(limitSize(this.value, 5), "intnumber");
            if (newval) newval = newval.match(/.{1,2}/g).join(" ");
            this.value = newval;
            this.setAttribute("datanum", newval);                
        }
    }
    });
    ele.addEventListener("focusin",function(){
        var val = this.getAttribute("datanum");
        this.value = val;          
        this.selectionStart = 0;
        this.selectionEnd = this.value.length;
        //this.setAttribute("type","number");
    });
    ele.addEventListener("focusout",function(){
        this.setAttribute("datanum", this.value);
        this.value = "";
        //this.setAttribute("type","text");
        if(this.getAttribute("datanum") !== null && this.getAttribute("datanum") !== undefined && this.getAttribute("datanum") != ""){
            this.value = this.getAttribute("datanum").split(" ").map((e, index) => {
                return (index == 0) ? e + "\"" : e ;
            }).join(" ");
        }else{
        this.value = "";
        }
    });
}
//Funcion recibe una cadena y retorna un número
function getNum(txt) {
    let num = (txt != null && txt != undefined && txt !="") ? parseFloat(txt.replace(/,/g, '.')) : '';
    return (isNaN(num)) ? 0 : num;
};
//Función que recibe un elemento date y lo convierte en fecha de input
const dateForInpt = (date) => (date.getFullYear() + "-" + pad(date.getMonth() + 1) + "-" + pad(date.getDate()));
const globmaxdate = (new Date(((new Date()).getFullYear()),11,31));
const globmindate = new Date(1900, 0, 1);
function validDateRange(date) {
    return new Promise((resolve, reject) => {
        let splitdate = date.split("-");
        if (parseFloat(splitdate[0]) < 1900) {
            reject();
        }
        let nwdate = new Date(splitdate[0], (parseFloat(splitdate[1]) - 1), splitdate[2]);
        if (nwdate.getTime() < globmaxdate.getTime() && nwdate.getTime() >= globmindate.getTime()) {
            resolve()
        } else {
            reject();
        }
    });
}
//Funcion que recibe un texto y limita su tamaño
const limitSize = (val, limit) => val.substr(0, limit);
//Funcion para añadir un 0 a la izquierda
function pad(n) {
    var s = ('0' + n);
    return s.substr(s.length - 2);
}
function focusIn(id) {
    let ele = (typeof id == 'object')?id:document.getElementById(id);
    ele.focus();
    if (ele.getAttribute("type") == 'text') {
        ele.selectionStart = 0;
        ele.selectionEnd = ele.value.length;
    }
}
//OBTENER LA PROPIEDAD DE UN ELEMENTO JSON
Object.prototype.jsonget = function (path) {
    // Break the path into an array of keys.
    let keys = path.split(".");
    let rsp = this;
    // Iterate over the keys and access the corresponding property from the object.
    for (let key of keys) {
        rsp = rsp[key];
    }

    // Return the value of the final property.
    return rsp;
}
