//Función incial se llama una vez cargado el modulo acá se asignan los eventos iniciales
async function traqueosInit() {
    //Evento mostrar popup de insertar usuario
    document.querySelector(".addBtn").addEventListener("click", function () {
        //Validamos si tiene el privilegio de aadir o no para "inhabilitar el boton"
        let btnsave = document.getElementById("popupUpdFrm").querySelector(".saveBtn");
        if (btnsave.getAttribute("add") == "inactive") btnsave.setAttribute("inactive", "");
        else btnsave.removeAttribute("inactive");

        //Desactivamos el botón de agregar (hasta guardar o cancelar)
        this.setAttribute("disabled", "");
        //Blanqueamos el addline y lo mostramos
        blankForm("addline", ["input", "select"]);
        document.getElementById("addline").querySelectorAll("input,select").forEach(e => {
            e.removeAttribute("disabled");
        });
        //Si existe uno activo lo restauramos
        let someactive = document.getElementById("pgTbl").querySelector(".tr[active]");
        if (someactive != undefined) resetdataRow(someactive);
        //Por default se requiere que al crear la fecha sea hoy
        document.getElementById("addline").children[6].firstElementChild.value = dateForInpt(new Date());
        //Activamos el addline
        document.getElementById("addline").setAttribute("active", "");
        document.getElementById("addline").querySelectorAll(".tblBtns")[0].style.display = "none";
        document.getElementById("addline").querySelectorAll(".tblBtns")[1].style.display = "";        
        document.getElementById("addline").parentElement.parentElement.style.display = "";
        focusIn(document.getElementById("addline").querySelectorAll("input[type='text']")[0]);
    });

    let refreshlist = () => {
        //Llevamos el offset a 0 removiendo cualquier pagina activa antes de llamar al 
        let selpag = document.querySelector(".pgSctTbl").querySelector(".pagNum[selected]");
        if (selpag != null) selpag.removeAttribute("selected");
        listAPI();
    }
    //EVENTO REFRESCAR TABLA EN EL AL HACER BUSQUEDA CON ENTER
    document.getElementById("searchTbl").addEventListener("keyup", function (e) {
        if (this.value != "") this.value = fieldFormat(this.value, "search");
        //Si le da al enter, refrescamos el listadol.  
        if (e.key != null && (e.key).toLowerCase() == 'enter') {
            refreshlist();
        }
    });

    let refreshlistdates = async (ele) => {
        let error = false;
        //Aplicamos algunas validaciones adicionales para las fechas
        let from = document.getElementById("fromFilt");
        let to = document.getElementById("toFilt");
        if (from.value !== "") {
            to.setAttribute("min", from.value);
            to.setAttribute("max", dateForInpt(new Date()));
            //Como el from tiene valor validamos que no exceda al ahora
            let fromdate = new Date(from.value.split("-"));
            if (fromdate.getTime() > (new Date()).getTime()) {
                errInpt(from.getAttribute("id"), "Fecha desde inválida", 6000);
                error = true;
            }
            await validDateRange(from.value).then().catch(() => {
                errInpt(from.getAttribute("id"), "Fecha desde inválida", 6000);
                error = true;
            });
        } else {
            to.setAttribute("min", dateForInpt(globmindate));
        }
        if (to.value !== "") {
            from.setAttribute("max", to.value);
            let todate = new Date(to.value.split("-"));
            if (todate.getTime() > (new Date()).getTime()) {
                errInpt(to.getAttribute("id"), "Fecha hasta inválida", 6000);
                error = true;
            }
            await validDateRange(to.value).then().catch(() => {
                errInpt(from.getAttribute("id"), "Fecha hasta inválida", 6000);
                error = true;
            });
        } else {
            from.setAttribute("max", dateForInpt(new Date()));
        }
        if (to.value != "" && from.value != "") {
            //Fechas
            let fromdate = new Date(from.value.split("-"));
            let todate = new Date(to.value.split("-"));
            if (fromdate.getTime() > todate.getTime()) {
                errInpt(ele.getAttribute("id"), "Rango de fechas inválido", 6000);
                error = true;
            }
        }

        if (error) {
            listDraw({
                numofrecords: 0,
                records: []
            });
            return;
        } else {
            errBlank(to.getAttribute("id"));
            errBlank(from.getAttribute("id"));

        }

        //Llevamos el offset a 0 removiendo cualquier pagina activa antes de llamar al 
        let selpag = document.querySelector(".pgSctTbl").querySelector(".pagNum[selected]");
        if (selpag != null) selpag.removeAttribute("selected");
        listAPI();
    }
    //Eventos rango de rechas
    document.getElementById("toFilt").addEventListener("change", function () { refreshlistdates(this) });
    document.getElementById("toFilt").setAttribute("min", dateForInpt(globmindate));
    document.getElementById("toFilt").setAttribute("max", dateForInpt(new Date()));
    document.getElementById("fromFilt").addEventListener("change", function () { refreshlistdates(this) });
    document.getElementById("fromFilt").setAttribute("min", dateForInpt(globmindate));
    document.getElementById("fromFilt").setAttribute("max", dateForInpt(new Date()));
    //EVENTOS A CAMPOS DEL FORMULARIO DE USUARIO CREAR / MODIFICAR
    //Listado de horses requerido para agregar
    document.getElementById("updHorseid").addEventListener("keyup", function (e) {
        if (this.value != "") this.value = fieldFormat(this.value, 'name');
        clearTimeout(delay);
        if (this.value.length >= 1) {
            delay = setTimeout(() => {
                listHorsesAPI(this.nextElementSibling, this.value);
            }, 500);
        }
    });
    


    //-------//

    //EVENTOS DE BOTONES GUARDAR Y CANCELAR
    //Popup "CREAR/EDITAR"
    let usrpop = document.getElementById("popupUpdFrm");
    //Evento al guardar el crear/editar el
    usrpop.querySelector(".saveBtn").addEventListener("click", function () {
        //Si no tiene el atributo inactivo se intenta guardar
        if (this.getAttribute("inactive") != null && this.getAttribute("inactive") != undefined) {
            errInpt(document.getElementById("popupUpdFrm").querySelector(".errmsgSct"), "No tiene privilegios para ejecutar esta acción", 6000);
        } else {
            //Acá se intenta el guardar
            updateAPI((this.getAttribute("upid") != undefined && this.getAttribute("upid") != null) ? this.getAttribute("upid") : 0);
        }
    });
    //Evento cancela popup crear/editar
    usrpop.querySelector(".backBtn").addEventListener("click", function () {
        closePopups();
    });

    //Popup "ELIMINAR usuario"
    let delpop = document.getElementById("popupDelFrm");
    //Evento al guardar el crear/editar el usuario
    delpop.querySelector(".saveBtn").addEventListener("click", function () {
        //Si no tiene el atributo inactivo se intenta guardar
        if (this.getAttribute("inactive") != null && this.getAttribute("inactive") != undefined) {
            errInpt(document.getElementById("popupDelFrm").querySelector(".poupDelItemLbl"), "No tiene privilegios para ejecutar esta acción", 6000);
        } else {
            //Acá se intenta el guardar
            deleteAPI(this.getAttribute("delid"));
        }
    });
    //Evento cancela popup 
    delpop.querySelector(".backBtn").addEventListener("click", function () {
        closePopups();
    });

    //INICIALIZAMOS LOS EVENTOS DE ORDENAMIENTO, CON ESTE FORMATO SE PUEDEN PASAR PARAMETROS A LA FUNCIÓN
    initOrders(document.querySelector(".pgSctTbl"), () => { listAPI(); });

    //IINICIALIZAMOS LOS EVENTOS DE LAS FLECHAS DEL PAGINADO SI EXISTE
    initPagsEvent(document.querySelector(".pgSctTbl"), () => { listAPI(); });

    await Promise.all([listDistancesAPI(), listRacecoursesAPI()]);
    listAPI();
    
}
//Función para llamar al sevicio de la lista
let notupdatedData = {}; //Guardamos la información de los 10 registros visibles localmente en caso de necesitar restaurar una linea "sin cambios"
function listAPI() {
    return new Promise((resolve, reject) => {
        var par = {};
        par.filter = document.getElementById("searchTbl").value;
        let order = document.querySelector(".pgSctTbl").querySelector(".orderCol[selected]");
        par.order = (order == null || order == undefined) ? -1 : order.getAttribute("colval");
        let actpage = document.querySelector(".pgSctTbl").querySelector(".pagNum[selected]");
        par.offset = (actpage != null) ? (actpage.innerHTML * 10) - 10 : 0;
        par.numofrec = 10;
        par.datefrom = document.getElementById("fromFilt").value;
        par.dateto = document.getElementById("toFilt").value;
        par.sessionid = localStorage.getItem("sessionid");
        console.log(par);
        //Funcion si todo en la llamada al servicio y se obtiene respuesta
        let onsuccess = async (rsp) => {
            switch (rsp.status) {
                case 200:
                    data = JSON.parse(rsp.response);
                    notupdatedData = data;
                    //Validamos los privilegios
                    await privValidations(data.privileges);
                    //Si obtenemos y se setean los privilegios correctamente pintamos la tabla
                    listDraw(data, data.privileges);
                    resolve();
                    break;
                case 401:
                    //NO autorizado
                    localStorage.clear();
                    gotoPage('login', '', {});
                    reject();
                    break;
                case 403:
                    //Si no tiene privilegios se muestra el mensaje de error
                    errTbl(document.querySelector(".tblSct"), "No tiene privilegios para visualizar los registros");
                    reject();
                    break;
                default:
                    data = JSON.parse(rsp.response);
                    reject();
                    console.log(data);
                    break;
            }
        }
        //Lamamos al servicio si todo sale ok se ejecuta el onsuccess si falla sale por el catch
        callWS("POST", "records/traqueos/list", par).then(onsuccess).catch((e) => { console.log("Ocurrió un error " + e) });
    });
}
//Función para pintar la respuesta de la lista en la tabla - requiere modelo base en html
function listDraw(rsp, privileges) {
    let tbl = document.getElementById("pgTbl").querySelector(".tbody");
    let list = rsp.records;
    let ele = tbl.querySelector(".tr:not([id='addline'])").parentElement.parentElement.cloneNode(true);
    let notedclass = "noteditable";

    tbl.innerHTML = "";
    //Activamos el add y agregamos/ocultamos el add
    if(rsp.create)document.querySelector(".addBtn").removeAttribute("disabled");
    //Antes que cualquier cosa insertamos la linea de "agregar"
    var clone = ele.cloneNode(true);        
    clone.style.display = "none";
    clone.removeAttribute("active");
    clone.removeAttribute("itemid");
    
    let rowSct = clone.children[0].children[0];    
    rowSct.removeAttribute("active");
    rowSct.removeAttribute("itemid");
    rowSct.setAttribute("id", "addline");
    //Blanqueamos el addline y lo mostramos
    var celda = rowSct.children[0];
    celda.firstElementChild.addEventListener("keyup", function (e) {
        let delay = null;
        if (this.value != "") this.value = fieldFormat(this.value, 'name');
        clearTimeout(delay);
        if (this.value.length >= 1) {
            delay = setTimeout(() => {
                listHorsesAPI(this.nextElementSibling, this.value);
            }, 500);
        }
    });

    var celda = rowSct.children[1];
    drawSelect(dataRacecourses, celda.firstElementChild, 'id', 'name', 'Hipódromos', "");

    var celda = rowSct.children[2];
    drawSelect(dataDistances, celda.firstElementChild, 'id', 'name', 'Distancia', "");

    var celda = rowSct.children[3];
    formatTime(celda.firstElementChild);
    celda.firstElementChild.removeAttribute("datanum");

    var celda = rowSct.children[4];
    formatTime(celda.firstElementChild);
    celda.firstElementChild.removeAttribute("datanum");

    var celda = rowSct.children[5];
    celda.firstElementChild.addEventListener("keyup", function (e) {
        if (this.value != "") this.value = fieldFormat(limitSize(this.value, 35), 'specialname');
    });


    var celda = rowSct.children[6];
    celda.firstElementChild.setAttribute("min", dateForInpt(globmindate));
    celda.firstElementChild.setAttribute("max", dateForInpt(new Date()));
    celda.firstElementChild.addEventListener("keyup", function (e) {
        if ((new Date(this.value)).getTime() > (new Date()).getTime()) {
            this.value = dateForInpt(new Date());
        }
        //Enter en date y que no esté activo el wait, guardamos
        var wait = document.getElementById("waitScreen");
        if (e.key != null && (e.key).toLowerCase() == 'enter' && wait == null) {
            //Llevamos el offset a 0 removiendo cualquier pagina activa antes de llamar al 
            let selpag = document.querySelector(".pgSctTbl").querySelector(".pagNum[selected]");
            if (selpag != null) selpag.removeAttribute("selected");
            updateAPI(document.getElementById("addline"), 0);
        }
    });
        
    //rowSct.querySelectorAll("." + notedclass).forEach(ele => ele.innerHTML = "");
    let btnsecond = rowSct.querySelectorAll(".tblBtns");
    btnsecond[1].querySelectorAll(".tblbtnIc")[0].addEventListener("click", function () {
        //Llevamos el offset a 0 removiendo cualquier pagina activa antes de llamar al 
        let selpag = document.querySelector(".pgSctTbl").querySelector(".pagNum[selected]");
        if (selpag != null) selpag.removeAttribute("selected");
        updateAPI(document.getElementById("addline"),0);
    });
    btnsecond[1].querySelectorAll(".tblbtnIc")[1].addEventListener("click", function () {
        document.getElementById("addline").removeAttribute("active");
        document.getElementById("addline").parentElement.parentElement.style.display = "none";
        document.querySelector(".addBtn").removeAttribute("disabled");
    });

    tbl.appendChild(clone);
    
    if (list.length > 0) {
        for (var i = 0; i < list.length; i++) {
            
            var clone = ele.cloneNode(true);            
            clone.style.display = "";
            clone.removeAttribute("active");
            
            let data = list[i];
            
            let rowSct = clone.children[0].children[0];
            rowSct.querySelectorAll(".tblInpt").forEach(e => {
                e.value = "";
                e.setAttribute("disabled", "");
            });
            rowSct.removeAttribute("active");
            rowSct.setAttribute("itemid", data.id);

            var celda = rowSct.children[0];
            celda.firstElementChild.value = data.horse.name + " (" + data.horse.id + ")";
            celda.firstElementChild.setAttribute("horseid", data.horse.id);
            celda.firstElementChild.addEventListener("keyup", function (e) {
                let delay = null;
                if (this.value != "") this.value = fieldFormat(this.value, 'name');
                clearTimeout(delay);
                if (this.value.length >= 1) {
                    delay = setTimeout(() => {
                        listHorsesAPI(this.nextElementSibling, this.value);
                    }, 500);
                }
            });

            var celda = rowSct.children[1];
            drawSelect(dataRacecourses, celda.firstElementChild, 'id', 'name', 'Hipódromos', data.racecourse.id);

            var celda = rowSct.children[2];
            drawSelect(dataDistances, celda.firstElementChild, 'id', 'name', 'Distancia', data.distance.id);

            var celda = rowSct.children[3];
            celda.firstElementChild.value = data.time;
            celda.firstElementChild.setAttribute("datanum", data.time.replace(/[^0-9\s]/g, ""));
            formatTime(celda.firstElementChild);

            var celda = rowSct.children[4];
            celda.firstElementChild.value = data.finishtime;
            celda.firstElementChild.setAttribute("datanum", data.finishtime.replace(/[^0-9\s]/g, ""));
            formatTime(celda.firstElementChild);

            var celda = rowSct.children[5];
            celda.firstElementChild.value = data.obs;
            celda.firstElementChild.addEventListener("keyup", function (e) {
                if (this.value != "") this.value = fieldFormat(limitSize(this.value, 35), 'specialname');
            });

            var celda = rowSct.children[6];
            celda.firstElementChild.value = dateForInpt(new Date(data.date.date + " 12:00"));
            celda.firstElementChild.setAttribute("min", dateForInpt(globmindate));
            celda.firstElementChild.setAttribute("max", dateForInpt(new Date()));
            celda.firstElementChild.addEventListener("keyup", function (e) {
                if ((new Date(this.value)).getTime() > (new Date()).getTime()) {
                    this.value = dateForInpt(new Date());
                }
                //Enter en date y que no esté activo el wait, guardamos
                var wait = document.getElementById("waitScreen");
                if (e.key != null && (e.key).toLowerCase() == 'enter' && wait == null) {
                    //Ocultamos si está editando otra linea
                    updateAPI(this.parentElement.parentElement, this.parentElement.parentElement.getAttribute("itemid"));
                }
            });
            var celda = rowSct.children[7].firstElementChild;//Botonera principal, editar/eliminar
            celda.style.display = "";
            //Atributos para eventos de los botones
            celda.setAttribute("itemid", data.id);
            celda.setAttribute("itemlbl", data.horse.name + " - " + data.date.formatted);

            //Editar Btn
            if (privileges.update) {
                celda.children[0].addEventListener("click", function (e) {
                    e.stopPropagation();
                    //Si existe uno activo lo restauramos
                    let someactive = document.getElementById("pgTbl").querySelector(".tr[active]");
                    if (someactive != undefined) resetdataRow(someactive);
                    //Cancelamos el add en caso de que esté activo
                    document.getElementById("addline").removeAttribute("active");
                    document.getElementById("addline").parentElement.parentElement.style.display = "none";
                    document.querySelector(".addBtn").removeAttribute("disabled");

                    let row = this.parentElement.parentElement.parentElement;
                    //Activamos la linea
                    row.setAttribute("active", "");
                    //Activamos la botonera que corresponde
                    row.querySelectorAll(".tblBtns")[0].style.display = "none";
                    row.querySelectorAll(".tblBtns")[1].style.display = "";
                    //Permitimos la edición de los campos
                    row.querySelectorAll("input,select").forEach(e => {
                        e.removeAttribute("disabled");
                    });
                    focusIn(row.querySelectorAll("input[type='text']")[0]);
                });
            } else {
                celda.children[0].setAttribute("disabled","");
            }
            //Eliminar Btn
            if (privileges.delete) {
                celda.children[1].addEventListener("click", function (e) {
                    e.stopPropagation();
                    //Se muestra el popup de confirmación
                    let usr = this.parentElement.getAttribute("itemlbl");
                    document.querySelector(".poupDelItemLbl").innerText = usr;
                    //Asignamos el id que va a ser eliminado al boton guardar de la confirmación del delete
                    let delpop = document.getElementById("popupDelFrm");
                    delpop.querySelector(".saveBtn").setAttribute("delid", this.parentElement.getAttribute("itemid"));
                    //Mostramos el popup de confirmación
                    showPopup("popupDelFrm");
                });
            } else {
                celda.children[1].setAttribute("disabled","");
            }

            var celda = rowSct.children[7].lastElementChild;//Botonera secundaria, confirmar/cancelar
            celda.style.display = "none";
            celda.setAttribute("itemid", data.id);
            celda.querySelectorAll(".tblbtnIc")[0].addEventListener("click", function () {
                //Ocultamos si está editando otra linea
                updateAPI(this.parentElement.parentElement.parentElement, this.parentElement.getAttribute("itemid"));
            });
            celda.querySelectorAll(".tblbtnIc")[1].addEventListener("click", function () {
                let row = this.parentElement.parentElement.parentElement;
                resetdataRow(row);
            });
            
            tbl.appendChild(clone);
        }
    } else {
        var clone = ele.cloneNode(true);
        clone.style.display = "none";
        clone.removeAttribute("id");
        tbl.appendChild(clone);
    }
    //SE PINTA EL PAGINADO LUEGO DE PINTAR LA TABLA
    var actpage = document.querySelector(".pgSctTbl").querySelector(".pagNum[selected]");
    actpage = (actpage != null && actpage != undefined) ? (actpage.innerHTML) : 1;
    drawPags(document.querySelector(".pgSctTbl"), rsp.numofrecords, 10, actpage, listAPI);
    
}
//Función si se cancela sin guarda devolvemos los valores iniciales
function resetdataRow(row) {
    //Vemos si existe el que se cancela la info para restaurarlo
    let data = notupdatedData.records.find(r => (r.id == row.getAttribute("itemid")));
    if (data) {
        row.removeAttribute("active");
        row.querySelectorAll(".tblInpt").forEach(e => {
            e.value = "";
            e.setAttribute("disabled", "");
        });
        row.querySelectorAll(".tblInpt")[0].value = data.horse.name + " (" + data.horse.id + ")";
        row.querySelectorAll(".tblInpt")[0].setAttribute("horseid", data.horse.id);
        drawSelect(dataRacecourses, row.querySelectorAll(".tblInpt")[1], 'id', 'name', 'Hipódromos', data.racecourse.id);
        drawSelect(dataDistances, row.querySelectorAll(".tblInpt")[2], 'id', 'name', 'Distancia', data.distance.id);
        row.querySelectorAll(".tblInpt")[3].value = data.time;
        row.querySelectorAll(".tblInpt")[3].setAttribute("datanum", data.time.replace(/[^0-9\s]/g, ""));
        row.querySelectorAll(".tblInpt")[4].value = data.finishtime;
        row.querySelectorAll(".tblInpt")[4].setAttribute("datanum", data.finishtime.replace(/[^0-9\s]/g, ""));
        row.querySelectorAll(".tblInpt")[5].value = data.obs;
        let splited = data.date.date.split("-");
        row.querySelectorAll(".tblInpt")[6].value = dateForInpt(new Date(splited[0], (parseFloat(splited[1])-1), splited[2]));

        row.querySelectorAll(".tblBtns")[1].style.display = "none";
        row.querySelectorAll(".tblBtns")[0].style.display = "";
    }
}
//Función para llamar el servicio que inserta o modifica un usuario.
async function updateAPI(row,id) {
    let validationpars = [
        {
            "key": "horseid",
            "id": row.querySelectorAll(".tblInpt")[0],
            "msg": ""
        },
        {
            "key": "racecourseid",
            "id": row.querySelectorAll(".tblInpt")[1],
            "msg": ""
        },
        {
            "key": "distanceid",
            "id": row.querySelectorAll(".tblInpt")[2],
            "msg": ""
        },
        {
            "key": "time",
            "id": row.querySelectorAll(".tblInpt")[3],
            "msg": ""
        },
        {
            "key": "finishtime",
            "id": row.querySelectorAll(".tblInpt")[4],
            "msg": ""
        },
        {
            "key": "date",
            "id": row.querySelectorAll(".tblInpt")[6],
            "msg": ""
        },
        {
            "key": "obs",
            "id": row.querySelectorAll(".tblInpt")[5],
            "msg": ""
        },
    ]

    var par = {};
    par.id = id;
    par.sessionid = localStorage.getItem("sessionid");
    par.horseid = row.querySelectorAll(".tblInpt")[0].getAttribute("horseid");
    par.racecourseid = row.querySelectorAll(".tblInpt")[1].value;
    par.distanceid = row.querySelectorAll(".tblInpt")[2].value;
    par.time = row.querySelectorAll(".tblInpt")[3].value.replace(" ","|");
    par.finishtime = row.querySelectorAll(".tblInpt")[4].value.replace(" ","|");
    par.obs = (row.querySelectorAll(".tblInpt")[5].value.replaceAll("'","/*.*/")).replaceAll("`","/*:*/");
    par.date = row.querySelectorAll(".tblInpt")[6].value;
    //Hacemos las validaciones
    var haserror = false;
    //Cómo son muchos campos simplificamos con un arreglo que contiene los campos a verificar
    validationpars.forEach((e) => {
        //Que el nombre no esté vacío
        if (!(par[e.key] !== undefined && par[e.key] !== null && par[e.key] !== "")) {
            errRowInpt(e.id, 6000);
            haserror = true;
        }
    });
    
    //Si tiene errores detenemos la llamada al servicio
    if (haserror) {
        errTbl(document.querySelector(".tblSct"), "Faltan campos obligatorios", 6000);
        return;
    }

    await validDateRange(par.date).then().catch(() => {
        haserror = true;
        errRowInpt(row.querySelectorAll(".tblInpt")[6], 6000);
    });

    if (haserror) {
        errTbl(document.querySelector(".tblSct"), "Fecha inválida", 6000);
        return;
    }

    //Funcion si todo en la llamada al servicio y se obtiene respuesta
    let onsuccess = (rsp) => {
        switch (rsp.status) {
            case 200:
                data = JSON.parse(rsp.response);
                //Si obtenemos un id insertado/modificado refrescamos la tabla 
                if (data.id != null && data.id != undefined) {
                    //Llevaos el ordenamiento por "id" y cargamos el listado
                    resetOrder(document.querySelector(".pgSctTbl")).then(() => { listAPI(); });
                    //Como definimos función flecha podemos leer los parametros para determinar si era nuevo y mostrar mensaje exitoso correcto
                    successMsgShow((par.id == 0) ? "Traqueo creado con éxito" : "Traqueo modificado con éxito");
                }
                //Cerramos el popup
                closePopups();
                break;
            case 400:
                data = JSON.parse(rsp.response);
                errTbl(document.querySelector(".tblSct"), data.msg, 6000);
                break;
            case 401:
                //NO autorizado
                localStorage.clear();
                gotoPage('login', '', {});
                break;
            case 403:
                //Error de privilegios - prohibido
                errTbl(document.querySelector(".tblSct"), "No tiene privilegios para ejecutar esta acción", 6000);
                break;
            case 409:
                errTbl(document.querySelector(".tblSct"), "Ya existe este traqueo", 6000);
                break;
            default:
                data = JSON.parse(rsp.response);
                console.log(data);
                break;
        }
    }
    //Lamamos al servicio si todo sale ok se ejecuta el onsuccess si falla sale por el catch
    callWS("POST", "records/traqueos/update", par).then(onsuccess).catch((e) => { console.log("Ocurrió un error " + e) });
}
//Función para llamar el servicio de eliminar, se ejecuta al confirmar el boton
function deleteAPI(id) {
    var par = {};
    par.id = id;
    par.sessionid = localStorage.getItem("sessionid");
    //Funcion si todo en la llamada al servicio y se obtiene respuesta
    let onsuccess = (rsp) => {
        switch (rsp.status) {
            case 200:
                data = JSON.parse(rsp.response);
                //Si obtenemos un id insertado/modificado refrescamos la tabla
                if (data.id != null && data.id != undefined) {
                    listAPI();
                    //Mostramos mensaje de eliminado con éxito
                    successMsgShow("Traqueo eliminado con éxito");
                }
                //Cerramos el popup
                closePopups();
                break;
            case 204:
                //Error de dependencias
                errInpt(document.getElementById("popupDelFrm").querySelector(".poupDelItemLbl"), "Registro no encontrado", 6000);
                break;
            case 304:
                //Error de dependencias
                errInpt(document.getElementById("popupDelFrm").querySelector(".poupDelItemLbl"), "Existen dependencias que no permiten ejecutar esta acción", 6000);
                break;
            case 401:
                //NO autorizado
                localStorage.clear();
                gotoPage('login', '', {});
                break;
            case 403:
                //Error de privilegios - prohibido
                errInpt(document.getElementById("popupDelFrm").querySelector(".poupDelItemLbl"), "No tiene privilegios para ejecutar esta acción", 6000);
                break;
            default:
                data = JSON.parse(rsp.response);
                console.log(data);
                break;
        }
    }
    //Lamamos al servicio si todo sale ok se ejecuta el onsuccess si falla sale por el catch
    callWS("POST", "records/traqueos/delete", par).then(onsuccess).catch((e) => { console.log("Ocurrió un error " + e) })
}
//Función retorna la inforación detallada del usuario
function entryAPI(id) {
    return new Promise((resolve, reject) => {
        var par = {};
        par.id = id;
        par.sessionid = localStorage.getItem("sessionid");
        //Funcion si todo en la llamada al servicio y se obtiene respuesta
        let onsuccess = (rsp) => {
            switch (rsp.status) {
                case 200:
                    data = JSON.parse(rsp.response);
                    resolve(data);
                    break;
                case 401:
                    //NO autorizado
                    localStorage.clear();
                    gotoPage('login', '', {});
                    break;
                default:
                    data = JSON.parse(rsp.response);
                    console.log(data);
                    break;
            }
        }
        //Lamamos al servicio si todo sale ok se ejecuta el onsuccess si falla sale por el catch
        callWS("GET", "records/traqueos/entry", par).then(onsuccess).catch((e) => { console.log("Ocurrió un error " + e) });
    });
}
//Función para rellenar el formulario de edición
function setFrm(rsp) {
    return new Promise((resolve, reject) => {
        document.getElementById("updName").value = rsp.name;
        document.getElementById("updStatus").checked = (rsp.status.id == 1) ? true : false;
        document.getElementById("updAbbr").value = rsp.abbr;
        document.getElementById("popupUpdFrm").querySelector(".saveBtn").setAttribute("upid", rsp.id);
        document.getElementById("creationLbl").innerText = "Creado: " + rsp.created.formatted;
        if (rsp.created.date != rsp.modified.date)
            document.getElementById("updatedLbl").innerText = "Modificado: " + rsp.modified.formatted;
        else
            document.getElementById("updatedLbl").innerText = "";
        setTimeout(function () { resolve("cargado") }, 100);
    });
}
//Se realizan las validaciones de privilegios de front, se inactivan y muestran los mensajes correspondientes
function privValidations(rsp) {
    return new Promise((resolve, reject) => {
        //ELIMINAR
        let popupdelBtn = document.getElementById("popupDelFrm").querySelector(".saveBtn");
        //Si existe el popup de eliminar validamos los privilegios y "desactivamos", no uso el disabled para mostrar mensaje propio
        if (popupdelBtn) {
            if (!rsp.delete) {
                popupdelBtn.setAttribute("inactive", "");
            } else {
                popupdelBtn.removeAttribute("inactive");
            }
        }

        //EDITAR
        let popupeditBtn = document.getElementById("popupUpdFrm").querySelector(".saveBtn");
        //Si existe el popup de eliminar validamos los privilegios y "desactivamos", no uso el disabled para mostrar mensaje propio
        if (popupeditBtn) {
            if (!rsp.update) {
                popupeditBtn.setAttribute("edit", "inactive");
            } else {
                popupeditBtn.removeAttribute("edit");
            }
        }

        //CREAR
        let popupaddBtn = document.getElementById("popupUpdFrm").querySelector(".saveBtn");
        //Si existe el popup de eliminar validamos los privilegios y "desactivamos", no uso el disabled para mostrar mensaje propio
        if (popupaddBtn) {
            if (!rsp.create) {
                popupaddBtn.setAttribute("add", "inactive");
            } else {
                popupaddBtn.removeAttribute("add");
            }
        }
        let tbladdBtn = document.querySelector(".addBtn");
        if (tbladdBtn) {
            if (!rsp.create) {
                tbladdBtn.setAttribute("disabled", "");
            } else {
                tbladdBtn.removeAttribute("disabled");
            }
        }
        resolve();
    });

}
//Se requiere adicionalmente llamar el mismo listado de horses pero cargando las opciones para el linaje, aplica busqueda y trae siempre todos los registros
function listHorsesAPI(box, srch) {
    var par = {};
    par.filter = srch;
    par.order = 3;
    par.statusid = "1";
    par.genderid = "";
    par.furid = "";
    par.harasid = "";
    par.offset = 0;
    par.numofrec = 999;
    par.sessionid = localStorage.getItem("sessionid");
    //Funcion si todo en la llamada al servicio y se obtiene respuesta
    let onsuccess = async (rsp) => {
        switch (rsp.status) {
            case 200:
                data = JSON.parse(rsp.response);
                var onclick = null;
                //Función onclick para las opciones del listado de busqueda de caballos linage
                onclick = async (opt) => {
                    if (opt.parentElement != null) {
                        opt.parentElement.previousElementSibling.value = opt.innerText;
                        opt.parentElement.previousElementSibling.setAttribute("horseid", opt.getAttribute("value"));
                        opt.parentElement.innerHTML = "";
                    }
                }
                drawSrchSelect(data.records, box, 'id', 'name+ (+id+)', undefined, '', onclick, [{'abbr': 'abbr'}], true);
                break;
            case 401:
                //NO autorizado
                localStorage.clear();
                gotoPage('login', '', {});
                break;
            case 403:
                //Si no tiene privilegios se muestra el mensaje de error
                errTbl(document.querySelector(".tblSct"), "No tiene privilegios para visualizar los registros");
                break;
            default:
                data = JSON.parse(rsp.response);
                console.log(data);
                break;
        }
    }
    //Lamamos al servicio si todo sale ok se ejecuta el onsuccess si falla sale por el catch
    callWS("POST", "horses/horses/list", par).then(onsuccess).catch((e) => { console.log("Ocurrió un error " + e) });
}
//Se requiere adicionalmente llamar el mismo listado de horses pero cargando las opciones para el linaje, aplica busqueda y trae siempre todos los registros
let dataRacecourses = [];
function listRacecoursesAPI() {
    return new Promise((resolve, reject) => {
        var par = {};
        par.filter = "";
        par.order = 1;
        par.offset = 0;
        par.numofrec = 999;
        par.sessionid = localStorage.getItem("sessionid");
        //Funcion si todo en la llamada al servicio y se obtiene respuesta
        let onsuccess = async (rsp) => {
            switch (rsp.status) {
                case 200:
                    data = JSON.parse(rsp.response);
                    //Asignamos el atributo disabled a los que traigan el status cómo inactivo para que el "drawSelect" deshabilite las opciones que corresponden
                    let disInactives = (data.records).map((r) => {
                        if (r.status.id == 0) r.disabled = true;
                        return r;
                    });
                    dataRacecourses = disInactives;
                    resolve();
                    break;
                case 401:
                    //NO autorizado
                    localStorage.clear();
                    gotoPage('login', '', {});
                    resolve();
                    break;
                case 403:
                    //Si no tiene privilegios se muestra el mensaje de error
                    errTbl(document.querySelector(".tblSct"), "No tiene privilegios para visualizar los hipódromos");
                    resolve();
                    break;
                default:
                    data = JSON.parse(rsp.response);
                    console.log(data);
                    reject();
                    break;
            }
        }
        //Lamamos al servicio si todo sale ok se ejecuta el onsuccess si falla sale por el catch
        callWS("POST", "hippodromes/racecourses/list", par).then(onsuccess).catch((e) => { console.log("Ocurrió un error " + e) });
    });

}
//Se requiere invocar el listado de "estados" para el select del filtro y el insertar nuevo
let dataDistances = [];
function listDistancesAPI() {
    return new Promise((resolve, reject) => {
        var par = {};
        par.filter = "";
        par.order = 1;
        par.offset = 0;
        par.numofrec = 9999;
        par.sessionid = localStorage.getItem("sessionid");
        //Funcion si todo en la llamada al servicio y se obtiene respuesta
        let onsuccess = async (rsp) => {
            switch (rsp.status) {
                case 200:
                    data = JSON.parse(rsp.response);
                    //Asignamos el atributo disabled a los que traigan el status cómo inactivo para que el "drawSelect" deshabilite las opciones que corresponden
                    let disInactives = (data.records).map((r) => {
                        if (r.status.id == 0) r.disabled = true;
                        return r;
                    });
                    dataDistances = disInactives;
                    resolve();
                    break;
                case 401:
                    //NO autorizado
                    localStorage.clear();
                    gotoPage('login', '', {});
                    reject();
                    break;
                case 403:
                    reject();
                    //errInpt("addTimeDist", "No tiene privilegios para visualizar las distancias", 0);
                    break;
                default:
                    data = JSON.parse(rsp.response);
                    console.log(data);
                    reject();
                    break;
            }
        }
        //Lamamos al servicio si todo sale ok se ejecuta el onsuccess si falla sale por el catch
        callWS("POST", "hippodromes/distances/list", par).then(onsuccess).catch((e) => { console.log("Ocurrió un error " + e) });
    });
}
//Llamada inicial
document.addEventListener("DOMContentLoaded", function () {
    traqueosInit();
    //Evento para ocultar los select de busqueda
    document.body.addEventListener("click", function (e) {
        setTimeout(function () {
            document.querySelectorAll(".optList").forEach(obj => {
                if (e.target != obj && e.target != obj.previousElementSibling) obj.innerHTML = "";
            })
        }, 300);
    });
});