//Función incial se llama una vez cargado el modulo acá se asignan los eventos iniciales
async function meetingsInit() {
    //Evento mostrar popup de insertar usuario
    document.querySelector(".addBtn").addEventListener("click", function () {
        //Si existe uno activo en editar lo restauramos y cerramos
        let someactive = document.getElementById("pgTbl").querySelector(".tr[active]");
        if(someactive != undefined) resetdataRow(someactive);

        //Desactivamos el botón de agregar (hasta guardar o cancelar)
        this.setAttribute("disabled", "");
        //Blanqueamos el addline y lo mostramos
        blankForm("addline", ["input", "select"]);        
        document.getElementById("addline").querySelectorAll("input,select").forEach(e => {
            e.removeAttribute("disabled");
            e.removeAttribute("style");
        });
        document.getElementById("addline").setAttribute("active", "");
        document.getElementById("addline").querySelectorAll(".tblBtns")[1].classList.remove("warning");
        document.getElementById("addline").querySelectorAll(".tblBtns")[0].style.display = "none";
        document.getElementById("addline").querySelectorAll(".tblBtns")[1].style.display = "";        
        document.getElementById("addline").parentElement.parentElement.style.display = "";
        focusIn(document.getElementById("addline").querySelectorAll("input[type='text']")[0]);
    });

    let refreshlist = () => {
        //Llevamos el offset a 0 removiendo cualquier pagina activa antes de llamar al 
        let selpag = document.querySelector(".pgSctTbl").querySelector(".pagNum[selected]");
        if (selpag != null) selpag.removeAttribute("selected");
        listAPI();
    }
    //EVENTO REFRESCAR TABLA EN EL AL HACER BUSQUEDA CON ENTER
    document.getElementById("searchTbl").addEventListener("keyup", function (e) {
        if (this.value != "") this.value = fieldFormat(this.value, "search");
        //Si le da al enter, refrescamos el listadol.  
        if (e.key != null && (e.key).toLowerCase() == 'enter') {
            refreshlist();
        }
    });

    //EVENTO REFRESCAR TABLA EN EL AL HACER FILTRO DE LA TABLA POR STATUS Y GENERO
    document.getElementById("statusTbl").addEventListener("change", refreshlist);
    document.getElementById("racecoursesTbl").addEventListener("change", refreshlist);
    let refreshlistdates = async (ele) => {
        let error = false;
        //Aplicamos algunas validaciones adicionales para las fechas
        let from = document.getElementById("fromFilt");
        let to = document.getElementById("toFilt");
        if (from.value !== "") {
            to.setAttribute("min", from.value);
            to.setAttribute("max", dateForInpt(new Date()));
            //Como el from tiene valor validamos que no exceda al ahora
            let fromdate = new Date(from.value.split("-"));
            if (fromdate.getTime() > (new Date()).getTime()) {
                errInpt(from.getAttribute("id"), "Fecha desde inválida", 6000);
                error = true;
            }
            await validDateRange(from.value).then().catch(() => {
                errInpt(from.getAttribute("id"), "Fecha desde inválida", 6000);
                error = true;
            });
        } else {
            to.setAttribute("min", dateForInpt(globmindate));
        }
        if (to.value !== "") {
            from.setAttribute("max", to.value);
            let todate = new Date(to.value.split("-"));
            if (todate.getTime() > (new Date()).getTime()) {
                errInpt(to.getAttribute("id"), "Fecha hasta inválida", 6000);
                error = true;
            }
            await validDateRange(to.value).then().catch(() => {
                errInpt(from.getAttribute("id"), "Fecha hasta inválida", 6000);
                error = true;
            });
        } else {
            from.setAttribute("max", dateForInpt(new Date()));
        }
        if (to.value != "" && from.value != "") {
            //Fechas
            let fromdate = new Date(from.value.split("-"));
            let todate = new Date(to.value.split("-"));
            if (fromdate.getTime() > todate.getTime()) {
                errInpt(ele.getAttribute("id"), "Rango de fechas inválido", 6000);
                error = true;
            }
        }

        if (error) {
            listDraw({
                numofrecords: 0,
                records: []
            });
            return;
        } else {
            errBlank(to.getAttribute("id"));
            errBlank(from.getAttribute("id"));

        }

        //Llevamos el offset a 0 removiendo cualquier pagina activa antes de llamar al 
        let selpag = document.querySelector(".pgSctTbl").querySelector(".pagNum[selected]");
        if (selpag != null) selpag.removeAttribute("selected");
        listAPI();
    }
    //Eventos rango de rechas
    document.getElementById("toFilt").addEventListener("change", function () { refreshlistdates(this) });
    document.getElementById("toFilt").setAttribute("min", dateForInpt(globmindate));
    document.getElementById("toFilt").setAttribute("max", dateForInpt(new Date()));
    document.getElementById("fromFilt").addEventListener("change", function () { refreshlistdates(this) });
    document.getElementById("fromFilt").setAttribute("max", dateForInpt(new Date()));
    document.getElementById("fromFilt").setAttribute("min", dateForInpt(globmindate));


    //Formulario de crear/modificar evento de pestañas 
    document.querySelectorAll(".frmHeadBox").forEach(e => {
        e.addEventListener("click", function () {
            let cnt = this.parentElement;
            let activo = cnt.parentElement.querySelector(".frmHeadBox[active]");
            if (activo != undefined) {
                activo.removeAttribute("active");
                activo.parentElement.querySelector(".popupSctScroll").style.height = "";
                activo.parentElement.querySelector(".popupFrmCnt").style.height = "";
                activo.querySelector(".frmBoxOpnBtn").innerHTML = '<i class="fa-solid fa-caret-down"></i>';
            }
            cnt.querySelector(".frmHeadBox").setAttribute("active", "");              
            cnt.querySelector(".popupFrmCnt").style.height = (cnt.querySelector(".popupFrmCnt").scrollHeight) + "px";            
            if((window.innerHeight * 0.6) <= (cnt.querySelector(".popupFrmCnt").scrollHeight))
                cnt.querySelector(".popupFrmCnt").parentElement.style.height = ((window.innerHeight * 0.6) - 65) + "px";
            else 
                cnt.querySelector(".popupFrmCnt").parentElement.style.height = "";
            this.querySelector(".frmBoxOpnBtn").innerHTML = '<i class="fa-solid fa-caret-up"></i>';
        });
    });

    /**UPDATE CARRERAS EVENTOS DE LOS CAMPOS INPUTS DEL FORMULARIO**/
    //Inicializamos el select de las apuestas dispnibles
    listBetsAPI().then(() => {
        let optionSelect = {
            ele: '#updPlaysSel',
            //Le damos el formato que corresponde al arreglo
            labelKey: 'name',
            valueKey: 'id',
            options: bets,
            placeholder: 'Seleccione una jugada',
            hideClearButton: false,
            autoSelectFirstOption: false,
            silentInitialValueSet: false,
            multiple: true,
            search: false,
            noOptionsText: 'No hay opciones',
            selectAllText: 'Seleccionar Todas',//Label de la opción para escoger todos
            allOptionsSelectedText: 'Todas ',//Texto que se muestra en el campo cuando están marcados todos 'Todos'+num
            maxWidth: "100%",
            dropboxWidth: "100%",
            optionSelectedText: 'Opción Seleccionada',
            optionsSelectedText: 'Opciones Seleccionadas',
            showValueAsTags: true,
            additionalClasses:"popInpt"
        }        
        VirtualSelect.init(optionSelect);
    });
    
    //Cuando cambia la condicion seteamos la serie
    document.getElementById("updFstCond").addEventListener("change", function () {
        if (this.value != "") {
            if (document.getElementById("updClasicid").value == "" || !document.getElementById("updIsClasic").checked) {
                document.getElementById("updSerie").value = conditions1.find(c => c.id == this.value)?.serie;
            }
            document.getElementById("updCondObs").value = document.getElementById("updCondObs").value + " " + conditions1.find(c => c.id == this.value)?.dsc;
        }
    });

    document.getElementById("updClasicid").addEventListener("change", function () {
        if (this.value != "") {
            document.getElementById("updSerie").value = clasics.find(c => c.id == this.value)?.abbr;
        } else {
            if (document.getElementById("updFstCond").value != "") {                
                document.getElementById("updSerie").value = conditions1.find(c => c.id == document.getElementById("updFstCond").value)?.serie;
            } else {
                document.getElementById("updSerie").value = "";
            }
        }
    });

    //Cuando cambia la condicion seteamos la serie
    /*
    document.getElementById("updSecCond").addEventListener("change", function () {
        if (this.value != "") {
            document.getElementById("updCondObs").value = document.getElementById("updCondObs").value + " " + conditions2.find(c => c.id == this.value)?.dsc;
        }
    });*/

    //Cuando cambia la condicion seteamos la serie
    document.getElementById("updIsClasic").addEventListener("change", function () {
        if (!this.checked) {
            document.getElementById("updClasicid").value = "";
            document.getElementById("updClasicid").options[0].innerText = "No Clásico";
            document.getElementById("updClasicid").setAttribute("disabled", "");
            if (document.getElementById("updFstCond").value != "") {
                document.getElementById("updSerie").value = conditions1.find(c => c.id == document.getElementById("updFstCond").value)?.serie;
            }
        } else {            
            document.getElementById("updClasicid").options[0].innerText = "Seleccione un Clásico";
            document.getElementById("updClasicid").removeAttribute("disabled");
        }
    });

    //Asignamos evento al introducir texto al campo abbr formulari
    let delay = null;
    document.getElementById("updCondObs").addEventListener("keyup", function (e) {
        if (this.value != "") {                        
            let cnt = document.querySelector(".frmHeadBox[active]").parentElement;
            cnt.querySelector(".popupFrmCnt").style.height = "max-content";
            this.value = this.value.replaceAll("\n", "");
            this.value = limitSize(this.value, 500);

            errBlank(this.getAttribute("id"));
            document.getElementById("updCondObs").style.height = "";
            //Luego de que insertamos hacemos un resize del campo.
            document.getElementById("updCondObs").style.height = (document.getElementById("updCondObs").scrollHeight - 17) + "px";

            clearTimeout(delay);
            delay = setTimeout(function (cnt) {
                cnt.querySelector(".popupFrmCnt").style.height = cnt.querySelector(".popupFrmCnt").scrollHeight + "px";                
            }, 500, cnt);
        }
    });

    //Los puestos de primer lugar segundo lugar ...
    formatAmount(document.getElementById("updMainpriceAmo"));
    formatAmount(document.getElementById("updExtpriceAmo"));
    formatPercent(document.getElementById("updFstPlace"));
    formatPercent(document.getElementById("updScdPlace"));
    formatPercent(document.getElementById("updTrhPlace"));
    formatPercent(document.getElementById("updFthPlace"));
    formatPercent(document.getElementById("updFfthPlace"));
    
    document.getElementById("popupUpdFrm").querySelectorAll(".fmtAmount").forEach(e => { 
        e.addEventListener("keyup", function (e) {
            if (this.value != "") {
                this.value = fieldFormat(this.value, "amount");
            }
        });
    })

    /*******/
    /**UPDATE LLEGADAS EVENTOS DE LOS CAMPOS INPUTS DEL FORMULARIO**/
    formatAmount(document.getElementById("arrvWinDiv"));
    formatAmount(document.getElementById("arrvPlace1Div"));
    formatAmount(document.getElementById("arrvPlace2Div"));

    
    document.getElementById("arrvFinishTime").addEventListener("keyup", function (e) {
        if (this.value != "") {
            this.value = fieldFormat(this.value, "validtime");
        }
    });
    //Tiempos en llegadas
    document.getElementById("popupArrvFrm").querySelectorAll(".finishtime").forEach(e => {
        e.addEventListener("keyup", function (e) {
            if (this.value != "") {
                this.value = fieldFormat(this.value, "validtime");
            }
        });
    });
    
    
    //-------//

    //EVENTOS DE BOTONES GUARDAR Y CANCELAR
    //Popup "CREAR/EDITAR"
    let usrpop = document.getElementById("popupUpdFrm");
    //Evento al guardar el crear/editar el
    usrpop.querySelector(".saveBtn").addEventListener("click", function () {
        //Si no tiene el atributo inactivo se intenta guardar
        if (this.getAttribute("inactive") != null && this.getAttribute("inactive") != undefined) {
            errInpt(document.getElementById("popupUpdFrm").querySelector(".errmsgSct"), "No tiene privilegios para ejecutar esta acción", 6000);
        } else {
            //Acá se intenta el guardar
            let meetingid = document.getElementById("pgTbl").querySelector(".tbody>div[active]")?.getAttribute("itemid");
            updateRacesAPI(meetingid, (this.getAttribute("upid") != undefined && this.getAttribute("upid") != null) ? this.getAttribute("upid") : 0);
        }
    });
    //Evento cancela popup crear/editar
    usrpop.querySelector(".backBtn").addEventListener("click", function () {
        closePopups();
    });
    //Evento de procesar una carrera
    usrpop.querySelector(".processBtn").addEventListener("click", function () {
        if (this.getAttribute("inactive") != null && this.getAttribute("inactive") != undefined) {
            errInpt(document.getElementById("popupUpdFrm").querySelector(".errmsgSct"), "No tiene privilegios para ejecutar esta acción", 6000);
        } else {
            processRacesAPI(this.getAttribute("upid"),true).then(() => {
                //Refrescamos el listado externo de carrearas para mostrar el cambio de status
                refreshMeets();
                //Cargamos toda la data de la llegada si lo procesamos con exito
                entryRacesAPI(this.getAttribute("upid")).then((rsp) => {
                    //Restauramos las pestañas de este popup
                    document.getElementById("popupArrvFrm").querySelectorAll(".frmHeadBox").forEach(b => {
                        let cnt = b.parentElement;
                        cnt.querySelector(".frmHeadBox").removeAttribute("disabled");
                        cnt.querySelector(".frmHeadBox").removeAttribute("active");                    
                        cnt.querySelector(".popupFrmCnt").style.height = "";
                        cnt.querySelector(".frmBoxOpnBtn").innerHTML = '<i class="fa-solid fa-caret-down"></i>';
                    });
                    setFrmArrv(rsp.entry);
                    listRacersAPI(rsp.entry.id,8).then(async racers => {                
                        await showPopup("popupArrvFrm");

                        let cnt = document.getElementById("popupArrvFrm").querySelectorAll(".frmHeadBox")[0].parentElement;
                        cnt.querySelector(".frmHeadBox").setAttribute("active", "");
                        cnt.querySelector(".popupFrmCnt").style.height = cnt.querySelector(".popupFrmCnt").scrollHeight + "px";
                        cnt.querySelector(".frmBoxOpnBtn").innerHTML = '<i class="fa-solid fa-caret-up"></i>';         

                        listDrawArrvRacers(racers, !(rsp.entry.status.id == 1));
                    });
                });
            });
        }
        
    });
    //Evento de REVERTIR una carrera
    usrpop.querySelector(".revertirBtn").addEventListener("click", function () {
        if (this.getAttribute("inactive") != null && this.getAttribute("inactive") != undefined) {
            errInpt(document.getElementById("popupUpdFrm").querySelector(".errmsgSct"), "No tiene privilegios para ejecutar esta acción", 6000);
        } else {
            processRacesAPI(this.getAttribute("upid")).then(() => {
                /*
                //Refrescamos el listado externo de carrearas para mostrar el cambio de status
                let meetingid = document.getElementById("pgTbl").querySelector(".tbody>div[active]")?.getAttribute("itemid");
                listRacesAPI(meetingid).then(function (data) {
                    let activerow = document.getElementById("pgTbl").querySelector(".tbody>div[active]");
                    listDrawRaces(activerow, data);
                });
                */
                refreshMeets();
                //Cargamos toda la data de la llegada si lo procesamos con exito
                entryRacesAPI(this.getAttribute("upid")).then((rsp) => {
                    setFrmRace(rsp.entry);
                    listRacersAPI(rsp.entry.id).then(async racers => {
                        listDrawRacers(rsp.entry.id, racers, !(rsp.entry.status.id == 0));
                    });
                    //Resize del campo condiciones si tiene valores y editamos
                    document.getElementById("updCondObs").dispatchEvent(new Event("keyup"));
                });
            });
        }
    });
    //Evento "mostrar" llegada
    usrpop.querySelector(".arriveBtn").addEventListener("click", function () {
        if (this.getAttribute("inactive") != null && this.getAttribute("inactive") != undefined) {
            errInpt(document.getElementById("popupUpdFrm").querySelector(".errmsgSct"), "No tiene privilegios para ejecutar esta acción", 6000);
        } else {
            entryRacesAPI(this.getAttribute("upid")).then((rsp) => {
                //Restauramos las pestañas de este popup
                document.getElementById("popupArrvFrm").querySelectorAll(".frmHeadBox").forEach(b => {
                    let cnt = b.parentElement;
                    cnt.querySelector(".frmHeadBox").removeAttribute("disabled");
                    cnt.querySelector(".frmHeadBox").removeAttribute("active");
                    cnt.querySelector(".popupFrmCnt").style.height = "";
                    cnt.querySelector(".frmBoxOpnBtn").innerHTML = '<i class="fa-solid fa-caret-down"></i>';
                });
                //Este readonly es exclusivo para los botones inferiores por eso no considero el status
                setFrmArrv(rsp.entry, (this.getAttribute("readonly") != null));
                listRacersAPI(rsp.entry.id, 8).then(async racers => {
                    await showPopup("popupArrvFrm");

                    let cnt = document.getElementById("popupArrvFrm").querySelectorAll(".frmHeadBox")[0].parentElement;
                    cnt.querySelector(".frmHeadBox").setAttribute("active", "");
                    cnt.querySelector(".popupFrmCnt").style.height = cnt.querySelector(".popupFrmCnt").scrollHeight + "px";
                    cnt.querySelector(".frmBoxOpnBtn").innerHTML = '<i class="fa-solid fa-caret-up"></i>';
                    //Acá si porque no se deben poder editar cuando cambia el status
                    listDrawArrvRacers(racers, (this.getAttribute("readonly") != null || !(rsp.entry.status.id == 1)));
                });
            });
        }
    });

    //Popup "LLegadas"
    let arvpop = document.getElementById("popupArrvFrm");    
    arvpop.querySelector(".saveBtn").addEventListener("click", function () {
        //Si no tiene el atributo inactivo se intenta guardar
        if (this.getAttribute("inactive") != null && this.getAttribute("inactive") != undefined) {
            errInpt(document.getElementById("popupUpdFrm").querySelector(".errmsgSct"), "No tiene privilegios para ejecutar esta acción", 6000);
        } else {
            //Acá se intenta el guardar
            ((this.getAttribute("upid") != undefined && this.getAttribute("upid") != null) ? updateArriveAPI(this.getAttribute("upid")) : "");
        }
    });
    arvpop.querySelector(".backBtn").addEventListener("click", function () {
        closePopups();
    });
    arvpop.querySelector(".processBtn").addEventListener("click", function () {
        closeRacesAPI(this.getAttribute("upid"),true).then(async () => {
            refreshMeets();
            closePopups();
        });
    });
    arvpop.querySelector(".revertirBtn").addEventListener("click", function () {
        closeRacesAPI(this.getAttribute("upid")).then(async () => {
            entryRacesAPI(this.getAttribute("upid")).then((rsp) => {
                setFrmArrv(rsp.entry);
                listRacersAPI(rsp.entry.id, 8).then(async racers => {
                    listDrawArrvRacers(racers,  !(rsp.entry.status.id == 1));
                });
            });
            refreshMeets();
        });
    });    

    //Popup "ELIMINAR 
    let delpop = document.getElementById("popupDelFrm");
    //Evento al guardar el crear/editar
    delpop.querySelector(".saveBtn").addEventListener("click", function () {
        //Si no tiene el atributo inactivo se intenta guardar
        if (this.getAttribute("inactive") != null && this.getAttribute("inactive") != undefined) {
            errInpt(document.getElementById("popupDelFrm").querySelector(".poupDelItemLbl"), "No tiene privilegios para ejecutar esta acción", 6000);
        } else {
            //Acá se intenta el guardar
            if (this.getAttribute("type") == 'race') {
                deleteRacesAPI(this.getAttribute("delid"))
            } else if (this.getAttribute("type") == 'racer') {
                deleteRacerAPI(this.getAttribute("delid"));
            } else {
                deleteAPI(this.getAttribute("delid"));
            }
        }
    });
    //Evento cancela popup 
    delpop.querySelector(".backBtn").addEventListener("click", function () {
        closePopups();
    });

    //Popup "CONFIRMACION PROCESO MASIVO"
    let cnfpop = document.getElementById("popupCnfFrm");
    //Evento al guardar el crear/editar el usuario
    cnfpop.querySelector(".saveBtn").addEventListener("click", async function () {
        //Si no tiene el atributo inactivo se intenta guardar
        if (this.getAttribute("inactive") != null && this.getAttribute("inactive") != undefined) {
            errInpt(document.getElementById("popupCnfFrm").querySelector(".poupDelItemLbl"), "No tiene privilegios para ejecutar esta acción", 6000);
        } else {
            //Acá se intenta el guardar            
            let ids = (this.getAttribute("raceids").split("-"));
            let successid = [];
            let errorid = [];
            let endfunct = async () => {
                refreshMeets();
                /*
                let openrow = document.getElementById("pgTbl").querySelector(".tbody>div[active]");
                await listRacesAPI(openrow?.getAttribute("itemid")).then(function (data) {
                    listDrawRaces(openrow, data);
                });*/
                closePopups();
            }
            if (Math.abs(this.getAttribute("processtype")) == 1) {
                if (ids.length > 0) {
                    //Esperamos que se confirme el ciclo
                    /*
                    ids.forEach(async (e,i) => {
                        await processWhlRacesAPI(e).then((r) => {
                            successid.push(r.id);
                        }).catch((rsp) => {
                            errorid.push({
                                'id': e,
                                'statuserr': rsp.status,
                                'statusmsg': JSON.parse(rsp.response)?.msg
                            });
                        });
                        if (i == (ids.length - 1)) {
                            if (errorid.length > 0) {
                                errTbl(document.getElementById("pgTbl").querySelector(".tbody>div[active]")?.querySelector(".calledTblSct"), "Orurrio un error al " + ((this.getAttribute("processtype") > 0) ? "procesar" : "revertir") + " " + errorid.length + " " + ((errorid.length == 1) ? "llamado" : "llamados"), 6000);
                            } else if (successid.length == ids.length) {
                                successMsgShow("Todos los llamados han sido " + ((this.getAttribute("processtype") > 0) ? "procesados" : "revertidos") + " con éxito");
                            }
                            endfunct();
                        }
                    });*/
                    let cnt = 0;
                    while ((successid.length + errorid.length) < ids.length) { 
                        let id = ids[cnt];
                        if ((successid.length + errorid.length) == cnt) {
                            await processWhlRacesAPI(id).then((r) => {
                                successid.push(r.id);
                                cnt++;
                            }).catch((rsp) => {
                                errorid.push({
                                    'id': id,
                                    'statuserr': rsp.status,
                                    'statusmsg': JSON.parse(rsp.response)?.msg
                                });
                                cnt++;
                            });
                            if (cnt == (ids.length)) {
                                if (errorid.length > 0) {
                                    errTbl(document.getElementById("pgTbl").querySelector(".tbody>div[active]")?.querySelector(".calledTblSct"), "Orurrio un error al " + ((this.getAttribute("processtype") > 0) ? "procesar" : "revertir") + " " + errorid.length + " " + ((errorid.length == 1) ? "llamado" : "llamados"), 6000);
                                } else if (successid.length == ids.length) {
                                    successMsgShow("Todos los llamados han sido " + ((this.getAttribute("processtype") > 0) ? "procesados" : "revertidos") + " con éxito");
                                }
                                endfunct();
                            }
                        }
                    }
                    
                }
            } else if (Math.abs(this.getAttribute("processtype")) == 2) {
                if (ids.length > 0) {
                    
                    let cnt = 0;
                    while ((successid.length + errorid.length) < ids.length) { 
                        let id = ids[cnt];
                        if ((successid.length + errorid.length) == cnt) {
                            await closeWhlRacesAPI(id).then((r) => {
                                successid.push(r.id);
                                cnt++;
                            }).catch((rsp) => {
                                errorid.push({
                                    'id': id,
                                    'statuserr': rsp.status,
                                    'statusmsg': JSON.parse(rsp.response)?.msg
                                });
                                cnt++;
                            });
                            if (cnt == (ids.length)) {
                                if (errorid.length > 0) {
                                    errTbl(document.getElementById("pgTbl").querySelector(".tbody>div[active]")?.querySelector(".calledTblSct"), "Orurrio un error al " + ((this.getAttribute("processtype") > 0) ? "cerrar" : "reabrir") + " " + errorid.length + " " + ((errorid.length == 1) ? "llegada" : "llegadas"), 6000);
                                } else if (successid.length == ids.length) {
                                    successMsgShow("Todos las llegadas han sido " + ((this.getAttribute("processtype") > 0) ? "cerradas" : "reabiertas") + " con éxito");
                                }
                                endfunct();
                            }
                        }
                    }
                    /*
                    ids.forEach(async (e,i) => {
                        
                        await closeWhlRacesAPI(e).then((r) => {
                            successid.push(r.id);
                        }).catch((rsp) => {
                            errorid.push({
                                'id': e,
                                'statuserr': rsp.status,
                                'statusmsg': JSON.parse(rsp.response)?.msg
                            });
                        });
                        if (i == (ids.length - 1)) {
                            if (errorid.length > 0) {
                                errTbl(document.getElementById("pgTbl").querySelector(".tbody>div[active]")?.querySelector(".calledTblSct"), "Orurrio un error al "+ ((this.getAttribute("processtype") > 0) ? "cerrar" : "reabrir")+ " "+errorid.length+" "+((errorid.length == 1) ? "llegada":"llegadas"), 6000);
                            } else if(successid.length == ids.length){
                                successMsgShow("Todos las llegadas han sido "+ ((this.getAttribute("processtype") > 0) ? "cerradas" : "reabiertas")+ " con éxito");
                            }
                            endfunct();
                        }
                        
                    });*/
                }
            }
        }
    });
    //Evento cancela popup 
    cnfpop.querySelector(".backBtn").addEventListener("click", function () {
        closePopups();
    });

    //INICIALIZAMOS LOS EVENTOS DE ORDENAMIENTO, CON ESTE FORMATO SE PUEDEN PASAR PARAMETROS A LA FUNCIÓN
    initOrders(document.querySelector(".pgSctTbl"), () => { listAPI(); });

    //IINICIALIZAMOS LOS EVENTOS DE LAS FLECHAS DEL PAGINADO SI EXISTE
    initPagsEvent(document.querySelector(".pgSctTbl"), () => { listAPI(); });

    let promises = [
        listHeadqueartersAPI(), listConditions1API(), listConditions2API(),
        listRacestypeAPI(), listCoursestypeAPI(), listCurrenciesAPI(),
        listImplementsAPI('M'), listImplementsAPI('I'), listStudsAPI(), listRetirementsAPI(),listStumblesAPI(), listBodiesAPI()];
    
    await Promise.all(promises);

    //Lamamos el servicio que carga el listado
    listAPI();
}
const days = ["Domingo", "Lunes", "Martes", "Miércoles", "Jueves", "Viernes", "Sábado"];
/**REUNIONES **/

//Refrescamos las reuniones validando si hay una abierta y manteniendo, esto se hace en segundo plano
async function refreshMeets() {
    let meetingid = document.getElementById("pgTbl").querySelector(".tbody>div[active]").getAttribute("itemid");//Obtenemos la reunión activa
    return listAPI().then(() => {
        let exist = document.getElementById("pgTbl").querySelector(".tbody>div[itemid='" + meetingid + "']");
        if (exist != undefined) {
            exist.querySelector(".openRow").dispatchEvent(new Event("click"));
        }
    });
}


//Función para llamar al sevicio de la lista
let notupdatedData = {}; //Guardamos la información de los 10 registros visibles localmente en caso de necesitar restaurar una linea "sin cambios"
function listAPI() {
    return new Promise((resolve, reject) => {
        var par = {};
        par.filter = document.getElementById("searchTbl").value;
        let order = document.querySelector(".pgSctTbl").querySelector(".orderCol[selected]");
        par.order = (order == null || order == undefined) ? -3 : order.getAttribute("colval");
        let actpage = document.querySelector(".pgSctTbl").querySelector(".pagNum[selected]");
        par.statusid = document.getElementById("statusTbl").value;
        par.racecourseid = document.getElementById("racecoursesTbl").value;
        par.datefrom = document.getElementById("fromFilt").value;
        par.dateto = document.getElementById("toFilt").value;
        par.offset = (actpage != null) ? (actpage.innerHTML * 10) - 10 : 0;
        par.numofrec = 10;
        par.sessionid = localStorage.getItem("sessionid");
        //Funcion si todo en la llamada al servicio y se obtiene respuesta
        let onsuccess = async (rsp) => {
            switch (rsp.status) {
                case 200:
                    data = JSON.parse(rsp.response);
                    notupdatedData = data;
                    //Validamos los privilegios
                    await privValidations(data.privileges);
                    //Si obtenemos y se setean los privilegios correctamente pintamos la tabla
                    listDraw(data, data.privileges);
                    resolve();
                    break;
                case 401:
                    //NO autorizado
                    localStorage.clear();
                    gotoPage('login', '', {});
                    reject();
                    break;
                case 403:
                    //Si no tiene privilegios se muestra el mensaje de error
                    errTbl(document.querySelector(".tblSct"), "No tiene privilegios para visualizar los registros");
                    reject();
                    break;
                default:
                    data = JSON.parse(rsp.response);
                    reject();
                    console.log(data);
                    break;
            }
        }
        //Lamamos al servicio si todo sale ok se ejecuta el onsuccess si falla sale por el catch
        callWS("POST", "records/reunions/list", par).then(onsuccess).catch((e) => { console.log("Ocurrió un error " + e) });
    });
}
//Función para pintar la respuesta de la lista en la tabla - requiere modelo base en html
function listDraw(rsp, privileges) {
    let tbl = document.getElementById("pgTbl").querySelector(".tbody");
    let list = rsp.records;
    let ele = tbl.querySelector(".tr:not([id='addline'])").parentElement.parentElement.cloneNode(true);
    let notedclass = "noteditable";

    tbl.innerHTML = "";
    //Activamos el add y agregamos/ocultamos el add
    if(rsp.create)document.querySelector(".addBtn").removeAttribute("disabled");
    //Antes que cualquier cosa insertamos la linea de "agregar"
    var clone = ele.cloneNode(true);        
    clone.style.display = "none";
    clone.removeAttribute("active");
    clone.removeAttribute("itemid");
    
    let rowSct = clone.children[0].children[0];
    rowSct.setAttribute("id", "addline");
    //No se puede desplegar hasta que se complete
    rowSct.querySelector(".openRow").style.display = "none";
    //Validación de datos en el campo del "añadir"
    var celda = rowSct.children[1];

    celda.children[0].addEventListener("keyup", function () {
        if (this.value != "") this.value = fieldFormat(this.value, 'intnumber');
    });
    //Los blanqueamos en caso de tener data
    rowSct.querySelectorAll("." + notedclass).forEach(ele => ele.innerHTML = "");
    let btnsecond = rowSct.querySelectorAll(".tblBtns");
    btnsecond[1].classList.remove("warning");
    btnsecond[1].querySelectorAll(".tblbtnIc")[0].addEventListener("click", function () {
        //Llevamos el offset a 0 removiendo cualquier pagina activa antes de llamar al 
        let selpag = document.querySelector(".pgSctTbl").querySelector(".pagNum[selected]");
        if (selpag != null) selpag.removeAttribute("selected");
        updateAPI(document.getElementById("addline"),0);
    });
    btnsecond[1].querySelectorAll(".tblbtnIc")[1].addEventListener("click", function () {
        document.getElementById("addline").removeAttribute("active");
        document.getElementById("addline").parentElement.parentElement.style.display = "none";
        document.querySelector(".addBtn").removeAttribute("disabled");
    });

    
    var celda = rowSct.children[2];
    celda.children[0].setAttribute("min", dateForInpt(globmindate));
    celda.children[0].setAttribute("max", dateForInpt(new Date()));

    tbl.appendChild(clone);
    
    if (list.length > 0) {
        for (var i = 0; i < list.length; i++) {
            
            var clone = ele.cloneNode(true);            
            clone.style.display = "";
            clone.removeAttribute("active");
            clone.querySelector(".openRow").style.display = "";
            clone.querySelector(".openRow").innerHTML = '<i class="fa-regular fa-square-plus"></i>';
            clone.querySelector(".newcall").addEventListener("click", async function () {
                //Uso de API 'Virtual select' para diseño y funcionalidad del select opciones de filtros
                blankForm("popupUpdFrm", ["input", "select", "textarea"]);
                document.getElementById("updCondObs").style.height = "";
                document.getElementById("creationLbl").innerText = "";
                document.getElementById("updatedLbl").innerText = "";
                //Llevamos el editable a true
                document.getElementById("popupUpdFrm").querySelectorAll(".popInpt,input[type='checkbox']").forEach(e => {
                    e.removeAttribute("disabled");
                    e.removeAttribute("readonly");
                    e.removeAttribute("datanum");
                });

                //Refrescamos la información del header con la reunión en la que se crea el llamado
                let meeting = document.getElementById("pgTbl").querySelector(".tbody>div[active]");//Obtenemos la reunión activa
                let meetingid = meeting?.getAttribute("itemid");
                let data = notupdatedData.records.find(r => (r.id == meetingid));
                if (data != undefined) {
                    let day = days[new Date(data.date.date+" 12:00").getDay()];
                    document.getElementById("popupUpdFrm").querySelector(".meetingInf").innerHTML = "<span>" + data.racecourse.name + "</span> - R." + data.number + " - " + data.status.name + " - <span>" + day + " " + data.date.formatted + "</span>";
                }
                //Una vez que tenemos la reunión sobre la que se trabaja ubicaos la última carreara para hacer consecutivo orden y carrera
                let races = meeting.querySelector("tbody").querySelectorAll("tr:not([style='display: none;'],[style='display:none'])");
                let def = {
                    'order': 1,
                    'race': document.getElementById("updNumber").getAttribute("minval") != null ? (parseFloat(document.getElementById("updNumber").getAttribute("minval"))+1) : 1
                }
                let lastrace = null;
                if (races.length > 0) lastrace = races[races.length - 1];
                if (lastrace != null) {
                    def.order = getNum(lastrace.querySelectorAll("td[data]")[0].getAttribute("data"))+1;
                    def.race = getNum(lastrace.querySelectorAll("td[data]")[1].getAttribute("data"))+1;
                }
                document.getElementById("updOrder").value = def.order;
                document.getElementById("updNumber").value = def.race;

                //Validamos los defaults de los porcentajes de apuestas y los asignamos
                let places = document.getElementById("popupUpdFrm").querySelectorAll(".popInpt[default]");
                places.forEach((e) => {
                    e.setAttribute("datanum", e.getAttribute("default"));
                    e.value = number_format(e.getAttribute("default"),2)+"%";
                });
                //Cargamos la lista de distancia que corresponde a este hipodromo
                listDistancesAPI(data.racecourse.id, "");
                //Seteamos otros valores por default
                document.getElementById("updMainpriceSym").value = "VES";
                document.getElementById("updExtpriceSym").value = "USD"; 
                document.getElementById("updValidrace").value = "1";
                document.getElementById("updIsClasic").checked = false;
                document.getElementById("updClasicid").setAttribute("disabled","");
                //Cerramos todas las pestañas
                document.querySelectorAll(".frmHeadBox").forEach(e => {
                    let cnt = e.parentElement;
                    cnt.querySelector(".frmHeadBox").removeAttribute("active");
                    cnt.querySelector(".frmHeadBox").removeAttribute("disabled");
                    cnt.querySelector(".popupFrmCnt").style.height = "";
                    e.querySelector(".frmBoxOpnBtn").innerHTML = '<i class="fa-solid fa-caret-down"></i>';
                });                   
                //Corregimos el texto del backbutton a salir
                document.getElementById("popupUpdFrm").querySelector(".backBtn").innerText = "Salir";
                document.getElementById("popupUpdFrm").querySelector(".saveBtn").removeAttribute("upid");
                document.getElementById("popupUpdFrm").querySelector(".saveBtn").style.display = "";
                document.getElementById("popupUpdFrm").querySelector(".processBtn").removeAttribute("upid");
                document.getElementById("popupUpdFrm").querySelector(".processBtn").style.display = "none";
                document.getElementById("popupUpdFrm").querySelector(".arriveBtn").removeAttribute("upid");                
                document.getElementById("popupUpdFrm").querySelector(".arriveBtn").style.display = "none";  
                document.getElementById("popupUpdFrm").querySelector(".revertirBtn").removeAttribute("upid");                
                document.getElementById("popupUpdFrm").querySelector(".revertirBtn").style.display = "none";  
                //Seteamos el titulo
                document.getElementById("popupUpdFrm").querySelector(".popupTit").innerText = "Crear Llamados";

                await showPopup("popupUpdFrm").then(() => {
                    //Abrimos la primera pestaña                    
                    let cnt = document.getElementById("popupUpdFrm").querySelectorAll(".frmHeadBox")[0].parentElement;
                    //Activamos  y abrimos la primera sección
                    cnt.querySelector(".frmHeadBox").setAttribute("active", "");
                    //Deshabilitamos la sección de ejemplares hasta que se carga la carreara
                    document.querySelectorAll(".frmHeadBox")[1].setAttribute("disabled", "");
                    cnt.querySelector(".popupFrmCnt").style.height = cnt.querySelector(".popupFrmCnt").scrollHeight + "px"; 
                    cnt.querySelector(".frmBoxOpnBtn").innerHTML = '<i class="fa-solid fa-caret-up"></i>';
                });
                //Reiniciamos el style del select
                document.querySelector('#updPlaysSel').reset();
            });
            
            let rowSct = clone.children[0].children[0];
            rowSct.removeAttribute("active");

            var data = list[i];
            //Evento del readonly al row
            rowSct.setAttribute("itemid", data.id);
            clone.setAttribute("itemid", data.id);

            var celda = rowSct.children[0].children[0];
            celda.children[0].addEventListener("click", async function () {
                //Elemento activo
                let active = document.getElementById("pgTbl").querySelector(".tbody>div[active]");
                let openrow = this.parentElement.parentElement.parentElement.parentElement.parentElement;
                if (active) {     
                    //Si existe validamos si es el mismo que se clickea
                    if (active.getAttribute("itemid") == openrow.getAttribute("itemid")) {
                        openrow.removeAttribute("active");
                        this.innerHTML = '<i class="fa-regular fa-square-plus"></i>';
                    } else {
                        
                        await listRacesAPI(openrow.getAttribute("itemid")).then(function (data) {
                            listDrawRaces(openrow, data);
                        });
                        //Si no es el mismo cerramos el abierto y mostramos el que se clickea
                        active.removeAttribute("active");
                        active.querySelector(".openRow").innerHTML = '<i class="fa-regular fa-square-plus"></i>';
                        openrow.setAttribute("active","");
                        this.innerHTML = '<i class="fa-regular fa-square-minus"></i>';
                    }
                } else {
                    
                    await listRacesAPI(openrow.getAttribute("itemid")).then(function (data) {
                        listDrawRaces(openrow, data);
                    });
                    //Si no hay ninguno abierto solo abrimos el que se clickea
                    openrow.setAttribute("active","");
                    this.innerHTML = '<i class="fa-regular fa-square-minus"></i>';
                }        
                //Si se está editando la linea siempre la llevamos a su estado no editable
                resetdataRow(openrow.querySelector(".tr"));
            });
            celda.children[1].value = data.racecourse.id;

            var celda = rowSct.children[1];
            celda.children[0].value = data.number;            
            celda.children[0].addEventListener("keyup", function () {
                if (this.value != "") this.value = fieldFormat(this.value, 'intnumber');
            });
            var celda = rowSct.children[2];
            celda.children[0].value = data.date.date;
            celda.children[0].setAttribute("min", dateForInpt(globmindate));
            celda.children[0].setAttribute("max", dateForInpt(new Date()));

            var celda = rowSct.children[3];
            celda.classList.add(notedclass);
            celda.innerText = data.variant.formatted;

            var celda = rowSct.children[4];
            celda.classList.add(notedclass);
            celda.innerText = data.racescnt;

            var celda = rowSct.children[5];
            celda.classList.add(notedclass);
            celda.innerText = data.status.name;

            var celda = rowSct.children[6].firstElementChild;//Botonera principal, editar/eliminar
            celda.style.display = "";
            //Atributos para eventos de los botones
            celda.setAttribute("itemid", data.id);
            celda.setAttribute("itemlbl", data.racecourse.name + " - " + data.number);

            //Editar Btn
            if (privileges.update) {
                if (data.status.name == 'Cerrada' || data.status.id == 3  || data.racescnt > 0) {
                    celda.children[0].setAttribute("disabled", "");
                } else {
                    celda.children[0].removeAttribute("disabled");                
                    celda.children[0].addEventListener("click", function (e) {
                        e.stopPropagation();
                        //Si existe uno activo lo restauramos
                        let someactive = document.getElementById("pgTbl").querySelector(".tr[active]");
                        if (someactive != undefined) resetdataRow(someactive);
                        //Cancelamos el add en caso de que esté activo
                        document.getElementById("addline").removeAttribute("active");
                        document.getElementById("addline").parentElement.parentElement.style.display = "none";
                        document.querySelector(".addBtn").removeAttribute("disabled");

                        let row = this.parentElement.parentElement.parentElement;
                        //Activamos la linea
                        row.setAttribute("active", "");
                        //Activamos la botonera que corresponde
                        row.querySelectorAll(".tblBtns")[0].style.display = "none";
                        row.querySelectorAll(".tblBtns")[1].style.display = "";
                        //Permitimos la edición de los campos
                        row.querySelectorAll("input,select").forEach(e => {
                            e.removeAttribute("disabled");
                        });
                        focusIn(row.querySelectorAll("input[type='text']")[0]);

                    });
                }
                
            } else {
                celda.children[0].setAttribute("disabled","");
            }
            //Eliminar Btn
            if (privileges.delete) {
                if (data.status.name == 'Cerrada' || data.status.id == 2 || data.racescnt > 0) {
                    celda.children[1].setAttribute("disabled", "");
                } else {
                    celda.children[1].removeAttribute("disabled");
                    celda.children[1].addEventListener("click", function (e) {
                        e.stopPropagation();
                        //Se muestra el popup de confirmación
                        let usr = this.parentElement.getAttribute("itemlbl");
                        document.querySelector(".poupDelItemLbl").innerText = usr;
                        //Asignamos el id que va a ser eliminado al boton guardar de la confirmación del delete
                        let delpop = document.getElementById("popupDelFrm");
                        delpop.querySelector(".saveBtn").setAttribute("type", "meeting");
                        delpop.querySelector(".saveBtn").setAttribute("delid", this.parentElement.getAttribute("itemid"));
                        document.getElementById("delLbl").innerText = "reunión";
                        //Mostramos el popup de confirmación
                        showPopup("popupDelFrm");
                    });
                }
            } else {
                celda.children[1].setAttribute("disabled","");
            }

            var celda = rowSct.children[6].lastElementChild;//Botonera secundaria, aceptar/cancelar
            celda.style.display = "none";
            celda.setAttribute("itemid", data.id);
            celda.classList.remove("warning");
            celda.querySelectorAll(".tblbtnIc")[0].addEventListener("click", function () {
                //Ocultamos si está editando otra linea
                updateAPI(this.parentElement.parentElement.parentElement, this.parentElement.getAttribute("itemid"));
            });
            celda.querySelectorAll(".tblbtnIc")[1].addEventListener("click", function () {
                let row = this.parentElement.parentElement.parentElement;
                resetdataRow(row);
            });
            
            rowSct.querySelectorAll("input,select").forEach(e => {
                e.setAttribute("disabled", "");
                e.removeAttribute("style");
            });
            
            clone.querySelector(".headCheck").addEventListener("click", function () {
                let cnt = document.getElementById("pgTbl").querySelector(".tbody>div[active]")?.querySelector(".calledTblSct");
                cnt.querySelectorAll(".processCheck").forEach(e => e.checked = this.checked);
                showBtnsRace();
            });

            
            clone.querySelector(".opencall").addEventListener("click", function () {
                let meeting = document.getElementById("pgTbl").querySelector(".tbody>div[active]")?.querySelector(".calledTblSct");
                let processopen = Array.from(meeting.querySelectorAll(".processCheck[racestatus='0']")).filter(e => e.checked);
                let revertopen = Array.from(meeting.querySelectorAll(".processCheck[racestatus='1']")).filter(e => e.checked);
                let ids = [];
                if (processopen.length > 0) {
                    processopen.forEach(async (e) => {
                        ids.push(e.getAttribute("raceid"));
                    }); 
                    document.getElementById("popupCnfFrm").querySelector(".saveBtn").setAttribute("processtype", 1);
                    document.getElementById("popupCnfFrm").querySelector(".popupMsgSct").querySelector("span").innerText = "procesar " + ids.length + " llamados";
                    document.getElementById("popupCnfFrm").querySelector(".popupTit").innerText = "Procesar llamados";
                } else if(revertopen.length > 0) {        
                    revertopen.forEach(async (e) => {
                        ids.push(e.getAttribute("raceid"));
                    });  
                    document.getElementById("popupCnfFrm").querySelector(".saveBtn").setAttribute("processtype", -1);
                    document.getElementById("popupCnfFrm").querySelector(".popupMsgSct").querySelector("span").innerText = "revertir " + ids.length + " llamados";
                    document.getElementById("popupCnfFrm").querySelector(".popupTit").innerText = "Revertir llamados";
                    
                }
                
                document.getElementById("popupCnfFrm").querySelector(".saveBtn").setAttribute("raceids", ((ids.length > 0) ? ids.join("-") : ""));

                showPopup("popupCnfFrm");
            });

            clone.querySelector(".openarrive").addEventListener("click", function () {
                let meeting = document.getElementById("pgTbl").querySelector(".tbody>div[active]")?.querySelector(".calledTblSct");
                let revertopen = Array.from(meeting.querySelectorAll(".processCheck[racestatus='1']")).filter(e =>e.checked);
                let closed = Array.from(meeting.querySelectorAll(".processCheck[racestatus='2']")).filter(e => e.checked);
                let ids = [];
                if (revertopen.length > 0) {
                    revertopen.forEach(async (e) => {
                        ids.push(e.getAttribute("raceid"));
                    }); 
                    
                    document.getElementById("popupCnfFrm").querySelector(".saveBtn").setAttribute("processtype", 2);
                    document.getElementById("popupCnfFrm").querySelector(".popupMsgSct").querySelector("span").innerText = "cerrar " + ids.length + " llegadas";
                    document.getElementById("popupCnfFrm").querySelector(".popupTit").innerText = "Cerrar llegadas";
                } else if(closed.length > 0) {        
                    closed.forEach(async (e) => {
                        ids.push(e.getAttribute("raceid"));
                    });  
                    
                    document.getElementById("popupCnfFrm").querySelector(".saveBtn").setAttribute("processtype", -2);
                    document.getElementById("popupCnfFrm").querySelector(".popupMsgSct").querySelector("span").innerText = "reabrir " + ids.length + " llegadas";
                    document.getElementById("popupCnfFrm").querySelector(".popupTit").innerText = "Abrir llegadas";
                }                 
                document.getElementById("popupCnfFrm").querySelector(".saveBtn").setAttribute("raceids", ((ids.length > 0) ? ids.join("-") : ""));

                showPopup("popupCnfFrm");
            });


            tbl.appendChild(clone);
        }
    } else {
        var clone = ele.cloneNode(true);
        clone.style.display = "none";
        clone.removeAttribute("id");
        tbl.appendChild(clone);
    }
    //SE PINTA EL PAGINADO LUEGO DE PINTAR LA TABLA
    var actpage = document.querySelector(".pgSctTbl").querySelector(".pagNum[selected]");
    actpage = (actpage != null && actpage != undefined) ? (actpage.innerHTML) : 1;
    drawPags(document.querySelector(".pgSctTbl"), rsp.numofrecords, 10, actpage, listAPI);
    
}
//Función si se cancela sin guarda devolvemos los valores iniciales
function resetdataRow(row) {
    //Vemos si existe el que se cancela la info para restaurarlo
    let data = notupdatedData.records.find(r => (r.id == row.getAttribute("itemid")));
    if (data) {
        row.removeAttribute("active");
        row.querySelectorAll(".tblInpt").forEach(e => {
            e.value = "";
            e.setAttribute("disabled", "");
        });
        row.querySelectorAll(".tblInpt")[0].value = data.racecourse.id;
        row.querySelectorAll(".tblInpt")[1].value = data.number;
        row.querySelectorAll(".tblInpt")[2].value = data.date.date;
        row.querySelectorAll(".tblBtns")[0].style.display = "";
        row.querySelectorAll(".tblBtns")[1].style.display = "none";
    }
}
//Función para llamar el servicio que inserta o modifica un usuario.
async function updateAPI(row,id) {
    let validationpars = [
        {
            "key": "racecourseid",
            "id": row.querySelectorAll(".tblInpt")[0],
            "msg": ""
        },
        {
            "key": "number",
            "id": row.querySelectorAll(".tblInpt")[1],
            "msg": ""
        },
        {
            "key": "date",
            "id": row.querySelectorAll(".tblInpt")[2],
            "msg": ""
        },
    ]

    var par = {};
    par.id = id;
    par.racecourseid = row.querySelectorAll(".tblInpt")[0].value;
    par.number = row.querySelectorAll(".tblInpt")[1].value;
    par.date = row.querySelectorAll(".tblInpt")[2].value;
    par.sessionid = localStorage.getItem("sessionid");

    //Hacemos las validaciones
    var haserror = false;
    //Cómo son muchos campos simplificamos con un arreglo que contiene los campos a verificar
    validationpars.forEach((e) => {
        //Que el nombre no esté vacío
        if (!(par[e.key] !== undefined && par[e.key] !== null && par[e.key] !== "")) {
            errRowInpt(e.id, 6000);
            haserror = true;
        }
    });

    //Si tiene errores detenemos la llamada al servicio
    if (haserror) {
        errTbl(document.querySelector(".tblSct"), "Faltan campos obligatorios", 6000);
        return;
    }

    await validDateRange(par.date).then().catch(() => {
        haserror = true;
        errRowInpt(row.querySelectorAll(".tblInpt")[2], 6000);
    });

    if (haserror) {
        errTbl(document.querySelector(".tblSct"), "Fecha inválida", 6000);
        return;
    }
    
    let lastreunionnum = notupdatedData.lastreunionnumbers.find(r => r.id == par.racecourseid).lastnumber;
    let btnsAct = row.lastElementChild.querySelectorAll(".tblBtns")[1];
    let msgtime = 8000;
    if (!btnsAct.classList.contains("warning")) {
        if (getNum(par.number) <= lastreunionnum) {
            errTbl(document.querySelector(".tblSct"), "Existen reuniones con nro mayor o igual para este hipódromo, pulse confirmar nuevamente para guardar", msgtime)
            errRowInpt(row.querySelectorAll(".tblInpt")[1], msgtime);
            btnsAct.classList.add("warning");
            setTimeout(function () {
                btnsAct.classList.remove("warning");
            }, msgtime, btnsAct);
            haserror = true;
        }
    }

    if (haserror) return;
    //Funcion si todo en la llamada al servicio y se obtiene respuesta
    let onsuccess = (rsp) => {
        switch (rsp.status) {
            case 200:
                data = JSON.parse(rsp.response);
                //Si obtenemos un id insertado/modificado refrescamos la tabla
                if (data.id != null && data.id != undefined) {
                    //Llevaos el ordenamiento por "id" y cargamos el listado
                    resetOrder(document.querySelector(".pgSctTbl")).then(() => { listAPI(); });
                    //Como definimos función flecha podemos leer los parametros para determinar si era nuevo y mostrar mensaje exitoso correcto
                    successMsgShow((par.id == 0) ? "Reunión creado con éxito" : "Reunión modificado con éxito");
                }
                //Cerramos el popup
                closePopups();
                break;
            case 400:
                data = JSON.parse(rsp.response);
                errTbl(document.querySelector(".tblSct"), ((data.msg != undefined)?data.msg:"Ocurrió un error al guardar por favor intente de nuevo"), 6000);
                break;
            case 401:
                //NO autorizado
                localStorage.clear();
                gotoPage('login', '', {});
                break;
            case 403:
                //Error de privilegios - prohibido
                errTbl(document.querySelector(".tblSct"), "No tiene privilegios para ejecutar esta acción", 6000);
                break;
            case 409:
                 errTbl(document.querySelector(".tblSct"), "Ya existe este Reunión", 6000);
                break;
            default:
                data = JSON.parse(rsp.response);
                console.log(data);
                break;
        }
    }
    //Lamamos al servicio si todo sale ok se ejecuta el onsuccess si falla sale por el catch
    callWS("POST", "records/reunions/update", par).then(onsuccess).catch((e) => { console.log("Ocurrió un error " + e) });
}
//Función para llamar el servicio de eliminar, se ejecuta al confirmar el boton
function deleteAPI(id) {
    var par = {};
    par.id = id;
    par.sessionid = localStorage.getItem("sessionid");
    //Funcion si todo en la llamada al servicio y se obtiene respuesta
    let onsuccess = (rsp) => {
        switch (rsp.status) {
            case 200:
                data = JSON.parse(rsp.response);
                //Si obtenemos un id insertado/modificado refrescamos la tabla
                if (data.id != null && data.id != undefined) {
                    listAPI();
                    //Mostramos mensaje de eliminado con éxito
                    successMsgShow("Reunión eliminado con éxito");
                }
                //Cerramos el popup
                closePopups();
                break;
            case 204:
                //Error de dependencias
                errInpt(document.getElementById("popupDelFrm").querySelector(".poupDelItemLbl"), "Registro no encontrado", 6000);
                break;
            case 304:
                //Error de dependencias
                errInpt(document.getElementById("popupDelFrm").querySelector(".poupDelItemLbl"), "Existen dependencias que no permiten ejecutar esta acción", 6000);
                break;
            case 401:
                //NO autorizado
                localStorage.clear();
                gotoPage('login', '', {});
                break;
            case 403:
                //Error de privilegios - prohibido
                errInpt(document.getElementById("popupDelFrm").querySelector(".poupDelItemLbl"), "No tiene privilegios para ejecutar esta acción", 6000);
                break;
            default:
                data = JSON.parse(rsp.response);
                console.log(data);
                break;
        }
    }
    //Lamamos al servicio si todo sale ok se ejecuta el onsuccess si falla sale por el catch
    callWS("POST", "records/reunions/delete", par).then(onsuccess).catch((e) => { console.log("Ocurrió un error " + e) })
}
//Función retorna la inforación detallada del usuario
function entryAPI(id) {
    return new Promise((resolve, reject) => {
        var par = {};
        par.id = id;
        par.sessionid = localStorage.getItem("sessionid");
        //Funcion si todo en la llamada al servicio y se obtiene respuesta
        let onsuccess = (rsp) => {
            switch (rsp.status) {
                case 200:
                    data = JSON.parse(rsp.response);
                    resolve(data);
                    break;
                case 401:
                    //NO autorizado
                    localStorage.clear();
                    gotoPage('login', '', {});
                    break;
                default:
                    data = JSON.parse(rsp.response);
                    console.log(data);
                    break;
            }
        }
        //Lamamos al servicio si todo sale ok se ejecuta el onsuccess si falla sale por el catch
        callWS("GET", "records/reunions/entry", par).then(onsuccess).catch((e) => { console.log("Ocurrió un error " + e) });
    });
}
//Se realizan las validaciones de privilegios de front, se inactivan y muestran los mensajes correspondientes
//1 Reuniones, 2 Llamados
function privValidations(rsp, type = 1) {
    console.log(rsp);
    return new Promise((resolve, reject) => {
        /**REUNIONES */
        if (type == 1) {
            //ELIMINAR
            let popupdelBtn = document.getElementById("popupDelFrm").querySelector(".saveBtn");
            //Si existe el popup de eliminar validamos los privilegios y "desactivamos", no uso el disabled para mostrar mensaje propio
            if (popupdelBtn) {
                if (!rsp.delete) {
                    popupdelBtn.setAttribute("inactive", "");
                } else {
                    popupdelBtn.removeAttribute("inactive");
                }
            }
            //AÑADIR
            let tbladdBtn = document.querySelector(".addBtn");
            if (tbladdBtn) {
                if (!rsp.create) {
                    tbladdBtn.setAttribute("disabled", "");
                } else {
                    tbladdBtn.removeAttribute("disabled");
                }
            }            
            //Editar y eliminar en row
        }
        else if (type == 2) {//LLAMADOS
            //CREAR 
            if (!rsp.create) {
                document.querySelectorAll(".newcall").forEach(e=>e.setAttribute("disabled", ""));
            } else {
                document.querySelectorAll(".newcall").forEach(e=>e.removeAttribute("disabled"));
            }
            //Procesar 
            if (!rsp.process) {
                document.querySelectorAll(".opencall").forEach(e =>e.setAttribute("process", "inactive"));
            } else {
                document.querySelectorAll(".opencall").forEach(e=>e.removeAttribute("process"));
            }
            //Revertir 
            if (!rsp.open) {
                document.querySelectorAll(".opencall").forEach(e =>e.setAttribute("revert", "inactive"));
            } else {
                document.querySelectorAll(".opencall").forEach(e=>e.removeAttribute("revert"));
            }
            //CREAR 
            if (!rsp.close) {
                document.querySelectorAll(".openarrive").forEach(e=>e.setAttribute("close", "inactive"));
            } else {
                document.querySelectorAll(".openarrive").forEach(e=>e.removeAttribute("close"));
            }
            //CREAR 
            if (!rsp.unclose) {
                document.querySelectorAll(".openarrive").forEach(e=>e.setAttribute("open", "inactive"));
            } else {
                document.querySelectorAll(".openarrive").forEach(e=>e.removeAttribute("open"));
            }
        }


        /**LLAMADOS**/
        resolve();
    });

}
//Se requiere invocar el listado de "estados" para el select del filtro y el insertar nuevo
function listHeadqueartersAPI(selected = "") {
    return new Promise((resolve, reject) => { 
        var par = {};
        par.filter = "";
        par.order = 2;
        par.offset = 0;
        par.numofrec = 9999;
        par.sessionid = localStorage.getItem("sessionid");
        //Funcion si todo en la llamada al servicio y se obtiene respuesta
        let onsuccess = async (rsp) => {
            switch (rsp.status) {
                case 200:
                    data = JSON.parse(rsp.response);
                                        
                    //Clonamos el arreglo y modificamos el disabled si el status es inactivo. Utilizamos la función structuredClone si es valida en el navegador
                    let disInactives = (structuredClone != undefined) ? structuredClone(data.records) : JSON.parse(JSON.stringify((data.records)));
                    disInactives.map((r) => { if (r.status.id == 0) r.disabled = true });

                    //Data del filtro de la tabla
                    drawSelect(data.records, document.getElementById("racecoursesTbl"), 'id', 'name', 'Todos los hipódromos', selected);

                    //Data de los row de la lista (debería ser solo el primero porque se llama antes de pintar)
                    document.querySelectorAll(".tblInpt[name='headquarters']").forEach((headq) => {
                        drawSelect(disInactives, headq, 'id', 'name', 'Hipódromo', selected);
                    });
                    
                    resolve();
                    

                    break;
                case 401:
                    //NO autorizado
                    localStorage.clear();
                    gotoPage('login', '', {});
                    reject();
                    break;
                case 403:
                    //Si no tiene privilegios se muestra el mensaje de error
                    resolve();
                    //errTbl(document.querySelector(".tblSct"), "No tiene privilegios para visualizar los registros");
                    break;
                default:
                    data = JSON.parse(rsp.response);
                    console.log(data);
                    reject();
                    break;
            }
        }
        //Lamamos al servicio si todo sale ok se ejecuta el onsuccess si falla sale por el catch
        callWS("POST", "hippodromes/racecourses/list", par).then(onsuccess).catch((e) => { console.log("Ocurrió un error " + e) });
    });
    
}

/**CARRERAS**/

//Función para llamar los valores de la lista de llamados
function listRacesAPI(meetingid) {
    return new Promise((resolve, reject) => { 
        var par = {};
        par.reunionid = meetingid;
        par.filter = "";
        par.order = 1;
        par.offset = 0;
        par.numofrec = 9999;
        par.sessionid = localStorage.getItem("sessionid");
        //Funcion si todo en la llamada al servicio y se obtiene respuesta
        let onsuccess = async (rsp) => {
            switch (rsp.status) {
                case 200:
                    data = JSON.parse(rsp.response);                    
                    await privValidations(data.privileges,2);
                    resolve(data);
                    break;
                case 401:
                    //NO autorizado
                    localStorage.clear();
                    gotoPage('login', '', {});
                    reject();
                    break;
                case 403:
                    //Si no tiene privilegios se muestra el mensaje de error
                    errTbl(document.querySelector(".tblSct"), "No tiene privilegios para visualizar las carreras");                    
                    reject();
                    break;
                default:
                    data = JSON.parse(rsp.response);
                    console.log(data);
                    reject();
                    break;
            }
        }
        //Lamamos al servicio si todo sale ok se ejecuta el onsuccess si falla sale por el catch
        callWS("POST", "records/races/list", par).then(onsuccess).catch((e) => { console.log("Ocurrió un error " + e) });
    });
}
//Función para pintar la respuesta de la lista en la tabla - requiere modelo base en html
function listDrawRaces(row, rsp) {
    console.log(rsp.lastbetsdistribution);
    for (let bet in rsp.lastbetsdistribution) {
        let ele = document.getElementById("popupUpdFrm").querySelector("[name='" + bet + "']");
        if (ele != undefined) {
            ele.setAttribute("default", rsp.lastbetsdistribution[bet].number);
        }
    }
    document.getElementById("updNumber").setAttribute("minval", rsp.minimalracenumber);
    let tblhead = row.querySelector("thead");
    tblhead.children[0].children[0].querySelector("input").checked = false;
    let tbl = row.querySelector("tbody");
    let list = rsp.records;
    let ele = tbl.children[0].cloneNode(true);
    if (list.length > 0) {
        tbl.innerHTML = "";
        for (var i = 0; i < list.length; i++) {
            var data = list[i];
            
            var clone = ele.cloneNode(true);
            clone.style.display = "";
            clone.setAttribute("itemid", data.id);
            clone.addEventListener("click", function () {
                entryRacesAPI(this.getAttribute("itemid")).then(async (rsp) => {
                    //Si obtenemos una respuesta exitosa del servicio en este caso seteamos el formulario de edición
                    setFrmRace(rsp.entry);
                    //Tradicional
                    editableForm("popupUpdFrm", false, [".popInpt,input[type='checkbox']"]);
                    //para que considero los select especiales
                    /*document.getElementById("popupUpdFrm").querySelectorAll(".popInpt,input[type='checkbox']").forEach((e => {
                        e.setAttribute("readonly", "");
                        e.setAttribute("disabled", "");
                    }));*/
                    //Cerramos todas las pestañas y llevamos al "estado original"
                    document.querySelectorAll(".frmHeadBox").forEach(e => {
                        let cnt = e.parentElement;
                        cnt.querySelector(".frmHeadBox").removeAttribute("active");
                        cnt.querySelector(".frmHeadBox").removeAttribute("disabled");
                        cnt.querySelector(".popupFrmCnt").style.height = "";
                        e.querySelector(".frmBoxOpnBtn").innerHTML = '<i class="fa-solid fa-caret-down"></i>';
                    });
                    //Seteamos el titulo
                    document.getElementById("popupUpdFrm").querySelector(".popupTit").innerText = "Llamados";
                    listRacersAPI(rsp.entry.id).then(async racers => {
                        await showPopup("popupUpdFrm");
                        
                        //Abrimos la primera pestaña                    
                        let cnt = document.getElementById("popupUpdFrm").querySelectorAll(".frmHeadBox")[0].parentElement;
                        cnt.querySelector(".frmHeadBox").setAttribute("active", "");
                        
                        
                        cnt.querySelector(".popupFrmCnt").style.height = cnt.querySelector(".popupFrmCnt").scrollHeight + "px";
                        cnt.querySelector(".frmBoxOpnBtn").innerHTML = '<i class="fa-solid fa-caret-up"></i>';
                        //Resize del campo condiciones si tiene valores y editamos
                        document.getElementById("updCondObs").dispatchEvent(new Event("keyup"));
                        //Pintamos los corredores
                        listDrawRacers(rsp.entry.id, racers, true);
                    });

                    //Marcamos el boton de llegadas con un readonly para identificar en su listener si la llegada es readonly o no
                    document.getElementById("popupUpdFrm").querySelector(".arriveBtn").setAttribute("readonly", "");
                });
            });

                
            var celda = clone.children[0];
            celda.firstElementChild.setAttribute("raceid", data.id);
            celda.firstElementChild.setAttribute("racestatus", data.status.id);
            celda.firstElementChild.checked = false;
            celda.firstElementChild.addEventListener("click", function (e) {
                e.stopPropagation();
                if (!this.checked) {
                    let meeting = document.getElementById("pgTbl").querySelector(".tbody>div[active]")?.querySelector(".calledTblSct");
                    meeting.querySelector(".headCheck").checked = false;
                }
                showBtnsRace();
            });
            
            if (data.status.id == 0) {                
                var celda = clone.children[1];
                celda.innerHTML = '<i class="fa-solid fa-lock-open"></i>';
                
                var celda = clone.children[2];
                celda.innerHTML = '<i class="fa-solid fa-lock-open"></i>';
            }else if (data.status.id == 1) {                
                var celda = clone.children[1];
                celda.innerHTML = '<i class="fa-solid fa-lock"></i>';
                
                var celda = clone.children[2];
                celda.innerHTML = '<i class="fa-solid fa-lock-open"></i>';
            } else {
                var celda = clone.children[1];
                celda.innerHTML = '<i class="fa-solid fa-lock"></i>';
                
                var celda = clone.children[2];
                celda.innerHTML = '<i class="fa-solid fa-lock"></i>';
            }



            var celda = clone.children[3];
            celda.setAttribute("data", data.order.id);
            celda.innerHTML = data.order.name;

            var celda = clone.children[4];
            celda.setAttribute("data", data.number);
            celda.innerHTML = data.number;

            var celda = clone.children[5];
            celda.innerHTML = data.call;

            var celda = clone.children[6];
            celda.innerHTML = data.time.formatted;

            var celda = clone.children[7];
            celda.innerHTML = data.distance.name;

            var celda = clone.children[8];
            celda.innerHTML = data.serie;

            var celda = clone.children[9];
            celda.innerHTML = data.mainprice.formatted + " " + data.mainprice.currency;
            
            var celda = clone.children[10];
            celda.innerHTML = data.status.name;

            var celda = clone.children[11].lastElementChild;//Botonera secundaria, aceptar/cancelar
            celda.setAttribute("itemid", data.id);
            celda.setAttribute("itemlbl", data.order.name + " " + data.number);

            if (rsp.privileges.update) {
                celda.querySelectorAll(".tblbtnIc")[0].removeAttribute("disabled");
                celda.querySelectorAll(".tblbtnIc")[0].addEventListener("click", function (e) {
                    e.stopPropagation();
                    entryRacesAPI(this.parentElement.getAttribute("itemid")).then((rsp) => {
                        setFrmRace(rsp.entry);
                        //Cerramos todas las pestañas y llevamos al "estado original"
                        document.querySelectorAll(".frmHeadBox").forEach(e => {
                            let cnt = e.parentElement;
                            cnt.querySelector(".frmHeadBox").removeAttribute("active");
                            cnt.querySelector(".frmHeadBox").removeAttribute("disabled");
                            cnt.querySelector(".popupFrmCnt").style.height = "";
                            e.querySelector(".frmBoxOpnBtn").innerHTML = '<i class="fa-solid fa-caret-down"></i>';
                        });
                        //Seteamos el titulo
                        document.getElementById("popupUpdFrm").querySelector(".popupTit").innerText = "Editar Llamados";
                        document.getElementById("popupUpdFrm").querySelector(".backBtn").innerText = "Salir";
                        listRacersAPI(rsp.entry.id).then(async racers => {
                            await showPopup("popupUpdFrm");
                            //Abrimos la primera pestaña                    
                            let cnt = document.getElementById("popupUpdFrm").querySelectorAll(".frmHeadBox")[0].parentElement;
                            cnt.querySelector(".frmHeadBox").setAttribute("active", "");
                            cnt.querySelector(".popupFrmCnt").style.height = cnt.querySelector(".popupFrmCnt").scrollHeight + "px";
                            cnt.querySelector(".frmBoxOpnBtn").innerHTML = '<i class="fa-solid fa-caret-up"></i>';
                            //Resize del campo condiciones si tiene valor y editamos
                            document.getElementById("updCondObs").dispatchEvent(new Event("keyup"));

                            listDrawRacers(rsp.entry.id, racers, !(rsp.entry.status.id == 0));

                        });
                    });
                    //Habilitamos futuras modificaciones para la pantalla de llegadas que se determina en este listener
                    document.getElementById("popupUpdFrm").querySelector(".arriveBtn").removeAttribute("readonly");
                });
            } else {
                celda.querySelectorAll(".tblbtnIc")[0].setAttribute("disabled","");
            }
            if (rsp.privileges.delete) {
                if (data.status.id == 2) {
                    celda.querySelectorAll(".tblbtnIc")[1].setAttribute("disabled", "");
                } else {
                    celda.querySelectorAll(".tblbtnIc")[1].removeAttribute("disabled");
                    celda.querySelectorAll(".tblbtnIc")[1].addEventListener("click", function (e) {
                        e.stopPropagation();
                        //Se muestra el popup de confirmación
                        let lbl = this.parentElement.getAttribute("itemlbl");
                        document.querySelector(".poupDelItemLbl").innerText = lbl;
                        //Asignamos el id que va a ser eliminado al boton guardar de la confirmación del delete
                        let delpop = document.getElementById("popupDelFrm");
                        delpop.querySelector(".saveBtn").setAttribute("type", "race");
                        delpop.querySelector(".saveBtn").setAttribute("delid", this.parentElement.getAttribute("itemid"));
                        document.getElementById("delLbl").innerText = "carrera";
                        //Mostramos el popup de confirmación
                        showPopup("popupDelFrm");
                    });
                }
            } else {
                celda.querySelectorAll(".tblbtnIc")[1].setAttribute("disabled","");
            }

            var celda = clone.children[12].firstElementChild;
            celda.classList.remove("icClasic","icValidClasic","icValid");
            if (data.isvalid) {
                if (data.isclassic) {
                    celda.classList.add("icValidClasic");
                } else {
                    celda.classList.add("icValid");
                }
            } else {
                if (data.isclassic) {
                    celda.classList.add("icClasic");
                }
            }

            tbl.appendChild(clone);

        }
    } else {
        var clone = ele.cloneNode(true);
        clone.style.display = "none";
        Array.from(clone.children).forEach(c => {
            c.removeAttribute("data");
        });
        tbl.innerHTML = "";
        tbl.appendChild(clone);
    }
    
    showBtnsRace(row);
}
//Función retorna la inforación detallada del usuario
function entryRacesAPI(id) {
    return new Promise((resolve, reject) => {
        var par = {};
        par.id = id;
        par.sessionid = localStorage.getItem("sessionid");
        //Funcion si todo en la llamada al servicio y se obtiene respuesta
        let onsuccess = (rsp) => {
            switch (rsp.status) {
                case 200:
                    data = JSON.parse(rsp.response);
                    resolve(data);
                    break;
                case 401:
                    //NO autorizado
                    localStorage.clear();
                    gotoPage('login', '', {});
                    break;
                default:
                    data = JSON.parse(rsp.response);
                    console.log(data);
                    break;
            }
        }
        //Lamamos al servicio si todo sale ok se ejecuta el onsuccess si falla sale por el catch
        callWS("GET", "records/races/entry", par).then(onsuccess).catch((e) => { console.log("Ocurrió un error " + e) });
    });
}
//Funcion para rellenar el formulario con un entry
function setFrmRace(rsp) {    
    //Primero habilitamos todo así si alguna se desactiva por comportamiento no se quita luego
    document.getElementById("popupUpdFrm").querySelectorAll(".popInpt,input[type='checkbox']").forEach((e => {
        e.removeAttribute("readonly");
        e.removeAttribute("disabled");
    }));
    //Cargamos la data de los valores
    document.getElementById("updCall").value = rsp.call;
    document.getElementById("updOrder").value = rsp.order.id;
    document.getElementById("updNumber").value = rsp.number;
    document.getElementById("updTime").value = rsp.time.time;
    document.getElementById("updValidrace").value = rsp.valid;
    document.getElementById("updIsClasic").checked = (rsp.racetype.id !== -1) ? true : false;
    document.getElementById("updClasicid").value = rsp.racetype.id == -1 ? "" : rsp.racetype.id;
    (rsp.racetype.id == -1) ? document.getElementById("updClasicid").setAttribute("disabled","") : "";
    document.getElementById("updFstCond").value = rsp.conditions.conditionid1;
    document.getElementById("updSecCond").value = rsp.conditions.conditionid2;
    document.getElementById("updCondObs").value = rsp.conditions.conditiondsc;
    document.getElementById("updSerie").value = rsp.serie;
    document.getElementById("updMainpriceSym").value = rsp.mainprice.currency;
    document.getElementById("updMainpriceAmo").value = rsp.mainprice.formatted;
    document.getElementById("updMainpriceAmo").setAttribute("datanum",!isNaN(rsp.mainprice.number) ? parseFloat(rsp.mainprice.number) : "");
    document.getElementById("updExtpriceSym").value = rsp.extraprice.currency;
    document.getElementById("updExtpriceAmo").value = rsp.extraprice.formatted;
    document.getElementById("updExtpriceAmo").setAttribute("datanum",!isNaN(rsp.extraprice.number) ? parseFloat(rsp.extraprice.number) : "");
    document.getElementById("updFstPlace").value = rsp.placedivs.first.formatted;
    document.getElementById("updFstPlace").setAttribute("datanum",!isNaN(rsp.placedivs.first.number) ? parseFloat(rsp.placedivs.first.number) : "");
    document.getElementById("updScdPlace").value = rsp.placedivs.second.formatted;
    document.getElementById("updScdPlace").setAttribute("datanum",!isNaN(rsp.placedivs.second.number) ? parseFloat(rsp.placedivs.second.number) : "");
    document.getElementById("updTrhPlace").value = rsp.placedivs.third.formatted;
    document.getElementById("updTrhPlace").setAttribute("datanum",!isNaN(rsp.placedivs.third.number) ? parseFloat(rsp.placedivs.third.number) : "");
    document.getElementById("updFthPlace").value = rsp.placedivs.fourth.formatted;
    document.getElementById("updFthPlace").setAttribute("datanum",!isNaN(rsp.placedivs.fourth.number) ? parseFloat(rsp.placedivs.fourth.number) : "");
    document.getElementById("updFfthPlace").value = rsp.placedivs.fifth.formatted;
    document.getElementById("updFfthPlace").setAttribute("datanum",!isNaN(rsp.placedivs.fifth.number) ? parseFloat(rsp.placedivs.fifth.number) : "");

    document.getElementById("updPlaysSel").setValue(rsp.bets?.map(b => b.id));
    
    //Mostramos los botones que corresponden con el status de la carrera
    if (rsp.status.id == 0) {                
        document.getElementById("popupUpdFrm").querySelector(".saveBtn").style.display = "";
        document.getElementById("popupUpdFrm").querySelector(".saveBtn").setAttribute("upid", rsp.id);
        document.getElementById("popupUpdFrm").querySelector(".processBtn").style.display = "";
        document.getElementById("popupUpdFrm").querySelector(".processBtn").setAttribute("upid", rsp.id);
        document.getElementById("popupUpdFrm").querySelector(".arriveBtn").style.display = "none";
        document.getElementById("popupUpdFrm").querySelector(".arriveBtn").removeAttribute("upid");
        document.getElementById("popupUpdFrm").querySelector(".revertirBtn").style.display = "none";
        document.getElementById("popupUpdFrm").querySelector(".revertirBtn").removeAttribute("upid"); 
    } else if (rsp.status.id == 1) {
        document.getElementById("popupUpdFrm").querySelector(".arriveBtn").style.display = "";
        document.getElementById("popupUpdFrm").querySelector(".arriveBtn").setAttribute("upid", rsp.id);
        document.getElementById("popupUpdFrm").querySelector(".revertirBtn").style.display = "";
        document.getElementById("popupUpdFrm").querySelector(".revertirBtn").setAttribute("upid", rsp.id);
        document.getElementById("popupUpdFrm").querySelector(".saveBtn").style.display = "none";
        document.getElementById("popupUpdFrm").querySelector(".saveBtn").removeAttribute("upid");  
        document.getElementById("popupUpdFrm").querySelector(".processBtn").style.display = "none";
        document.getElementById("popupUpdFrm").querySelector(".processBtn").removeAttribute("upid");
    } else if (rsp.status.id == 2) {
        document.getElementById("popupUpdFrm").querySelector(".arriveBtn").style.display = "";
        document.getElementById("popupUpdFrm").querySelector(".arriveBtn").setAttribute("upid", rsp.id);
        document.getElementById("popupUpdFrm").querySelector(".revertirBtn").style.display = "none";
        document.getElementById("popupUpdFrm").querySelector(".revertirBtn").removeAttribute("upid");
        document.getElementById("popupUpdFrm").querySelector(".saveBtn").style.display = "none";
        document.getElementById("popupUpdFrm").querySelector(".saveBtn").removeAttribute("upid");  
        document.getElementById("popupUpdFrm").querySelector(".processBtn").style.display = "none";
        document.getElementById("popupUpdFrm").querySelector(".processBtn").removeAttribute("upid");        
    }
    //Si no es status abierto siempre se deshabilita todo
    if (rsp.status.id != 0) {        
        document.getElementById("popupUpdFrm").querySelectorAll(".popInpt,input[type='checkbox']").forEach((e => {
            e.setAttribute("readonly", "");
            e.setAttribute("disabled", "");
        }));
    }
    //Llenamos los datos del header ubicando la reunion abierta
    let meetingid = document.getElementById("pgTbl").querySelector(".tbody>div[active]")?.getAttribute("itemid");
    let data = notupdatedData.records.find(r => (r.id == meetingid));
    if (data != undefined) {    
        let day = days[new Date(data.date.date + " 12:00").getDay()];
        let raceno = "";
        if (rsp.number != undefined && rsp.number != null && rsp.number != "") raceno = rsp.number+" - ";
        document.getElementById("popupUpdFrm").querySelector(".meetingInf").innerHTML = "<span>" + data.racecourse.name + "</span> - R." + data.number + " - " + raceno + data.status.name + " - <span>" + day + " " + data.date.formatted + "</span>";
        //Esto carga las opciones de distancias y marca la opción seleccionada
        listDistancesAPI(data.racecourse.id, rsp.distance.id);
    }
    document.getElementById("creationLbl").innerText = "Creado: " + rsp.created.formatted;
    if (rsp.created.date != rsp.modified.date)
        document.getElementById("updatedLbl").innerText = "Modificado: " + rsp.modified.formatted;
    else
        document.getElementById("updatedLbl").innerText = "";

    if (document.getElementById("popupUpdFrm").offsetHeight > window.innerHeight) {
        document.getElementById("popupUpdFrm").style.alignItems = "flex-start";
    }

}
//Función para llamar el servicio de eliminar, se ejecuta al confirmar el boton
function deleteRacesAPI(id) {
    var par = {};
    par.id = id;
    par.sessionid = localStorage.getItem("sessionid");
    //Funcion si todo en la llamada al servicio y se obtiene respuesta
    let onsuccess = (rsp) => {
        switch (rsp.status) {
            case 200:
                data = JSON.parse(rsp.response);
                //Si obtenemos un id insertado/modificado refrescamos la tabla
                if (data.id != null && data.id != undefined) {
                    refreshMeets();
                    /*
                    let activerow = document.getElementById("pgTbl").querySelector(".tbody>div[active]");
                    listRacesAPI(activerow.getAttribute("itemid")).then(function (data) {
                        listDrawRaces(activerow, data);
                    });*/
                    //Mostramos mensaje de eliminado con éxito
                    successMsgShow("Carrera eliminada con éxito");
                }
                //Cerramos el popup
                closePopups();
                break;
            case 204:
                //Error de dependencias
                errInpt(document.getElementById("popupDelFrm").querySelector(".poupDelItemLbl"), "Registro no encontrado", 6000);
                break;
            case 304:
                //Error de dependencias
                errInpt(document.getElementById("popupDelFrm").querySelector(".poupDelItemLbl"), "Existen dependencias que no permiten ejecutar esta acción", 6000);
                break;
            case 401:
                //NO autorizado
                localStorage.clear();
                gotoPage('login', '', {});
                break;
            case 403:
                //Error de privilegios - prohibido
                errInpt(document.getElementById("popupDelFrm").querySelector(".poupDelItemLbl"), "No tiene privilegios para ejecutar esta acción", 6000);
                break;
            default:
                data = JSON.parse(rsp.response);
                console.log(data);
                break;
        }
    }
    //Lamamos al servicio si todo sale ok se ejecuta el onsuccess si falla sale por el catch
    callWS("POST", "records/races/delete", par).then(onsuccess).catch((e) => { console.log("Ocurrió un error " + e) })
}
//Función para llamar el servicio que inserta o modifica un usuario.
function updateRacesAPI(meetingid, id) {
    return new Promise((resolve,reject)=>{
        let validationpars = [
            {
                "key": "call",
                "id": "updCall",
                "msg": ""
            },
            {
                "key": "number",
                "id": "updNumber",
                "msg": ""
            },
            {
                "key": "time",
                "id": "updTime",
                "msg": ""
            },
            {
                "key": "ord",
                "id": "updOrder",
                "msg": ""
            },        
            {
                "key": "distanceid",
                "id": "updDistanceid",
                "msg": ""
            },
            {
                "key": "racetypeid",
                "id": "updClasicid",
                "msg": ""
            },
            {
                "key": "conditionid1",
                "id": "updFstCond",
                "msg": ""
            },
            {
                "key": "conditionid2",
                "id": "updSecCond",
                "msg": ""
            },
            {
                "key": "conditiondsc",
                "id": "updCondObs",
                "msg": ""
            },
            {
                "key": "serie",
                "id": "updSerie",
                "msg": ""
            },
            {
                "key": "mainprice",
                "id": "updMainpriceAmo",
                "msg": ""
            },/*
            {
                "key": "extraprice",
                "id": "updExtpriceAmo",
                "msg": ""
            },*/
            {
                "key": "firstplace",
                "id": "updFstPlace",
                "msg": ""
            },
            {
                "key": "secondplace",
                "id": "updScdPlace",
                "msg": ""
            },
            {
                "key": "thirdplace",
                "id": "updTrhPlace",
                "msg": ""
            },
            {
                "key": "fourthplace",
                "id": "updFthPlace",
                "msg": ""
            },
            {
                "key": "fifthplace",
                "id": "updFfthPlace",
                "msg": ""
            },
            {
                "key": "bets",
                "id": document.getElementById("updPlaysSel").querySelector(".vscomp-toggle-button"),
                "msg": ""
            },

        ]

        var par = {};
        par.id = id;
        par.reunionid = meetingid;
        par.call = document.getElementById("updCall").value;
        par.ord = document.getElementById("updOrder").value;
        par.number = document.getElementById("updNumber").value;
        par.time = document.getElementById("updTime").value;
        par.distanceid = document.getElementById("updDistanceid").value;
        par.valid = document.getElementById("updValidrace").value;
        
        par.racetypeid = (document.getElementById("updClasicid").value == "") ? -1 : document.getElementById("updClasicid").value;
        par.conditionid1 = document.getElementById("updFstCond").value;
        par.conditionid2 = document.getElementById("updSecCond").value;
        par.conditiondsc = document.getElementById("updCondObs").value;
        par.serie = document.getElementById("updSerie").value;
        par.mainpricecurr = document.getElementById("updMainpriceSym").value;
        par.mainprice = getNum(document.getElementById("updMainpriceAmo").getAttribute("datanum"));
        par.extrapricecurr = document.getElementById("updExtpriceSym").value;
        let extprice = document.getElementById("updExtpriceAmo").getAttribute("datanum");
        par.extraprice = (extprice != null && extprice != "") ? getNum(extprice) : 0;
        par.firstplace =  getNum(document.getElementById("updFstPlace").getAttribute("datanum"));
        par.secondplace = getNum(document.getElementById("updScdPlace").getAttribute("datanum"));
        par.thirdplace =  getNum(document.getElementById("updTrhPlace").getAttribute("datanum"));
        par.fourthplace =  getNum(document.getElementById("updFthPlace").getAttribute("datanum"));
        par.fifthplace = getNum(document.getElementById("updFfthPlace").getAttribute("datanum"));
        par.sessionid = localStorage.getItem("sessionid");
        par.bets = (document.getElementById("updPlaysSel").value.sort()).join("-");

        //Hacemos las validaciones
        var haserror = false;
        //Cómo son muchos campos simplificamos con un arreglo que contiene los campos a verificar
        validationpars.forEach((e) => {
            //Que el nombre no esté vacío
            if (!(par[e.key] !== undefined && par[e.key] !== null && par[e.key] !== "")) {
                errInpt(e.id, e.msg, 6000);
                haserror = true;
            }
        });
        //Si tiene errores detenemos la llamada al servicio
        if (haserror) {
            errInpt(document.getElementById("popupUpdFrm").querySelector(".errmsgSct"), "Faltan campos obligatorios", 6000);
            reject(false);
            return;

        } 
        if (document.getElementById("updIsClasic").checked && document.getElementById("updClasicid").value == "") {
            errInpt(document.getElementById("popupUpdFrm").querySelector(".errmsgSct"), "Seleccione un clásico válido", 6000);
            errInpt(document.getElementById("updClasicid"), "", 6000);
            reject(false);
            return;
        }

        //Validamos que la suma de los porcentajes no exceda el 100%
        let places = ["updFstPlace","updScdPlace","updTrhPlace","updFthPlace","updFfthPlace"]
        if ((par.firstplace + par.secondplace + par.thirdplace + par.fourthplace + par.fifthplace) != 100) {
            places.forEach((e) => {
                errInpt(e, "", 6000);
                haserror = true;            
            });
        }
        //Si tiene errores detenemos la llamada al servicio
        if (haserror) {
            errInpt(document.getElementById("popupUpdFrm").querySelector(".errmsgSct"), "La suma de los porcentajes de premios debe ser igual al 100%", 6000);
            reject(false);
            return;
        } 

        //Validamos que no haya racers en modo de edición
        let ejempActivos = document.getElementById("popupUpdFrm").querySelector(".table .tbody").querySelectorAll(".tr[active]");
        if (ejempActivos.length > 0) {      
            Array.from(ejempActivos).forEach(eAct => {
                let iconos = Array.from(eAct.querySelectorAll(".tblbtnIc"));
                iconos.forEach(e => {
                    e.style.color = "var(--errColor)";
                });
                setTimeout(function (iconos) {
                    iconos.forEach(e => {
                        e.style.color = "";
                    });
                }, 6000, iconos);
            });
            
            haserror = true;
        }
        //Si tiene errores detenemos la llamada al servicio
        if (haserror) {
            errInpt(document.getElementById("popupUpdFrm").querySelector(".errmsgSct"), "Existen ejemplares en modo de edición", 6000);
            reject(false);
            return;
        } 

        //Validación si algun ejemplar tiene posición de partida en 0
        let ejemp = document.getElementById("popupUpdFrm").querySelector(".table .tbody").querySelectorAll(".tr");
        if (ejemp.length > 0 && id != 0) {
            Array.from(ejemp).forEach(e => {
                if (getNum(e.querySelector("[name='position']").value) <= 0) {
                    let iconos = Array.from(e.querySelectorAll(".tblbtnIc"));
                    iconos.forEach(e => {
                        e.style.color = "var(--errColor)";
                    });
                    setTimeout(function (iconos) {
                        iconos.forEach(e => {
                            e.style.color = "";
                        });
                    }, 6000, iconos);
                
                    haserror = true;
                }
            });
        
        }
        //Si tiene errores detenemos la llamada al servicio
        if (haserror) {
            errInpt(document.getElementById("popupUpdFrm").querySelector(".errmsgSct"), "Existen ejemplares con posición de partida en 0", 6000);
            reject(false);            
            return;
        }

        //Funcion si todo en la llamada al servicio y se obtiene respuesta
        let onsuccess = async (rsp) => {
            switch (rsp.status) {
                case 200:
                    let data = JSON.parse(rsp.response);
                    //Si obtenemos un id insertado/modificado refrescamos la tabla
                    if (par.id == 0) {
                        await refreshMeets();
                    }
                    if (data.id != null && data.id != undefined) {
                        //Llevaos el ordenamiento por "id" y cargamos el listado
                        //resetOrder(document.querySelector(".pgSctTbl")).then(() => { listAPI(); });  
                        entryRacesAPI(data.id).then((rsp) => {
                            setFrmRace(rsp.entry);
                            listRacersAPI(rsp.entry.id).then(async racers => {
                                //Se habilita el popup de ejemplares
                                let cnt = document.getElementById("popupUpdFrm").querySelectorAll(".frmHeadBox")[1].parentElement;
                                cnt.querySelector(".frmHeadBox").removeAttribute("disabled");
                                /*cnt.querySelector(".popupFrmCnt").style.height = "";*/
                                cnt.querySelector(".frmBoxOpnBtn").innerHTML = '<i class="fa-solid fa-caret-down"></i>';

                                listDrawRacers(rsp.entry.id, racers, !(rsp.entry.status.id == 0));
                            });                            
                            //Resize del campo condiciones si tiene valores y editamos
                            document.getElementById("updCondObs").dispatchEvent(new Event("keyup"));
                        })
                        //Como definimos función flecha podemos leer los parametros para determinar si era nuevo y mostrar mensaje exitoso correcto
                        successMsgShow((par.id == 0) ? "Carrera creada con éxito" : "Carrera modificada con éxito");
                        resolve();
                    }
                    //Cerramos el popup
                    //closePopups();
                    break;
                case 400:
                    data = JSON.parse(rsp.response);
                    errInpt(document.getElementById("popupUpdFrm").querySelector(".errmsgSct"), data.msg, 6000);
                    reject(false);
                    break;
                case 401:
                    //NO autorizado
                    localStorage.clear();
                    gotoPage('login', '', {});
                    reject(false);
                    break;
                case 403:
                    //Error de privilegios - prohibido
                    errInpt(document.getElementById("popupUpdFrm").querySelector(".errmsgSct"), "No tiene privilegios para ejecutar esta acción", 6000);
                    reject(false);
                    break;
                case 409:
                    errInpt("updCall", "", 6000);
                    errInpt("updOrder", "", 6000);
                    errInpt("updNumber", "", 6000);
                    errInpt(document.getElementById("popupUpdFrm").querySelector(".errmsgSct"), "Ya existe este Carrera", 6000);
                    reject(false);
                    break;
                default:
                    console.log(data);
                    reject(false);
                    break;
            }
        }
        //Lamamos al servicio si todo sale ok se ejecuta el onsuccess si falla sale por el catch
        callWS("POST", "records/races/update", par).then(onsuccess).catch((e) => { console.log("Ocurrió un error " + e) });
    })
}
//Función para procesar una careara después de que los datos están completos "process"
function processRacesAPI(raceid,save = false) {
    return new Promise(async (resolve, reject) => { 
        let haserror = false;
        if (save) {
            let meetingid = document.getElementById("pgTbl").querySelector(".tbody>div[active]")?.getAttribute("itemid");
            await updateRacesAPI(meetingid,raceid).catch(() => {
                haserror = true;
            });
        }

        if (haserror) return;
        var par = {};
        par.id = raceid;
        par.sessionid = localStorage.getItem("sessionid");
        //Funcion si todo en la llamada al servicio y se obtiene respuesta
        let onsuccess = async (rsp) => {
            switch (rsp.status) {
                case 200:
                    data = JSON.parse(rsp.response);
                    resolve(data);
                    break;
                case 401:
                    //NO autorizado
                    localStorage.clear();
                    gotoPage('login', '', {});
                    reject();
                    break;
                case 403:
                    //Si no tiene privilegios se muestra el mensaje de error
                    errInpt(document.getElementById("popupUpdFrm").querySelector(".errmsgSct"), "No tiene privilegios para ejecutar esta acción", 6000);
                    //errTbl(document.querySelector(".tblSct"), "No tiene privilegios para visualizar los registros");
                    break;                
                case 417:
                    data = JSON.parse(rsp.response);
                    errInpt(document.getElementById("popupUpdFrm").querySelector(".errmsgSct"), data.msg, 6000);
                break;
                default:
                    data = JSON.parse(rsp.response);
                    console.log(data);
                    reject();
                    break;
            }
        }
        //Lamamos al servicio si todo sale ok se ejecuta el onsuccess si falla sale por el catch
        callWS("GET", "records/races/process", par).then(onsuccess).catch((e) => { console.log("Ocurrió un error " + e) });
    });
}
//Funcion proceses races pero en forma de ciclo solo considera correcto el 200
function processWhlRacesAPI(raceid) {
    return new Promise((resolve, reject) => { 
        var par = {};
        par.id = raceid;
        par.sessionid = localStorage.getItem("sessionid");
        //Funcion si todo en la llamada al servicio y se obtiene respuesta
        let onsuccess = async (rsp) => {
            switch (rsp.status) {
                case 200:
                    data = JSON.parse(rsp.response);
                    resolve(data);
                    break;
                default:
                    reject(rsp);
                    break;
            }
        }
        //Lamamos al servicio si todo sale ok se ejecuta el onsuccess si falla sale por el catch
        callWS("GET", "records/races/process", par).then(onsuccess).catch((e) => { console.log("Ocurrió un error " + e) });
    });
}
//FUNCION PARA MOSTRAR LOS BOTONES DE PROCESAR  / CERRAR SEGUN CORRESPONDA
function showBtnsRace(row) {
    let meeting = (row != undefined) ? row :document.getElementById("pgTbl").querySelector(".tbody>div[active]");
    if (meeting != undefined) {
        let processopen = Array.from(meeting.querySelectorAll(".processCheck[racestatus='0']")).filter(e => e.checked);
        let revertopen = Array.from(meeting.querySelectorAll(".processCheck[racestatus='1']")).filter(e => e.checked);
        let closed = Array.from(meeting.querySelectorAll(".processCheck[racestatus='2']")).filter(e => e.checked);
        meeting.querySelector(".opencall").style.display = "";
        meeting.querySelector(".openarrive").style.display = "";
        if (processopen.length > 0) {
            if (meeting.querySelector(".opencall").getAttribute("process") == "inactive") meeting.querySelector(".opencall").setAttribute("disabled", "");
            else meeting.querySelector(".opencall").removeAttribute("disabled");
            meeting.querySelector(".opencall").querySelector("span").innerText = "Procesar Llamados";
        } else if (revertopen.length > 0) {
            if (meeting.querySelector(".opencall").getAttribute("revert") == "inactive") meeting.querySelector(".opencall").setAttribute("disabled", "");
            else meeting.querySelector(".opencall").removeAttribute("disabled");
            meeting.querySelector(".opencall").querySelector("span").innerText = "Revertir Llamados";
        } else {
            meeting.querySelector(".opencall").style.display = "none";
        }
        if (revertopen.length > 0) {
            if (meeting.querySelector(".openarrive").getAttribute("close") == "inactive") meeting.querySelector(".openarrive").setAttribute("disabled", "");
            else meeting.querySelector(".openarrive").removeAttribute("disabled");
            meeting.querySelector(".openarrive").querySelector("span").innerText = "Cerrar Llegadas";
        } else if (closed.length > 0) {
            if (meeting.querySelector(".openarrive").getAttribute("open") == "inactive") meeting.querySelector(".openarrive").setAttribute("disabled", "");
            else meeting.querySelector(".openarrive").removeAttribute("disabled");
            meeting.querySelector(".openarrive").querySelector("span").innerText = "Reabrir Llegadas";
        } else {
            meeting.querySelector(".openarrive").style.display = "none";
        }
    }
}

//Se requiere invocar listados adicionales 
let bets = [];
async function listBetsAPI() {
    var par = {};
    par.filter = "";
    par.order = 1;
    par.offset = 0;
    par.numofrec = 9999;
    par.sessionid = localStorage.getItem("sessionid");
    //Funcion si todo en la llamada al servicio y se obtiene respuesta
    let onsuccess = async (rsp) => {
        switch (rsp.status) {
            case 200:
                data = JSON.parse(rsp.response);
                //Clonamos el arreglo y modificamos el disabled si el status es inactivo. Utilizamos la función structuredClone si es valida en el navegador
                let disInactives = (structuredClone != undefined) ? structuredClone(data.records) : JSON.parse(JSON.stringify((data.records)));
                disInactives.map((r) => { if (r.status.id == 0 || r.id == 1) { r.disabled = true; r.selected = true; } });
                //Filtro de listado
                bets = disInactives;
                break;
            case 401:
                //NO autorizado
                localStorage.clear();
                gotoPage('login', '', {});
                break;
            default:
                data = JSON.parse(rsp.response);
                console.log(data);
                break;
        }
    }
    //Lamamos al servicio si todo sale ok se ejecuta el onsuccess si falla sale por el catch
    return callWS("POST", "records/bets/list", par).then(onsuccess).catch((e) => { console.log("Ocurrió un error " + e) });
}
//Se requiere invocar el listado de condiciones
let conditions1 = [];
async function listConditions1API() {
    var par = {};
    par.filter = "";
    par.typeid = 1;
    par.order = 1;
    par.offset = 0;
    par.numofrec = 9999;
    par.sessionid = localStorage.getItem("sessionid");
    //Funcion si todo en la llamada al servicio y se obtiene respuesta
    let onsuccess = async (rsp) => {
        switch (rsp.status) {
            case 200:
                data = JSON.parse(rsp.response);
                //Clonamos el arreglo y modificamos el disabled si el status es inactivo. Utilizamos la función structuredClone si es valida en el navegador
                let disInactives = (structuredClone != undefined) ? structuredClone(data.records) : JSON.parse(JSON.stringify((data.records)));
                disInactives.map((r) => { if (r.status.id == 0) r.disabled = true });
                
                conditions1 = data.records;
                //Filtro de listado
                drawSelect(disInactives, document.getElementById("updFstCond"), 'id', '(+code+) +dsc', 'Seleccione una condición', '');
                break;
            case 401:
                //NO autorizado
                localStorage.clear();
                gotoPage('login', '', {});
                break;
            case 403:
                //Mostramos el error en el filtro y manejamos para mostrarlo en el popup del update
                document.getElementById("updFstCond").setAttribute("privileges", -1);
                document.getElementById("updSecCond").setAttribute("privileges", -1);
                break;
            default:
                data = JSON.parse(rsp.response);
                console.log(data);
                break;
        }
    }
    //Lamamos al servicio si todo sale ok se ejecuta el onsuccess si falla sale por el catch
    return callWS("POST", "races/conditions/list", par).then(onsuccess).catch((e) => { console.log("Ocurrió un error " + e) });
}
let conditions2 = [];
async function listConditions2API() {
    var par = {};
    par.filter = "";
    par.typeid = 2;
    par.order = 1;
    par.offset = 0;
    par.numofrec = 9999;
    par.sessionid = localStorage.getItem("sessionid");
    //Funcion si todo en la llamada al servicio y se obtiene respuesta
    let onsuccess = async (rsp) => {
        switch (rsp.status) {
            case 200:
                data = JSON.parse(rsp.response);
                conditions2 = data.records;
                //Clonamos el arreglo y modificamos el disabled si el status es inactivo. Utilizamos la función structuredClone si es valida en el navegador
                let disInactives = (structuredClone != undefined) ? structuredClone(data.records) : JSON.parse(JSON.stringify((data.records)));
                disInactives.map((r) => { if (r.status.id == 0) r.disabled = true });
                //Filtro de listado
                drawSelect(disInactives, document.getElementById("updSecCond"), 'id', '(+code+) +dsc', 'Seleccione una condición', '');
                break;
            case 401:
                //NO autorizado
                localStorage.clear();
                gotoPage('login', '', {});
                break;
            case 403:
                //Mostramos el error en el filtro y manejamos para mostrarlo en el popup del update
                document.getElementById("updFstCond").setAttribute("privileges", -1);
                document.getElementById("updSecCond").setAttribute("privileges", -1);
                break;
            default:
                data = JSON.parse(rsp.response);
                console.log(data);
                break;
        }
    }
    //Lamamos al servicio si todo sale ok se ejecuta el onsuccess si falla sale por el catch
    return callWS("POST", "races/conditions/list", par).then(onsuccess).catch((e) => { console.log("Ocurrió un error " + e) });
}
//Se requiere invocar el listado de "estados" para el select del filtro y el insertar nuevo
async function listDistancesAPI(racecourseid = "", selected = "") {
    var par = {};
    par.id = racecourseid;
    par.filter = "";
    par.order = 1;
    par.offset = 0;
    par.numofrec = 9999;
    par.sessionid = localStorage.getItem("sessionid");
    //Funcion si todo en la llamada al servicio y se obtiene respuesta
    let onsuccess = async (rsp) => {
        switch (rsp.status) {
            case 200:
                data = JSON.parse(rsp.response);
                let disInactives = (structuredClone != undefined) ? structuredClone(data.entry.distances) : JSON.parse(JSON.stringify((data.entry.distances)));
                disInactives.map((r) => { if (!r.status) r.disabled = true });
                drawSelect(disInactives, document.getElementById("updDistanceid"), 'id', 'name', 'Distancia', selected);
                break;
            case 401:
                //NO autorizado
                localStorage.clear();
                gotoPage('login', '', {});
                break;
            case 403:
                document.getElementById("addTimeDist").setAttribute("privileges", -1);
                //errInpt("addTimeDist", "No tiene privilegios para visualizar las distancias", 0);
                break;
            default:
                data = JSON.parse(rsp.response);
                console.log(data);
                break;
        }
    }
    //Lamamos al servicio si todo sale ok se ejecuta el onsuccess si falla sale por el catch
    return callWS("GET", "hippodromes/racecourses/entry", par).then(onsuccess).catch((e) => { console.log("Ocurrió un error " + e) });
}
//Se requiere invocar el listado de "tipos de carreras" para el select del filtro y el insertar nuevo
let clasics = [];
async function listRacestypeAPI(selected = "") {
    var par = {};
    par.filter = "";
    par.order = 1;
    par.offset = 0;
    par.numofrec = 9999;
    par.sessionid = localStorage.getItem("sessionid");
    //Funcion si todo en la llamada al servicio y se obtiene respuesta
    let onsuccess = async (rsp) => {
        switch (rsp.status) {
            case 200:
                data = JSON.parse(rsp.response);
                //Asignamos el atributo disabled a los que traigan el status cómo inactivo para que el "drawSelect" deshabilite las opciones que corresponden
                let disInactives = (structuredClone != undefined) ? structuredClone(data.records) : JSON.parse(JSON.stringify((data.records)));
                disInactives.map((r) => { if (r.status.id == 0) r.disabled = true });
                clasics = disInactives;
                drawSelect(disInactives, document.getElementById("updClasicid"), 'id', 'dsc', 'No Clásico', selected);
                break;
            case 401:
                //NO autorizado
                localStorage.clear();
                gotoPage('login', '', {});
                break;
            case 403:
                document.getElementById("addTimeDist").setAttribute("privileges", -1);
                //errInpt("addTimeDist", "No tiene privilegios para visualizar las distancias", 0);
                break;
            default:
                data = JSON.parse(rsp.response);
                console.log(data);
                break;
        }
    }
    //Lamamos al servicio si todo sale ok se ejecuta el onsuccess si falla sale por el catch
    return callWS("POST", "races/types/list", par).then(onsuccess).catch((e) => { console.log("Ocurrió un error " + e) });
}
//Lista de monedas utilitario para la definición de los montos de los premios
async function listCurrenciesAPI() {
    var par = {};
    par.filter = "";
    par.order = 1;
    par.offset = 0;
    par.numofrec = 9999;
    par.sessionid = localStorage.getItem("sessionid");
    //Funcion si todo en la llamada al servicio y se obtiene respuesta
    let onsuccess = async (rsp) => {
        switch (rsp.status) {
            case 200:
                data = JSON.parse(rsp.response);
                //Clonamos el arreglo y modificamos el disabled si el status es inactivo. Utilizamos la función structuredClone si es valida en el navegador
                //let disInactives = (structuredClone != undefined) ? structuredClone(data.records) : JSON.parse(JSON.stringify((data.records)));
                //disInactives.map((r) => { if (r.status.id == 0) r.disabled = true });
                //Filtro de listado
                drawSelect(data.records, document.getElementById("updMainpriceSym"), 'code', 'name', '', '');
                drawSelect(data.records, document.getElementById("updExtpriceSym"), 'code', 'name', '', '');
                break;
            case 401:
                //NO autorizado
                localStorage.clear();
                gotoPage('login', '', {});
                break;
            case 403:
                //Mostramos el error en el filtro y manejamos para mostrarlo en el popup del update
                document.getElementById("updMainpriceSym").setAttribute("privileges", -1);
                document.getElementById("updMainpriceSym").setAttribute("privileges", -1);
                break;
            default:
                data = JSON.parse(rsp.response);
                console.log(data);
                break;
        }
    }
    //Lamamos al servicio si todo sale ok se ejecuta el onsuccess si falla sale por el catch
    return callWS("POST", "records/currencies/list", par).then(onsuccess).catch((e) => { console.log("Ocurrió un error " + e) });
}

/** CORREDORES EN CARRERAS **/

//Función para llamar los valores de la lista de llamados
let notupdatedRacers = {}; //Guardamos la información de los registros visibles localmente en caso de necesitar restaurar una linea "sin cambios"
function listRacersAPI(raceid, order = 1) {
    return new Promise((resolve, reject) => { 
        var par = {};
        par.raceid = raceid;
        par.filter = "";
        par.order = order;
        par.offset = 0;
        par.numofrec = 9999;
        par.sessionid = localStorage.getItem("sessionid");
        //Funcion si todo en la llamada al servicio y se obtiene respuesta
        let onsuccess = async (rsp) => {
            switch (rsp.status) {
                case 200:
                    data = JSON.parse(rsp.response);
                    notupdatedRacers = data;
                    resolve(data);
                    break;
                case 401:
                    //NO autorizado
                    localStorage.clear();
                    gotoPage('login', '', {});
                    reject();
                    break;
                case 403:
                    //Si no tiene privilegios se muestra el mensaje de error
                    resolve();
                    //errTbl(document.querySelector(".tblSct"), "No tiene privilegios para visualizar los registros");
                    break;
                default:
                    data = JSON.parse(rsp.response);
                    console.log(data);
                    reject();
                    break;
            }
        }
        //Lamamos al servicio si todo sale ok se ejecuta el onsuccess si falla sale por el catch
        callWS("POST", "records/racers/list", par).then(onsuccess).catch((e) => { console.log("Ocurrió un error " + e) });
    });
}
//Función para pintar la respuesta de la lista en la tabla - requiere modelo base en html
const maxhorses = 14;
function listDrawRacers(raceid, rsp, readonly = false) {
    console.log(rsp);
    let tbl = document.getElementById("popupUpdFrm").querySelector(".popupFrmCnt.tblSct").querySelector(".tbody");
    let list = rsp?.records;
    let ele = tbl.children[0].cloneNode(true);
    if (list.length > 0 || !readonly) {
        tbl.innerHTML = "";
        for (var i = 0; i < ((readonly)?list.length:list.length+1); i++) {
            var clone = ele.cloneNode(true);
            clone.style.display = "";
            clone.removeAttribute("itemid");
            clone.removeAttribute("active");
            clone.querySelectorAll(".popInpt").forEach(e => {
                e.setAttribute("disabled","");
            });

            let focuseventeles = Array.from(clone.children);
            focuseventeles.forEach((e,i) => {
                e.querySelector("input[type='text']")?.addEventListener("focusin", function () {
                    this.selectionStart = 0;
                    this.selectionEnd = this.value.length;
                });
            })

            var data = undefined;
            if (list != undefined) {
                let exist = list[i];
                data = (exist != undefined) ? exist : undefined;
            }
            (data != undefined) ? clone.setAttribute("itemid", data.id) : "";
        
            var celda = clone.children[0];
            celda.children[0].value = (data != undefined) ? data.number : (i + 1);
            if (data == undefined) celda.children[0].setAttribute("last", (i + 1));
            celda.children[0].addEventListener("keyup", function (e) {
                if (this.value != "") this.value = fieldFormat(this.value, 'intnumber');
            });
            
            var celda = clone.children[1];
            let delay = null;
            celda.children[0].addEventListener("keyup", function (e) {
                if (this.value != "") this.value = fieldFormat(this.value, 'name');
                clearTimeout(delay);
                if (this.value.length >= 1) {
                    delay = setTimeout(() => {
                        listHorsesAPI(this.nextElementSibling, this.value);
                    }, 500);
                }
            });
            if (data != undefined) {
                celda.firstElementChild.value = data.horse.name + " ("+data.horse.id+")";
                celda.firstElementChild.setAttribute("horseid",data.horse.id);
            } else {
                celda.firstElementChild.value = "";
                celda.firstElementChild.removeAttribute("horseid");
            }
            
            //Celda 2 despues de insertada - multiselect

            var celda = clone.children[3];
            celda.firstElementChild.value = (data != undefined) ? (data.jockey.weight).replace(/\./g,",") : "";
            celda.firstElementChild.addEventListener("keyup", function () {
                //let regex = new RegExp(`^((\\d{1,2})(?:[.,]\\d{0,2})?).*`,"g");
                let regex = new RegExp('^(((\\d{1,2})(?:[.,]\\d{0,2})?)((?:[+|-])\\d{0,2})?(?:[.,]\\d{0,2})?).*', 'g')
                this.value = fieldFormat(this.value, "uniquereplace", (this.value.replace(/[^0-9.,\+\-]/g,"")).replace(regex, "$1"));
            });

            var celda = clone.children[4];
            let delayJ = null;
            celda.children[0].addEventListener("keyup", function (e) {
                if (this.value != "") this.value = fieldFormat(this.value, 'name');
                clearTimeout(delayJ);
                if (this.value.length >= 1) {
                    delayJ = setTimeout(() => {
                        listJockeysAPI(this.nextElementSibling, this.value);
                    }, 500);
                }
            });
            if (data != undefined) {
                celda.firstElementChild.value = data.jockey.abbr + " ("+data.jockey.id+")";
                celda.firstElementChild.setAttribute("jockeyid",data.jockey.id);
            } else {
                celda.firstElementChild.value = "";
                celda.firstElementChild.removeAttribute("jockeyid");
            }

            //Celda 5 despues de insertada - multiselect

            var celda = clone.children[6];
            celda.children[0].addEventListener("keyup", function (e) {
                if (this.value != "") this.value = fieldFormat(this.value, 'name');
                clearTimeout(delay);
                if (this.value.length >= 1) {
                    delay = setTimeout(() => {
                        listTrainersAPI(this.nextElementSibling, this.value);
                    }, 500);
                }
            });
            if (data != undefined) {
                celda.firstElementChild.value = data.trainer.abbr + " ("+data.trainer.id+")";
                celda.firstElementChild.setAttribute("trainerid",data.trainer.id);
            } else {
                celda.firstElementChild.value = "";
                celda.firstElementChild.removeAttribute("trainerid");
            }
            
            var celda = clone.children[7];
            //celda.firstElementChild.classList.add("inactive");
            //if (i == 0) celda.firstElementChild.classList.remove("inactive");
            let prev = list.find(e => e.number == (i));
            let prevdata = (prev != undefined) ? prev : undefined;            
            if (prevdata != undefined) celda.firstElementChild.setAttribute("last", (prevdata.position+1));         
            celda.firstElementChild.value = (data != undefined) ? data.position : ((prevdata != undefined) ? (prevdata.position+1) : i+1);
            var celda = clone.children[8];        
            if(studs.length>0)drawSelect(studs, celda.firstElementChild, 'id', 'name', '--', (data != undefined) ? data.stud.id : "");

            //Editar Btn
            var celda = clone.children[9];
            let btnsA = celda.children[0];//Editar, eliminar
            let btnsB = celda.children[1];//Arpobar, cancelar
            let btnsC = celda.children[2];//Solo agregar
            if (readonly) {
                btnsA.style.display = "none";
                btnsB.style.display = "none";
                btnsC.style.display = "none";
            }else if (data != undefined) {            
                btnsA.style.display = "";
                btnsB.style.display = "none";
                btnsC.style.display = "none";
            } else {    
                btnsA.style.display = "none";
                btnsB.style.display = "none";
                btnsC.style.display = "";
            }
            let addactivate = function (e) {
                let tbl = document.getElementById("popupUpdFrm").querySelector(".popupFrmCnt.tblSct").querySelector(".tbody");
                e.stopPropagation();
                //Si existe uno activo lo restauramos
                let someactive = tbl.querySelector(".tr[active]");
                if (someactive != undefined) resetracerRow(someactive);

                let row = this.parentElement.parentElement.parentElement;
                //Activamos la linea
                row.setAttribute("active", "");
                //Activamos la botonera que corresponde
                row.querySelectorAll(".tblBtns")[2].style.display = "none";
                row.querySelectorAll(".tblBtns")[0].style.display = "none";
                row.querySelectorAll(".tblBtns")[1].style.display = "";
                //Permitimos la edición de los campos
                row.querySelectorAll(".popInpt:not(.inactive)").forEach(e => {
                    e.removeAttribute("disabled");
                });
            };
            //Evevntos botones editar y eliminar
            if (data != undefined) {            
                btnsA.setAttribute("itemlbl", data.horse.name + " (" + data.horse.id + ") - Nro:" + data.number);
                btnsA.setAttribute("itemid", data.id);
                if (!readonly) {
                    btnsA.children[0].addEventListener("click", addactivate);
                    btnsA.children[1].addEventListener("click", function (e) {
                    
                        e.stopPropagation();
                        //Se muestra el popup de confirmación
                        let usr = this.parentElement.getAttribute("itemlbl");
                        document.querySelector(".poupDelItemLbl").innerText = usr;
                        //Asignamos el id que va a ser eliminado al boton guardar de la confirmación del delete
                        let delpop = document.getElementById("popupDelFrm");
                        delpop.querySelector(".saveBtn").setAttribute("type", "racer");
                        delpop.querySelector(".saveBtn").setAttribute("delid", this.parentElement.getAttribute("itemid"));
                        document.getElementById("delLbl").innerText = "ejemplar corredor";
                        //Mostramos el popup de confirmación
                        showPopup("popupDelFrm", false);
                    });
                }
            }
            //eventos botones agregar
            if (!readonly) btnsC.children[0].addEventListener("click", addactivate);
            //Eventos botones guardar o cancelar 
            btnsB.children[0].setAttribute("raceid", raceid);
            btnsB.children[0].setAttribute("racerid", ((data != undefined) ? data.id : "0"));
            if (!readonly) {
                btnsB.children[0].addEventListener("click", function () {
                    updateRacerAPI(this.parentElement.parentElement.parentElement, this.getAttribute("raceid"), this.getAttribute("racerid"));
                });
                btnsB.children[1].addEventListener("click", function () {
                    resetracerRow(this.parentElement.parentElement.parentElement);
                });
            }

            tbl.appendChild(clone);

            let selectedMed = ((data != undefined) ? data.medicaments.map(i => i.id) : medicines.map(i=>i.id));
            let medicinOptSelect = {
                ele: clone.children[2].firstElementChild,
                //Le damos el formato que corresponde al arreglo
                labelKey: 'abbr',
                valueKey: 'id',
                aliasKey: 'name',
                labelRenderer: (opt) => {
                    return medicines[opt.index].name+" ("+medicines[opt.index].abbr+") ";;
                },
                options: medicines,
                disabledOptions: medicines.filter(r=>r.disabled).map(i=>i.id),
                placeholder: '--',
                hideClearButton: false,
                optionHeight:'35px',
                autoSelectFirstOption: false,
                silentInitialValueSet: false,
                multiple: true,
                search: false,
                disableAllOptionsSelectedText: true,
                noOptionsText: 'No hay opciones',
                selectAllText: 'Todas',//Label de la opción para escoger todos
                allOptionsSelectedText: 'Todas ',//Texto que se muestra en el campo cuando están marcados todos 'Todos'+num
                maxWidth: (clone.children[2].firstElementChild.offsetWidth-3)+"px",
                dropboxWidth: "20vw",
                optionSelectedText: 'Opción Seleccionada',
                optionsSelectedText: 'Opciones Seleccionadas',
                silentInitialValueSet: false,
                hideClearButton:true,
                additionalClasses: "popInpt",
                selectedValue: selectedMed,
                alwaysShowSelectedOptionsLabel: true,
                dropboxWrapper:'.boxscroll'
            }        
            //Inicializamos el select de las opciones
            VirtualSelect.init(medicinOptSelect);

            let selectedImp = ((data != undefined) ? data.implements.map(i => i.id) : []);
            let implementOptSelect = {
                ele: clone.children[5].firstElementChild,
                //Le damos el formato que corresponde al arreglo
                labelKey: 'abbr',
                valueKey: 'id',                
                aliasKey:'name',
                labelRenderer: (opt) => {
                    return implements[opt.index].name+" ("+implements[opt.index].abbr+") ";
                },
                options: implements,
                disabledOptions: implements.filter(r=>r.disabled).map(i=>i.id),
                placeholder: '--',
                hideClearButton: false,
                autoSelectFirstOption: false,
                silentInitialValueSet: false,
                multiple: true,
                search: false,
                optionHeight:'35px',
                disableAllOptionsSelectedText: true,
                noOptionsText: 'No hay opciones',
                selectAllText: 'Todas',//Label de la opción para escoger todos
                allOptionsSelectedText: 'Todas ',//Texto que se muestra en el campo cuando están marcados todos 'Todos'+num
                maxWidth: (clone.children[5].firstElementChild.offsetWidth-3)+"px",
                dropboxWidth: "20vw",
                optionSelectedText: 'Opción Seleccionada',
                optionsSelectedText: 'Opciones Seleccionadas',
                silentInitialValueSet: false,
                hideClearButton:true,
                additionalClasses: "popInpt",
                selectedValue: selectedImp,
                alwaysShowSelectedOptionsLabel: true,            
                dropboxWrapper:'.boxscroll'

            }        
            //Inicializamos el select de las opciones
            VirtualSelect.init(implementOptSelect)

        }
    } else {
        var clone = ele.cloneNode(true);
        clone.style.display = "none";
        tbl.innerHTML = "";
        tbl.appendChild(clone);
    }

    //Luego de recorrer todo revalidamos el size de la tabla
    let cnt = document.getElementById("popupUpdFrm").querySelector(".frmHeadBox[active]+.popupSctScroll").children[0];
    cnt.style.height = cnt.scrollHeight + "px";

}
//Funcion para actualizar un corredor
function updateRacerAPI(row, raceid, id) {  
    let validationpars = [
        {
            "key": "number",
            "id": row.children[0],
            "msg": ""
        },        
        {
            "key": "horseid",
            "id": row.querySelector("[name='horseid']"),
            "msg": ""
        },     
        {
            "key": "jockeyweight",
            "id": row.querySelector("[name='jockeyWeight']"),
            "msg": ""
        },               
        {
            "key": "jockeyid",
            "id": row.querySelector("[name='jockeyid']"),
            "msg": ""
        },
        {
            "key": "trainerid",
            "id": row.querySelector("[name='trainerid']"),
            "msg": ""
        },
        {
            "key": "position",
            "id": row.querySelector("[name='position']"),
            "msg": ""
        },
        {
            "key": "studid",
            "id": row.querySelector("[name='studid']"),
            "msg": ""
        }
    ]

    var par = {};
    par.id = id;
    par.raceid = raceid;    
    par.number = getNum(row.querySelector("[name='horsenumber']").value);   
    par.horseid = row.querySelector("[name='horseid']").getAttribute("horseid");
    par.medicaments = (row.querySelector("[name='medicaments']").value!="") ? row.querySelector("[name='medicaments']").value.join("-") : "-";
    par.jockeyweight = row.querySelector("[name='jockeyWeight']").value.replace(/\,/g,".");  
    par.jockeyid = row.querySelector("[name='jockeyid']").getAttribute("jockeyid");
    par.implements = (row.querySelector("[name='implements']").value != "") ? row.querySelector("[name='implements']").value.join("-") : "-";
    par.trainerid = row.querySelector("[name='trainerid']").getAttribute("trainerid");
    par.position = row.querySelector("[name='position']").value;
    par.studid = row.querySelector("[name='studid']").value;
    par.sessionid = localStorage.getItem("sessionid");

    console.log(par);
    //Hacemos las validaciones
    var haserror = false;
    //Cómo son muchos campos simplificamos con un arreglo que contiene los campos a verificar
    validationpars.forEach((e) => {
        //Que el nombre no esté vacío
        if (!(par[e.key] !== undefined && par[e.key] !== null && par[e.key] !== "")) {
            errRowInpt(e.id, 6000);
            haserror = true;
        }
    });

    //Si tiene errores detenemos la llamada al servicio
    if (haserror) {
        errInpt(document.getElementById("popupUpdFrm").querySelector(".errmsgSct"), "Faltan campos obligatorios para agregar el ejemplar", 6000);
        return;
    }

    if (par.position <= 0) {
        errInpt(document.getElementById("popupUpdFrm").querySelector(".errmsgSct"), "La posición de partida debe ser mayor a 0", 6000);
        return;
    }
    //Funcion si todo en la llamada al servicio y se obtiene respuesta
    let onsuccess = (rsp) => {
        switch (rsp.status) {
            case 200:
                data = JSON.parse(rsp.response);
                //Si obtenemos un id insertado/modificado refrescamos la tabla
                if (data.id != null && data.id != undefined) {
                    //Llevaos el ordenamiento por "id" y cargamos el listado
                    //resetOrder(document.querySelector(".pgSctTbl")).then(() => { listAPI(); });
                    listRacersAPI(raceid).then(async racers => {
                        listDrawRacers(raceid, racers);
                    });
                    //Como definimos función flecha podemos leer los parametros para determinar si era nuevo y mostrar mensaje exitoso correcto
                    successMsgShow((par.id == 0) ? "Ejemplar agregado con éxito" : "Ejemplar modificado con éxito");

                }
                //Cerramos el popup
                //closePopups();
                break;
            case 400:
                data = JSON.parse(rsp.response);
                errInpt(document.getElementById("popupUpdFrm").querySelector(".errmsgSct"), data.msg, 6000);
                break;
            case 401:
                //NO autorizado
                localStorage.clear();
                gotoPage('login', '', {});
                break;
            case 409:
                errInpt(document.getElementById("popupUpdFrm").querySelector(".errmsgSct"), "Este ejemplar o jinete ya se encuentra agregado a los corredores", 6000);
                break;
            default:
                data = JSON.parse(rsp.response);
                console.log(data);
                break;
        }
    }
    //Lamamos al servicio si todo sale ok se ejecuta el onsuccess si falla sale por el catch
    callWS("POST", "records/racers/update", par).then(onsuccess).catch((e) => { console.log("Ocurrió un error " + e) });
}
//Función para llamar el servicio de eliminar, se ejecuta al confirmar el boton
function deleteRacerAPI(id) {
    var par = {};
    par.id = id;
    par.sessionid = localStorage.getItem("sessionid");
    //Funcion si todo en la llamada al servicio y se obtiene respuesta
    let onsuccess = (rsp) => {
        switch (rsp.status) {
            case 200:
                data = JSON.parse(rsp.response);
                //Si obtenemos un id insertado/modificado refrescamos la tabla
                if (data.id != null && data.id != undefined) {
                    
                    let raceid = document.getElementById("popupUpdFrm").querySelector(".saveBtn").getAttribute("upid");
                    listRacersAPI(raceid).then(async racers => {
                        listDrawRacers(raceid, racers);                        
                        //Cerramos el popup
                        var delform = document.getElementById("popupDelFrm");
                        delform.style.opacity = "";
                        setTimeout(() => {
                            delform.style.display = ""
                        }, 300, delform);
                    });
                        
                    //Mostramos mensaje de eliminado con éxito
                    successMsgShow("Corredor eliminada con éxito");
                }
                break;
            case 204:
                //Error de dependencias
                errInpt(document.getElementById("popupDelFrm").querySelector(".poupDelItemLbl"), "Registro no encontrado", 6000);
                break;
            case 304:
                //Error de dependencias
                errInpt(document.getElementById("popupDelFrm").querySelector(".poupDelItemLbl"), "Existen dependencias que no permiten ejecutar esta acción", 6000);
                break;
            case 401:
                //NO autorizado
                localStorage.clear();
                gotoPage('login', '', {});
                break;
            case 403:
                //Error de privilegios - prohibido
                errInpt(document.getElementById("popupDelFrm").querySelector(".poupDelItemLbl"), "No tiene privilegios para ejecutar esta acción", 6000);
                break;
            default:
                data = JSON.parse(rsp.response);
                console.log(data);
                break;
        }
    }
    //Lamamos al servicio si todo sale ok se ejecuta el onsuccess si falla sale por el catch
    callWS("POST", "records/racers/delete", par).then(onsuccess).catch((e) => { console.log("Ocurrió un error " + e) })
}
//Función si se cancela sin guarda devolvemos los valores iniciales
function resetracerRow(row) {
    //Vemos si existe el que se cancela la info para restaurarlo
    let data = notupdatedRacers.records.find(r => (r.id == row.getAttribute("itemid")));
    if (data) {
        row.removeAttribute("active");
        row.querySelectorAll(".popInpt").forEach(e => {
            e.value = "";
            e.setAttribute("disabled", "");
        });
        row.querySelector("[name='medicaments']").reset();
        row.querySelector("[name='implements']").reset();

        row.querySelector("[name='horsenumber']").value = data.number;
        row.querySelector("[name='horseid']").setAttribute("horseid", data.horse.id);
        row.querySelector("[name='horseid']").value = data.horse.name + " ("+data.horse.id+")";
        row.querySelector("[name='medicaments']").setValue(data.medicaments.map(m=>m.id));
        row.querySelector("[name='jockeyWeight']").value = (data.jockey.weight).replace(/\./g,",");//data.jockey.weight; 
        row.querySelector("[name='jockeyid']").setAttribute("jockeyid", data.jockey.id);
        row.querySelector("[name='jockeyid']").value = data.jockey.abbr + " ("+data.jockey.id+")";
        row.querySelector("[name='implements']").setValue(data.implements.map(m=>m.id));
        row.querySelector("[name='trainerid']").setAttribute("trainerid", data.trainer.id);
        row.querySelector("[name='trainerid']").value = data.trainer.abbr + " ("+data.trainer.id+")";
        row.querySelector("[name='position']").value = data.position;
        row.querySelector("[name='studid']").value = data.stud.id;
        
    } else {
        row.removeAttribute("active");
        row.querySelectorAll(".popInpt").forEach(e => {
            e.value = "";
            e.setAttribute("disabled", "");
        });
        if (row.querySelector("[name='horsenumber']").getAttribute("last") != null) {
            row.querySelector("[name='horsenumber']").value = row.querySelector("[name='horsenumber']").getAttribute("last");
        }
        if (row.querySelector("[name='position']").getAttribute("last") != null) {
            row.querySelector("[name='position']").value = row.querySelector("[name='position']").getAttribute("last");
        }
        row.querySelector("[name='medicaments']").reset();
        row.querySelector("[name='medicaments']").setValue(medicines.map(m=>m.id));
        row.querySelector("[name='implements']").reset();
    }
    
    if (row.getAttribute("itemid") != null && row.getAttribute("itemid") != undefined && row.getAttribute("itemid") != "") {        
        row.querySelectorAll(".tblBtns")[2].style.display = "none";
        row.querySelectorAll(".tblBtns")[0].style.display = "";
        row.querySelectorAll(".tblBtns")[1].style.display = "none";
    } else {        
        row.querySelectorAll(".tblBtns")[2].style.display = "";
        row.querySelectorAll(".tblBtns")[0].style.display = "none";
        row.querySelectorAll(".tblBtns")[1].style.display = "none";
    }
}
//Se requiere adicionalmente llamar el mismo listado de horses pero cargando las opciones para el linaje, aplica busqueda y trae siempre todos los registros
function listHorsesAPI(box, srch) {
    var par = {};
    par.filter = srch;
    par.order = 3;
    par.statusid = "1";
    par.genderid = "";
    par.furid = "";
    par.harasid = "";
    par.offset = 0;
    par.numofrec = 999;
    par.sessionid = localStorage.getItem("sessionid");
    //Funcion si todo en la llamada al servicio y se obtiene respuesta
    let onsuccess = async (rsp) => {
        switch (rsp.status) {
            case 200:
                data = JSON.parse(rsp.response);
                var onclick = null;
                //Función onclick para las opciones del listado de busqueda de caballos linage
                onclick = async (opt) => {
                    if (opt.parentElement != null) {
                        opt.parentElement.previousElementSibling.value = opt.innerText;
                        opt.parentElement.previousElementSibling.setAttribute("horseid", opt.getAttribute("value"));
                        let cnt = opt.parentElement.parentElement.parentElement;
                        let validfields = ['jockeyid','jockeyWeight','trainerid','studid'];
                        let someempty = false;
                        validfields.forEach(f => {
                            if (cnt.querySelector("[name='" + f + "']").value == "") someempty = true;
                        });
                        if (someempty) {
                            entryHorseAPI(opt.getAttribute("value")).then(rsp => {
                                let data = rsp.entry;
                                let validfields = ['jockeyid','jockeyWeight','trainerid','studid'];
                                validfields.forEach(f => {
                                    let ele = cnt.querySelector("[name='" + f + "']");
                                    if (ele.value == "") {
                                        switch (f) {
                                            case 'jockeyid':
                                                if (data.lastjockey.id != 0) {
                                                    ele.setAttribute("jockeyid", data.lastjockey.id);
                                                    ele.value = data.lastjockey.abbr + " (" + data.lastjockey.id + ")";
                                                }
                                                break;
                                            case 'jockeyWeight':
                                                ele.value = data.lastjockeyweight;
                                                break;
                                            case 'trainerid':
                                                if (data.lasttrainer.id != 0) {
                                                    ele.setAttribute("trainerid", data.lasttrainer.id);
                                                    ele.value = data.lasttrainer.abbr + " (" + data.lasttrainer.id + ")";
                                                }
                                                break;
                                            case 'studid':
                                                if(data.laststud.id != 0)ele.value = data.laststud.id;
                                                break;
                                        }
                                    }
                                });
                            });
                        }
                        opt.parentElement.innerHTML = "";
                    }
                }
                drawSrchSelect(data.records, box, 'id', 'name+ (+id+)', undefined, '', onclick, [{'abbr': 'abbr'}], true);
                break;
            case 401:
                //NO autorizado
                localStorage.clear();
                gotoPage('login', '', {});
                break;
            case 403:
                //Si no tiene privilegios se muestra el mensaje de error
                errTbl(document.querySelector(".tblSct"), "No tiene privilegios para visualizar los registros");
                break;
            default:
                data = JSON.parse(rsp.response);
                console.log(data);
                break;
        }
    }
    //Lamamos al servicio si todo sale ok se ejecuta el onsuccess si falla sale por el catch
    callWS("POST", "horses/horses/list", par).then(onsuccess).catch((e) => { console.log("Ocurrió un error " + e) });
}
function entryHorseAPI(id) {
    return new Promise((resolve, reject) => {
        var par = {};
        par.id = id;
        par.sessionid = localStorage.getItem("sessionid");
        //Funcion si todo en la llamada al servicio y se obtiene respuesta
        let onsuccess = (rsp) => {
            switch (rsp.status) {
                case 200:
                    data = JSON.parse(rsp.response);
                    resolve(data);
                    break;
                case 401:
                    //NO autorizado
                    localStorage.clear();
                    gotoPage('login', '', {});
                    break;
                default:
                    data = JSON.parse(rsp.response);
                    console.log(data);
                    break;
            }
        }
        //Lamamos al servicio si todo sale ok se ejecuta el onsuccess si falla sale por el catch
        callWS("GET", "horses/horses/entry", par).then(onsuccess).catch((e) => { console.log("Ocurrió un error " + e) });
    });
}
//Se requiere adicionalmente llamar el mismo listado de horses pero cargando las opciones para el linaje, aplica busqueda y trae siempre todos los registros
function listJockeysAPI(box, srch) {
    var par = {};
    par.filter = srch;
    par.order = 9;
    par.statusid = "1";
    par.genderid = "";
    par.furid = "";
    par.harasid = "";
    par.offset = 0;
    par.numofrec = 999;
    par.sessionid = localStorage.getItem("sessionid");
    //Funcion si todo en la llamada al servicio y se obtiene respuesta
    let onsuccess = async (rsp) => {
        switch (rsp.status) {
            case 200:
                data = JSON.parse(rsp.response);
                var onclick = null;
                //Función onclick para las opciones del listado de busqueda de caballos linage
                onclick = async (opt) => {                    
                    if (opt.parentElement != null) {
                        opt.parentElement.previousElementSibling.value = opt.getAttribute("abbr")+ " ("+opt.getAttribute("value")+")";
                        opt.parentElement.previousElementSibling.setAttribute("jockeyid", opt.getAttribute("value"));
                        opt.parentElement.innerHTML = "";
                    }
                }
                drawSrchSelect(data.records, box, 'id', 'fullname+ (+id+)', undefined, '', onclick, [{'abbr': 'abbr'}], true);
                break;
            case 401:
                //NO autorizado
                localStorage.clear();
                gotoPage('login', '', {});
                break;
            case 403:
                //Si no tiene privilegios se muestra el mensaje de error
                errTbl(document.querySelector(".tblSct"), "No tiene privilegios para visualizar los registros");
                break;
            default:
                data = JSON.parse(rsp.response);
                console.log(data);
                break;
        }
    }
    //Lamamos al servicio si todo sale ok se ejecuta el onsuccess si falla sale por el catch
    callWS("POST", "horses/jockeys/list", par).then(onsuccess).catch((e) => { console.log("Ocurrió un error " + e) });
}
//Se requiere adicionalmente llamar el mismo listado de horses pero cargando las opciones para el linaje, aplica busqueda y trae siempre todos los registros
function listTrainersAPI(box, srch) {
    var par = {};
    par.filter = srch;
    par.order = 9;
    par.statusid = "1";
    par.genderid = "";
    par.furid = "";
    par.harasid = "";
    par.offset = 0;
    par.numofrec = 999;
    par.sessionid = localStorage.getItem("sessionid");
    //Funcion si todo en la llamada al servicio y se obtiene respuesta
    let onsuccess = async (rsp) => {
        switch (rsp.status) {
            case 200:
                data = JSON.parse(rsp.response);
                var onclick = null;
                //Función onclick para las opciones del listado de busqueda de caballos linage
                onclick = async (opt) => {                    
                    if (opt.parentElement != null) {
                        opt.parentElement.previousElementSibling.value = opt.getAttribute("abbr")+ " ("+opt.getAttribute("value")+")";
                        opt.parentElement.previousElementSibling.setAttribute("trainerid", opt.getAttribute("value"));
                        opt.parentElement.innerHTML = "";
                    }
                }
                drawSrchSelect(data.records, box, 'id', 'fullname+ (+id+)', undefined, '', onclick, [{'abbr': 'abbr'}], true);
                break;
            case 401:
                //NO autorizado
                localStorage.clear();
                gotoPage('login', '', {});
                break;
            case 403:
                //Si no tiene privilegios se muestra el mensaje de error
                errTbl(document.querySelector(".tblSct"), "No tiene privilegios para visualizar los registros");
                break;
            default:
                data = JSON.parse(rsp.response);
                console.log(data);
                break;
        }
    }
    //Lamamos al servicio si todo sale ok se ejecuta el onsuccess si falla sale por el catch
    callWS("POST", "horses/trainers/list", par).then(onsuccess).catch((e) => { console.log("Ocurrió un error " + e) });
}
let implements = [];
let medicines = [];
async function listImplementsAPI(typeid) {
    var par = {};
    par.filter = "";
    par.order = 3;
    par.offset = 0;
    par.numofrec = 9999;
    par.typeid = typeid;
    par.sessionid = localStorage.getItem("sessionid");
    //Funcion si todo en la llamada al servicio y se obtiene respuesta
    let onsuccess = async (rsp) => {
        switch (rsp.status) {
            case 200:
                data = JSON.parse(rsp.response);
                //Clonamos el arreglo y modificamos el disabled si el status es inactivo. Utilizamos la función structuredClone si es valida en el navegador
                let disInactives = (structuredClone != undefined) ? structuredClone(data.records) : JSON.parse(JSON.stringify((data.records)));
                disInactives.map((r) => { if (r.status.id == 0) r.disabled = true });
                //Seteamos el valor de data local para cargarlo en la lista de horses en carreras
                if (typeid == 'I') {
                    implements = disInactives;
                } else {
                    medicines = disInactives;
                }
                break;
            case 401:
                //NO autorizado
                localStorage.clear();
                gotoPage('login', '', {});
                break;
            case 403:
                //Mostramos el error en el filtro y manejamos para mostrarlo en el popup del update
                document.getElementById("updMainpriceSym").setAttribute("privileges", -1);
                document.getElementById("updMainpriceSym").setAttribute("privileges", -1);
                break;
            default:
                data = JSON.parse(rsp.response);
                console.log(data);
                break;
        }
    }
    //Lamamos al servicio si todo sale ok se ejecuta el onsuccess si falla sale por el catch
    return callWS("POST", "races/implements/list", par).then(onsuccess).catch((e) => { console.log("Ocurrió un error " + e) });
}
let studs = [];
async function listStudsAPI() {
    var par = {};
    par.filter = "";
    par.order = 6;
    par.offset = 0;
    par.numofrec = 9999;
    par.sessionid = localStorage.getItem("sessionid");
    //Funcion si todo en la llamada al servicio y se obtiene respuesta
    let onsuccess = async (rsp) => {
        switch (rsp.status) {
            case 200:
                data = JSON.parse(rsp.response);
                //Clonamos el arreglo y modificamos el disabled si el status es inactivo. Utilizamos la función structuredClone si es valida en el navegador
                let disInactives = (structuredClone != undefined) ? structuredClone(data.records) : JSON.parse(JSON.stringify((data.records)));
                disInactives.map((r) => { if (r.status.id == 0) r.disabled = true });
                //Seteamos el valor de data local para cargarlo en la lista de horses en carreras
                studs = disInactives;
                break;
            case 401:
                //NO autorizado
                localStorage.clear();
                gotoPage('login', '', {});
                break;
            case 403:
                //Mostramos el error en el filtro y manejamos para mostrarlo en el popup del update
                document.getElementById("updMainpriceSym").setAttribute("privileges", -1);
                document.getElementById("updMainpriceSym").setAttribute("privileges", -1);
                break;
            default:
                data = JSON.parse(rsp.response);
                console.log(data);
                break;
        }
    }
    //Lamamos al servicio si todo sale ok se ejecuta el onsuccess si falla sale por el catch
    return callWS("POST", "horses/studs/list", par).then(onsuccess).catch((e) => { console.log("Ocurrió un error " + e) });
}

/**LLEGADAS**/
//Función para llamar el servicio que inserta o modifica un usuario.
function updateArriveAPI(id) {
    return new Promise((resolve, reject) => {
        let validationpars = [
            {
                "key": "finishtime",
                "id": "arrvFinishTime",
                "msg": ""
            },
            {
                "key": "racecoursetypeid",
                "id": "arrvRacetypeid",
                "msg": ""
            },
        ]

        //Hacemos las validaciones
        var haserror = false;

        var par = {};
        par.id = id;
        par.finishtime = getNum(document.getElementById("arrvFinishTime").value);
        let tiempos = Array.from(document.getElementById("popupArrvFrm").querySelectorAll(".finishtime:not([disabled])"));
        par.times400 = (tiempos.filter(t => t.value != "").map(t => getNum(t.value))).join("-");
        par.racecoursetypeid = document.getElementById("arrvRacetypeid").value;
        let bets = [];
        if (document.getElementById("arrvWinDiv").getAttribute("disabled") == null) {
            if (document.getElementById("arrvWinDiv").getAttribute("datanum") != "" &&
                document.getElementById("arrvWinDiv").getAttribute("datanum") != null) {
                bets.push({
                    'betprices': getNum(document.getElementById("arrvWinDiv").getAttribute("datanum")),
                    'bethorses': "",
                    'betid': 1
                });
            } else {
                errInpt("arrvWinDiv", "", 6000);
                haserror = true;
            }
        }
        if ((document.getElementById("arrvPlace1Div").getAttribute("disabled") == null && !document.getElementById("arrvPlace1Div").classList.contains("inactive")) &&
            (document.getElementById("arrvPlace2Div").getAttribute("disabled") == null && !document.getElementById("arrvPlace2Div").classList.contains("inactive"))) {
            if (document.getElementById("arrvPlace1Div").getAttribute("datanum") != "" && document.getElementById("arrvPlace2Div").getAttribute("datanum") != "") {
                bets.push({
                    'betprices': getNum(document.getElementById("arrvPlace1Div").getAttribute("datanum")) + "|" + getNum(document.getElementById("arrvPlace2Div").getAttribute("datanum")),
                    'bethorses': "",
                    'betid': 2
                });
            } else {
                if (document.getElementById("arrvPlace1Div").value == "") errInpt("arrvPlace1Div", "", 6000);
                if (document.getElementById("arrvPlace2Div").value == "") errInpt("arrvPlace2Div", "", 6000);
                haserror = true;
            }
        }
        let extbets = document.getElementById("popupArrvFrm").querySelectorAll(".popDblInptFrm[betid]");
        if (extbets.length > 0) {
            extbets.forEach((b) => {
                if (b.parentElement.getAttribute("disabled") == null) {
                    let horseval = b.querySelectorAll(".popInpt")[0].value;
                    if (horseval != "") {
                        if (horseval.split("-").length < b.querySelectorAll(".popInpt")[0].getAttribute("cnt")) {
                            errInpt(b.querySelectorAll(".popInpt")[0].parentElement, "", 6000);
                            haserror = true;
                        }
                    } else {
                        errInpt(b.querySelectorAll(".popInpt")[0].parentElement, "", 6000);
                        haserror = true;
                    }
                    let priceval = b.querySelectorAll(".popInpt")[1].value;
                    if (priceval != "") {
                        if (priceval.split("-").length < b.querySelectorAll(".popInpt")[1].getAttribute("cnt")) {
                            errInpt(b.querySelectorAll(".popInpt")[1].parentElement, "", 6000);
                            haserror = true;
                        }
                    } else {
                        errInpt(b.querySelectorAll(".popInpt")[1].parentElement, "", 6000);
                        haserror = true;
                    }

                    if (!haserror) {
                        bets.push({
                            'betprices': (b.querySelectorAll(".popInpt")[1].getAttribute("cnt") <= 1) ? getNum(b.querySelectorAll(".popInpt")[1].getAttribute("datanum")) : priceval.split("-").map(h => getNum(h)).join("|"),
                            'bethorses': horseval.replace(/-/g, "|"),
                            'betid': b.getAttribute("betid")
                        });
                    }
                }
            });
        }
        //Reordenamos en función de la carga del entry
        bets.sort((a, b) => {
            a.id - b.id
        });
    
        par.bethorses = bets.map(b => b.bethorses);
        par.betprices = bets.map(b => b.betprices);

        par.betprices = par.betprices.join("-");
        par.bethorses = par.bethorses.join("-");
        if (par.bethorses == "") par.bethorses = "|";
        if (par.betprices == "") par.betprices = "|";
    

        par.sessionid = localStorage.getItem("sessionid");
        //Cómo son muchos campos simplificamos con un arreglo que contiene los campos a verificar
        validationpars.forEach((e) => {
            //Que el nombre no esté vacío
            if (!(par[e.key] !== undefined && par[e.key] !== null && par[e.key] !== "")) {
                errInpt(e.id, e.msg, 6000);
                haserror = true;
            }
        });
        if (par['times400'].split("-").length < tiempos.length) {
            tiempos.filter(t => t.value == "").forEach(f => {
                errInpt(f.parentElement, "", 6000);
            });
            haserror = true
        };
        //Si tiene errores detenemos la llamada al servicio
        if (haserror) {
            errInpt(document.getElementById("popupArrvFrm").querySelector(".errmsgSct"), "Faltan campos obligatorios", 6000);
            reject(false);
            return;
        }
        //Validamos que no haya racers en modo de edición
        let ejempActivos = document.getElementById("popupArrvFrm").querySelector(".table .tbody").querySelectorAll(".tr[active]");
        if (ejempActivos.length > 0) {
            Array.from(ejempActivos).forEach(eAct => {
                let iconos = Array.from(eAct.querySelectorAll(".tblbtnIc"));
                iconos.forEach(e => {
                    e.style.color = "var(--errColor)";
                });
                setTimeout(function (iconos) {
                    iconos.forEach(e => {
                        e.style.color = "";
                    });
                }, 6000, iconos);
            });
        
            haserror = true;
        }
        //Si tiene errores detenemos la llamada al servicio
        if (haserror) {
            errInpt(document.getElementById("popupArrvFrm").querySelector(".errmsgSct"), "Existen ejemplares en modo de edición", 6000);
            reject(false);            
            return;
        }
        //Funcion si todo en la llamada al servicio y se obtiene respuesta
        let onsuccess = async (rsp) => {
            switch (rsp.status) {
                case 200:
                    data = JSON.parse(rsp.response);
                    //Si obtenemos un id insertado/modificado refrescamos la tabla
                    if (data.id != null && data.id != undefined) {
                        entryRacesAPI(data.id).then((rsp) => {
                            setFrmArrv(rsp.entry);
                            listRacersAPI(rsp.entry.id, 8).then(async racers => {
                                /*let cnt = document.getElementById("popupArrvFrm").querySelectorAll(".frmHeadBox")[0].parentElement;
                                cnt.querySelector(".frmHeadBox").setAttribute("active","");
                                cnt.querySelector(".popupFrmCnt").style.height = cnt.querySelector(".popupFrmCnt").scrollHeight + "px";
                                cnt.querySelector(".frmBoxOpnBtn").innerHTML = '<i class="fa-solid fa-caret-up"></i>';     */

                                listDrawArrvRacers(racers, !(rsp.entry.status.id == 1));
                            });
                        });
                        //Como definimos función flecha podemos leer los parametros para determinar si era nuevo y mostrar mensaje exitoso correcto
                        successMsgShow((par.id == 0) ? "Llegada creada con éxito" : "Llegada modificada con éxito");
                        resolve();
                    }
                    //Cerramos el popup
                    //closePopups();
                    break;
                case 400:
                    data = JSON.parse(rsp.response);
                    errInpt(document.getElementById("popupArrvFrm").querySelector(".errmsgSct"), data.msg, 6000);
                    reject(false);
                    break;
                case 401:
                    //NO autorizado
                    localStorage.clear();
                    gotoPage('login', '', {});
                    reject(false);
                    break;
                case 403:
                    //Error de privilegios - prohibido
                    errInpt(document.getElementById("popupArrvFrm").querySelector(".errmsgSct"), "No tiene privilegios para ejecutar esta acción", 6000);
                    reject(false);
                    break;
                case 409:
                    errInpt(document.getElementById("popupUpdFrm").querySelector(".errmsgSct"), "Ya existe este Carrera", 6000);
                    reject(false);
                    break;
                default:
                    console.log(rsp);
                    reject();
                    break;
            }
        }
        //Lamamos al servicio si todo sale ok se ejecuta el onsuccess si falla sale por el catch
        callWS("POST", "records/races/updateend", par).then(onsuccess).catch((e) => { console.log("Ocurrió un error " + e) });
    });
}
//Función para llenar el formulario de llegadas
let betsorder = [];
function setFrmArrv(rsp, readonly = false) {
    //Seteamos el titulo
    document.getElementById("popupArrvFrm").querySelector(".popupTit").innerText = "Editar Llegadas";
    //Sección principal info
    document.getElementById("arrvInfCall").innerText = rsp.call;
    document.getElementById("arrvInfOrder").innerText = rsp.order.name;
    document.getElementById("arrvInfNumber").innerText = rsp.number;
    document.getElementById("arrvInfTime").innerText = rsp.time.formatted;
    document.getElementById("arrvInfDist").innerText = rsp.distance.name;
    document.getElementById("arrvInfValid").innerText = rsp.racetype.name;
    document.getElementById("arrvInfCond").innerText = rsp.conditions.conditiondsc;
    document.getElementById("arrvInfSerie").innerText = rsp.serie;
    betsorder = rsp.bets.map(b => b.id);
    inptDrawBets(rsp.bets.filter(b => b.exntensible), rsp.betprices);
    //Id 1 = Ganador
    document.getElementById("arrvWinDiv").removeAttribute("readonly");
    document.getElementById("arrvWinDiv").removeAttribute("disabled");
    if (rsp.betprices.find(b => b.id == 1) != undefined) {
        let val = (rsp.betprices).find(b => b.id == 1);
        document.getElementById("arrvWinDiv").value = (val != undefined) ? (val.prices).map(p => number_format(p, 2)).join("-") : "";
        document.getElementById("arrvWinDiv").setAttribute("datanum", (val != undefined) ? (val.prices).join("-") : "");
    } else {
        document.getElementById("arrvWinDiv").value = "";
        document.getElementById("arrvWinDiv").removeAttribute("datanum");
    }
    //Id 2 = Place
    if (rsp.bets.find(b => b.id == 2) != undefined) {
        document.getElementById("arrvPlace1Div").removeAttribute("readonly");
        document.getElementById("arrvPlace1Div").removeAttribute("disabled");
        document.getElementById("arrvPlace2Div").removeAttribute("readonly");
        document.getElementById("arrvPlace2Div").removeAttribute("disabled");
        let val = (rsp.betprices).find(b => b.id == 2);
        document.getElementById("arrvPlace1Div").value = (val?.prices.length > 0) ? number_format(val.prices[0], 2) : "";
        document.getElementById("arrvPlace1Div").setAttribute("datanum", (val?.prices.length > 0) ? val.prices[0] : "");
        document.getElementById("arrvPlace2Div").value = (val?.prices.length > 1) ? number_format(val.prices[1], 2) : "";
        document.getElementById("arrvPlace2Div").setAttribute("datanum", (val?.prices.length > 1) ? val.prices[1] : "");

        document.getElementById("arrvPlace1Div").classList.remove("inactive");
        document.getElementById("arrvPlace2Div").classList.remove("inactive");

    } else {
        document.getElementById("arrvPlace1Div").setAttribute("readonly", "");
        document.getElementById("arrvPlace1Div").setAttribute("disabled", "");
        document.getElementById("arrvPlace2Div").setAttribute("readonly", "");
        document.getElementById("arrvPlace2Div").setAttribute("disabled", "");
        document.getElementById("arrvPlace1Div").value = "";
        document.getElementById("arrvPlace2Div").value = "";
        document.getElementById("arrvPlace1Div").classList.add("inactive");
        document.getElementById("arrvPlace2Div").classList.add("inactive");
    }
    //Cargamos los tiempos
    document.getElementById("arrvFinishTime").value = (rsp.times.finish.number == 0) ? "" : rsp.times.finish.formatted;
    document.getElementById("arrvLasttime").value = (rsp.times.finalsprint.number == 0) ? "" : rsp.times.finalsprint.formatted;
    document.getElementById("arrvRacetypeid").value = (rsp.racecoursetype.id == 0) ? "" : rsp.racecoursetype.id;

    if (rsp.status.id == 1) {
        document.getElementById("popupArrvFrm").querySelector(".revertirBtn").removeAttribute("upid");
        document.getElementById("popupArrvFrm").querySelector(".revertirBtn").style.display = "none";
        document.getElementById("popupArrvFrm").querySelector(".saveBtn").setAttribute("upid", rsp.id);
        document.getElementById("popupArrvFrm").querySelector(".saveBtn").style.display = "";
        document.getElementById("popupArrvFrm").querySelector(".processBtn").setAttribute("upid", rsp.id);
        document.getElementById("popupArrvFrm").querySelector(".processBtn").style.display = "";
        document.getElementById("popupArrvFrm").querySelectorAll(".popInpt:not(.inactive)").forEach((e => {
            e.removeAttribute("readonly");
            e.removeAttribute("disabled");
        }));
    } else if (rsp.status.id > 1) {
        document.getElementById("popupArrvFrm").querySelector(".revertirBtn").setAttribute("upid", rsp.id);
        document.getElementById("popupArrvFrm").querySelector(".revertirBtn").style.display = "";
        document.getElementById("popupArrvFrm").querySelector(".saveBtn").style.display = "none";
        document.getElementById("popupArrvFrm").querySelector(".saveBtn").removeAttribute("upid");
        document.getElementById("popupArrvFrm").querySelector(".processBtn").style.display = "none";
        document.getElementById("popupArrvFrm").querySelector(".processBtn").removeAttribute("upid");
        document.getElementById("popupArrvFrm").querySelectorAll(".popInpt").forEach((e => {
            e.setAttribute("readonly", "");
            e.setAttribute("disabled", "");
        }));
    }

    var cont = 400;
    document.getElementById("popupArrvFrm").querySelectorAll(".finishtime:not([id])").forEach((t) => {
        if (parseFloat(rsp.distance.name) > cont) {
            let exist = (rsp.times.each400.find((t) => (t[cont] != undefined)));
            t.value = (exist != undefined) ? number_format(exist[cont], 2) : "";
            cont = cont + 400;
        } else {
            t.setAttribute("disabled", "");
            t.setAttribute("readonly", "");
        }
    });

    let meetingid = document.getElementById("pgTbl").querySelector(".tbody>div[active]")?.getAttribute("itemid");
    let data = notupdatedData.records.find(r => (r.id == meetingid));
    if (data != undefined) { 
        let day = days[new Date(data.date.date + " 12:00").getDay()];
        if (rsp.number != undefined && rsp.number != null && rsp.number != "") raceno = rsp.number+" - ";
        document.getElementById("popupArrvFrm").querySelector(".meetingInf").innerHTML = "<span>" + data.racecourse.name + "</span> - R." + data.number + " - " + raceno + data.status.name + " - <span>" + day + " " + data.date.formatted + "</span>";
    }

    if (readonly) {
        editableForm("popupArrvFrm", false, [".popInpt,input[type='checkbox']"]);
        document.getElementById("popupArrvFrm").querySelector(".popupTit").innerText = "Llegadas";

    }

    document.getElementById("creationArvLbl").innerText = "Creado: " + rsp.created.formatted;
    if (rsp.created.date != rsp.modified.date)
        document.getElementById("updatedArvLbl").nnerText = "Modificado: " + rsp.modified.formatted;
    else
        document.getElementById("updatedArvLbl").innerText = "";

}
//Función pintamos los campos especiales de apuestas
//Función para pintar la respuesta de la lista en la tabla - requiere modelo base en html
function inptDrawBets(bets,rsp) {
    let tbl = document.getElementById("popupArrvFrm").querySelector("#extbetsCnt");
    let list = bets;
    let ele = tbl.children[0].cloneNode(true);
    if (list.length > 0) {
        tbl.innerHTML = "";
        for (var i = 0; i < list.length; i++) {
            var clone = ele.cloneNode(true);
            clone.style.display = "";
            var data = list[i];
            clone.querySelector(".popDblInptFrm").removeAttribute("betid");
            clone.querySelector(".popDblInptFrm").setAttribute("betid", data.id);
            let val = rsp.find(b => b.id == data.id);

            clone.querySelector(".popInptLbl").innerText = data.name;

            clone.querySelectorAll("input")[0].value = (val != undefined) ? val.horses.join("-") : "";
            clone.querySelectorAll("input")[0].setAttribute("cnt", data.reporthorsescnt);
            clone.querySelectorAll("input")[0].setAttribute("placeholder", Array(data.reporthorsescnt).fill("0").join("-"));
            clone.querySelectorAll("input")[0].addEventListener("keyup", function () {                
                if (this.value != "") {
                    let valid = (this.value).match(new RegExp(/(\d+-?)*/));
                    let validarr = (valid != null) ? valid[0].split("-") : "";
                    if (validarr.length > 0) validarr = validarr.slice(0, this.getAttribute("cnt")).map((e) => e.substring(0, 2));
                    this.value = validarr.join("-");
                }
            });

            clone.querySelectorAll("input")[1].value = (val != undefined) ? (val.prices).map(p=>number_format(p,2)).join("-") : "";
            clone.querySelectorAll("input")[1].setAttribute("cnt", data.reportpricecnt);
            clone.querySelectorAll("input")[1].setAttribute("datanum", (val != undefined) ? (val.prices).join("-") : "");
            clone.querySelectorAll("input")[1].setAttribute("placeholder", Array(data.reportpricecnt).fill("0,00").join("-"));
            if (data.reportpricecnt > 1) {
                clone.querySelectorAll("input")[1].addEventListener("keyup", function () {
                    if (this.value != "") {
                        let valid = (this.value).match(new RegExp(/((^\d+([\.,]{0,1}\d{0,2}))|(-\d*([.,]{0,1})?(\d{0,2})?))/g));
                        let validarr = (valid != null) ? valid.join("").split("-") : "";
                        if (validarr.length > 0) validarr = validarr.slice(0, this.getAttribute("cnt")).map((e) => e.substring(0, 12));
                        this.value = validarr.join("-");
                    }
                });
            } else {
                formatAmount(clone.querySelectorAll("input")[1]);
            }
            
            tbl.appendChild(clone);

        }
    } else {
        var clone = ele.cloneNode(true);
        clone.style.display = "none";
        clone.querySelector(".popDblInptFrm").removeAttribute("betid");
        tbl.innerHTML = "";
        tbl.appendChild(clone);
    }
    
}
//Se requiere invocar el listado de "tipos de pista" para el select del filtro y el insertar nuevo
async function listCoursestypeAPI(selected = "") {
    var par = {};
    par.filter = "";
    par.order = 1;
    par.offset = 0;
    par.numofrec = 9999;
    par.sessionid = localStorage.getItem("sessionid");
    //Funcion si todo en la llamada al servicio y se obtiene respuesta
    let onsuccess = async (rsp) => {
        switch (rsp.status) {
            case 200:
                data = JSON.parse(rsp.response);
                //Asignamos el atributo disabled a los que traigan el status cómo inactivo para que el "drawSelect" deshabilite las opciones que corresponden
                let disInactives = (structuredClone != undefined) ? structuredClone(data.records) : JSON.parse(JSON.stringify((data.records)));
                disInactives.map((r) => { if (r.status.id == 0) r.disabled = true });
                
                drawSelect(disInactives, document.getElementById("arrvRacetypeid"), 'id', 'dsc', 'Tipo de Pista', selected);
                break;
            case 401:
                //NO autorizado
                localStorage.clear();
                gotoPage('login', '', {});
                break;
            case 403:
                document.getElementById("addTimeDist").setAttribute("privileges", -1);
                //errInpt("addTimeDist", "No tiene privilegios para visualizar las distancias", 0);
                break;
            default:
                data = JSON.parse(rsp.response);
                console.log(data);
                break;
        }
    }
    //Lamamos al servicio si todo sale ok se ejecuta el onsuccess si falla sale por el catch
    return callWS("POST", "races/coursetypes/list", par).then(onsuccess).catch((e) => { console.log("Ocurrió un error " + e) });
}

//Función para pintar la respuesta de la lista en la tabla - requiere modelo base en html
function listDrawArrvRacers(rsp,readonly = false) {
    let tbl = document.getElementById("popupArrvFrm").querySelector(".popupFrmCnt.tblSct").querySelector(".tbody");
    let list = rsp?.records;
    let ele = tbl.children[0].cloneNode(true);
    if (list.length > 0) {
        tbl.innerHTML = "";
        for (var i = 0; i < list.length; i++) {
            var clone = ele.cloneNode(true);
            clone.style.display = "";
            clone.removeAttribute("itemid");
            clone.removeAttribute("active");
            clone.querySelectorAll(".popInpt").forEach(e => {
                e.setAttribute("disabled", "");
                e.value = "";
            });

            var data = list[i];
        
            clone.setAttribute("itemid", data.id);

            let focuseventeles = Array.from(clone.children);
            focuseventeles.forEach((e,i) => {
                if (i != 0 && i != 4 && i != 13) {
                    e.querySelector("input[type='text']")?.addEventListener("focusin", function () {
                        this.selectionStart = 0;
                        this.selectionEnd = this.value.length;
                    });
                }
            })

            var celda = clone.children[0];            
            let delayR = null;
            celda.children[0].addEventListener("focusin", function (e) { 
                if (this.value == "--") {
                    this.value = "";
                    this.dispatchEvent(new Event("keyup"));
                } else {                    
                    this.selectionStart = 0;
                    this.selectionEnd = this.value.length;
                }
            });
            celda.children[0].addEventListener("focusout", function (e) { 
                if (this.getAttribute("retirementsid") == "" || this.getAttribute("retirementsid") == null || this.value == "") {
                    this.value = "--";                    
                    this.removeAttribute("retirementsid");
                }else if (this.getAttribute("retirementsid") != "" && this.getAttribute("retirementsid") != null) {
                    this.value = retirments.find(s => s.id == this.getAttribute("retirementsid")).abbr;
                }
            });
            celda.children[0].addEventListener("keyup", function (e) {
                if (this.value != "") this.value = fieldFormat(this.value, 'name');
                clearTimeout(delayR);
                if (this.value.length >= 0) {
                    delayR = setTimeout(() => {                        
                        listRetirementsAPI(this.nextElementSibling, this.value);
                    }, 500);
                }
            });
            if (data != undefined && data.retirements.id > 0) {
                celda.firstElementChild.value = data.retirements.abbr + " ("+data.retirements.id+")";
                celda.firstElementChild.setAttribute("retirementsid", data.retirements.id);
            } else {
                celda.firstElementChild.value = "--";
                celda.firstElementChild.removeAttribute("retirementsid");
            }
            //if (retirments.length > 0) drawSelect(retirments, celda.firstElementChild, 'id', 'dsc', '--', ((data.retirements.id != 0) ? data.retirements.id : ""));


            var celda = clone.children[1];
            celda.innerText = data.number;

            var celda = clone.children[2];
            celda.firstElementChild.value = data.horse.name + " (" + data.horse.id + ")";
            celda.firstElementChild.setAttribute("horseid", data.horse.id);
            celda.firstElementChild.setAttribute("disabled", "");


            var celda = clone.children[3];
            celda.firstElementChild.value = (data.weight.number != 0) ? data.weight.number : "";
            celda.firstElementChild.addEventListener("keyup", function () {
                this.value = fieldFormat(limitSize(this.value,3), 'intnumber');
            });

            var celda = clone.children[4];
            let delaySt = null;
            celda.children[0].addEventListener("focusin", function (e) { 
                if (this.value == "--") {
                    this.value = "";
                    this.dispatchEvent(new Event("keyup"));
                } else {                    
                    this.selectionStart = 0;
                    this.selectionEnd = this.value.length;
                }
            });
            celda.children[0].addEventListener("focusout", function (e) { 
                if (this.getAttribute("stumbleid") == "" || this.getAttribute("stumbleid") == null || this.value == "") {
                    this.value = "--";                    
                    this.removeAttribute("stumbleid");
                } else if (this.getAttribute("stumbleid") != "" && this.getAttribute("stumbleid") != null) {
                    this.value = stumbles.find(s => s.id == this.getAttribute("stumbleid")).abbr;
                }
            });
            celda.children[0].addEventListener("keyup", function (e) {
                if (this.value != "") this.value = fieldFormat(this.value, 'name');
                clearTimeout(delaySt);
                if (this.value.length >= 0) {
                    delaySt = setTimeout(() => {                        
                        listStumblesAPI(this.nextElementSibling, this.value);
                    }, 500);
                }
            });
            if (data != undefined && data.stumble.id > 0) {
                celda.firstElementChild.value = data.stumble.abbr+ " ("+data.stumble.id+")";;
                celda.firstElementChild.setAttribute("stumbleid", data.stumble.id);
            } else {
                celda.firstElementChild.value = "--";
                celda.firstElementChild.removeAttribute("stumbleid");
            }
            //if (stumbles.length > 0) drawSelect(stumbles, celda.firstElementChild, 'id', 'dsc', '--', ((data.stumble.id != 0) ? data.stumble.id : ""));
        
            var celda = clone.children[5];
            celda.firstElementChild.value = (data.finishtime.number != 0) ? data.finishtime.name : "";
            celda.firstElementChild.addEventListener("keyup", function (e) {
                if (this.value != "") this.value = fieldFormat(this.value, 'validtime');
            });

            var celda = clone.children[6];
            celda.firstElementChild.value = data.position;
            celda.firstElementChild.addEventListener("keyup", function (e) {
                if (this.value != "") this.value = fieldFormat(limitSize(this.value,2), 'intnumber');
            });
        
            var celda = clone.children[7];
            celda.firstElementChild.value = (data.pos400.number == 0) ? "0" : data.pos400.number;
            celda.firstElementChild.addEventListener("keyup", function (e) {
                if (this.value != "") this.value = fieldFormat(limitSize(this.value, 2), 'intnumber');
            });
        
            var celda = clone.children[8];
            celda.firstElementChild.value = (data.pos800.number == 0) ? "0" : data.pos800.number;
            celda.firstElementChild.addEventListener("keyup", function (e) {
                if (this.value != "") this.value = fieldFormat(limitSize(this.value,2), 'intnumber');
            });
        
            var celda = clone.children[9];
            celda.firstElementChild.value = (data.arrivalposition == 0) ? "" : data.arrivalposition;
            celda.firstElementChild.addEventListener("keyup", function (e) {
                if (this.value != "") this.value = fieldFormat(limitSize(this.value,2), 'intnumber');
            });

            var celda = clone.children[10];
            if (bodies.length > 0) drawSelect(bodies, celda.firstElementChild, 'id', 'abbr', '--', ((data.bodies.id != 0) ? data.bodies.id : ""));

            var celda = clone.children[11];
            let delayJ = null;
            celda.children[0].addEventListener("keyup", function (e) {
                if (this.value != "") this.value = fieldFormat(this.value, 'name');
                clearTimeout(delayJ);
                if (this.value.length >= 1) {
                    delayJ = setTimeout(() => {
                        listJockeysAPI(this.nextElementSibling, this.value);
                    }, 500);
                }
            });
            if (data != undefined) {
                celda.firstElementChild.value = data.jockey.abbr + " ("+data.jockey.id+")";
                celda.firstElementChild.setAttribute("jockeyid",data.jockey.id);
            } else {
                celda.firstElementChild.value = "";
                celda.firstElementChild.removeAttribute("jockeyid");
            }

            var celda = clone.children[12];
            celda.firstElementChild.value = (data.jockey.weight == 0) ? "" : (data.jockey.weight).replace(/\./g, ",");
            celda.firstElementChild.addEventListener("keyup", function () {
                let regex = new RegExp('^(((\\d{1,2})(?:[.,]\\d{0,2})?)((?:[+|-])\\d{0,2})?(?:[.,]\\d{0,2})?).*', 'g')
                this.value = fieldFormat(this.value, "uniquereplace", (this.value.replace(/[^0-9.,\+\-]/g,"")).replace(regex, "$1"));
            });

            var celda = clone.children[13];
            celda.firstElementChild.setAttribute("datanum", (data.dividends.number == 0) ? "" : data.dividends.number)
            celda.firstElementChild.value = (data.dividends.number == 0) ? "" : data.dividends.name;
            formatAmount(celda.firstElementChild,2,10);
        
            //Editar Btn
            var celda = clone.children[14];
            let btnsA = celda.children[0];//Editar, eliminar
            let btnsB = celda.children[1];//Arpobar, cancelar
            let btnsC = celda.children[2];//Solo agregar
            btnsA.style.display = "";
            btnsB.style.display = "none";
            btnsC.style.display = "none";
            if (readonly) {
                btnsA.style.display = "none";
                btnsB.style.display = "none";
                btnsC.style.display = "none";
            }
            let addactivate = function (e) {
                let tbl = document.getElementById("popupArrvFrm").querySelector(".popupFrmCnt.tblSct").querySelector(".tbody");
                e.stopPropagation();
                //Si existe uno activo lo restauramos
                let someactive = tbl.querySelector(".tr[active]");
                if (someactive != undefined) resetracerArvvRow(someactive);

                let row = this.parentElement.parentElement.parentElement;
                //Activamos la linea
                row.setAttribute("active", "");
                //Activamos la botonera que corresponde
                row.querySelectorAll(".tblBtns")[2].style.display = "none";
                row.querySelectorAll(".tblBtns")[0].style.display = "none";
                row.querySelectorAll(".tblBtns")[1].style.display = "";
                //Permitimos la edición de los campos
                row.querySelectorAll(".editable.popInpt").forEach(e => {
                    e.removeAttribute("disabled");
                });
            };

            //Eventos botones editar y eliminar
            //btnsA.setAttribute("itemlbl", data.horse.name + " (" + data.horse.id + ") - Nro:" + data.number);
            btnsA.setAttribute("itemid", data.id);
            if (!readonly) btnsA.children[0].addEventListener("click", addactivate);
            //Eventos botones guardar o cancelar 
            btnsB.children[0].setAttribute("racerid", (data.id));
            if (!readonly) {
                btnsB.children[0].addEventListener("click", function () {
                    let linecnt = this.parentElement.parentElement.parentElement;
                    let btnsAct = linecnt.lastElementChild.querySelectorAll(".tblBtns")[1];
                    let haserror = false;
                    let retirado = (linecnt.querySelector("[name=retirementId]").getAttribute("retirementsid") == null)
                    if (!btnsAct.classList.contains("warning") && retirado) {
                        let posiciones = Array.from(linecnt.parentElement.querySelectorAll(".tr:not([active]) input[name=finishPos]"));
                        posiciones.forEach(h => {
                            if (getNum(h.value) == linecnt.querySelector("[name='finishPos']").value) {
                                errInpt(document.getElementById("popupArrvFrm").querySelector(".errmsgSct"), "Ya existe un ejemplar con este nro de llegada, pulse confirmar nuevamente para guardar", 6000);
                                btnsAct.classList.add("warning");
                                setTimeout(function () {
                                    btnsAct.classList.remove("warning");
                                }, 6000, btnsAct);
                                haserror = true;

                            }
                        });
                    }

                    if(!haserror)updateArrvRacerAPI(this.parentElement.parentElement.parentElement, this.getAttribute("racerid"));
                });
                btnsB.children[1].addEventListener("click", function () {
                    resetracerArvvRow(this.parentElement.parentElement.parentElement);
                });
            }
            tbl.appendChild(clone);

        }
    } else {
        var clone = ele.cloneNode(true);
        clone.style.display = "none";
        tbl.innerHTML = "";
        tbl.appendChild(clone);
    }
}
//Funcion para actualizar un corredor
function updateArrvRacerAPI(row, id) {  
    let validationpars = [
        {
            "key": "stumbleid",
            "id": row.querySelector("[name='stumbleId']"),
            "msg": ""
        },        
        {
            "key": "retirementid",
            "id": row.querySelector("[name='retirementId']"),
            "msg": ""
        },        
        {
            "key": "jockeyweight",
            "id": row.querySelector("[name='jockeyWeight']"),
            "msg": ""
        }, 
        {
            "key": "jockeyid",
            "id": row.querySelector("[name='jockey']"),
            "msg": ""
        }, 
        
        {
            "key": "weight",
            "id": row.querySelector("[name='weight']"),
            "msg": ""
        }, 
        {
            "key": "finishtime",
            "id": row.querySelector("[name='time']"),
            "msg": ""
        },               
        {
            "key": "pos400",
            "id": row.querySelector("[name='p400']"),
            "msg": ""
        },
        {
            "key": "pos800",
            "id": row.querySelector("[name='p800']"),
            "msg": ""
        },
        {
            "key": "dividends",
            "id": row.querySelector("[name='divPrice']"),
            "msg": ""
        },
        {
            "key": "bodiesid",
            "id": row.querySelector("[name='bodiesId']"),
            "msg": ""
        },
        {
            "key": "arrivalposition",
            "id":row.querySelector("[name='finishPos']"),
            "msg": ""
        }
    ]

    var par = {};
    par.id = id;
    let stumblesel = row.querySelector("[name='stumbleId']");
    par.stumbleid = (stumblesel.getAttribute("stumbleid") != "" && stumblesel.getAttribute("stumbleid") != null) ? stumblesel.getAttribute("stumbleid") : 0;
    let retirementsel = row.querySelector("[name='retirementId']");
    par.retirementid = (retirementsel.getAttribute("retirementsid") != "" && retirementsel.getAttribute("retirementsid") != null) ? retirementsel.getAttribute("retirementsid") : 0;
    par.weight = getNum(row.querySelector("[name='weight']").value);
    par.jockeyweight = (row.querySelector("[name='jockeyWeight']").value).replace(/\,/g,".");
    par.jockeyid = (row.querySelector("[name='jockey']").getAttribute("jockeyid"));
    par.finishtime = getNum(row.querySelector("[name='time']").value);    
    par.pos400 = getNum(row.querySelector("[name='p400']").value);    
    par.pos800 = getNum(row.querySelector("[name='p800']").value);    
    par.dividends = getNum(row.querySelector("[name='divPrice']").getAttribute("datanum"));
    let bodiessel = row.querySelector("[name='bodiesId']");
    par.bodiesid = bodiessel.value;
    par.arrivalposition = getNum(row.querySelector("[name='finishPos']").value);
    par.sessionid = localStorage.getItem("sessionid");

    console.log(par);
    //Hacemos las validaciones
    var haserror = false;
    //Cómo son muchos campos simplificamos con un arreglo que contiene los campos a verificar
    if (par.retirementid != 0) {        
        validationpars.forEach((e) => {
            if(e.key != 'retirementid' && e.key != 'jockeyweight' && e.key != 'jockeyid') par[e.key] = "0";
        });             
    } else {
        validationpars.forEach((e) => {
            //Que el nombre no esté vacío
            if (!(par[e.key] !== undefined && par[e.key] !== null && par[e.key] !== "")) {
                errRowInpt(e.id, 6000);
                haserror = true;
            }
        });
        //Si tiene errores detenemos la llamada al servicio
        if (haserror) {
            errInpt(document.getElementById("popupArrvFrm").querySelector(".errmsgSct"), "Faltan campos obligatorios para agregar el ejemplar", 6000);
            return;
        }   
    }    
    //Funcion si todo en la llamada al servicio y se obtiene respuesta
    let onsuccess = (rsp) => {
        switch (rsp.status) {
            case 200:
                data = JSON.parse(rsp.response);
                //Si obtenemos un id insertado/modificado refrescamos la tabla
                if (data.id != null && data.id != undefined) {
                    //Llevaos el ordenamiento por "id" y cargamos el listado
                    let raceid = document.getElementById("popupArrvFrm").querySelector(".saveBtn").getAttribute("upid");
                    listRacersAPI(raceid, 8).then(async racers => {
                        listDrawArrvRacers(racers);
                    });
                    //Como definimos función flecha podemos leer los parametros para determinar si era nuevo y mostrar mensaje exitoso correcto
                    successMsgShow((par.id == 0) ? "Ejemplar agregado con éxito" : "Ejemplar modificado con éxito");

                }
                //Cerramos el popup
                //closePopups();
                break;
            case 400:
                data = JSON.parse(rsp.response);
                errInpt(document.getElementById("popupArrvFrm").querySelector(".errmsgSct"), data.msg, 6000);
                break;
            case 401:
                //NO autorizado
                localStorage.clear();
                gotoPage('login', '', {});
                
            default:
                data = JSON.parse(rsp.response);
                console.log(data);
                break;
        }
    }
    //Lamamos al servicio si todo sale ok se ejecuta el onsuccess si falla sale por el catch
    callWS("POST", "records/racers/updateend", par).then(onsuccess).catch((e) => { console.log("Ocurrió un error " + e) });
}
//Resetear los valores de una linea si se editaba o se agregaba
function resetracerArvvRow(row) {
    let data = notupdatedRacers.records.find(r => (r.id == row.getAttribute("itemid")));
    row.removeAttribute("active");
    row.querySelectorAll(".editable.popInpt").forEach(e => {
        e.value = "";
        e.setAttribute("disabled", "");
    });
    row.querySelector("[name='stumbleId']").value = (data.stumble.id != 0) ? data.stumble.abbr : "--";
    row.querySelector("[name='stumbleId']").setAttribute("stumbleid", (data.stumble.id != 0) ? data.stumble.id : null);
    row.querySelector("[name='retirementId']").value = (data.retirements.id != 0) ? data.retirements.abbr : "--";
    row.querySelector("[name='retirementId']").setAttribute("retirementsid", (data.retirements.id != 0) ? data.retirements.id : null);
    row.querySelector("[name='weight']").value = (data.weight.number != 0) ? data.weight.number : "";
    row.querySelector("[name='jockeyWeight']").value = (data.jockey.weight != 0) ? (data.jockey.weight).replace(/\./g,",") : "";
    row.querySelector("[name='time']").value = (data.finishtime.number != 0) ? data.finishtime.name : "";    
    row.querySelector("[name='p400']").value = (data.pos400.number != 0) ? (data.pos400.number) : "0";    
    row.querySelector("[name='p800']").value = (data.pos800.number != 0) ? (data.pos800.number) : "0";
    row.querySelector("[name='divPrice']").value = data.dividends.name;
    row.querySelector("[name='divPrice']").setAttribute("datanum",!isNaN(data.dividends.number) ? (data.dividends.number) : "");
    //row.querySelector("[name='divPrice']").value = (data.dividends.number != 0) ? data.dividends.number : "";
    row.querySelector("[name='bodiesId']").value = (data.bodies.id != 0) ? data.bodies.id : "";
    row.querySelector("[name='finishPos']").value = (data.arrivalposition != 0) ? data.arrivalposition : "";

    if (row.getAttribute("itemid") != null && row.getAttribute("itemid") != undefined && row.getAttribute("itemid") != "") {        
        row.querySelectorAll(".tblBtns")[2].style.display = "none";
        row.querySelectorAll(".tblBtns")[0].style.display = "";
        row.querySelectorAll(".tblBtns")[1].style.display = "none";
    } 
    console.log(data);
}

//Función para procesar una careara después de que los datos están completos "process"
function closeRacesAPI(raceid,save=false) {
    return new Promise(async (resolve, reject) => { 
        /*
        let validationpars = [
            {
                "key": "finishtime",
                "id": "arrvFinishTime",
                "msg": ""
            },
            {
                "key": "racecoursetypeid",
                "id": "arrvRacetypeid",
                "msg": ""
            }, 
        ]

        //Hacemos las validaciones
        var haserror = false;

        var par = {};
        par.finishtime = getNum(document.getElementById("arrvFinishTime").value);
        let tiempos = Array.from(document.getElementById("popupArrvFrm").querySelectorAll(".finishtime:not([disabled])"));
        par.times400 = (tiempos.filter(t=>t.value != "").map(t=>getNum(t.value))).join("-");
        par.racecoursetypeid = document.getElementById("arrvRacetypeid").value;    
        let bets = [];
        if (document.getElementById("arrvWinDiv").getAttribute("disabled") == null && !document.getElementById("arrvWinDiv").classList.contains("inactive")) {
            if (document.getElementById("arrvWinDiv").value != "") {            
                bets.push({
                    'betprices': getNum(document.getElementById("arrvWinDiv").getAttribute("datanum")),
                    'bethorses': "",
                    'betid': 1
                });
            } else {
                errInpt("arrvWinDiv", "", 6000);
                haserror = true;
            }
        }
        if ((document.getElementById("arrvPlace1Div").getAttribute("disabled") == null && !document.getElementById("arrvPlace1Div").classList.contains("inactive")) &&
            (document.getElementById("arrvPlace2Div").getAttribute("disabled") == null && !document.getElementById("arrvPlace2Div").classList.contains("inactive"))) {        
            if (document.getElementById("arrvPlace1Div").value != "" && document.getElementById("arrvPlace2Div").value != "") {
                bets.push({
                    'betprices': getNum(document.getElementById("arrvPlace1Div").getAttribute("datanum")) + "|" + getNum(document.getElementById("arrvPlace2Div").getAttribute("datanum")),
                    'bethorses': "",
                    'betid': 2
                });
            } else {
                if (document.getElementById("arrvPlace1Div").value == "") errInpt("arrvPlace1Div", "", 6000);
                if (document.getElementById("arrvPlace2Div").value == "") errInpt("arrvPlace2Div", "", 6000);
                haserror = true;
            }
        }
        let extbets = document.getElementById("popupArrvFrm").querySelectorAll(".popDblInptFrm[betid]");
        if (extbets.length > 0) {
            extbets.forEach((b) => {
                if (b.parentElement.getAttribute("disabled") == null) {
                    let horseval = b.querySelectorAll(".popInpt")[0].value;
                    if (horseval != "") {
                        if (horseval.split("-").length < b.querySelectorAll(".popInpt")[0].getAttribute("cnt")) {
                            errInpt(b.querySelectorAll(".popInpt")[0].parentElement, "", 6000);
                            haserror = true;
                        }
                    } else {
                        errInpt(b.querySelectorAll(".popInpt")[0].parentElement, "", 6000);
                        haserror = true;
                    }
                    let priceval = b.querySelectorAll(".popInpt")[1].value;
                    if (priceval != "") {
                        if (priceval.split("-").length < b.querySelectorAll(".popInpt")[1].getAttribute("cnt")) {
                            errInpt(b.querySelectorAll(".popInpt")[1].parentElement, "", 6000);
                            haserror = true;
                        }
                    } else {
                        errInpt(b.querySelectorAll(".popInpt")[1].parentElement, "", 6000);
                        haserror = true;
                    }

                    if (!haserror) {
                        bets.push({
                            'betprices': (b.querySelectorAll(".popInpt")[1].getAttribute("cnt") <= 1) ? getNum(b.querySelectorAll(".popInpt")[1].getAttribute("datanum")) : priceval.split("-").map(h=>getNum(h)).join("|"),
                            'bethorses': horseval.replace(/-/g, "|"),
                            'betid': b.getAttribute("betid")
                        });
                    }
                }
            });
        }
        //Reordenamos en función de la carga del entry
        bets.sort((a, b) => { a.id - b.id });
        
        par.bethorses = bets.map(b => b.bethorses);
        par.betprices = bets.map(b => b.betprices);

        par.betprices = par.betprices.join("-");
        par.bethorses = par.bethorses.join("-");
        if (par.bethorses == "") par.bethorses = "|";
        if (par.betprices == "") par.betprices = "|";
        
        par.sessionid = localStorage.getItem("sessionid");
        //Cómo son muchos campos simplificamos con un arreglo que contiene los campos a verificar
        validationpars.forEach((e) => {
            //Que el nombre no esté vacío
            if (!(par[e.key] !== undefined && par[e.key] !== null && par[e.key] !== "")) {
                errInpt(e.id, e.msg, 6000);
                haserror = true;
            }
        });
        if (par['times400'].split("-").length < tiempos.length) {
            tiempos.filter(t=>t.value == "").forEach(f => {
                errInpt(f.parentElement, "", 6000);
            });
            haserror = true
        };
        //Si tiene errores detenemos la llamada al servicio
        if (haserror) {
            errInpt(document.getElementById("popupArrvFrm").querySelector(".errmsgSct"), "Faltan campos obligatorios", 6000);
            return;
        }

        //Validamos que no haya racers en modo de edición
        let ejempActivos = document.getElementById("popupArrvFrm").querySelector(".table .tbody").querySelectorAll(".tr[active]");
        if (ejempActivos.length > 0) {      
            Array.from(ejempActivos).forEach(eAct => {
                let iconos = Array.from(eAct.querySelectorAll(".tblbtnIc"));
                iconos.forEach(e => {
                    e.style.color = "var(--errColor)";
                });
                setTimeout(function (iconos) {
                    iconos.forEach(e => {
                        e.style.color = "";
                    });
                }, 6000, iconos);
            });
            
            haserror = true;
        }
        //Si tiene errores detenemos la llamada al servicio
        if (haserror) {
            errInpt(document.getElementById("popupArrvFrm").querySelector(".errmsgSct"), "Existen ejemplares en modo de edición", 6000);
            return;
        } 
        */        
        let haserror = false;
        if (save) {
            await updateArriveAPI(raceid).catch(() => {
                haserror = true;
            });
        }

        if (haserror) return;
        
        var par = {};
        par.id = raceid;
        par.sessionid = localStorage.getItem("sessionid");
        //Funcion si todo en la llamada al servicio y se obtiene respuesta
        let onsuccess = async (rsp) => {
            switch (rsp.status) {
                case 200:
                    data = JSON.parse(rsp.response);
                    resolve(data);
                    break;
                case 401:
                    //NO autorizado
                    localStorage.clear();
                    gotoPage('login', '', {});
                    reject();
                    break;
                case 403:
                    //Si no tiene privilegios se muestra el mensaje de error
                    errInpt(document.getElementById("popupArrvFrm").querySelector(".errmsgSct"), "No tiene privilegios para realizar esta acción", 6000);
                    reject();
                    break;
                case 417:
                    data = JSON.parse(rsp.response);
                    errInpt(document.getElementById("popupArrvFrm").querySelector(".errmsgSct"), (data.msg != undefined) ? data.msg : "Ocurrió un error, por favor intente nuvamente", 6000);
                    reject();
                    break;
                default:
                    data = JSON.parse(rsp.response);
                    errInpt(document.getElementById("popupArrvFrm").querySelector(".errmsgSct"), (data.msg != undefined) ? data.msg : "Ocurrió un error, por favor intente nuvamente", 6000);
                    reject();
                    break;
            }
        }
        //Lamamos al servicio si todo sale ok se ejecuta el onsuccess si falla sale por el catch
        callWS("GET", "records/races/close", par).then(onsuccess).catch((e) => { console.log("Ocurrió un error " + e) });
    });
}
function closeWhlRacesAPI(raceid) {
    return new Promise((resolve, reject) => { 
        let par = {};
        par.id = raceid;
        par.sessionid = localStorage.getItem("sessionid");
        console.log(par);
        //Funcion si todo en la llamada al servicio y se obtiene respuesta
        let onsuccess = async (rsp) => {
            switch (rsp.status) {
                case 200:
                    data = JSON.parse(rsp.response);
                    resolve(data);
                    break;
                default:
                    reject(rsp);
                    break;
            }
        }
        //Lamamos al servicio si todo sale ok se ejecuta el onsuccess si falla sale por el catch
        callWS("GET", "records/races/close", par).then(onsuccess).catch((e) => { console.log("Ocurrió un error " + e) });
    });
}

//Listados adicionales para los "CORREDORES EN LLEGADAS"
let retirments = [];
async function listRetirementsAPI(box,srch = "") {
    var par = {};
    par.filter = srch
    par.order = 3;
    par.offset = 0;
    par.numofrec = 9999;
    par.sessionid = localStorage.getItem("sessionid");
    //Funcion si todo en la llamada al servicio y se obtiene respuesta
    let onsuccess = async (rsp) => {
        switch (rsp.status) {
            case 200:
                data = JSON.parse(rsp.response);
                var onclick = null;
                //Función onclick para las opciones del listado de busqueda de caballos linage
                onclick = async (opt) => {
                    if (opt.parentElement != null) {
                        opt.parentElement.previousElementSibling.value = opt.getAttribute("dsc") + " ("+opt.getAttribute("value")+")";
                        opt.parentElement.previousElementSibling.setAttribute("retirementsid", opt.getAttribute("value"));
                        opt.parentElement.innerHTML = "";
                    }
                }
                //Clonamos el arreglo y modificamos el disabled si el status es inactivo. Utilizamos la función structuredClone si es valida en el navegador
                let disInactives = (structuredClone != undefined) ? structuredClone(data.records) : JSON.parse(JSON.stringify((data.records)));
                disInactives.map((r) => { if (r.status.id == 0) r.disabled = true });
                if (box != undefined) drawSrchSelect(disInactives, box, 'id', 'dsc+ (+id+)', undefined, '', onclick, [{ 'dsc': 'abbr' }], true);
                else retirments = disInactives;
                /*
                data = JSON.parse(rsp.response);
                //Clonamos el arreglo y modificamos el disabled si el status es inactivo. Utilizamos la función structuredClone si es valida en el navegador
                let disInactives = (structuredClone != undefined) ? structuredClone(data.records) : JSON.parse(JSON.stringify((data.records)));
                disInactives.map((r) => { if (r.status.id == 0) r.disabled = true });
                //Seteamos el valor de data local para cargarlo en la lista de horses en carreras
                retirments = disInactives;*/
                break;
            case 401:
                //NO autorizado
                localStorage.clear();
                gotoPage('login', '', {});
                break;
            case 403:
                break;
            default:
                data = JSON.parse(rsp.response);
                console.log(data);
                break;
        }
    }
    //Lamamos al servicio si todo sale ok se ejecuta el onsuccess si falla sale por el catch
    return callWS("POST", "races/retirements/list", par).then(onsuccess).catch((e) => { console.log("Ocurrió un error " + e) });
}
let stumbles = [];
async function listStumblesAPI(box,srch = "") {
    var par = {};
    par.filter = srch;
    par.order = 3;
    par.offset = 0;
    par.numofrec = 9999;
    par.sessionid = localStorage.getItem("sessionid");
    //Funcion si todo en la llamada al servicio y se obtiene respuesta
    let onsuccess = async (rsp) => {
        switch (rsp.status) {
            case 200:
                data = JSON.parse(rsp.response);
                var onclick = null;
                //Función onclick para las opciones del listado de busqueda de caballos linage
                onclick = async (opt) => {
                    if (opt.parentElement != null) {
                        opt.parentElement.previousElementSibling.value = opt.getAttribute("dsc")+" ("+opt.getAttribute("value")+")";
                        opt.parentElement.previousElementSibling.setAttribute("stumbleid", opt.getAttribute("value"));
                        opt.parentElement.innerHTML = "";
                    }
                }
                //Clonamos el arreglo y modificamos el disabled si el status es inactivo. Utilizamos la función structuredClone si es valida en el navegador
                let disInactives = (structuredClone != undefined) ? structuredClone(data.records) : JSON.parse(JSON.stringify((data.records)));
                disInactives.map((r) => { if (r.status.id == 0) r.disabled = true });
                if (box != undefined) drawSrchSelect(disInactives, box, 'id', 'dsc+ (+id+)', undefined, '', onclick, [{ 'dsc': 'abbr' }], true);
                else stumbles = disInactives;
                /*
                data = JSON.parse(rsp.response);
                //Clonamos el arreglo y modificamos el disabled si el status es inactivo. Utilizamos la función structuredClone si es valida en el navegador
                let disInactives = (structuredClone != undefined) ? structuredClone(data.records) : JSON.parse(JSON.stringify((data.records)));
                disInactives.map((r) => { if (r.status.id == 0) r.disabled = true });
                //Seteamos el valor de data local para cargarlo en la lista de horses en carreras
                stumbles = disInactives;*/
                break;
            case 401:
                //NO autorizado
                localStorage.clear();
                gotoPage('login', '', {});
                break;
            case 403:
                break;
            default:
                data = JSON.parse(rsp.response);
                console.log(data);
                break;
        }
    }
    //Lamamos al servicio si todo sale ok se ejecuta el onsuccess si falla sale por el catch
    return callWS("POST", "races/stumbles/list", par).then(onsuccess).catch((e) => { console.log("Ocurrió un error " + e) });
}
let bodies = [];
async function listBodiesAPI() {
    var par = {};
    par.filter = "";
    par.order = 5;
    par.offset = 0;
    par.numofrec = 9999;
    par.sessionid = localStorage.getItem("sessionid");
    //Funcion si todo en la llamada al servicio y se obtiene respuesta
    let onsuccess = async (rsp) => {
        switch (rsp.status) {
            case 200:
                data = JSON.parse(rsp.response);
                //Clonamos el arreglo y modificamos el disabled si el status es inactivo. Utilizamos la función structuredClone si es valida en el navegador
                let disInactives = (structuredClone != undefined) ? structuredClone(data.records) : JSON.parse(JSON.stringify((data.records)));
                disInactives.map((r) => { if (r.status.id == 0) r.disabled = true });
                //Seteamos el valor de data local para cargarlo en la lista de horses en carreras
                bodies = disInactives;
                break;
            case 401:
                //NO autorizado
                localStorage.clear();
                gotoPage('login', '', {});
                break;
            case 403:
                break;
            default:
                data = JSON.parse(rsp.response);
                console.log(data);
                break;
        }
    }
    //Lamamos al servicio si todo sale ok se ejecuta el onsuccess si falla sale por el catch
    return callWS("POST", "races/bodies/list", par).then(onsuccess).catch((e) => { console.log("Ocurrió un error " + e) });
}



//Llamada inicial
document.addEventListener("DOMContentLoaded", function () {
    meetingsInit();
    //Evento para ocultar los select de busqueda
    document.body.addEventListener("click", function (e) {
        setTimeout(function () {
            document.querySelectorAll(".optList").forEach(obj => {
                if (e.target != obj && e.target != obj.previousElementSibling) obj.innerHTML = "";
            })
        }, 300);
    });
    document.body.addEventListener("keyup", function (e) {
        setTimeout(function () {
            document.querySelectorAll(".optList").forEach(obj => {
                if (e.target != obj && e.target != obj.previousElementSibling) obj.innerHTML = "";
            })
        }, 300);
    });
});