<?php
    header("Content-Type:application/json");
    header("Access-Control-Allow-Origin: http://localhost:5500");
    include("../../../settings/dbconn.php");
    include("../../../settings/utils.php");
    
    // forzar a que se haga un POST y no un GET
    if ($_SERVER['REQUEST_METHOD']!= "POST")
        badEnd("400", array("msg"=>"Debe llamarse al servicio usando un POST"));
    
    // parametros obligatorios
    $parmsob = array("userid","privileges","sessionid");
    if (!parametrosValidos($_REQUEST, $parmsob))
        badEnd("400", array("msg"=>"Parametros obligatorios " . implode(", ", $parmsob)));
    
    $sessionid = preg_replace("/[^a-zA-Z0-9]+/", "", $_REQUEST["sessionid"]);
    $userid = intval($_REQUEST["userid"]);
    $privileges = preg_replace("/[^0-9-]+/", "", $_REQUEST["privileges"]);
    
    isSessionValid($db, $sessionid);
    
    if (!tienePrivilegio($db, $sessionid, 101))
        badEnd("403", array("msg"=>"No tiene privilegios para ejecutar esta acción"));
    
    // Se eliminan los privilegios anteriores del usuario
    $sql = "DELETE FROM userprivileges WHERE userid=" . $userid;
    if (!$db->query($sql))
        badEnd("500", array(msg=>$db->error));
    // Se eliminan los privilegios anteriores de los usuarios que tienen el rol asignado
    $sql = "DELETE FROM userprivileges WHERE userid IN " . 
                   "(SELECT id FROM users WHERE userid=" . $userid . ")";
    if (!$db->query($sql))
        badEnd("500", array("msg"=>$db->error));
    
    // Se asignan los nuevos privilegios al usuario
    $privs = explode("-", $privileges);
    foreach ($privs as $priv){
        $sql =  "INSERT INTO userprivileges " . 
                "            (userid, privilegeid) " . 
                "VALUES      ('" . $userid . "'," . $priv . ")";
        if (!$db->query($sql))
            badEnd("500", array("msg"=>$db->error));
    }
    
    setAudit($db, "Privilegios", $sessionid, "Se asignaron los privilegios " . $privileges . " al usuario " . $userid);
    
    $out = new stdClass;
    $out->userid = $userid;
    
    header("HTTP/1.1 200");
    echo (json_encode($out));
    die();
?>