<?php
    header("Content-Type:application/json");
    header("Access-Control-Allow-Origin: http://localhost:5500");
    include("../../../settings/dbconn.php");
    include("../../../settings/utils.php");

    // forzar a que se haga un GET
    if ($_SERVER['REQUEST_METHOD']!= "POST")
        badEnd("400", array("msg"=>"Debe llamarse al servicio usando un POST"));

    // parametros obligatorios
    $parmsob = array("id","reunionid","call","number","ord","time","distanceid",
                    "valid","racetypeid","conditionid1","conditionid2","conditiondsc",
                    "serie","mainpricecurr","mainprice","extrapricecurr","extraprice",
                    "firstplace","secondplace","thirdplace","fourthplace","fifthplace",
                    "bets", "sessionid");
    if (!parametrosValidos($_REQUEST, $parmsob))
        badEnd("400", array("msg"=>"Parametros obligatorios " . implode(", ", $parmsob)));
    
    $sessionid = preg_replace("/[^a-zA-Z0-9]+/", "", $_REQUEST["sessionid"]);
    $id = intval($_REQUEST["id"]);
    $reunionid = intval($_REQUEST["reunionid"]);
    $call = intval($_REQUEST["call"]);
    $number = intval($_REQUEST["number"]);
    $ord = intval($_REQUEST["ord"]);
    $time = preg_replace("/[^0-9:]+/", "", $_REQUEST["time"]);
    $distanceid = intval($_REQUEST["distanceid"]);
    $valid = intval($_REQUEST["valid"]);
    $racetypeid = intval($_REQUEST["racetypeid"]);
    $conditionid1 = intval($_REQUEST["conditionid1"]);
    $conditionid2 = intval($_REQUEST["conditionid2"]);
    $conditiondsc = preg_replace("/[^a-zA-Z0-9 .,:\-()+*\/áéíóúñüÁÉÍÓÚÑÜ]+/", "", $_REQUEST["conditiondsc"]);
    $serie = preg_replace("/[^a-zA-Z0-9 .,:\-()+*\/áéíóúñüÁÉÍÓÚÑÜ]+/", "", $_REQUEST["serie"]);
    $mainpricecurr = preg_replace("/[^A-Z]+/", "", $_REQUEST["mainpricecurr"]);
    $mainprice = floatval($_REQUEST["mainprice"]);
    $extrapricecurr = preg_replace("/[^A-Z]+/", "", $_REQUEST["extrapricecurr"]);
    $extraprice = floatval($_REQUEST["extraprice"]);
    $firstplace = floatval($_REQUEST["firstplace"]);
    $secondplace = floatval($_REQUEST["secondplace"]);
    $thirdplace = floatval($_REQUEST["thirdplace"]);
    $fourthplace = floatval($_REQUEST["fourthplace"]);
    $fifthplace = floatval($_REQUEST["fifthplace"]);
    $bets = preg_replace("/[^0-9\-]+/", "", $_REQUEST["bets"]);

    isSessionValid($db, $sessionid);

    // armar apuestas
    $betslst = explode("-", $bets);
    $betfld = array();
    foreach($betslst as $bet){
        $sql =  "SELECT     B.id, B.dsc, B.reportpricecnt, B.reporthorsescnt, B.extensible " .
                "FROM       bets B " . 
                "WHERE      id = '" . $bet . "'";
        if (!$rs = $db->query($sql))
            badEnd("500", array("errlog"=>2, "msg"=>$db->error));
        if ($row = $rs->fetch_assoc()){
            $betfld[] = array(  
                                "id"=>(integer)$row["id"],
                                "name"=>$row["dsc"],
                                "reportpricecnt"=>(integer)$row["reportpricecnt"],
                                "reporthorsescnt"=>(integer)$row["reporthorsescnt"],
                                "exntensible"=>(boolean)$row["extensible"]<>0
            );
        }
    }

    if ($id==0){    // incluir registro
        if (!tienePrivilegio($db, $sessionid, 622, false))
            badEnd("403", array("msg"=>"No tiene privilegios para ejecutar esta acción"));
            
        $sql =  "INSERT INTO races " .
                "       (`reunionid`, `call`, `number`, `ord`, `time`, bets, " .
                "       `distanceid`, `valid`, `racetypeid`, `conditionid1`, `conditionid2`, " .
                "       `conditiondsc`, `serie`, `mainpricecurr`, `mainprice`, `extrapricecurr`, " .
                "       `extraprice`, `firstplace`, `secondplace`, `thirdplace`, `fourthplace`, `fifthplace`) " .
                "VALUES (" .
                "        '" . $reunionid . "'," .
                "        '" . $call . "'," .
                "        '" . $number . "'," .
                "        '" . $ord . "'," .
                "        '" . $time . "'," .
                "        '" . json_encode($betfld) . "'," .
                "        '" . $distanceid . "'," .
                "        '" . $valid . "'," .
                "        '" . $racetypeid . "'," .
                "        '" . $conditionid1 . "'," .
                "        '" . $conditionid2 . "'," .
                "        '" . $conditiondsc . "'," .
                "        '" . $serie . "', " .
                "        '" . $mainpricecurr . "', " .
                "        '" . $mainprice . "', " .
                "        '" . $extrapricecurr . "', " .
                "        '" . $extraprice . "', " .
                "        '" . $firstplace . "', " .
                "        '" . $secondplace . "', " .
                "        '" . $thirdplace . "', " .
                "        '" . $fourthplace . "', " .
                "        '" . $fifthplace . "' " .
                "        )";
        if (!$db->query($sql)){
            if ($db->errno == 1062){
                badEnd("409", array("msg"=>"Registro Duplicado"));
            }else{
                badEnd("500", array("msg"=>$db->error));
            }
        }

        $id = $db->insert_id;
        
        setAudit($db, "Carreras", $sessionid, "Se incluyó la carrera \'" . $number . "\' (" . $id . ")");
    }else{          // modificar registro
        if (!tienePrivilegio($db, $sessionid, 621, false))
            badEnd("403", array("msg"=>"No tiene privilegios para ejecutar esta acción"));
            
        $sql =  "UPDATE races " .
                "SET    reunionid = '" . $reunionid . "'," .
                "       `call` = '" . $call . "', " .
                "       number = '" . $number . "', " .
                "       ord = '" . $ord . "', " .
                "       time = '" . $time . "', " .
                "       bets = '" . json_encode($betfld) . "', " .
                "       distanceid = '" . $distanceid . "', " .
                "       valid = '" . $valid . "', " .
                "       racetypeid = '" . $racetypeid . "', " .
                "       conditionid1 = '" . $conditionid1 . "', " .
                "       conditionid2 = '" . $conditionid2 . "', " .
                "       conditiondsc = '" . $conditiondsc . "', " .
                "       serie = '" . $serie . "', " .
                "       mainpricecurr = '" . $mainpricecurr . "', " .
                "       mainprice = '" . $mainprice . "', " .
                "       extrapricecurr = '" . $extrapricecurr . "', " .
                "       extraprice = '" . $extraprice . "', " .
                "       firstplace = '" . $firstplace . "', " .
                "       secondplace = '" . $secondplace . "', " .
                "       thirdplace = '" . $thirdplace . "', " .
                "       fourthplace = '" . $fourthplace . "', " .
                "       fifthplace = '" . $fifthplace . "' " .
                "WHERE  id=" . $id;
        if (!$db->query($sql))
            if ($db->errno == 1062){
                badEnd("409", array("msg"=>"Registro Duplicado"));
            }else{
                badEnd("500", array("id"=>0,"sql"=>$sql,"msg"=>$db->error));
            }
            
        setAudit($db, "Carreras", $sessionid, "Se actualizó la carrera \'" . $number . "\' (" . $id . ")");

    }

    $out = new stdClass;
    $out->id = $id;
    
    header("HTTP/1.1 200");
    echo (json_encode($out));
    die();
?>