<?php
    header("Content-Type:application/json");
    header("Access-Control-Allow-Origin: http://localhost:5500");
    include("../../../settings/dbconn.php");
    include("../../../settings/utils.php");

    // forzar a que se haga con GET
    if ($_SERVER['REQUEST_METHOD']!= "GET")
        badEnd("400", array("msg"=>"Debe llamarse al servicio usando un GET"));

    // parametros obligatorios
    $parmsob = array("id","sessionid");
    if (!parametrosValidos($_REQUEST, $parmsob))
        badEnd("400", array("msg"=>"Parametros obligatorios " . implode(", ", $parmsob)));
    
    $id = (integer) $_REQUEST["id"];
    $sessionid = preg_replace("/[^a-zA-Z0-9]+/", "", $_REQUEST["sessionid"]);

    isSessionValid($db, $sessionid);

    // verificar el estatus actual
    $sql =  "SELECT     status, number " .
            "FROM       races " . 
            "WHERE      id=" . $id;
    if (!$rs = $db->query($sql))
        badEnd("500", array("sql"=>$sql, "msg"=>$db->error));
    if (!$row = $rs->fetch_assoc())
        badEnd("204", array("msg"=>"No se encuentra el registro"));
    $status = $row["status"];
    $number = $row["number"];

    if ($status != "0" && $status != "1")
        badEnd("417", array("msg"=>"Solo se puede llamar a este servicio para abrir o procesar una carrera"));

    $newstatus = -1;
    if ($status == "0"){
        if (!tienePrivilegio($db, $sessionid, 624, false))
            badEnd("403", array("msg"=>"No tiene privilegios para ejecutar esta acción"));

        // Validar que haya caballos cargados
        $sql =  "SELECT     count(*) cnt " . 
                "FROM       racers " . 
                "WHERE      raceid=" . $id;
        if (!$rs = $db->query($sql))
            badEnd("500", array("sql"=>$sql, "msg"=>$db->error));
        if (!$row = $rs->fetch_assoc())
            badEnd("204", array("msg"=>"No se encuentra el registro"));
        if ($row["cnt"]=="0")
            badEnd("417", array("msg"=>"Deben existir ejemplares cargados para procesar la carrera"));

        $newstatus = 1;
    }
    if ($status == "1"){
        if (!tienePrivilegio($db, $sessionid, 625, false))
            badEnd("403", array("msg"=>"No tiene privilegios para ejecutar esta acción"));

        // borrar pronósticos
        //$sql = "DELETE FROM forecasts WHERE raceid=" . $id;
        //if (!$db->query($sql))
        //    badEnd("500", array("sql"=>$sql, "msg"=>$db->error));

        $newstatus = 0;
    }
    if ($newstatus != -1){
        $sql =  "UPDATE     races " .
                "SET        status=" . $newstatus . " " .
                "WHERE      id=" . $id;
        if (!$rs = $db->query($sql))
            badEnd("500", array("sql"=>$sql, "msg"=>$db->error));

        if ($newstatus == 1)
            setAudit($db, "Carreras", $sessionid, "Se procesó la carrera \'" . $number . "\' (" . $id . ")");
        else
            setAudit($db, "Carreras", $sessionid, "Se abrió la carrera \'" . $number . "\' (" . $id . ")");

    }

    $out = new stdClass;
    $out->id = $id;
    $out->newstatus = $newstatus;

    header("HTTP/1.1 200");
    echo (json_encode($out));
    die();
?>