<?php
    header("Content-Type:application/json");
    header("Access-Control-Allow-Origin: http://localhost:5500");
    include("../../../settings/dbconn.php");
    include("../../../settings/utils.php");

    // forzar a que se haga un GET
    if ($_SERVER['REQUEST_METHOD']!= "POST")
        badEnd("400", array("msg"=>"Debe llamarse al servicio usando un POST"));

    // parametros obligatorios
    $parmsob = array("id","raceid","horseid","number","position","jockeyid","trainerid",
                    "jockeyweight","medicaments","implements","studid","sessionid");
    if (!parametrosValidos($_REQUEST, $parmsob))
        badEnd("400", array("msg"=>"Parametros obligatorios " . implode(", ", $parmsob)));
    
    $sessionid = preg_replace("/[^a-zA-Z0-9]+/", "", $_REQUEST["sessionid"]);
    $id = intval($_REQUEST["id"]);
    $raceid = intval($_REQUEST["raceid"]);
    $horseid = intval($_REQUEST["horseid"]);
    $number = intval($_REQUEST["number"]);
    $position = intval($_REQUEST["position"]);
    $jockeyid = intval($_REQUEST["jockeyid"]);
    $trainerid = intval($_REQUEST["trainerid"]);
    $studid = intval($_REQUEST["studid"]);
    $jockeyweight = preg_replace("/[^0-9 \.\-\+]+/", "", $_REQUEST["jockeyweight"]);
    $medicamentspars = preg_replace("/[^0-9\-]+/", "", $_REQUEST["medicaments"]);
    $implementspars = preg_replace("/[^0-9\-]+/", "", $_REQUEST["implements"]);

    isSessionValid($db, $sessionid);

    // validar medicamentos
    $medicaments = array();
    if ($medicamentspars != "-"){
        foreach (explode("-",$medicamentspars) as $medicament){
            $sql =  "SELECT     id, dsc, abbr " .
                    "FROM       implements " . 
                    "WHERE      type='M' " .
                    "AND        id='" . $medicament . "'";
            if (!$rs = $db->query($sql))
                badEnd("500", array("errlog"=>2, "msg"=>$db->error));

            if (!$row = $rs->fetch_assoc())
                badEnd("400", array("msg"=>"Medicamentos inválidos"));
            $medicaments[] = array("id"=>$medicament, "dsc"=>$row["dsc"], "abbr"=>$row["abbr"]);
        }
    }
    // validar implementos
    $implements = array();
    if ($implementspars != "-"){
        foreach (explode("-",$implementspars) as $implement){
            $sql =  "SELECT     id, dsc, abbr " .
                    "FROM       implements " . 
                    "WHERE      type='I' " .
                    "AND        id='" . $implement . "'";
            if (!$rs = $db->query($sql))
                badEnd("500", array("errlog"=>2, "msg"=>$db->error));

            if (!$row = $rs->fetch_assoc())
                badEnd("400", array("msg"=>"Implementos inválidos"));
            $implements[] = array("id"=>$implement, "dsc"=>$row["dsc"], "abbr"=>$row["abbr"]);
        }
    }
    if ($id==0){    // incluir registro
        if (!tienePrivilegio($db, $sessionid, 621, false))
            badEnd("403", array("msg"=>"No tiene privilegios para ejecutar esta acción"));
            
        $sql =  "INSERT INTO racers " .
                "       (`raceid`, `horseid`, `number`, `position`, `jockeyid`, " .
                "       `trainerid`, `jockeyweight`, `implementstypeM`, `implementstypeI`, `studid`) " .
                "VALUES (" .
                "        '" . $raceid . "'," .
                "        '" . $horseid . "'," .
                "        '" . $number . "'," .
                "        '" . $position . "'," .
                "        '" . $jockeyid . "'," .
                "        '" . $trainerid . "'," .
                "        '" . $jockeyweight . "'," .
                "        '" . json_encode($medicaments) . "'," .
                "        '" . json_encode($implements) . "'," .
                "        '" . $studid . "' " .
                "        )";
        if (!$db->query($sql)){
            if ($db->errno == 1062){
                badEnd("409", array("msg"=>"Registro Duplicado"));
            }else{
                badEnd("500", array("msg"=>$db->error));
            }
        }

        $id = $db->insert_id;
        
        setAudit($db, "Carreras", $sessionid, "Se incluyó el ejemplar \'" . $number . "\' en la carrera (" . $raceid . ")");
    }else{          // modificar registro
        if (!tienePrivilegio($db, $sessionid, 621, false))
            badEnd("403", array("msg"=>"No tiene privilegios para ejecutar esta acción"));
            
        $sql =  "UPDATE racers " .
                "SET    raceid = '" . $raceid . "'," .
                "       horseid = '" . $horseid . "', " .
                "       number = '" . $number . "', " .
                "       position = '" . $position . "', " .
                "       jockeyid = '" . $jockeyid . "', " .
                "       jockeyweight = '" . $jockeyweight . "', " .
                "       trainerid = '" . $trainerid . "', " .
                "       implementstypeM = '" . json_encode($medicaments) . "', " .
                "       implementstypeI = '" . json_encode($implements)  . "', " .
                "       studid = '" . $studid . "' " .
                "WHERE  id=" . $id;
        if (!$db->query($sql))
            if ($db->errno == 1062){
                badEnd("409", array("msg"=>"Registro Duplicado"));
            }else{
                badEnd("500", array("id"=>0,"sql"=>$sql,"msg"=>$db->error));
            }
            
        setAudit($db, "Carreras", $sessionid, "Se actualizó el ejemplar \'" . $number . "\' de la carrera (" . $raceid . ")");
    }

    $out = new stdClass;
    $out->id = $id;
    
    header("HTTP/1.1 200");
    echo (json_encode($out));
    die();
?>