<?php
    header("Content-Type:application/json");
    header("Access-Control-Allow-Origin: http://localhost:5500");
    include("../../../settings/dbconn.php");
    include("../../../settings/utils.php");

    // forzar a que se haga un POST y no un GET
    if ($_SERVER['REQUEST_METHOD']!= "POST")
        badEnd("400", array("msg"=>"Debe llamarse al servicio usando un POST"));

    // parametros obligatorios
    $parmsob = array("raceid", "order", "offset", "numofrec", "sessionid");
    if (!parametrosValidos($_REQUEST, $parmsob))
        badEnd("400", array("msg"=>"Parametros obligatorios " . implode(", ", $parmsob)));
    
    $sessionid = preg_replace("/[^a-zA-Z0-9]+/", "", $_REQUEST["sessionid"]);
    $raceid = intval($_REQUEST["raceid"]);
    $orderpar = intval($_REQUEST["order"]);
    $offset = intval($_REQUEST["offset"]);
    $numofrec = intval($_REQUEST["numofrec"]);

    isSessionValid($db, $sessionid);

    if (!tienePrivilegio($db, $sessionid, 620, false))
        badEnd("403", array("msg"=>"No tiene privilegios para ejecutar esta acción"));
    
    // busqueda
    $filter = " R.raceid=" . $raceid . " ";

    if (strlen($filter) > 0){
        $filter = " WHERE " . $filter;
    }

    // orden
    $order = "";
    switch (abs($orderpar)){
        case 1:
            $order = " R.number ";
            break;
        case 2:
            $order = " H.dsc ";
            break;
        case 3:
            $order = " R.weight ";
            break;
        case 4:
            $order = " CONCAT(J.names,' ',J.lastnames) ";
            break;
        case 5:
            $order = " CONCAT(T.names,' ',T.lastnames) ";
            break;
        case 6:
            $order = " R.position ";
            break;
        case 7:
            $order = " S.dsc ";
            break;
        case 8:
            $order = " IFNULL(R.arrivalposition,0) ";
            break;
    }
    if (strlen($order) > 0){
        if ($orderpar < 0)
            $order = str_replace(", ", " DESC,", $order) . " DESC ";
        $order = " ORDER BY " . $order;
    }

    $sql =  "SELECT     R.id, R.number, R.position, R.weight, " .
            "           R.horseid, H.dsc horsedsc, " .
            "           R.jockeyid, CONCAT(J.names, ' ', J.lastnames) jockeydsc, J.abbr jockeyabbr, " .
            "           R.trainerid, CONCAT(T.names, ' ', T.lastnames) trainerdsc, T.abbr trainerabbr, " .
            "           R.studid, S.dsc studdsc, R.finishtime, R.pos400, R.pos800, IFNULL(R.dividends, 0) dividends, " .
            "           R.implementstypeM medicaments, R.implementstypeI implements, " .
            "           IFNULL(RE.id,'') retirementsid, IFNULL(RE.dsc,'') retirementsdsc, IFNULL(RE.abbr,'') retirementsabbr, " .
            "           IFNULL(ST.id,'') stumbleid, IFNULL(ST.dsc,'') stumbledsc, IFNULL(ST.abbr,'') stumbleabbr, " .
            "           IFNULL(B.id,'') bodiesid, IFNULL(B.dsc,'') bodiesdsc, IFNULL(B.abbr,'') bodiesabbr, IFNULL(B.value,'') bodiesvalue, " .
            "           IFNULL(R.arrivalposition,0) arrivalposition, IFNULL(R.jockeyweight,0) jockeyweight " .
            "FROM       racers R " .
            "INNER JOIN horses H " .
            "ON         R.horseid = H.id " . 
            "INNER JOIN jockeys J " .
            "ON         R.jockeyid = J.id " . 
            "INNER JOIN trainers T " .
            "ON         R.trainerid = T.id " . 
            "INNER JOIN studs S " .
            "ON         R.studid = S.id " . 
            "LEFT JOIN  retirements RE " .
            "ON         R.retirementid=RE.id " .
            "LEFT JOIN  stumbles ST " .
            "ON         R.stumbleid=ST.id " .
            "LEFT JOIN  bodies B " .
            "ON         R.bodiesid=B.id " .
            $filter .
            $order;
    // calcular numero de registros
    if (!$rs = $db->query("SELECT COUNT(*) cnt FROM (" . $sql . ") A "))
        badEnd("500", array("errlog"=>1, "sql"=>$sql, "msg"=>$db->error));
    $row = $rs->fetch_assoc();
    $out = new stdClass;
    $out->numofrecords = (integer) $row["cnt"];

    // limitar número de
    $sql =  "SELECT A.* FROM (" . $sql . ") A " .
            "LIMIT " . $offset . "," . $numofrec;
    if (!$rs = $db->query($sql))
        badEnd("500", array("errlog"=>2, "msg"=>$db->error));

    $out->records = array();
    while ($row = $rs->fetch_assoc()){
        $records = new stdClass;
        $records->id = (integer) $row["id"];
        $records->number = (integer) $row["number"];
        $records->position = (integer) $row["position"];
        $records->horse = new stdClass;
        $records->horse->id = (integer) $row["horseid"];
        $records->horse->name = $row["horsedsc"];
        $records->jockey = new stdClass;
        $records->jockey->id = (integer) $row["jockeyid"];
        $records->jockey->name = $row["jockeydsc"];
        $records->jockey->abbr = $row["jockeyabbr"];
        $records->jockey->weight = $row["jockeyweight"];
        $records->trainer = new stdClass;
        $records->trainer->id = (integer) $row["trainerid"];
        $records->trainer->name = $row["trainerdsc"];
        $records->trainer->abbr = $row["trainerabbr"];
        $records->stud = new stdClass;
        $records->stud->id = (integer) $row["studid"];
        $records->stud->name = $row["studdsc"];
        $records->weight = new stdClass;
        $records->weight->number = (float) $row["weight"];
        $records->weight->formatted = number_format($records->weight->number, 2, ",", ".");
        $records->medicaments = nvl(json_decode($row["medicaments"]),array());
        $records->implements = nvl(json_decode($row["implements"]),array());
        $records->retirements = new stdClass;
        $records->retirements->id = (integer) $row["retirementsid"];
        $records->retirements->name = $row["retirementsdsc"];
        $records->retirements->abbr = $row["retirementsabbr"];
        $records->arrivalposition = (integer) $row["arrivalposition"];
        $records->stumble = new stdClass;
        $records->stumble->id = (integer) $row["stumbleid"];
        $records->stumble->name = $row["stumbledsc"];
        $records->stumble->abbr = $row["stumbleabbr"];
        $records->finishtime = new stdClass;
        $records->finishtime->number = (float) $row["finishtime"];
        $records->finishtime->name = number_format($records->finishtime->number, 2, ",", ".");
        $records->dividends = new stdClass;
        $records->dividends->number = (float) $row["dividends"];
        $records->dividends->name = number_format($records->dividends->number, 2, ",", ".");
        $records->pos400 = new stdClass;
        $records->pos400->number = (integer) $row["pos400"];
        $records->pos400->formatted = number_format($records->pos400->number, 0, ",", ".");
        $records->pos800 = new stdClass;
        $records->pos800->number = (integer) $row["pos800"];
        $records->pos800->formatted = number_format($records->pos800->number, 0, ",", ".");
        $records->bodies = new stdClass;
        $records->bodies->id = (integer) $row["bodiesid"];
        $records->bodies->name = $row["bodiesdsc"];
        $records->bodies->abbr = $row["bodiesabbr"];
        $records->bodies->value = (float) $row["bodiesvalue"];
        
        $out->records[] = $records;
    }

    header("HTTP/1.1 200");
    echo (json_encode($out));
    die();
?>