<?php
    header("Content-Type:application/json");
    header("Access-Control-Allow-Origin: http://localhost:5500");
    include("../../../settings/dbconn.php");
    include("../../../settings/utils.php");

    // forzar a que se haga un GET
    if ($_SERVER['REQUEST_METHOD']!= "POST")
        badEnd("400", array("msg"=>"Debe llamarse al servicio usando un POST"));

    // parametros obligatorios
    $parmsob = array("id", "sessionid", "dsc", "minvariant", "maxvariant", "statusid");
    if (!parametrosValidos($_REQUEST, $parmsob))
        badEnd("400", array("msg"=>"Parametros obligatorios " . implode(", ", $parmsob)));
    
    $sessionid = preg_replace("/[^a-zA-Z0-9]+/", "", $_REQUEST["sessionid"]);
    $id = intval($_REQUEST["id"]);
    $dsc = preg_replace("/[^a-zA-Z0-9 .,:\-()+*\/áéíóúñüÁÉÍÓÚÑÜ]+/", "", $_REQUEST["dsc"]);
    $minvariant = floatval($_REQUEST["minvariant"]);
    $maxvariant = floatval($_REQUEST["maxvariant"]);
    $statusid = intval($_REQUEST["statusid"]);

    if($statusid!=0 && $statusid!=1)
        badEnd("400", array("msg"=>"El parámetro statusid puede ser 0 o 1"));
    if ($minvariant > $maxvariant)
        badEnd("400", array("msg"=>"El parámetro minvariant debe ser menor o igual al maxvariant"));

    isSessionValid($db, $sessionid);

    // verificar que el minvariant y maxvaraint no choca con otro regisotr
    $sql =  "SELECT     COUNT(*) cnt " . 
            "FROM       racecoursetypes " . 
            "WHERE      ((minvariant <= " . $minvariant . " " .
            "AND        maxvariant >= " . $minvariant . ") " .
            "OR         (minvariant <= " . $maxvariant . " " .
            "AND        maxvariant >= " . $maxvariant . ")) " . 
            "AND        id<>" . $id;
    if (!$rs = $db->query($sql))
        badEnd("500", array("sql"=>$sql, "msg"=>$db->error));
    $row = $rs->fetch_assoc();
    if ($row["cnt"]>0)
        badEnd("400", array("msg"=>"El rango indicado coincide con otro rango registrado"));

    if ($id==0){    // incluir registro
        if (!tienePrivilegio($db, $sessionid, 552, false))
            badEnd("403", array("msg"=>"No tiene privilegios para ejecutar esta acción"));
            
        $sql =  "INSERT INTO racecoursetypes " .
                "       (dsc, minvariant, maxvariant, status) " .
                "VALUES (" .
                "        '" . $dsc . "'," .
                "        '" . $minvariant . "'," .
                "        '" . $maxvariant . "'," .
                "        '" . $statusid . "' " .
                "        )";
        if (!$db->query($sql)){
            if ($db->errno == 1062){
                badEnd("409", array("msg"=>"Registro Duplicado"));
            }else{
                badEnd("500", array("msg"=>$db->error));
            }
        }

        $id = $db->insert_id;

        $dsc = substr($dsc, 0, 20);
        if (strlen($dsc) == 20)
            $dsc = substr($dsc, 0, 17) . "...";
        
        setAudit($db, "Tipos de Pista", $sessionid, "Se incluyó el tipo \'" . $dsc . "\' (" . $id . ")");
    }else{          // modificar registro
        if (!tienePrivilegio($db, $sessionid, 551, false))
            badEnd("403", array("msg"=>"No tiene privilegios para ejecutar esta acción"));
            
        $sql =  "UPDATE racecoursetypes " .
                "SET    dsc = '" . $dsc . "'," .
                "       minvariant = '" . $minvariant . "', " .
                "       maxvariant = '" . $maxvariant . "', " .
                "       status = '" . $statusid . "' " .
                "WHERE  id=" . $id;
        if (!$db->query($sql))
            if ($db->errno == 1062){
                badEnd("409", array("msg"=>"Registro Duplicado"));
            }else{
                badEnd("500", array("id"=>0,"sql"=>$sql,"msg"=>$db->error));
            }
            
        $dsc = substr($dsc, 0, 20);
        if (strlen($dsc) == 20)
            $dsc = substr($dsc, 0, 17) . "...";

        setAudit($db, "Tipos de Pista", $sessionid, "Se actualizó el tipo \'" . $dsc . "\' (" . $id . ")");

    }

    $out = new stdClass;
    $out->id = $id;
    
    header("HTTP/1.1 200");
    echo (json_encode($out));
    die();
?>