<?php
error_reporting(E_ALL);
ini_set('display_errors', 1);

    require '../../../hooks/autoload.php';
    use \PhpOffice\PhpWord\PhpWord;
    use \PhpOffice\PhpWord\SimpleType\Border;
    use \PhpOffice\PhpWord\Style\Font;

    include("../../../settings/dbconn.php");
    include("../../../settings/utils.php");

    // forzar a que se haga un POST y no un GET
    if ($_SERVER['REQUEST_METHOD']!= "GET")
        badEnd("400", array("msg"=>"Debe llamarse al servicio usando un GET"));
    // parametros obligatorios
    $parmsob = array("reunionid", "magazineid", "sessionid");
    if (!parametrosValidos($_REQUEST, $parmsob))
        badEnd("400", array("msg"=>"Parametros obligatorios " . implode(", ", $parmsob)));

    $sessionid = preg_replace("/[^a-zA-Z0-9]+/", "", $_REQUEST["sessionid"]);
    $reunionid = intval($_REQUEST["reunionid"]);
    $magazineid = intval($_REQUEST["magazineid"]);

    // parametros opcionales
    $outputformat = "docx";
    if (isset($_REQUEST["format"]))
        $outputformat = preg_replace("/[^docxpf]+/", "", strtolower($_REQUEST["format"]));
    if ($outputformat != "docx" && $outputformat != "pdf" )
        badEnd("500", array("msg"=>"Los formatos validos son 'pdf' y 'docx"));
    $racefilter = "";
    //if (isset($_REQUEST["raceidfrom"]) && isset($_REQUEST["raceidto"])){
    //    $racefilter = " AND RA.id BETWEEN " . $_REQUEST["raceidfrom"] . " AND " . $_REQUEST["raceidto"] . " ";
    //}
    if (isset($_REQUEST["raceidfrom"]) && isset($_REQUEST["raceidto"])){
        $raceidfrom = intval($_REQUEST["raceidfrom"]);
        $raceidto = intval($_REQUEST["raceidto"]);
        $sql = "SELECT number FROM races WHERE id=" . $raceidfrom;
        if (!$rs = $db->query($sql))
            badEnd("500", array("sql"=>$sql, "msg"=>$db->error));
        if (!$row = $rs->fetch_assoc())
            badEnd("409", array("msg"=>"Reunion desde no encontrada"));
        $racenumberfrom = $row["number"];
        $sql = "SELECT number FROM races WHERE id=" . $raceidto;
        if (!$rs = $db->query($sql))
            badEnd("500", array("sql"=>$sql, "msg"=>$db->error));
        if (!$row = $rs->fetch_assoc())
            badEnd("409", array("msg"=>"Reunion hasts no encontrada"));
        $racenumberto = $row["number"];
        $racefilter = " AND RA.number BETWEEN '" . $racenumberfrom . "' AND '" . $racenumberto . "' ";
    }
    isSessionValid($db, $sessionid);

    // conseguir fecha e hipodromo de la reunión
    $sql =  "SELECT 	R.date, R.racecourseid, H.dsc, H.abbr rcabbr " .
            "FROM 		reunions R " .
            "INNER JOIN racecourses H " .
            "ON         R.racecourseid = H.id " .
            "WHERE      R.id = " . $reunionid . " ";
    if (!$rs = $db->query($sql))
        badEnd("500", array("sql"=>$sql, "msg"=>$db->error));
    if (!$row = $rs->fetch_assoc())
        badEnd("409", array("msg"=>"Reunion no encontrada"));
    $date = $row["date"];
    $racecourseid = $row["racecourseid"];
    $racecourse = $row["dsc"];
    $rcabbr = $row["rcabbr"];

    //obtener primera carrera de la reunión para efectos del nombre
    $sql =  "SELECT LPAD(MIN(number), 3, '0') num FROM races WHERE valid=0 AND reunionid=" . $reunionid;
    if (!$rs = $db->query($sql))
        badEnd("500", array("sql"=>$sql, "msg"=>$db->error));
    if (!$row = $rs->fetch_assoc())
        badEnd("409", array("msg"=>"Reunion no encontrada"));
    $filename = "S" . $rcabbr  . "C" . $row["num"] . "." . $outputformat;

    // Armar arreglo con jugadas de pool de 4 y loto hipico
    $sql =  "SELECT     number, JSON_EXTRACT(RA.bets, '$[*].id') bet " .
            "FROM       races RA " . 
            "WHERE      RA.reunionid = " . $reunionid . " " . 
            "ORDER BY   RA.number";
    if (!$rs = $db->query($sql))
        badEnd("500", array("sql"=>$sql, "msg"=>$db->error));
    $doblep = array();
    $pool4 = array();
    $lotohip = array();
    $tripleap = array();
    $cntdbl = 0;
    $cntp4 = 0;
    $cntlh = 0;
    $cntta = 0;
    while ($row = $rs->fetch_assoc()){
        // se busca 6 que es el id de dobleperfecta
        if (strpos(preg_replace("/[^1234567890,]+/", "", $row["bet"]), "6"))
            if ($cntdbl<2)
                $cntdbl++;
            else
                $cntdbl = 1;
        else
            $cntdbl=0;
        $doblep[$row["number"]] = $cntdbl;
        // se busca 7 que es el id de pool de 4
        if (strpos(preg_replace("/[^1234567890,]+/", "", $row["bet"]), "7"))
            if ($cntp4<4)
                $cntp4++;
            else
                $cntp4 = 1;
        else
            $cntp4=0;
        $pool4[$row["number"]] = $cntp4;
        // se busca 8 que es el id de loto hipico
        if (strpos(preg_replace("/[^1234567890,]+/", "", $row["bet"]), "8"))
            if ($cntlh<2)
                $cntlh++;
            else
                $cntlh = 1;
        else
            $cntlh=0;
        $lotohip[$row["number"]] = $cntlh;
        // se busca 9 que es el id de triple apuesta
        if (strpos(preg_replace("/[^1234567890,]+/", "", $row["bet"]), "9"))
            if ($cntta<2)
                $cntta++;
            else
                $cntta = 1;
        else
            $cntta=0;
        $tripleap[$row["number"]] = $cntta;
    }

    $sql =  "SELECT     C.id horseid, R.id racerid, H.dsc racecourse, RA.extraprice, CU1.symbol pricecurr, CU2.symbol extrapricecurr, DATE_FORMAT(RE.date, '%d/%m/%y') fecha, " .
            "           H.id racecourseid, RA.id raceid, RA.ord raceord, RA.number racenumber, RA.mainprice, RA.firstplace, RA.secondplace, RA.thirdplace, RA.fourthplace, RA.fifthplace, " .
            "           R.number horsenumber, R.position horseposition, R.jockeyweight, " .
            "           RE.date reuniondate, D.dsc distancia, RT.id racetypeid, RT.dsc racetypedsc, " .
            "           REPLACE(LOWER(DATE_FORMAT(RA.time, '%h:%i %p')),'m','m') hora, DAYOFWEEK(RE.date) dow, " .
            "           CO1.dsc condicion1, CO2.dsc condicion2, RA.conditiondsc, " .
            "           RH.horsename recordhorse, RH.jockeyname recordjockey, RH.jockeyweight recordweight, RH.basetime recordtime,  " .
            "           DATE_FORMAT(RH.date, '%d/%m/%y') recorddate, " .
            "           S.dsc studname, S.abbr studabbr, " .
            "           C.obs horseobs, C.dsc horsename, C.mothergfname horsegfather, C.fathername horsefather, C.mothername horsemother, DATE_FORMAT(C.birthdate, '%d/%m/%y') horsebirth, " .
            "           J.abbr jockeyname, T.abbr trainername,  " .
            "           R.implementstypeM medicaments, IFNULL(R.implementstypeI,'') implements, " .
            "           IFNULL(F.racers,'') forecastracers, F.top3, F.top6, " .
            "           SH.totalraces, SH.firstplace totalwin, SH.totalracesyear, SH.firstplaceyear totalwinyear, " .
            "           SA.harasname, SA.pricesbs harasbs " .
            "FROM       racers R  " .
            "INNER JOIN races RA  " .
            "ON         R.raceid=RA.id " .
            "INNER JOIN racetypes RT " . 
            "ON         RA.racetypeid=RT.id " .
            "INNER JOIN reunions RE  " .
            "ON         RA.reunionid=RE.id " .
            "INNER JOIN racecourses H  " .
            "ON         RE.racecourseid=H.id " .
            "INNER JOIN conditions CO1 " .
            "ON         RA.conditionid1=CO1.id " .
            "INNER JOIN conditions CO2 " .
            "ON         RA.conditionid2=CO2.id " .
            "INNER JOIN distances D  " .
            "ON         RA.distanceid=D.id " .
            "LEFT JOIN	(SELECT * FROM records_hipdst WHERE deleted IS NULL) RH " .
            "ON			RE.racecourseid=RH.racecourseid " .
            "AND		RA.distanceid=RH.distanceid " .
            "LEFT JOIN  (SELECT * FROM forecasts WHERE magazineid=" . $magazineid . ") F " .
            "ON         RA.id=F.raceid " .
            "INNER JOIN studs S  " .
            "ON			R.studid=S.id " .
            "INNER JOIN horses C  " .
            "ON			R.horseid=C.id " .
            "INNER JOIN stats_haras SA " .
            "ON         C.harasid=SA.harasid " .
            "INNER JOIN jockeys J  " .
            "ON			R.jockeyid=J.id " .
            "INNER JOIN	trainers T  " .
            "ON			R.trainerid=T.id " .
            "INNER JOIN currencies CU1 " .
            "ON         RA.mainpricecurr=CU1.code " .
            "INNER JOIN currencies CU2 " .
            "ON         RA.extrapricecurr=CU2.code " .
            "LEFT JOIN  ( " .
            "            SELECT		horseid, racecourseid, SUM(firstplace) firstplace, SUM(totalraces) totalraces,  " .
            "                       SUM(firstplaceyear) firstplaceyear, SUM(totalracesyear) totalracesyear  " .
            "            FROM		stats_horses " .
            "            GROUP BY   horseid, racecourseid " .
            "           )  SH " .
            "ON         R.horseid = SH.horseid " .
            "AND        RE.racecourseid = SH.racecourseid " .
//            "AND        RA.distanceid = SH.distanceid " .
            "WHERE      RE.id=" . $reunionid . " " .
            "AND        RA.valid=0 " .
            $racefilter .
            //"AND        RE.number=49 " .
            "ORDER BY   RA.ord, R.number";
    if (!$rs = $db->query($sql))
        badEnd("500", array("sql"=>$sql, "msg"=>$db->error));

    $phpWord = new PhpWord();

    // medidas
    $pulgada = 1440;
    $height = 7.28*$pulgada;  // 1440 twip = 1 pulgada
    $width = 4.8*$pulgada;
    $top = 0;
    $bottom = 0;
    $left = 15;
    $right = 15;
    $columnspaces = 0;
    $blank = chr(194) . chr(160);

    // colores
    $negro = "000000";
    $gris = "CECECE";
    $verde = "849966";
    $verdeclaro = "dcdfcc";
    if ($racecourseid == 4){
        $fondo = $verde;
        $fondoclaro = $verdeclaro;
    }else{
        $fondo = $negro;
        $fondoclaro = $gris;
    }

    // Ancho de las columnas
    $C1 =  0.04;
    $C2 =  0.23;
    $C3 =  0.10; //+C19
    $C4 =  0.03;
    $C5 =  0.035;
    $C6 =  0.035;
    $C7 =  0.045;
    $C8 =  0.035;
    $C9 =  0.02;
    $C10 = 0.03;
    $C11 = 0.03;
    $C11_1 = 0.03;
    $C12 = 0.10;
    $C13 = 0.10;
    $C14 = 0.03;
    $C15 = 0.03;
    $C16 = 0.00;
    $C17 = 0.04;
    $C18 = 0.04;
    $C19 = 0; //0.02;
    $anchoHistoria = $width*($C5+$C6+$C7+$C8+$C9+$C10+$C11+$C11_1+$C12+$C13+$C14+$C15+$C16+$C17+$C18+$C19);

    $borderwidth = 6;
    // ESTILOS
    // Estilos de celdas
    $headerCellFullBrdStyle = [
        "valign" => "bottom",
        "borderSize" => $borderwidth,
        "borderColor" => "000000",
    ];
    $headerCellTopDwnBrdStyle = [
        "valign" => "bottom",
        "borderBottomSize" => $borderwidth,
        "borderBottomColor" => "000000",
        "borderTopSize" => $borderwidth,
        "borderTopColor" => '000000',
        "borderRightSize" => 0,
        "borderLeftSize" => 0,
        "borderRightStyle" => Border::NONE,
        "borderLeftStyle" => Border::NONE,
    ];
    $headerCellRightBrdStyle = [
        "valign" => "bottom",
        "borderRightSize" => $borderwidth,
        "borderRightColor" => "000000",
        "borderTopSize" => $borderwidth,
        "borderTopColor" => "000000",
        "borderBottomSize" => $borderwidth,
        "borderBottomColor" => "000000",
        "borderLeftSize" => 0,
        "borderLeftStyle" => Border::NONE,
    ];
    $headerCellStyle = [
        //"bgColor"=>$fondoclaro,
        "valign" => "bottom",
        "borderRightSize" => $borderwidth,
        "borderRightColor" => "000000",
        "borderTopSize" => 0,
        "borderBottomSize" => 0,
        "borderLeftSize" => 0,
        "borderTopStyle" => Border::NONE,
        "borderBottomStyle" => Border::NONE,
        "borderLeftStyle" => Border::NONE,
    ];

    $detailCellStyle = [
        "valign" => "center",
        "borderSize" => 0,
        "borderStyle" => Border::NONE,
    ];

    $statsAreaCellStyle = [
        "valign" => "top",
        "borderSize" => 6,
        //"borderStyle" => Border::NONE,
    ];

    $detailCellSpanStyle = [
        "gridSpan" => 14,
        "valign" => "center",
        "borderSize" => 0,
        "borderStyle" => Border::NONE,
    ];

    $detailCellStyleFullBrd = [
        "valign" => "center",
        "borderSize" => $borderwidth,
        "borderColor" => '000000',
    ];
    $detailCellSpanStyleFullBrd = [
        "gridSpan" => 14,
        "valign" => "center",
        "borderSize" => $borderwidth,
        "borderColor" => '000000',
    ];
    $detailCellSpanStyle = [
        "gridSpan" => 14,
        "valign" => "center",
        "borderSize" => 0,
        "borderStyle" => Border::NONE,
    ];
    $defaultCellStyle = [
        "borderSize" => 0,
        "borderStyle" => Border::NONE
    ];
    $borderCellStyle = [
        "borderSize" => 6
    ];
    $blackCellStyle = [
        "valign" => "center",
        "bgColor" => "000000",
        "borderSize" => 0,
        "borderStyle" => Border::NONE,
    ];

    // Estilos de Tablas
    $defaultTableFullWidthStyle = "defaultTableFullWidthStyle";
    $phpWord->addTableStyle($defaultTableFullWidthStyle,[
            "width" => $width,
            "borderSize" => 0,
            "borderStyle" => Border::NONE,
            "alignment" => \PhpOffice\PhpWord\SimpleType\JcTable::CENTER,
            "cellMargin" => 0,
            "cellSpacing" => 0,
        ], $defaultCellStyle, $defaultCellStyle);
    $defaultTableHalfWidthStyle = "defaultTableHalfWidthStyle";
    $phpWord->addTableStyle($defaultTableHalfWidthStyle,[
            "width" => $width/2,
            "borderSize" => 0,
            "borderStyle" => Border::NONE,
            "alignment" => \PhpOffice\PhpWord\SimpleType\JcTable::CENTER,
            "cellMargin"=>0,
            "cellSpacing" => 0,
    ], $defaultCellStyle, $defaultCellStyle);
    $defaultTableHstWidthStyle = "defaultTableHstWidthStyle";
    $phpWord->addTableStyle($defaultTableHstWidthStyle,[
            "width" => $anchoHistoria,
            "borderSize" => 0,
            "borderStyle" => Border::NONE,
            "alignment" => \PhpOffice\PhpWord\SimpleType\JcTable::CENTER,
            "cellMargin"=>0,
            "cellSpacing" => 0,
    ], $defaultCellStyle, $defaultCellStyle);
    $pricesTableStyle = "pricesTableStyle";
    $phpWord->addTableStyle($pricesTableStyle,[
            "width" => $width*0.10,
            "borderSize" => 0,
            "borderStyle" => Border::NONE,
            "alignment" => \PhpOffice\PhpWord\SimpleType\JcTable::CENTER,
            "cellMargin" => 0,
            "cellSpacing" => 0,
        ], $borderCellStyle, $borderCellStyle);


    // cintillo superior de premio en dolares
    $initialBannerText = "initialBannerText";
    $phpWord->addFontStyle($initialBannerText, [
        "name"=>"Times New Roman",
        "size"=>17,
        "italic"=>true,
        "bold"=>true,
        "color"=>"000000",
        //"bgColor"=>$fondo
    ]);
    $initialBannerPar = "initialBannerPar";
    $phpWord->addParagraphStyle($initialBannerPar, [
        "alignment" => \PhpOffice\PhpWord\SimpleType\Jc::CENTER,
        //"shading"=>["fill"=>$fondo],
        "spaceBefore"=>0,
        "spaceAfter"=>0,
    ]);
    // Clásico
    $classicText = "classicText";
    $phpWord->addFontStyle($classicText, [
        "name"=>"Univers 65",
        "size"=>10,
        "allCaps"=>true,
        "bold"=>false,
        "italic"=>false,
        "color"=>"000000"
    ]);
    $classicPar = "classicPar";
    $phpWord->addParagraphStyle($classicPar, [
        "alignment" => \PhpOffice\PhpWord\SimpleType\Jc::CENTER,
        "spacing"=>0,
        "spaceBefore"=>20,
        "spaceAfter"=>20,
    ]);
    // nombre del hipodromo
    $racecourseText = "racecourseText";
    $phpWord->addFontStyle($racecourseText, [
        "name"=>"Univers 55",
        "size"=>6,
        "allCaps"=>false,
        "bold"=>true,
        "color"=>"000000"
    ]);
    $racecoursePar = "racecoursePar";
    $phpWord->addParagraphStyle($racecoursePar, [
        "spacing"=>1,
        "spaceBefore"=>0,
        "spaceAfter"=>0,
        "tabs" => [
                    new \PhpOffice\PhpWord\Style\Tab('left', $width/24)
        ]
    ]);
    // fecha y hora de la carrera
    $dateText = "dateText";
    $phpWord->addFontStyle($dateText, [
        "name"=>"Univers Extra Black",
        "size"=>8,
        "allCaps"=>false,
        "bold"=>false,
        "color"=>"000000",
        "scale" => 150
    ]);
    $datePar = "datePar";
    $phpWord->addParagraphStyle($datePar, [
        "spacing"=>1,
        "spaceBefore"=>0,
        "spaceAfter"=>0,
        "tabs" => [
                    new \PhpOffice\PhpWord\Style\Tab('right', $width/2)
        ]
    ]);
    // titulo premios
    $dateText = "dateText";
    $phpWord->addFontStyle($dateText, [
        "name"=>"Univers 65",
        "size"=>8,
        "allCaps"=>false,
        "bold"=>false,
        "color"=>"000000",
        "scale" => 150
    ]);
    $datePar = "datePar";
    $phpWord->addParagraphStyle($datePar, [
        "spacing"=>1,
        "spaceBefore"=>0,
        "spaceAfter"=>0,
        "tabs" => [
                    new \PhpOffice\PhpWord\Style\Tab('right', $width/2)
        ]
    ]);
    // numero de carrera y hora
    $raceNmbrText = "raceNmbrText";
    $phpWord->addFontStyle($raceNmbrText, [
        "name"=>"Univers 55",
        "size"=>7,
        "allCaps"=>false,
        "bold"=>false,
        "color"=>"000000"
    ]);
    $raceNmbrPar = "raceNmbrPar";
    $phpWord->addParagraphStyle($raceNmbrPar, [
        "spacing"=>1,
        "spaceBefore"=>0,
        "spaceAfter"=>0,
        "tabs" => [
                    new \PhpOffice\PhpWord\Style\Tab('left', $width*0.20/2+20),
        ],
//        "shading"=>["fill"=>$fondo],
    ]);
    // numero ordinal de carrera
    $raceOrdinalText = "raceOrdinalText";
    $phpWord->addFontStyle($raceOrdinalText, [
        "name"=>"Univers 65",
        "size"=>40,
        "scale"=>60,
        "allCaps"=>false,
        "bold"=>false,
        "color"=>"000000"
    ]);
    $raceOrdinalPar = "raceOrdinalPar";
    $phpWord->addParagraphStyle($raceOrdinalPar, [
        "alignment" => \PhpOffice\PhpWord\SimpleType\Jc::CENTER,
        "spacing"=>-70,
        "spaceBefore"=>0,
        "spaceAfter"=>0,
    ]);
    // dia de la semana
    $dowText = "dowText";
    $phpWord->addFontStyle($dowText, [
        "name"=>"Univers 65",
        "size"=>15,
        "scale"=>80,
        "allCaps"=>false,
        "bold"=>false,
        "color"=>"FFFFFF"
    ]);
    $dowPar = "dowPar";
    $phpWord->addParagraphStyle($dowPar, [
        "alignment" => \PhpOffice\PhpWord\SimpleType\Jc::CENTER,
        "spacing"=>-20,
        "spaceBefore"=>0,
        "spaceAfter"=>0,
        "shading"=>["fill"=>"000000"],
    ]);
    // condiciones linea uno
    $conditions1Text = "conditions1Text";
    $phpWord->addFontStyle($conditions1Text, [
        "name"=>"Univers 65",
        "scale"=>70,
        "size"=>9,
        "allCaps"=>false,
        "bold"=>false,
        "color"=>"000000",
        "sapcing"=>-5
    ]);
    $conditions1Par = "conditions1Par";
    $phpWord->addParagraphStyle($conditions1Par, [
        "spaceBefore"=>0,
        "spaceAfter"=>0,
        "alignment" => \PhpOffice\PhpWord\SimpleType\Jc::CENTER,
        "spacing"=>0,
    ]);
    // condiciones linea dos
    $conditions2Text = "conditions2Text";
    $phpWord->addFontStyle($conditions2Text, [
        "name"=>"Univers 65",
        "scale"=>70,
        "size"=>8,
        "allCaps"=>false,
        "bold"=>false,
        "color"=>"000000",
        "spacing"=> -5
    ]);
    $conditions2Par = "conditions2Par";
    $phpWord->addParagraphStyle($conditions2Par, [
        "spaceBefore"=>0,
        "spaceAfter"=>0,
        "alignment" => \PhpOffice\PhpWord\SimpleType\Jc::CENTER,
        "spacing"=>-40,
    ]);
    // premios
    $pricesTitText = "pricesTitText";
    $phpWord->addFontStyle($pricesTitText, [
        "name"=>"Univers 65",
        "scale"=>70,
        "size"=>9,
        "allCaps"=>false,
        "bold"=>false,
        "color"=>"FFFFFF"
    ]);
    $pricesTitPar = "pricesTitPar";
    $phpWord->addParagraphStyle($pricesTitPar, [
        "alignment" => \PhpOffice\PhpWord\SimpleType\Jc::CENTER,
        "spaceBefore"=>20,
        "spaceAfter"=>20,
    ]);
    $pricesText = "pricesText";
    $phpWord->addFontStyle($pricesText, [
        "name"=>"Univers 55",
        "size"=>8,
        "scale"=>70,
        "allCaps"=>false,
        "bold"=>false,
        "color"=>"000000",
        "spacing"=>-5
    ]);
    $pricesBoldText = "pricesBoldText";
    $phpWord->addFontStyle($pricesBoldText, [
        "name"=>"Univers 55",
        "scale"=>70,
        "size"=>8,
        "allCaps"=>false,
        "bold"=>true,
        "color"=>"000000",
        "spacing"=>-5
    ]);
    $pricesPar = "pricesPar";
    $phpWord->addParagraphStyle($pricesPar, [
        "alignment" => \PhpOffice\PhpWord\SimpleType\Jc::CENTER,
        "spaceBefore"=>0,
        "spaceAfter"=>0,
        "spacing"=>-20,
        "tabs" => [
            new \PhpOffice\PhpWord\Style\Tab('right', $width*0.10-20)
        ],
    ]);
    // distancia
    $distanceText = "distanceText";
    $phpWord->addFontStyle($distanceText, [
        "name"=>"Univers 75 Black",
        "scale"=>70,
        "size"=>12,
        "allCaps"=>false,
        "bold"=>true,
        "color"=>"000000"
    ]);
    $distancePar = "distancePar";
    $phpWord->addParagraphStyle($distancePar, [
        "alignment" => \PhpOffice\PhpWord\SimpleType\Jc::CENTER,
        "spaceBefore"=>80,
        "spaceAfter"=>20,
        "spacing"=>0,
    ]);
    // record
    $recordText = "recordText";
    $phpWord->addFontStyle($recordText, [
        "name"=>"Univers 65",
        "scale"=>70,
        "size"=>8,
        "allCaps"=>false,
        "bold"=>false,
        "color"=>"000000",
        "spacing"=> -5
    ]);
    $recordPar = "recordPar";
    $phpWord->addParagraphStyle($recordPar, [
        "alignment" => \PhpOffice\PhpWord\SimpleType\Jc::CENTER,
        "spacing"=>-10,
        "spaceBefore"=>0,
        "spaceAfter"=>40,
    ]);
    // jugadas
    $betText = "betText";
    $phpWord->addFontStyle($betText, [
        "name"=>"Univers 65",
        "scale"=>90,
        "size"=>8,
        "allCaps"=>true,
        "bold"=>false,
        "color"=>"000000",
        "spacing"=> 0
    ]);
    $betPar = "betPar";
    $phpWord->addParagraphStyle($betPar, [
        "alignment" => \PhpOffice\PhpWord\SimpleType\Jc::CENTER,
        "spacing"=>-10,
        "spaceBefore"=>0,
        "spaceAfter"=>0,
    ]);
    // DETALLE
    // header
    $headerText = "headerText";
    $phpWord->addFontStyle($headerText, [
        "name"=>"Univers LT 45 Light",
        "scale"=>80,
        "spacing"=>-5,
        "size"=>4.5,
        "allCaps"=>false,
        "bold"=>false,
        "color"=>"000000"
    ]);
    $headerC2Text = "headerC2Text";
    $phpWord->addFontStyle($headerC2Text, [
        "name"=>"Helvetica",
        "scale"=>90,
        "spacing"=>-5,
        "size"=>4.5,
        "allCaps"=>false,
        "bold"=>false,
        "color"=>"000000"
    ]);
    $headerPar = "headerPar";
    $phpWord->addParagraphStyle($headerPar, [
        "alignment" => \PhpOffice\PhpWord\SimpleType\Jc::CENTER,
        "spacing"=>1,
        "spaceBefore"=>0,
        "spaceAfter"=>0,
    ]);
    $headerLeftPar = "headerLeftPar";
    $phpWord->addParagraphStyle($headerLeftPar, [
        "alignment" => \PhpOffice\PhpWord\SimpleType\Jc::LEFT,
        "spacing"=>1,
        "spaceBefore"=>0,
        "spaceAfter"=>0,
    ]);

    // Horse Number
    $horseNumberText = "horseNumberText";
    $phpWord->addFontStyle($horseNumberText, [
        "name"=>"Univers 65 Bold",
        "scale"=>50,
        "spacing"=>-10,
        "size"=>24,
        "allCaps"=>false,
        "bold"=>false,
        "color"=>"000000"
    ]);
    $horseNumberPar = "horseNumberPar";
    $phpWord->addParagraphStyle($horseNumberPar, [
        "alignment" => \PhpOffice\PhpWord\SimpleType\Jc::CENTER,
        "spacing"=>0.5,
        "spaceBefore"=>0,
        "spaceAfter"=>0,
    ]);
    // Horse Details
    $horsedetailsText = "horsedetailsText";
    $phpWord->addFontStyle($horsedetailsText, [
        "name"=>"Univers 55",
        "scale" => 80,
        "spacing" => -5,
        "size"=>5,
        "allCaps"=>false,
        "bold"=>false,
        "color"=>"000000"
    ]);
    $horsedetailsPar = "horsedetailsPar";
    $phpWord->addParagraphStyle($horsedetailsPar, [
        "alignment" => \PhpOffice\PhpWord\SimpleType\Jc::LEFT,
        "spaceBefore"=>0,
        "spaceAfter"=>0,
        "tabs" => [
            new \PhpOffice\PhpWord\Style\Tab('right', $width*$C2-80)
        ],
        "spacing" => -55,
    ]);
    // horse name
    $horsenameText = "horsenameText";
    $phpWord->addFontStyle($horsenameText, [
        "name"=>"Univers LT 45 Light",
        "scale" => 80,
        "spacing" => -10,
        "size"=>9,
        "allCaps"=>true,
        "bold"=>false,
        "color"=>"000000"
    ]);
    $horsenamePar = "horsenamePar";
    $phpWord->addParagraphStyle($horsenamePar, [
        "alignment" => \PhpOffice\PhpWord\SimpleType\Jc::LEFT,
        "spaceBefore"=>0,
        "spaceAfter"=>0,
        //"spacingLineRule"=>\PhpOffice\PhpWord\SimpleType\LineSpacingRule::AT_LEAST,
        "spacing"=>-50,
    ]);
    // jockey name
    $jockeynameText = "jockeynameText";
    $phpWord->addFontStyle($jockeynameText, [
        "name"=>"Univers 65 Bold",
        //"scale" => 80,
        //"spacing" => 0.8,
        "size"=>5,
        "allCaps"=>false,
        "bold"=>false,
        "color"=>"000000"
    ]);
    $jockeynamePar = "jockeynamePar";
    $phpWord->addParagraphStyle($jockeynamePar, [
        "alignment" => \PhpOffice\PhpWord\SimpleType\Jc::CENTER,
        "spacing"=>0,
        "spaceBefore"=>0,
        "spaceAfter"=>0,
    ]);
    // jockey weight
    $jockeyweightText = "jockeyweightText";
    $phpWord->addFontStyle($jockeyweightText, [
        "name"=>"Univers LT 45 Light",
        "size"=>8,
        "allCaps"=>false,
        "bold"=>false,
        "color"=>"000000"
    ]);
    $jockeyweightPar = "jockeyweightPar";
    $phpWord->addParagraphStyle($jockeyweightPar, [
        "alignment" => \PhpOffice\PhpWord\SimpleType\Jc::CENTER,
        "spacing"=>0.8,
        "spaceBefore"=>0,
        "spaceAfter"=>0,
    ]);
    // implements
    $implementsText = "implementsText";
    $phpWord->addFontStyle($implementsText, [
        "name"=>"Univers 55",
        //"scale" => 90,
        //"spacing" => 0.8,
        "size"=>4.5,
        "allCaps"=>false,
        "bold"=>false,
        "color"=>"000000"
    ]);
    $implementsPar = "implementsPar";
    $phpWord->addParagraphStyle($implementsPar, [
        "alignment" => \PhpOffice\PhpWord\SimpleType\Jc::CENTER,
        "spacing"=>0,
        "spaceBefore"=>0,
        "spaceAfter"=>0,
    ]);
    // trainer
    $trainerText = "trainerText";
    $phpWord->addFontStyle($trainerText, [
        "name"=>"Univers 55",
        //"scale" => 80,
        //"spacing" => 0.8,
        "size"=>4.5,
        "allCaps"=>false,
        "bold"=>false,
        "color"=>"000000"
    ]);
    $trainerPar = "trainerPar";
    $phpWord->addParagraphStyle($trainerPar, [
        "alignment" => \PhpOffice\PhpWord\SimpleType\Jc::CENTER,
        "spacing"=>0,
        "spaceBefore"=>10,
        "spaceAfter"=>0,
    ]);
    // position
    $positionText = "positionText";
    $phpWord->addFontStyle($positionText, [
        "name"=>"Univers LT 45 Light",
        "scale"=>80,
        "spacing"=>-5,
        "size"=>7,
        "allCaps"=>false,
        "bold"=>true,
        "color"=>"000000"
    ]);
    $positionPar = "positionPar";
    $phpWord->addParagraphStyle($positionPar, [
        "alignment" => \PhpOffice\PhpWord\SimpleType\Jc::CENTER,
        "spacing"=>1,
        "spaceBefore"=>0,
        "spaceAfter"=>0,
    ]);
    // history data
    $historyText = "historyText";
    $phpWord->addFontStyle($historyText, [
        "name"=>"Univers 55",
        "size"=>5.1,
        "scale" => 70,
        "spacing"=>-5,
        "allCaps"=>false,
        "bold"=>false,
        "color"=>"000000"
    ]);
    $cposText = "cposText";
    $phpWord->addFontStyle($cposText, [
        "name"=>"Univers 55",
        "size"=>4,
        //"scale" => 60,
        "allCaps"=>false,
        "bold"=>false,
        "color"=>"000000"
    ]);
    $historyPar = "historyPar";
    $phpWord->addParagraphStyle($historyPar, [
        "alignment" => \PhpOffice\PhpWord\SimpleType\Jc::CENTER,
        "spacing"=>1,
        "spaceBefore"=>0,
        "spaceAfter"=>0,
    ]);
    $historyLeftPar = "historyLeftPar";
    $phpWord->addParagraphStyle($historyLeftPar, [
        "alignment" => \PhpOffice\PhpWord\SimpleType\Jc::LEFT,
        "spacing"=>1,
        "spaceBefore"=>0,
        "spaceAfter"=>0,
    ]);
    $historyRightPar = "historyRightPar";
    $phpWord->addParagraphStyle($historyRightPar, [
        "alignment" => \PhpOffice\PhpWord\SimpleType\Jc::RIGHT,
        "spacing"=>1,
        "spaceBefore"=>0,
        "spaceAfter"=>0,
    ]);
    // additional data
    $addDataText = "addDataText";
    $phpWord->addFontStyle($addDataText, [
        "name"=>"Univers LT 45 Light",
        "size"=>5.25,
        "allCaps"=>false,
        "bold"=>false,
        "color"=>"000000"
    ]);
    $addDataPar = "addDataPar";
    $phpWord->addParagraphStyle($addDataPar, [
        "alignment" => \PhpOffice\PhpWord\SimpleType\Jc::LEFT,
        "spacing"=>1,
        "spaceBefore"=>0,
        "spaceAfter"=>0,
        "tabs" => [
            new \PhpOffice\PhpWord\Style\Tab('right', $anchoHistoria-20)
        ],
    ]);
    // footer favoritos
    $footTitText = "footTitText";
    $phpWord->addFontStyle($footTitText, [
        "name"=>"Univers 65",
        "size"=>14,
        "scale" => 60,
        "spacing"=>-10,
        "allCaps"=>false,
        "bold"=>false,
        "color"=>"FFFFFF",
    ]);
    $footTitPar = "footTitPar";
    $phpWord->addParagraphStyle($footTitPar, [
        "alignment" => \PhpOffice\PhpWord\SimpleType\Jc::CENTER,
        "spacing" =>0,
        "spaceBefore"=>0,
        "spaceAfter"=>0,
        "shading"=>["fill"=>"000000"],
    ]);

    $footFavDataText = "footFavDataText";
    $phpWord->addFontStyle($footFavDataText, [
        "name"=>"Univers 65",
        "scale" => 60,
        "spacing" => -10,
        "size"=>14,
        "allCaps"=>false,
        "bold"=>false,
        "color"=>"000000",
    ]);
    $footFavDataPar = "footFavDataPar";
    $phpWord->addParagraphStyle($footFavDataPar, [
        "alignment" => \PhpOffice\PhpWord\SimpleType\Jc::LEFT,
        "spacing"=>1,
        "spaceBefore"=>0,
        "spaceAfter"=>0,
    ]);
    $footFavNamText = "footFavNamText";
    $phpWord->addFontStyle($footFavNamText, [
        "name"=>"Univers 65",
        "size"=>9.36,
        "spacing"=>-5,
        "allCaps"=>true,
        "bold"=>false,
        "color"=>"000000",
    ]);
    $footFavNamPar = "footFavNamPar";
    $phpWord->addParagraphStyle($footFavNamPar, [
        "alignment" => \PhpOffice\PhpWord\SimpleType\Jc::LEFT,
        "spacing"=>1,
        "spaceBefore"=>0,
        "spaceAfter"=>0,
        "tabs" => [
            new \PhpOffice\PhpWord\Style\Tab('left', ($width/7*5)*0.1),
            new \PhpOffice\PhpWord\Style\Tab('left', ($width/7*5)*0.7),
        ],
    ]);
    
    $ordinal = ["1a", "2a", "3a", "4a", "5a", "6a", "7a", "8a", "9a", "10a", "11a", "12a", "13a", "14s"];
    $dow = ["Domingo", "Lunes", "Martes", "Miércoles", "Jueves", "Viernes", "Sábado"];

    $top3 = "";
    $actualrace = "";
    $validcnt = 0;
    while ($row = $rs->fetch_assoc()){
        if ($row["racenumber"] != $actualrace){
            $validcnt++;
            if ($actualrace != ""){
                $foottable = $section->addTable([$defaultTableFullWidthStyle]);
                $foottable->addRow();
                $cell = $foottable->addCell($width*0.05, $blackCellStyle);
                $cell->addText("Fav.",
                                $footTitText,
                                $footTitPar
                );
                $cell = $foottable->addCell($width*0.60, $borderCellStyle);
                $cell->addText(substr($forecastdsc, 0, -3),
                                $footFavDataText,
                                $footFavDataPar
                );
                $cell = $foottable->addCell($width*0.16, $blackCellStyle);
                $cell->addText("Sin Favoritos",
                                $footTitText,
                                $footTitPar
                );
                $cell = $foottable->addCell($width*0.19, $borderCellStyle);
                $cell->addText("????",
                                $footFavDataText,
                                $footFavDataPar
                );
            }

            $actualrace = $row["racenumber"];

            // calcular los 5 mejores segun speedrating
            $sql =  "SELECT 	GROUP_CONCAT(`number` SEPARATOR '-') top5 " . 
                    "FROM 	    (SELECT number FROM racers WHERE raceid=" . $row["raceid"] . " ORDER BY speedr LIMIT 5) A";
            if (!$rs2 = $db->query($sql))
                badEnd("500", array("sql"=>$sql, "msg"=>$db->error));
            $srtop5="";
            if ($row2 = $rs2->fetch_assoc()){
                $srtop5 = $row2["top5"]; 
            }

            $section = $phpWord->addSection([
                "marginTop"=>$top,
                "marginBottom"=>$bottom,
                "marginLeft"=>$left,
                "marginRight"=>$right,
                "pageSizeH"=>$height,
                "pageSizeW"=>$width,
            ]);

            $forecastdsc = "";
            $lastfc = 0;

            // PREMIO ESPECIAL
            if ($row["extraprice"] != 0){
                $maintable = $section->addTable([$defaultTableFullWidthStyle]);
                $maintable->addRow();
                $cell = $maintable->addCell($width);

                $cell->addText("Premiación Especial Adicional: " . number_format($row["extraprice"], 2, ",", ".") . " " . $row["extrapricecurr"],
                                $initialBannerText,
                                $initialBannerPar
                );
            }


            if ($lotohip[$actualrace] == 1){
                $maintable = $section->addTable([$defaultTableFullWidthStyle]);
                $maintable->addRow();
                $cell = $maintable->addCell($width);

                $cell->addText("AQUI COMIENZA EL LOTO HIPICO",
                                $initialBannerText,
                                $initialBannerPar
                );
            }
            if ($tripleap[$actualrace] != 0){
                $maintable = $section->addTable([$defaultTableFullWidthStyle]);
                $maintable->addRow();
                $cell = $maintable->addCell($width);

                $cell->addText("TRIPLE APUESTA " . $validcnt . "-" . $validcnt+1 . "-" . $validcnt+2,
                                $initialBannerText,
                                $initialBannerPar
                );
            }
            //if ($tripleap[$actualrace] != 0)
            //    $cell->addText("TRIPLE APUESTA " . $validcnt . "-" . $validcnt+1 . "-" . $validcnt+2, $betText, $betPar);

            // Clasico
            if ($row["racetypeid"] != -1){
                $maintable = $section->addTable([$defaultTableFullWidthStyle]);
                $maintable->addRow();
                $cell = $maintable->addCell($width, $statsAreaCellStyle);
                $cell->addText($row["racetypedsc"],
                                $classicText,
                                $classicPar
                );
            }

            // ENCABEZADO DE CUATRO COLUMNAS
            $headertable = $section->addTable([$defaultTableFullWidthStyle]);
            $headertable->addRow();
                // contenido izquierda
                $cell = $headertable->addCell($width*0.20, $statsAreaCellStyle);
                    $cell->addText("\tN. " . $row["racenumber"],
                            $raceNmbrText, $raceNmbrPar);
                    $cell->addText("\t" . $row["hora"],
                            $raceNmbrText, $raceNmbrPar);
                    $cell->addText($ordinal[$row["raceord"]-1],
                            $raceOrdinalText, $raceOrdinalPar);
                    $cell->addText($dow[$row["dow"]-1],
                            $dowText, $dowPar);

                // contenido medio iz
                $cell = $headertable->addCell($width*0.40, $statsAreaCellStyle);
                    $cell->addText(mb_strtoupper($row["condicion2"]),
                            $conditions1Text, $conditions1Par);
                    $cell->addText(str_replace(" (", "<w:br/>(", $row["conditiondsc"]), $conditions2Text, $conditions2Par);
                    $cell->addText( "DISTANCIA: " . $row["distancia"] . " METROS"
                            , $distanceText, $distancePar);
                    $cell->addText( mb_strtoupper($row["recordhorse"]) . " - " .
                                    $row["recordjockey"] . " - Ks." . $row["recordweight"] . " - " .
                                    $row["recordtime"] . " - " . $row["recorddate"]
                            , $recordText, $recordPar);

                // contenido medio der
                $cell = $headertable->addCell($width*0.10, $statsAreaCellStyle);
                    $innertable = $cell->addTable([$pricesTableStyle]);
                    $innertable->addRow();
                    $innercell = $innertable->addCell($width*0.10, $blackCellStyle);
                    $innercell->addText("PREMIOS", $pricesTitText, $pricesTitPar);
                    $innertable->addRow();
                    $innercell = $innertable->addCell($width*0.10, $borderCellStyle);
                    $innercell->addText($row["pricecurr"] . ".\t" . number_format($row["mainprice"],2, ",", "."), $pricesBoldText, $pricesPar);
                    $innercell->addText("1°\t" . number_format($row["mainprice"]*$row["firstplace"]/100, 2, ",", "."), $pricesText, $pricesPar);
                    $innercell->addText("2°\t" . number_format($row["mainprice"]*$row["secondplace"]/100, 2, ",", "."), $pricesText, $pricesPar);
                    $innercell->addText("3°\t" . number_format($row["mainprice"]*$row["thirdplace"]/100, 2, ",", "."), $pricesText, $pricesPar);
                    $innercell->addText("4°\t" . number_format($row["mainprice"]*$row["fourthplace"]/100, 2, ",", "."), $pricesText, $pricesPar);
                    $innercell->addText("5°\t" . number_format($row["mainprice"]*$row["fifthplace"]/100, 2, ",", "."), $pricesText, $pricesPar);

                // contenido derecha
                $statscell = $headertable->addCell($width*0.30, $statsAreaCellStyle);
                    if ($pool4[$actualrace] != "0")
                        $statscell->addText($pool4[$actualrace] . "ª Pool de 4", $betText, $betPar);
                    //if ($lotohip[$actualrace] != 0)
                    //    $statscell->addText($lotohip[$actualrace] . "ª" . " LOTO HIPICO", $betText, $betPar);
                    //if ($tripleap[$actualrace] != 0)
                    //    $statscell->addText("TRIPLE APUESTA " . $validcnt . "-" . $validcnt+1 . "-" . $validcnt+2, $betText, $betPar);
                    if ($doblep[$actualrace] != 0)
                        $statscell->addText($doblep[$actualrace] . "ª DOBLE PERFECTA", $betText, $betPar);


            // ENCABEZADO DEL DETALLE
            $detailtable = $section->addTable([$defaultTableFullWidthStyle]);
                $detailtable->addRow();
                $cell = $detailtable->addCell($width*$C1, $headerCellFullBrdStyle);
                $cell->addText( "N°", $headerText, $headerPar);

                $cell = $detailtable->addCell($width*$C2, $headerCellFullBrdStyle);
                $cell->addText( "Propietario, Divisa, Ejemplar, Sexo, Pelaje, Edad, Padres y Origen"
                        , $headerC2Text, $headerPar);

                $cell = $detailtable->addCell($width*$C3, $headerCellFullBrdStyle);
                $cell->addText( "Jinete, Ks, Imple-<w:br/>mentos, Prep."
                        , $headerText, $headerPar);

                $cell = $detailtable->addCell($width*$C4, $headerCellFullBrdStyle);
                $cell->addText( "PP"
                        , $headerText, $headerPar);

                //$cell = $detailtable->addCell($width*$C16, $headerCellTopDwnBrdStyle);
                //$cell->addText( "Ind"
                //        , $headerText, $headerPar);
                //$cell->addText( "Vel."
                //        , $headerText, $headerPar);

                $cell = $detailtable->addCell($width*$C5, $headerCellTopDwnBrdStyle);
                $cell->addText( "Fecha"
                        , $headerText, $headerPar);

                $cell = $detailtable->addCell($width*$C6, $headerCellTopDwnBrdStyle);
                $cell->addText( "Carr.<w:br/>ant."
                        , $headerText, $headerPar);

                $cell = $detailtable->addCell($width*$C7, $headerCellTopDwnBrdStyle);
                $cell->addText( "Peso<w:br/>Ejem"
                        , $headerText, $headerPar);

                $cell = $detailtable->addCell($width*$C8, $headerCellTopDwnBrdStyle);
                $cell->addText( "Dtcia"
                        , $headerText, $headerPar);

                $cell = $detailtable->addCell($width*$C9, $headerCellTopDwnBrdStyle);
                $cell->addText( "PP"
                        , $headerText, $headerPar);

                $cell = $detailtable->addCell($width*$C10, $headerCellTopDwnBrdStyle);
                $cell->addText( "1000<w:br/>300m"
                        , $headerText, $headerPar);

                $cell = $detailtable->addCell($width*$C11, $headerCellTopDwnBrdStyle);
                $cell->addText( "Lleg"
                        , $headerText, $headerPar);

                $cell = $detailtable->addCell($width*$C11_1, $headerCellTopDwnBrdStyle);
                $cell->addText( "Ks"
                        , $headerText, $headerPar);

                $cell = $detailtable->addCell($width*$C12, $headerCellTopDwnBrdStyle);
                $cell->addText( "Jinete     Divid"
                        , $headerText, $headerLeftPar);

                $cell = $detailtable->addCell($width*$C13, $headerCellTopDwnBrdStyle);
                $cell->addText( "Ganador"
                        , $headerText, $headerPar);

                $cell = $detailtable->addCell($width*$C14, $headerCellTopDwnBrdStyle);
                $cell->addText( "Cpos"
                        , $headerText, $headerPar);

                $cell = $detailtable->addCell($width*$C15, $headerCellTopDwnBrdStyle);
                $cell->addText( "Serie"
                        , $headerText, $headerPar);

                $cell = $detailtable->addCell($width*$C17, $headerCellTopDwnBrdStyle);
                $cell->addText( "Tmpo Gndor"
                        , $headerText, $headerPar);

                $cell = $detailtable->addCell($width*$C18, $headerCellRightBrdStyle);
                $cell->addText( "Tmpo Ejem"
                        , $headerText, $headerPar);

//                $cell = $detailtable->addCell($width*$C19, $headerCellStyle);
//                $cell->addText( "# Ejs"
//                        , $headerText, $headerPar);

            $top3 = $row["top3"];
        }
        // RENGLONES

        // Calcular actuaciones

        // Verificar información de pronósticos
        $racersfc = array();
        if (strlen($row["forecastracers"]))
            $racersfc = json_decode($row["forecastracers"]);

        $proncmt = getHorseForecasts($row["racerid"], $racersfc);
        if ($proncmt->forecast > 0 && $proncmt->forecast <= 3){
            if ($lastfc < $proncmt->forecast)
                $forecastdsc .= $row["horsename"] . " - ";
            else
                $forecastdsc = $row["horsename"] . " - " . $forecastdsc;
            $lastfc = $proncmt->forecast;
        }

        $detailtable->addRow();
        $cell = $detailtable->addCell($width*$C1, $detailCellStyleFullBrd);
            $cell->addText( $row["horsenumber"]
                    , $horseNumberText, $horseNumberPar);

        $cell = $detailtable->addCell($width*$C2, $detailCellStyleFullBrd);
            $cell->addText( "Stud " . clnprn($row["studname"]) . " - " . clnprn($row["studabbr"])
                    , $horsedetailsText, $horsedetailsPar);
            $cell->addText( $row["horsename"], $horsenameText, $horsenamePar);
            $cell->addText( $row["horsefather"] . " - " . $row["horsemother"]
                    , $horsedetailsText, $horsedetailsPar);

        $cell = $detailtable->addCell($width*$C3, $detailCellStyleFullBrd);
            $cell->addText( $row["jockeyname"]
                    , $jockeynameText, $jockeynamePar);
            $cell->addText( "Ks. " . $row["jockeyweight"]
                , $jockeyweightText, $jockeyweightPar);
            // medicamentos
            $medicaments = [];
            if (strlen($row["medicaments"]))
                $medicaments = json_decode($row["medicaments"]);
            $meds = "";
            foreach($medicaments as $medicament)
                $meds .= $medicament->abbr . ".";
            if ($meds == "") $meds = "--";
            // implementos
            $implements = [];
            if (strlen($row["implements"]))
                $implements = json_decode($row["implements"]);
            $imps = "";
            foreach($implements as $implement)
                $imps .= $implement->abbr . ".";
            if ($imps == "") $imps = "--";
            $cell->addText( $imps
                , $implementsText, $implementsPar);
            $cell->addText( $row["trainername"]
                , $trainerText, $trainerPar);

        $cell = $detailtable->addCell($width*$C4, $detailCellStyleFullBrd);
            $cell->addText( $row["horseposition"]
                , $positionText, $positionPar);

        $cell = $detailtable->addCell($anchoHistoria, $detailCellSpanStyleFullBrd); //XX

            //$htsareatable = $cell->addTable([$defaultTableHstWidthStyle]);
            // historia
            $hsttable = $cell->addTable([$defaultTableHstWidthStyle]);
            $sql3 = "SELECT     * " .
                    "FROM " .
                    "(" .
                    "SELECT     * " .
                    "FROM       wrk_horsehistory " .
                    "WHERE      horseid = " . $row["horseid"] . " " .
                    "AND        raceid <> " . $row["raceid"] . " " .
                    "AND        date < '"   . $row["reuniondate"] . "' " .
                    "ORDER BY   date " .
                    "LIMIT 4 " .
                    ") A " .
                    "ORDER BY   date DESC ";
            if (!$rs3 = $db->query($sql3))
                badEnd("500", array("sql"=>$sql, "msg"=>$db->error));
            for  ($i=0; $i<4; $i++){
            //while ($row3 = $rs3->fetch_assoc()){
                if ($row3 = $rs3->fetch_assoc()){
                    $hsttable->addRow(-112);
                    //$cell = $hsttable->addCell($width*$C16, $detailCellStyle);
                    //    $cell->addText(number_format($row3["srating"],0,",","."), $historyText, $historyPar);
                    $cell = $hsttable->addCell($width*$C5, $detailCellStyle);
                        $cell->addText(date_format(date_create($row3["date"]), 'd-m'), $historyText, $historyPar);
                    $cell = $hsttable->addCell($width*$C6, $detailCellStyle);
                        $cell->addText($row3["racecourseabbr"].$row3["racenumber"], $historyText, $historyRightPar);
                    $cell = $hsttable->addCell($width*$C7, $detailCellStyle);
                        $cell->addText($row3["weight"], $historyText, $historyPar);
                    $cell = $hsttable->addCell($width*$C8, $detailCellStyle);
                        $cell->addText($row3["distancename"], $historyText, $historyPar);
                    $cell = $hsttable->addCell($width*$C9, $detailCellStyle);
                        $cell->addText($row3["position"], $historyText, $historyPar);
                    $cell = $hsttable->addCell($width*$C10, $detailCellStyle);
                        $cell->addText($row3["pos400"]." ".$row3["pos800"], $historyText, $historyPar);
                    $cell = $hsttable->addCell($width*$C11, $detailCellStyle);
                        $cell->addText($row3["arrivalposition"], $historyText, $historyPar);
                    $cell = $hsttable->addCell($width*$C11_1, $detailCellStyle);
                        $cell->addText($row3["jockeyweight"], $historyText, $historyPar);
                    $cell = $hsttable->addCell($width*$C12, $detailCellStyle);
                        $cell->addText($row3["jockeyabbr"].",".$row3["dividends"], $historyText, $historyLeftPar);
                    $cell = $hsttable->addCell($width*$C13, $detailCellStyle);
                        $cell->addText(norm($row3["winnerdsc"]), $historyText, $historyRightPar);
                    $cell = $hsttable->addCell($width*$C14, $detailCellStyle);
                        $cell->addText($row3["bodiesabbr"] == '' ? $blank : $row3["bodiesabbr"], $cposText, $historyRightPar);
                    $cell = $hsttable->addCell($width*$C15, $detailCellStyle);
                        $cell->addText(substr($row3["serie"], 0, 6), $historyText, $historyPar);
                    $cell = $hsttable->addCell($width*$C17, $detailCellStyle);
                        $cell->addText(number_format($row3["winnertime"],1,",","."), $historyText, $historyRightPar);
                    $cell = $hsttable->addCell($width*$C18, $detailCellStyle);
                        $cell->addText(number_format($row3["finishtime"],1,",","."), $historyText, $historyRightPar);
//                    $cell = $hsttable->addCell($width*$C19, $detailCellStyle);
//                        $cell->addText($row3["horsenumber"], $historyText, $historyPar);
                }else{
                    // si estamos en el primer renglon significa que no hay información del caballo así que se imprimen las observacones
                    if ($i==0){
                        $hsttable->addRow(-112*4);
                        $cell = $hsttable->addCell($anchoHistoria, $detailCellSpanStyle);
                            $cell->addText($row["horseobs"], $historyText, $historyLeftPar);
                        $i = 4;
                    }else{
                        $hsttable->addRow(-112);
                        //$cell = $hsttable->addCell($width*$C16, $detailCellStyle);
                        //    $cell->addText($blank, $historyText, $historyPar);
                        $cell = $hsttable->addCell($width*$C5, $detailCellStyle);
                            $cell->addText($blank, $historyText, $historyPar);
                        $cell = $hsttable->addCell($width*$C6, $detailCellStyle);
                            $cell->addText($blank, $historyText, $historyPar);
                        $cell = $hsttable->addCell($width*$C7, $detailCellStyle);
                            $cell->addText($blank, $historyText, $historyPar);
                        $cell = $hsttable->addCell($width*$C8, $detailCellStyle);
                            $cell->addText($blank, $historyText, $historyPar);
                        $cell = $hsttable->addCell($width*$C9, $detailCellStyle);
                            $cell->addText($blank, $historyText, $historyPar);
                        $cell = $hsttable->addCell($width*$C10, $detailCellStyle);
                            $cell->addText($blank, $historyText, $historyPar);
                        $cell = $hsttable->addCell($width*$C11, $detailCellStyle);
                            $cell->addText($blank, $historyText, $historyPar);
                        $cell = $hsttable->addCell($width*$C11_1, $detailCellStyle);
                            $cell->addText($blank, $historyText, $historyPar);
                        $cell = $hsttable->addCell($width*$C12, $detailCellStyle);
                            $cell->addText($blank, $historyText, $historyPar);
                        $cell = $hsttable->addCell($width*$C13, $detailCellStyle);
                            $cell->addText($blank, $historyText, $historyPar);
                        $cell = $hsttable->addCell($width*$C14, $detailCellStyle);
                            $cell->addText($blank, $historyText, $historyPar);
                        $cell = $hsttable->addCell($width*$C15, $detailCellStyle);
                            $cell->addText($blank, $historyText, $historyPar);
                        $cell = $hsttable->addCell($width*$C17, $detailCellStyle);
                            $cell->addText($blank, $historyText, $historyPar);
                        $cell = $hsttable->addCell($width*$C18, $detailCellStyle);
                            $cell->addText($blank, $historyText, $historyPar);
//                        $cell = $hsttable->addCell($width*$C19, $detailCellStyle);
//                            $cell->addText($blank, $historyText, $historyPar);
                    }
                }
            }
            // addional info
            $hsttable->addRow(-112);
            $cell = $hsttable->addCell($anchoHistoria, $detailCellSpanStyle);
                $cell->addText( "De " . $row["totalraces"] . "-" . $row["totalwin"] . "(-)," 
//                                "De " . $row["totalracesyear"] . "-" . $row["totalwinyear"] . "(-) "
                                . $proncmt->comment . " " . $meds
                                . "\t" . clnprn($row["harasname"]) . " " . $row["pricecurr"] . ". " . number_format($row["harasbs"],2,",",".")
                                , $addDataText, $addDataPar);


    }
    if ($actualrace != ""){
        $foottable = $section->addTable([$defaultTableFullWidthStyle]);
        $foottable->addRow();
        $cell = $foottable->addCell($width*0.05, $blackCellStyle);
        $cell->addText("Fav.",
                        $footTitText,
                        $footTitPar
        );
        $cell = $foottable->addCell($width*0.60, $borderCellStyle);
        $cell->addText(substr($forecastdsc, 0, -3),
                        $footFavDataText,
                        $footFavDataPar
        );
        $cell = $foottable->addCell($width*0.16, $blackCellStyle);
        $cell->addText("Sin Favoritos",
                        $footTitText,
                        $footTitPar
        );
        $cell = $foottable->addCell($width*0.19, $borderCellStyle);
        $cell->addText("???",
                        $footFavDataText,
                        $footFavDataPar
        );
    }


    switch ($outputformat){
        case "pdf":
            $domPdfPath = realpath(__DIR__ . '/../../../hooks/Dompdf/Dompdf');
            \PhpOffice\PhpWord\Settings::setPdfRendererPath($domPdfPath);
            \PhpOffice\PhpWord\Settings::setPdfRendererName('DomPDF');
            
            $objWriter = \PhpOffice\PhpWord\IOFactory::createWriter($phpWord , 'PDF');
            $temp_file = tempnam(sys_get_temp_dir(), 'PHPWord');
            $objWriter->save($temp_file);
            break;
        case "docx":
            $objWriter = \PhpOffice\PhpWord\IOFactory::createWriter($phpWord, 'Word2007');
            $temp_file = tempnam(sys_get_temp_dir(), 'PHPWord');
            $objWriter->save($temp_file);
            break;
        default:
            die ("FORMATO DE SALIDA INVALIDO");
    }

    header("Content-Disposition: attachment; filename=" . $filename);
    readfile($temp_file); // or echo file_get_contents($temp_file);
    unlink($temp_file);

    function norm($dsc){
        $out = ucwords(mb_strtolower($dsc, 'UTF-8'));
        $out = str_replace(" De ", " de ", $out);
        $out = str_replace(" La ", " la ", $out);
        $out = str_replace(" El ", " el ", $out);
        $out = str_replace(" En ", " en ", $out);
        return($out);
    }
    function getHorseForecasts($racerid, $json){
        $salida = json_decode(json_encode(["id"=>0, "number"=>0, "arrivalposition"=>0, "forecast"=>0, "comment"=>"--"]));

        foreach($json as $pron){
            if ($pron->id == $racerid){
                $salida = $pron;
            }
        }
        return($salida);
    }
    function clnprn($valor){
        return (trim(preg_replace("/[^a-zA-Z0-9 \"\'.,:\-()+*\/áéíóúñüÁÉÍÓÚÑÜ]+/", "", str_replace("&", "y", $valor))));
    }
?>