<?php
require '../../../hooks/autoload.php';
use \PhpOffice\PhpWord\PhpWord;

$phpWord = new PhpWord();

$fontStyleName = 'rStyle';
$phpWord->addFontStyle($fontStyleName, ['bold' => true, 'italic' => true, 'size' => 16, 'allCaps' => true, 'doubleStrikethrough' => true]);

$paragraphStyleName = 'pStyle';
$phpWord->addParagraphStyle($paragraphStyleName, ['alignment' => \PhpOffice\PhpWord\SimpleType\Jc::CENTER, 'spaceAfter' => 100]);

$phpWord->addTitleStyle(1, ['bold' => true], ['spaceAfter' => 240]);

// New portrait section
$section = $phpWord->addSection();

// Simple text
$section->addTitle('TAMAÑOS DE LETRAS', 1);
$section->addText('Este es tamaño 5', ["size"=>5]);
$section->addText('Este es tamaño 5.25', ["size"=>5.25]);
$section->addText('Este es tamaño 5.5', ["size"=>5.5]);
$section->addText('Este es tamaño 5.75', ["size"=>5.75]);
$section->addText('Este es tamaño 6', ["size"=>6]);
/*
// $pStyle = new Font();
// $pStyle->setLang()
$section->addText('Ce texte-ci est en français.', ['lang' => \PhpOffice\PhpWord\Style\Language::FR_BE]);

// Two text break
$section->addTextBreak(2);

// Define styles
$section->addText('I am styled by a font style definition.', $fontStyleName);
$section->addText('I am styled by a paragraph style definition.', null, $paragraphStyleName);
$section->addText('I am styled by both font and paragraph style.', $fontStyleName, $paragraphStyleName);

$section->addTextBreak();

// Inline font style
$fontStyle['name'] = 'Times New Roman';
$fontStyle['size'] = 20;

$textrun = $section->addTextRun();
$textrun->addText('I am inline styled ', $fontStyle);
$textrun->addText('with ');
$textrun->addText('color', ['color' => '996699']);
$textrun->addText(', ');
$textrun->addText('bold', ['bold' => true]);
$textrun->addText(', ');
$textrun->addText('italic', ['italic' => true]);
$textrun->addText(', ');
$textrun->addText('underline', ['underline' => 'dash']);
$textrun->addText(', ');
$textrun->addText('strikethrough', ['strikethrough' => true]);
$textrun->addText(', ');
$textrun->addText('doubleStrikethrough', ['doubleStrikethrough' => true]);
$textrun->addText(', ');
$textrun->addText('superScript', ['superScript' => true]);
$textrun->addText(', ');
$textrun->addText('subScript', ['subScript' => true]);
$textrun->addText(', ');
$textrun->addText('smallCaps', ['smallCaps' => true]);
$textrun->addText(', ');
$textrun->addText('allCaps', ['allCaps' => true]);
$textrun->addText(', ');
$textrun->addText('fgColor', ['fgColor' => 'yellow']);
$textrun->addText(', ');
$textrun->addText('scale', ['scale' => 200]);
$textrun->addText(', ');
$textrun->addText('spacing', ['spacing' => 120]);
$textrun->addText(', ');
$textrun->addText('kerning', ['kerning' => 10]);
$textrun->addText('. ');

// Link
$section->addLink('https://github.com/PHPOffice/PHPWord', 'PHPWord on GitHub');
$section->addTextBreak();
*/
$outputformat="docx";
switch ($outputformat){
    case "pdf":
        $domPdfPath = realpath(__DIR__ . '/../../../hooks/Dompdf/Dompdf');
        \PhpOffice\PhpWord\Settings::setPdfRendererPath($domPdfPath);
        \PhpOffice\PhpWord\Settings::setPdfRendererName('DomPDF');
        \PhpOffice\PhpWord\Settings::setPdfRendererOptions([
            'font' => 'Helvetica',
        ]);
        
        $objWriter = \PhpOffice\PhpWord\IOFactory::createWriter($phpWord , 'PDF');
        $temp_file = tempnam(sys_get_temp_dir(), 'PHPWord');
        $objWriter->save($temp_file);
        break;
    case "docx":
        $objWriter = \PhpOffice\PhpWord\IOFactory::createWriter($phpWord, 'Word2007');
        $temp_file = tempnam(sys_get_temp_dir(), 'PHPWord');
        $objWriter->save($temp_file);
        break;
    default:
        die ("FORMATO DE SALIDA INVALIDO");
}

header("Content-Disposition: attachment; filename=" . basename($_SERVER['PHP_SELF'],".php") . "." . $outputformat);
readfile($temp_file); // or echo file_get_contents($temp_file);
unlink($temp_file);

?>