<?php
    require '../../../hooks/autoload.php';
    use \PhpOffice\PhpWord\PhpWord;
    use \PhpOffice\PhpWord\SimpleType\Border;
    use \PhpOffice\PhpWord\ComplexType\TblWidth;

    include("../../../settings/dbconn.php");
    include("../../../settings/utils.php");

    // forzar a que se haga un POST y no un GET
    if ($_SERVER['REQUEST_METHOD']!= "GET")
        badEnd("400", array("msg"=>"Debe llamarse al servicio usando un GET"));
    // parametros obligatorios
    $parmsob = array("reunionid", "sessionid");
    if (!parametrosValidos($_REQUEST, $parmsob))
        badEnd("400", array("msg"=>"Parametros obligatorios " . implode(", ", $parmsob)));

    $sessionid = preg_replace("/[^a-zA-Z0-9]+/", "", $_REQUEST["sessionid"]);
    $reunionid = intval($_REQUEST["reunionid"]);

    $outputformat = "docx";
    if (isset($_REQUEST["format"]))
        $outputformat = preg_replace("/[^docxpf]+/", "", strtolower($_REQUEST["format"]));
    if ($outputformat != "docx" && $outputformat != "pdf" )
        badEnd("500", array("msg"=>"Los formatos validos son 'pdf' y 'docx"));

    isSessionValid($db, $sessionid);

    // conseguir fecha e hipodromo de la reunión
    $sql =  "SELECT 	R.date, R.racecourseid, H.dsc, H.abbr rcabbr, DAYOFWEEK(R.date) dow " .
            "FROM 		reunions R " .
            "INNER JOIN racecourses H " .
            "ON         R.racecourseid = H.id " .
            "WHERE      R.id = " . $reunionid . " ";
    if (!$rs = $db->query($sql))
        badEnd("500", array("sql"=>$sql, "msg"=>$db->error));
    if (!$row = $rs->fetch_assoc())
        badEnd("409", array("msg"=>"Reunion no encontrada"));
    $date = $row["date"];
    $dow = ["D", "L", "M", "X", "J", "V", "S"];
    $dayletter = $dow[$row["dow"]-1];
    $racecourseid = $row["racecourseid"];
    $racecourse = $row["dsc"];
    $rcabbr = $row["rcabbr"];

    $actualmonth = intval(date('m', strtotime($date)));
    if ($actualmonth <= 4)
        $datefrom4 = "01";
    else if ($actualmonth <= 8)
        $datefrom4 = "05";
    else if ($actualmonth <= 12)
        $datefrom4 = "09";
    $datefrom4 = date('Y', strtotime($date)) . "-" . $datefrom4 . "-01";
    $datefrom = date('Y-m-d', strtotime('first day of January '. date('Y', strtotime($date)) ));
    // SOlo para Caracas
    if ($racecourseid == 2)
        $datefrom = $datefrom4;
    $dateto =   date('Y-m-d', strtotime('-1 day', strtotime($date)));

    //obtener primera carrera de la reunión para efectos del nombre
    $sql =  "SELECT LPAD(MIN(number), 3, '0') num FROM races WHERE reunionid=" . $reunionid;
    if (!$rs = $db->query($sql))
        badEnd("500", array("sql"=>$sql, "msg"=>$db->error));
    if (!$row = $rs->fetch_assoc())
        badEnd("409", array("msg"=>"Reunion no encontrada"));
    $filename = "G" . $rcabbr . "EJ" . $row["num"] . "." . $outputformat;

    $sql =  "SELECT     CONCAT(SUBSTRING_INDEX(J.lastnames, ' ', 1), ' ', SUBSTR(J.names, 1, 1), '.') jockeyname, J.id jockeyid, SJ.prices, SJ.firstplace, SJ.secondplace, " . 
            "           SJ.thirdplace, SJ.fourthplace, SJ.fifthplace, SJ.firstplacedate, " . 
            "           SJ.noplace, SJ.nowinplace, SJ.totalraces, SJ.firstplace5, SJ.totalraces5, SJ.efectiveness, SJ.rend " . 
            "FROM       (SELECT     J.* " . 
            "           FROM        (select @df:='" . $datefrom . "' f, @dt:='" . $dateto . "' t) a, stats_jockeys J " . 
            "           WHERE       J.racecourseid=" . $racecourseid . ") SJ " . 
            "INNER JOIN jockeys J " . 
            "ON         SJ.jockeyid = J.id " . 
            "INNER JOIN racers R " . 
            "ON         J.id=R.jockeyid " . 
            "INNER JOIN races RA " . 
            "ON         R.raceid=RA.id " . 
            "WHERE      RA.reunionid=" . $reunionid . " " . 
            "ORDER BY   SJ.firstplace DESC, SJ.secondplace DESC, SJ.thirdplace DESC, SJ.fourthplace DESC, SJ.fifthplace DESC ";
    $sql =  "SELECT     jockeyname, jockeyid, prices, firstplace, secondplace, thirdplace, fourthplace, fifthplace, " . 
            "           noplace, nowinplace, totalraces, firstplace5, totalraces5, efectiveness, rend, firstplacedate " . 
            "FROM       (" . $sql . ") A " . 
            "GROUP BY   jockeyname, jockeyid, prices, firstplace, secondplace, thirdplace, fourthplace, fifthplace, ".
            "           noplace, nowinplace, totalraces, firstplace5, totalraces5, efectiveness, rend, firstplacedate ";
    if (!$rs = $db->query($sql))
        badEnd("500", array("sql"=>$sql, "msg"=>$db->error));
    $sql =  "SELECT     CONCAT(SUBSTRING_INDEX(T.lastnames, ' ', 1), ' ', SUBSTR(T.names, 1, 1), '.') trainername, T.id trainerid, ST.prices, ST.firstplace, ST.secondplace, " . 
            "           ST.thirdplace, ST.fourthplace, ST.fifthplace, ST.firstplacedate, " . 
            "           ST.noplace, ST.nowinplace, ST.totalraces, ST.firstplace5, ST.totalraces5, ST.efectiveness, ST.rend " . 
            "FROM       (SELECT     T.* " . 
            "           FROM        (select @df:='" . $datefrom . "' f, @dt:='" . $dateto . "' t) a, stats_trainers T " . 
            "           WHERE       T.racecourseid=" . $racecourseid . ") ST " . 
            "INNER JOIN trainers T " . 
            "ON         ST.trainerid = T.id " .
            "INNER JOIN racers R " . 
            "ON         T.id=R.trainerid " . 
            "INNER JOIN races RA " . 
            "ON         R.raceid=RA.id " . 
            "WHERE      RA.reunionid=" . $reunionid . " " . 
            "ORDER BY   ST.firstplace DESC, ST.secondplace DESC, ST.thirdplace DESC, ST.fourthplace DESC, ST.fifthplace DESC ";
    $sql =  "SELECT     trainername, trainerid, prices, firstplace, secondplace, thirdplace, fourthplace, fifthplace, " . 
            "           noplace, nowinplace, totalraces, firstplace5, totalraces5, efectiveness, rend, firstplacedate " . 
            "FROM       (" . $sql . ") A " . 
            "GROUP BY   trainername, trainerid, prices, firstplace, secondplace, thirdplace, fourthplace, fifthplace, " .
            "           noplace, nowinplace, totalraces, firstplace5, totalraces5, efectiveness, rend, firstplacedate ";
    if (!$rs2 = $db->query($sql))
        badEnd("500", array("sql"=>$sql, "msg"=>$db->error));

    // Creating the new document...
    $phpWord = new PhpWord();

    $pulgada = 1440;
    $height = 8.07*$pulgada;  // 1440 twip = 1 pulgada
    $width = 5.32*$pulgada;
    $top = 0;
    $bottom = 0;
    $left = 0;
    $right = 0;
    $columnspaces = 0;
    $blank = chr(194) . chr(160);

    // colores
    $cyan = "00AEEF";
    $cyanlight = "C1EFFF";
    $bgGray = "CECECE";

    // anchura de columnas
    $tmpwidth = $width - 50;
    $C1  = ($tmpwidth/2) * 0.06;
    $C2  = ($tmpwidth/2) * 0.24;
    $C3  = ($tmpwidth/2) * 0.15;
    $C4  = ($tmpwidth/2) * 0.04;
    $C5  = ($tmpwidth/2) * 0.04;
    $C6  = ($tmpwidth/2) * 0.04;
    $C7  = ($tmpwidth/2) * 0.04;
    $C8  = ($tmpwidth/2) * 0.04;
    $C9  = ($tmpwidth/2) * 0.05;
    $C10 = ($tmpwidth/2) * 0.05;
    $C11 = ($tmpwidth/2) * 0.05;
    $C12 = ($tmpwidth/2) * 0.11;
    $C13 = ($tmpwidth/2) * 0.04;
    $C14 = ($tmpwidth/2) * 0.05;

    $widthcampana = $C1+$C2+$C3+$C4+$C5+$C6+$C7+$C8+$C9+$C10+$C11+$C12;
    $width5Y6 = $C13+$C14;

    // ESTILOS
    // Celdas
    $headerCellStyle = [
        //"bgColor"=>$cyan,
        "valign" => "center",
        //"borderColor" => "FF0000",
        "borderSize" => 0,
        "borderStyle" => Border::NONE,
    ];
    $statsGroupCellStyle = [
        "gridSpan" => 12,
        "bgColor"=>$bgGray,
        "valign" => "center",
        "borderTopSize" => 7,
        "borderTopColor" => "000000",
        "borderBottomSize" => 7,
        "borderBottomColor" => "000000",
        "borderLeftSize" => 0,
        "borderLeftStyle" => Border::NONE,
        "borderRightSize" => 0,
        "borderRightStyle" => Border::NONE,
    ];
    $statsGroupLeftBrdCellStyle = [
        "gridSpan" => 12,
        "bgColor"=>$bgGray,
        "valign" => "center",
        "borderTopSize" => 7,
        "borderTopColor" => "000000",
        "borderBottomSize" => 7,
        "borderBottomColor" => "000000",
        "borderLeftSize" => 7,
        "borderLeftColor" => "000000",
        "borderRightSize" => 0,
        "borderRightStyle" => Border::NONE,
    ];
    $statsGroupRightBrdCellStyle = [
        "gridSpan" => 12,
        "bgColor"=>$bgGray,
        "valign" => "center",
        "borderTopSize" => 7,
        "borderTopColor" => "000000",
        "borderBottomSize" => 7,
        "borderBottomColor" => "000000",
        "borderRightSize" => 7,
        "borderRightColor" => "000000",
        "borderLeftSize" => 0,
        "borderLeftStyle" => Border::NONE,
    ];
    $statsGroup5Y6CellStyle = [
        "gridSpan" => 2,
        "bgColor"=>$bgGray,
        "valign" => "center",
        "borderTopSize" => 7,
        "borderTopColor" => "000000",
        "borderBottomSize" => 7,
        "borderBottomColor" => "000000",
        "borderRightSize" => 0,
        "borderRightStyle" => Border::NONE,
        "borderLeftSize" => 0,
        "borderLeftStyle" => Border::NONE,
    ];
    $statsGroup5Y6RightBrdCellStyle = [
        "gridSpan" => 2,
        "bgColor"=>$bgGray,
        "valign" => "center",
        "borderTopSize" => 7,
        "borderTopColor" => "000000",
        "borderBottomSize" => 7,
        "borderBottomColor" => "000000",
        "borderRightSize" => 7,
        "borderRightColor" => "000000",
        "borderLeftSize" => 0,
        "borderLeftStyle" => Border::NONE,
    ];
    $statsHeaderCellStyle = [
        "valign" => "center",
        "borderTopSize" => 7,
        "borderBottomSize" => 7,
        "borderLeftSize" => 0,
        "borderLeftStyle" => Border::NONE,
        "borderRightSize" => 0,
        "borderRightStyle" => Border::NONE,
    ];
    $statsHeaderRightBlueCellStyle = [
        "valign" => "center",
        "borderTopSize" => 7,
        "borderBottomSize" => 7,
        "borderLeftSize" => 0,
        "borderLeftStyle" => Border::NONE,
        "borderRightSize" => 7,
        "borderRightColor" => $cyan,
    ];
    $statsHeaderLeftCellStyle = [
        "valign" => "center",
        "borderTopSize" => 7,
        "borderBottomSize" => 7,
        "borderLeftSize" => 7,
        "borderRightSize" => 0,
        "borderRightStyle" => Border::NONE,
    ];
    $statsHeaderRightCellStyle = [
        "valign" => "center",
        "borderTopSize" => 7,
        "borderBottomSize" => 7,
        "borderLeftSize" => 0,
        "borderLeftStyle" => Border::NONE,
        "borderRightSize" => 7,
    ];
    $jockCellStyle = [
        "gridSpan" => 14,
        "valign" => "top",
        "borderSize" => 6,
        "borderColor" => $cyan,
        //"borderLeftColor" => $cyan,
        //"borderLeftSize" => 6,
        //"borderRightColor" => $cyan,
        //"borderRightSize" => 6,
        //"borderTopColor" => $cyan,
        //"borderTopSize" => 6,
        //"borderBottomColor" => $cyan,
        //"borderBottomSize" => 6,
    ];
    $traiCellStyle = [
        "gridSpan" => 14,
        "valign" => "top",
        "borderSize" => 6,
        "borderColor" => $cyan,
        //"borderLeftColor" => $cyan,
        //"borderLeftSize" => 6,
        //"borderRightColor" => $cyan,
        //"borderRightSize" => 6,
        //"borderTopColor" => $cyan,
        //"borderTopSize" => 6,
        //"borderBottomColor" => $cyan,
        //"borderBottomSize" => 6,
    ];
    $jocktraiDetCellStyle = [
        "valign" => "center",
        "borderSize" => 0,
        "borderStyle" => Border::NONE,
    ];
    $jocktraiDetRightBlueCellStyle = [
        "valign" => "center",
        "borderLeftSize" => 0,
        "borderLeftStyle" => Border::NONE,
        "borderTopSize" => 0,
        "borderTopStyle" => Border::NONE,
        "borderBottomSize" => 0,
        "borderBottomStyle" => Border::NONE,
        "borderRightColor" => $cyan,
        "borderRightSize" => 6,
    ];
    // Tablas
    $headerTableStyle = "headerTableStyle";
    $phpWord->addTableStyle($headerTableStyle,[
            "width" => $width+50,
            "bgColor"=>$cyan,
            "borderColor" => "000000",
            "borderSize" => 7,
            "alignment" => \PhpOffice\PhpWord\SimpleType\JcTable::CENTER,
            "cellMargin" => 0,
            "cellSpacing" => 0,
            "layout" => \PhpOffice\PhpWord\Style\Table::LAYOUT_FIXED,
        ], $headerCellStyle, $headerCellStyle);
    $statsTableStyle = "statsTableStyle";
    $phpWord->addTableStyle($statsTableStyle,[
            "width" => $width,
            "borderColor" => "FFFFFF",
            "borderSize" => 0,
            "borderStyle" => Border::NONE,
            "alignment" => \PhpOffice\PhpWord\SimpleType\JcTable::CENTER,
            "cellMargin" => 0,
            "cellSpacing" => 0,
            "layout" => \PhpOffice\PhpWord\Style\Table::LAYOUT_FIXED,
        ], $headerCellStyle, $headerCellStyle);
    $jocktraiTableStyle = "jocktraiTableStyle";
    $phpWord->addTableStyle($jocktraiTableStyle,[
            "width" => $tmpwidth/2,
            "borderSize" => 0,
            "borderColor" => "FFFFFF",
            "borderStyle" => Border::NONE,
            "cellMargin" => 0,
            "cellSpacing" => 0,
        ], $jocktraiDetCellStyle, $jocktraiDetCellStyle);
    // Textos
    $mainHeaderText = "mainHeaderText";
    $phpWord->addFontStyle($mainHeaderText, [
        "name"=>"Univers 75 Black",
        "size"=>15,
        "scale" => 120,
        //"spacing"=>-15,
        "allCaps"=>true,
        "bold"=>false,
        "color"=>"FFFFFF",
    ]);
    $mainHeaderPar = "mainHeaderPar";
    $phpWord->addParagraphStyle($mainHeaderPar, [
        "alignment" => \PhpOffice\PhpWord\SimpleType\Jc::CENTER,
        "spacing" =>1,
        "spaceBefore"=>0,
        "spaceAfter"=>0,
    ]);
    $titlesHeaderText = "titlesHeaderText";
    $phpWord->addFontStyle($titlesHeaderText, [
        "name"=>"Univers 75 Black",
        "size"=>9,
        //"scale" => 120,
        //"spacing"=>-15,
        "allCaps"=>true,
        "bold"=>true,
        "color"=>"000000",
    ]);
    $yearHeaderText = "yearHeaderText";
    $phpWord->addFontStyle($yearHeaderText, [
        "name"=>"Univers 75 Black",
        "size"=>18,
        "scale" => 120,
        //"spacing"=>-15,
        "allCaps"=>true,
        "bold"=>true,
        "color"=>"FFFFFF",
    ]);
    $titlesHeaderPar = "titlesHeaderPar";
    $phpWord->addParagraphStyle($titlesHeaderPar, [
        //"alignment" => \PhpOffice\PhpWord\SimpleType\Jc::CENTER,
        "spacing" =>1,
        "spaceBefore"=>0,
        "spaceAfter"=>0,
        "tabs" => [
            new \PhpOffice\PhpWord\Style\Tab('center', $width/4),
            new \PhpOffice\PhpWord\Style\Tab('center', $width/2),
            new \PhpOffice\PhpWord\Style\Tab('center', $width/4*3)
        ]
    ]);
    $statsGroupHeaderText = "statsGroupHeaderText";
    $phpWord->addFontStyle($statsGroupHeaderText, [
        "name"=>"Univers 65",
        "size"=>7,
        //"scale" => 120,
        //"spacing"=>-15,
        "allCaps"=>true,
        "bold"=>true,
        "color"=>"000000",
    ]);
    $statsGroupHeaderPar = "statsGroupHeaderPar";
    $phpWord->addParagraphStyle($statsGroupHeaderPar, [
        "alignment" => \PhpOffice\PhpWord\SimpleType\Jc::CENTER,
        "spacing" =>1,
        "spaceBefore"=>0,
        "spaceAfter"=>0,
    ]);
    $statsHeaderText = "statsHeaderText";
    $phpWord->addFontStyle($statsHeaderText, [
        "name"=>"Univers 55",
        "size"=>5,
        //"scale" => 120,
        //"spacing"=>-15,
        "allCaps"=>true,
        "bold"=>true,
        "color"=>"000000",
    ]);
    $statsHeaderRightPar = "statsHeaderRightPar";
    $phpWord->addParagraphStyle($statsHeaderRightPar, [
        "alignment" => \PhpOffice\PhpWord\SimpleType\Jc::RIGHT,
        "spacing" =>1,
        "spaceBefore"=>0,
        "spaceAfter"=>0,
    ]);
    $statsHeaderLeftPar = "statsHeaderLeftPar";
    $phpWord->addParagraphStyle($statsHeaderLeftPar, [
        "alignment" => \PhpOffice\PhpWord\SimpleType\Jc::LEFT,
        "spacing" =>1,
        "spaceBefore"=>0,
        "spaceAfter"=>0,
    ]);
    $statsHeaderCenterPar = "statsHeaderCenterPar";
    $phpWord->addParagraphStyle($statsHeaderCenterPar, [
        "alignment" => \PhpOffice\PhpWord\SimpleType\Jc::CENTER,
        "spacing" =>1,
        "spaceBefore"=>0,
        "spaceAfter"=>0,
    ]);
    $statsHeaderText = "statsHeaderText";
    $phpWord->addFontStyle($statsHeaderText, [
        "name"=>"Univers 55",
        "size"=>4.5,
        //"scale" => 120,
        //"spacing"=>-15,
        "allCaps"=>true,
        "bold"=>true,
        "color"=>"000000",
    ]);
    $statsHeaderRightPar = "statsHeaderRightPar";
    $phpWord->addParagraphStyle($statsHeaderRightPar, [
        "alignment" => \PhpOffice\PhpWord\SimpleType\Jc::RIGHT,
        "spacing" =>1,
        "spaceBefore"=>0,
        "spaceAfter"=>0,
    ]);
    $jocktraiText = "jocktraiText";
    $phpWord->addFontStyle($jocktraiText, [
        "name"=>"Univers 55",
        "size"=>4.5,
        //"scale" => 80,
        "spacing"=>-5,
        "allCaps"=>false,
        "bold"=>false,
        "color"=>"000000",
    ]);
    $jocktraiRightPar = "jocktraiRightPar";
    $phpWord->addParagraphStyle($jocktraiRightPar, [
        "alignment" => \PhpOffice\PhpWord\SimpleType\Jc::RIGHT,
        "spacing" =>1,
        "spaceBefore"=>0,
        "spaceAfter"=>0,
    ]);
    $jocktraiCenterPar = "jocktraiCenterPar";
    $phpWord->addParagraphStyle($jocktraiCenterPar, [
        "alignment" => \PhpOffice\PhpWord\SimpleType\Jc::CENTER,
        "spacing" =>1,
        "spaceBefore"=>0,
        "spaceAfter"=>0,
    ]);
    $jocktraiLeftPar = "jocktraiLeftPar";
    $phpWord->addParagraphStyle($jocktraiLeftPar, [
        "alignment" => \PhpOffice\PhpWord\SimpleType\Jc::LEFT,
        "spacing" =>1,
        "spaceBefore"=>0,
        "spaceAfter"=>0,
    ]);


    // Página
    $section = $phpWord->addSection([
        "marginTop"=>$top,
        "marginBottom"=>$bottom,
        "marginLeft"=>$left,
        "marginRight"=>$right,
        "pageSizeH"=>$height,
        "pageSizeW"=>$width+50,
        //"breakType"=>"continuous"
    ]);

    // header principal
    $headertab = $section->addTable($headerTableStyle);
    $headertab->addRow();
    $cell = $headertab->addCell($width, $headerCellStyle);
    $cell->addText("Estadísticas " . $racecourse,
            $mainHeaderText, $mainHeaderPar);
    $textRun = $cell->addTextRun($titlesHeaderPar);
    $textRun->addText("\tJinetes ",
            $titlesHeaderText, $titlesHeaderPar);
    $textRun->addText("\t" . date('Y', strtotime($date)),
            $yearHeaderText, $mainHeaderPar);
    $textRun->addText("\tEntrenadores",
            $titlesHeaderText, $titlesHeaderPar);
  
    // tabla stats
    $statstab = $section->addTable($statsTableStyle);
    // titulos grupales
    $statstab->addRow();
    $cell = $statstab->addCell($widthcampana,$statsGroupLeftBrdCellStyle);
    $cell->addText("Campaña General",
            $statsGroupHeaderText, $statsGroupHeaderPar);
    $cell = $statstab->addCell($width5Y6,$statsGroup5Y6CellStyle);
    $cell->addText("5Y6",
            $statsGroupHeaderText, $statsGroupHeaderPar);
    $cell = $statstab->addCell($widthcampana,$statsGroupCellStyle);
    $cell->addText("Campaña General",
            $statsGroupHeaderText, $statsGroupHeaderPar);
    $cell = $statstab->addCell($width5Y6,$statsGroup5Y6RightBrdCellStyle);
    $cell->addText("5Y6",
            $statsGroupHeaderText, $statsGroupHeaderPar);

    // titulos columnas
    $statstab->addRow();
    $cell = $statstab->addCell($C1,$statsHeaderLeftCellStyle);
    $cell->addText("S/G",
            $statsHeaderText, $statsHeaderCenterPar);
    $cell = $statstab->addCell($C2,$statsHeaderCellStyle);
    $cell->addText("Nombre",
            $statsHeaderText, $statsHeaderLeftPar);
    $cell = $statstab->addCell($C3,$statsHeaderCellStyle);
    $cell->addText("Premios",
            $statsHeaderText, $statsHeaderRightPar);
    $cell = $statstab->addCell($C4,$statsHeaderCellStyle);
    $cell->addText("1",
            $statsHeaderText, $statsHeaderRightPar);
    $cell = $statstab->addCell($C5,$statsHeaderCellStyle);
    $cell->addText("2",
            $statsHeaderText, $statsHeaderRightPar);
    $cell = $statstab->addCell($C6,$statsHeaderCellStyle);
    $cell->addText("3",
            $statsHeaderText, $statsHeaderRightPar);
    $cell = $statstab->addCell($C7,$statsHeaderCellStyle);
    $cell->addText("4",
            $statsHeaderText, $statsHeaderRightPar);
    $cell = $statstab->addCell($C8,$statsHeaderCellStyle);
    $cell->addText("5",
            $statsHeaderText, $statsHeaderRightPar);
    $cell = $statstab->addCell($C9,$statsHeaderCellStyle);
    $cell->addText("NF",
            $statsHeaderText, $statsHeaderRightPar);
    $cell = $statstab->addCell($C10,$statsHeaderCellStyle);
    $cell->addText("TA",
            $statsHeaderText, $statsHeaderRightPar);
    $cell = $statstab->addCell($C11,$statsHeaderCellStyle);
    $cell->addText("EF",
            $statsHeaderText, $statsHeaderRightPar);
    $cell = $statstab->addCell($C12,$statsHeaderRightBlueCellStyle);
    $cell->addText("REND" . $blank,
            $statsHeaderText, $statsHeaderRightPar);
    $cell = $statstab->addCell($C13,$statsHeaderCellStyle);
    $cell->addText("1" . $blank,
            $statsHeaderText, $statsHeaderRightPar);
    $cell = $statstab->addCell($C14,$statsHeaderRightCellStyle);
    $cell->addText("TA" . $blank,
            $statsHeaderText, $statsHeaderRightPar);
    // Entrenadores
    $cell = $statstab->addCell($C1,$statsHeaderLeftCellStyle);
    $cell->addText("S/G",
            $statsHeaderText, $statsHeaderCenterPar);
    $cell = $statstab->addCell($C2,$statsHeaderCellStyle);
    $cell->addText("Nombre",
            $statsHeaderText, $statsHeaderLeftPar);
    $cell = $statstab->addCell($C3,$statsHeaderCellStyle);
    $cell->addText("Premios",
            $statsHeaderText, $statsHeaderRightPar);
    $cell = $statstab->addCell($C4,$statsHeaderCellStyle);
    $cell->addText("1",
            $statsHeaderText, $statsHeaderRightPar);
    $cell = $statstab->addCell($C5,$statsHeaderCellStyle);
    $cell->addText("2",
            $statsHeaderText, $statsHeaderRightPar);
    $cell = $statstab->addCell($C6,$statsHeaderCellStyle);
    $cell->addText("3",
            $statsHeaderText, $statsHeaderRightPar);
    $cell = $statstab->addCell($C7,$statsHeaderCellStyle);
    $cell->addText("4",
            $statsHeaderText, $statsHeaderRightPar);
    $cell = $statstab->addCell($C8,$statsHeaderCellStyle);
    $cell->addText("5",
            $statsHeaderText, $statsHeaderRightPar);
    $cell = $statstab->addCell($C9,$statsHeaderCellStyle);
    $cell->addText("NF",
            $statsHeaderText, $statsHeaderRightPar);
    $cell = $statstab->addCell($C10,$statsHeaderCellStyle);
    $cell->addText("TA",
            $statsHeaderText, $statsHeaderRightPar);
    $cell = $statstab->addCell($C11,$statsHeaderCellStyle);
    $cell->addText("EF",
            $statsHeaderText, $statsHeaderRightPar);
    $cell = $statstab->addCell($C12,$statsHeaderRightBlueCellStyle);
    $cell->addText("REND" . $blank,
            $statsHeaderText, $statsHeaderRightPar);
    $cell = $statstab->addCell($C13,$statsHeaderCellStyle);
    $cell->addText("1" . $blank,
            $statsHeaderText, $statsHeaderRightPar);
    $cell = $statstab->addCell($C14,$statsHeaderRightCellStyle);
    $cell->addText("TA" . $blank,
            $statsHeaderText, $statsHeaderRightPar);

    // Detalles
    $statstab->addRow();
    // jockeys
    $cell = $statstab->addCell($tmpwidth/2,$jockCellStyle);
        $jocktraitable = $cell->addTable($jocktraiTableStyle);
        for ($i=0; $i<28; $i++){
            if ($row = $rs->fetch_assoc()){
                if ($row["firstplacedate"] == "1900-01-01"){
                    $sg = $blank;
                }else{
                    // calcular actuaciones sin ganar
                    $sql3 = "SELECT     COUNT(*) cnt " .
                            "FROM       racers R  " .
                            "INNER JOIN races RA  " .
                            "ON	        R.raceid=RA.id " .
                            "INNER JOIN reunions RE  " .
                            "ON	        RA.reunionid=RE.id " .
                            "WHERE 	    R.jockeyid=" . $row["jockeyid"] . " " . 
                            "AND        RE.date > '" . $row["firstplacedate"] . "' " .
                            "AND        RE.date < '" . $date . "' ";
                            //"GROUP BY   RE.id";
                    if (!$rs3 = $db->query($sql3))
                        badEnd("500", array("sql"=>$sql3, "msg"=>$db->error));
                    if (!$row3 = $rs3->fetch_assoc())
                        badEnd("500", array("sql"=>$sql3, "msg"=>"Ocurrio un error"));
                    $sg = $row3["cnt"];
                }
                $jocktraitable->addRow();
                $jocktraicell = $jocktraitable->addCell($C1,$jocktraiDetCellStyle);
                $jocktraicell->addText("  " . $sg,
                    $jocktraiText, $jocktraiLeftPar);
                $jocktraicell = $jocktraitable->addCell($C2,$jocktraiDetCellStyle);
                $jocktraicell->addText($row["jockeyname"],
                    $jocktraiText, $jocktraiLeftPar);
                $jocktraicell = $jocktraitable->addCell($C3,$jocktraiDetCellStyle);
                $jocktraicell->addText(number_format($row["prices"],2,",","."),
                    $jocktraiText, $jocktraiRightPar);
                $jocktraicell = $jocktraitable->addCell($C4,$jocktraiDetCellStyle);
                $jocktraicell->addText($row["firstplace"],
                    $jocktraiText, $jocktraiRightPar);
                $jocktraicell = $jocktraitable->addCell($C5,$jocktraiDetCellStyle);
                $jocktraicell->addText($row["secondplace"],
                    $jocktraiText, $jocktraiRightPar);
                $jocktraicell = $jocktraitable->addCell($C6,$jocktraiDetCellStyle);
                $jocktraicell->addText($row["thirdplace"],
                    $jocktraiText, $jocktraiRightPar);
                $jocktraicell = $jocktraitable->addCell($C7,$jocktraiDetCellStyle);
                $jocktraicell->addText($row["fourthplace"],
                    $jocktraiText, $jocktraiRightPar);
                $jocktraicell = $jocktraitable->addCell($C8,$jocktraiDetCellStyle);
                $jocktraicell->addText($row["fifthplace"],
                    $jocktraiText, $jocktraiRightPar);
                $jocktraicell = $jocktraitable->addCell($C9,$jocktraiDetCellStyle);
                $jocktraicell->addText($row["noplace"],
                    $jocktraiText, $jocktraiRightPar);
                $jocktraicell = $jocktraitable->addCell($C10,$jocktraiDetCellStyle);
                $jocktraicell->addText($row["totalraces"],
                    $jocktraiText, $jocktraiRightPar);
                $jocktraicell = $jocktraitable->addCell($C11,$jocktraiDetCellStyle);
                $jocktraicell->addText(number_format($row["efectiveness"],0,",","."),
                    $jocktraiText, $jocktraiRightPar);
                $jocktraicell = $jocktraitable->addCell($C12,$jocktraiDetRightBlueCellStyle);
                $jocktraicell->addText(number_format($row["rend"],2,",",".") . $blank,
                    $jocktraiText, $jocktraiRightPar);
                $jocktraicell = $jocktraitable->addCell($C13,$jocktraiDetCellStyle);
                $jocktraicell->addText($row["firstplace5"] . $blank,
                    $jocktraiText, $jocktraiRightPar);
                $jocktraicell = $jocktraitable->addCell($C14,$jocktraiDetCellStyle);
                $jocktraicell->addText($row["totalraces5"] . $blank,
                    $jocktraiText, $jocktraiRightPar);
            }
        }
    // trainers
    $cell = $statstab->addCell($tmpwidth/2,$traiCellStyle);
        $jocktraitable = $cell->addTable($jocktraiTableStyle);
        for ($i=0; $i<28; $i++){
            if ($row = $rs2->fetch_assoc()){
                if ($row["firstplacedate"] == "1900-01-01"){
                    $sg = $blank;
                }else{
                    // calcular actuaciones sin ganar
                    $sql3 = "SELECT     COUNT(*) cnt " .
                            "FROM       racers R  " .
                            "INNER JOIN races RA  " .
                            "ON	        R.raceid=RA.id " .
                            "INNER JOIN reunions RE  " .
                            "ON	        RA.reunionid=RE.id " .
                            "WHERE 	    R.trainerid=" . $row["trainerid"] . " " . 
                            "AND        RE.date > '" . $row["firstplacedate"] . "' " .
                            "AND        RE.date < '" . $date . "' ";
                            //"GROUP BY   RE.id";
                    if (!$rs3 = $db->query($sql3))
                        badEnd("500", array("sql"=>$sql3, "msg"=>$db->error));
                    if (!$row3 = $rs3->fetch_assoc())
                        badEnd("500", array("sql"=>$sql3, "msg"=>"Ocurrio un error"));
                    $sg = $row3["cnt"];
                }
                $jocktraitable->addRow();
                $jocktraicell = $jocktraitable->addCell($C1,$jocktraiDetCellStyle);
                $jocktraicell->addText("  " . $sg,
                    $jocktraiText, $jocktraiLeftPar);
                $jocktraicell = $jocktraitable->addCell($C2,$jocktraiDetCellStyle);
                $jocktraicell->addText($row["trainername"],
                    $jocktraiText, $jocktraiLeftPar);
                $jocktraicell = $jocktraitable->addCell($C3,$jocktraiDetCellStyle);
                $jocktraicell->addText(number_format($row["prices"],2,",","."),
                    $jocktraiText, $jocktraiRightPar);
                $jocktraicell = $jocktraitable->addCell($C4,$jocktraiDetCellStyle);
                $jocktraicell->addText($row["firstplace"],
                    $jocktraiText, $jocktraiRightPar);
                $jocktraicell = $jocktraitable->addCell($C5,$jocktraiDetCellStyle);
                $jocktraicell->addText($row["secondplace"],
                    $jocktraiText, $jocktraiRightPar);
                $jocktraicell = $jocktraitable->addCell($C6,$jocktraiDetCellStyle);
                $jocktraicell->addText($row["thirdplace"],
                    $jocktraiText, $jocktraiRightPar);
                $jocktraicell = $jocktraitable->addCell($C7,$jocktraiDetCellStyle);
                $jocktraicell->addText($row["fourthplace"],
                    $jocktraiText, $jocktraiRightPar);
                $jocktraicell = $jocktraitable->addCell($C8,$jocktraiDetCellStyle);
                $jocktraicell->addText($row["fifthplace"],
                    $jocktraiText, $jocktraiRightPar);
                $jocktraicell = $jocktraitable->addCell($C9,$jocktraiDetCellStyle);
                $jocktraicell->addText($row["noplace"],
                    $jocktraiText, $jocktraiRightPar);
                $jocktraicell = $jocktraitable->addCell($C10,$jocktraiDetCellStyle);
                $jocktraicell->addText($row["totalraces"],
                    $jocktraiText, $jocktraiRightPar);
                $jocktraicell = $jocktraitable->addCell($C11,$jocktraiDetCellStyle);
                $jocktraicell->addText(number_format($row["efectiveness"],0,",","."),
                    $jocktraiText, $jocktraiRightPar);
                $jocktraicell = $jocktraitable->addCell($C12,$jocktraiDetRightBlueCellStyle);
                $jocktraicell->addText(number_format($row["rend"],2,",",".") . $blank,
                    $jocktraiText, $jocktraiRightPar);
                $jocktraicell = $jocktraitable->addCell($C13,$jocktraiDetCellStyle);
                $jocktraicell->addText($row["firstplace5"] . $blank,
                    $jocktraiText, $jocktraiRightPar);
                $jocktraicell = $jocktraitable->addCell($C14,$jocktraiDetCellStyle);
                $jocktraicell->addText($row["totalraces5"] . $blank,
                    $jocktraiText, $jocktraiRightPar);
            }
        }

    switch ($outputformat){
        case "pdf":
            $domPdfPath = realpath(__DIR__ . '/../../../hooks/Dompdf/Dompdf');
            \PhpOffice\PhpWord\Settings::setPdfRendererPath($domPdfPath);
            \PhpOffice\PhpWord\Settings::setPdfRendererName('DomPDF');
            
            $objWriter = \PhpOffice\PhpWord\IOFactory::createWriter($phpWord , 'PDF');
            $temp_file = tempnam(sys_get_temp_dir(), 'PHPWord');
            $objWriter->save($temp_file);
            break;
        case "docx":
            $objWriter = \PhpOffice\PhpWord\IOFactory::createWriter($phpWord, 'Word2007');
            $temp_file = tempnam(sys_get_temp_dir(), 'PHPWord');
            $objWriter->save($temp_file);
            break;
        default:
            die ("FORMATO DE SALIDA INVALIDO");
    }

    header("Content-Disposition: attachment; filename=" . $filename);
    readfile($temp_file); // or echo file_get_contents($temp_file);
    unlink($temp_file);
?>