<?php
error_reporting(E_ALL);
ini_set('display_errors', 1);

    require '../../../hooks/autoload.php';
    use \PhpOffice\PhpWord\PhpWord;
    use \PhpOffice\PhpWord\SimpleType\Border;
    use \PhpOffice\PhpWord\Style\Font;

    include("../../../settings/dbconn.php");
    include("../../../settings/utils.php");

    // forzar a que se haga un POST y no un GET
    if ($_SERVER['REQUEST_METHOD']!= "GET")
        badEnd("400", array("msg"=>"Debe llamarse al servicio usando un GET"));
    // parametros obligatorios
    $parmsob = array("reunionid", "magazineid", "sessionid");
    if (!parametrosValidos($_REQUEST, $parmsob))
        badEnd("400", array("msg"=>"Parametros obligatorios " . implode(", ", $parmsob)));

    $sessionid = preg_replace("/[^a-zA-Z0-9]+/", "", $_REQUEST["sessionid"]);
    $reunionid = intval($_REQUEST["reunionid"]);
    $magazineid = intval($_REQUEST["magazineid"]);

    // parametros opcionales
    $outputformat = "docx";
    if (isset($_REQUEST["format"]))
        $outputformat = preg_replace("/[^docxpf]+/", "", strtolower($_REQUEST["format"]));
    if ($outputformat != "docx" && $outputformat != "pdf" )
        badEnd("500", array("msg"=>"Los formatos validos son 'pdf' y 'docx"));
    $racefilter = "";
    //if (isset($_REQUEST["raceidfrom"]) && isset($_REQUEST["raceidto"])){
    //    $racefilter = " AND RA.id BETWEEN " . $_REQUEST["raceidfrom"] . " AND " . $_REQUEST["raceidto"] . " ";
    //}
    if (isset($_REQUEST["raceidfrom"]) && isset($_REQUEST["raceidto"])){
        $raceidfrom = intval($_REQUEST["raceidfrom"]);
        $raceidto = intval($_REQUEST["raceidto"]);
        $sql = "SELECT number FROM races WHERE id=" . $raceidfrom;
        if (!$rs = $db->query($sql))
            badEnd("500", array("sql"=>$sql, "msg"=>$db->error));
        if (!$row = $rs->fetch_assoc())
            badEnd("409", array("msg"=>"Reunion desde no encontrada"));
        $racenumberfrom = $row["number"];
        $sql = "SELECT number FROM races WHERE id=" . $raceidto;
        if (!$rs = $db->query($sql))
            badEnd("500", array("sql"=>$sql, "msg"=>$db->error));
        if (!$row = $rs->fetch_assoc())
            badEnd("409", array("msg"=>"Reunion hasts no encontrada"));
        $racenumberto = $row["number"];
        $racefilter = " AND RA.number BETWEEN '" . $racenumberfrom . "' AND '" . $racenumberto . "' ";
    }
    isSessionValid($db, $sessionid);

    // conseguir fecha e hipodromo de la reunión
    $sql =  "SELECT 	R.date, R.racecourseid, H.dsc, H.abbr rcabbr " .
            "FROM 		reunions R " .
            "INNER JOIN racecourses H " .
            "ON         R.racecourseid = H.id " .
            "WHERE      R.id = " . $reunionid . " ";
    if (!$rs = $db->query($sql))
        badEnd("500", array("sql"=>$sql, "msg"=>$db->error));
    if (!$row = $rs->fetch_assoc())
        badEnd("409", array("msg"=>"Reunion no encontrada"));
    $date = $row["date"];
    $racecourseid = $row["racecourseid"];
    $racecourse = $row["dsc"];
    $rcabbr = $row["rcabbr"];

    //obtener primera carrera de la reunión para efectos del nombre
    $sql =  "SELECT LPAD(MIN(number), 3, '0') num FROM races WHERE valid=0 AND reunionid=" . $reunionid;
    if (!$rs = $db->query($sql))
        badEnd("500", array("sql"=>$sql, "msg"=>$db->error));
    if (!$row = $rs->fetch_assoc())
        badEnd("409", array("msg"=>"Reunion no encontrada"));
    $filename = "D" . $rcabbr  . "C" . $row["num"] . "." . $outputformat;

    // Armar arreglo con jugadas de pool de 4 y loto hipico
    $sql =  "SELECT     number, JSON_EXTRACT(RA.bets, '$[*].id') bet " .
            "FROM       races RA " . 
            "WHERE      RA.reunionid = " . $reunionid . " " . 
            "ORDER BY   RA.number";
    if (!$rs = $db->query($sql))
        badEnd("500", array("sql"=>$sql, "msg"=>$db->error));
    $pool4 = array();
    $lotohip = array();
    $tripleap = array();
    $cntp4 = 0;
    $cntlh = 0;
    $cntta = 0;
    while ($row = $rs->fetch_assoc()){
        // se busca 7 que es el id de pool de 4
        if (strpos(preg_replace("/[^1234567890,]+/", "", $row["bet"]), "7"))
            if ($cntp4<4)
                $cntp4++;
            else
                $cntp4 = 1;
        else
            $cntp4=0;
        $pool4[$row["number"]] = $cntp4;
        // se busca 8 que es el id de loto hipico
        if (strpos(preg_replace("/[^1234567890,]+/", "", $row["bet"]), "8"))
            if ($cntlh<2)
                $cntlh++;
            else
                $cntlh = 1;
        else
            $cntlh=0;
        $lotohip[$row["number"]] = $cntlh;
        // se busca 9 que es el id de triple apuesta
        if (strpos(preg_replace("/[^1234567890,]+/", "", $row["bet"]), "9"))
            if ($cntta<2)
                $cntta++;
            else
                $cntta = 1;
        else
            $cntta=0;
        $tripleap[$row["number"]] = $cntta;
    }

    $sql =  "SELECT     C.id horseid, R.id racerid, H.dsc racecourse, RA.extraprice, CU1.symbol pricecurr, CU2.symbol extrapricecurr, DATE_FORMAT(RE.date, '%d/%m/%y') fecha, " .
            "           H.id racecourseid, RA.id raceid, RA.ord raceord, RA.number racenumber, RA.mainprice, RA.firstplace, RA.secondplace, RA.thirdplace, RA.fourthplace, RA.fifthplace, " .
            "           R.number horsenumber, R.position horseposition, R.jockeyweight, " .
            "           RE.date reuniondate, D.dsc distancia, RT.id racetypeid, RT.dsc racetypedsc, " .
            "           REPLACE(LOWER(DATE_FORMAT(RA.time, '%h:%i %p')),'m','.m.') hora, DAYOFWEEK(RE.date) dow, " .
            "           CO1.dsc condicion1, CO2.dsc condicion2, RA.conditiondsc, " .
            "           RH.horsename recordhorse, RH.jockeyname recordjockey, RH.jockeyweight recordweight, RH.basetime recordtime,  " .
            "           DATE_FORMAT(RH.date, '%d/%m/%y') recorddate, " .
            "           S.dsc studname, S.abbr studabbr, " .
            "           C.obs horseobs, C.dsc horsename, C.mothergfname horsegfather, C.fathername horsefather, C.mothername horsemother, DATE_FORMAT(C.birthdate, '%d/%m/%y') horsebirth, " .
            "           J.abbr jockeyname, T.abbr trainername,  " .
            "           IFNULL(R.implementstypeM,'') medicaments, IFNULL(R.implementstypeI,'') implements, " .
            "           IFNULL(F.racers,'') forecastracers, F.top3, F.top6, " .
            "           SH.totalraces, SH.firstplace totalwin, SH.totalracesyear, SH.firstplaceyear totalwinyear, " .
            "           SA.harasname, SA.pricesbs harasbs " .
            "FROM       racers R  " .
            "INNER JOIN races RA  " .
            "ON         R.raceid=RA.id " .
            "INNER JOIN racetypes RT " . 
            "ON         RA.racetypeid=RT.id " .
            "INNER JOIN reunions RE  " .
            "ON         RA.reunionid=RE.id " .
            "INNER JOIN racecourses H  " .
            "ON         RE.racecourseid=H.id " .
            "INNER JOIN conditions CO1 " .
            "ON         RA.conditionid1=CO1.id " .
            "INNER JOIN conditions CO2 " .
            "ON         RA.conditionid2=CO2.id " .
            "INNER JOIN distances D  " .
            "ON         RA.distanceid=D.id " .
            "LEFT JOIN	(SELECT * FROM records_hipdst WHERE deleted IS NULL) RH " .
            "ON			RE.racecourseid=RH.racecourseid " .
            "AND		RA.distanceid=RH.distanceid " .
            "LEFT JOIN  (SELECT * FROM forecasts WHERE magazineid=" . $magazineid . ") F " .
            "ON         RA.id=F.raceid " .
            "INNER JOIN studs S  " .
            "ON			R.studid=S.id " .
            "INNER JOIN horses C  " .
            "ON			R.horseid=C.id " .
            "INNER JOIN stats_haras SA " .
            "ON         C.harasid=SA.harasid " .
            "INNER JOIN jockeys J  " .
            "ON			R.jockeyid=J.id " .
            "INNER JOIN	trainers T  " .
            "ON			R.trainerid=T.id " .
            "INNER JOIN currencies CU1 " .
            "ON         RA.mainpricecurr=CU1.code " .
            "INNER JOIN currencies CU2 " .
            "ON         RA.extrapricecurr=CU2.code " .
            "LEFT JOIN  ( " .
            "            SELECT		horseid, racecourseid, SUM(firstplace) firstplace, SUM(totalraces) totalraces,  " .
            "                       SUM(firstplaceyear) firstplaceyear, SUM(totalracesyear) totalracesyear  " .
            "            FROM		stats_horses " .
            "            GROUP BY   horseid, racecourseid " .
            "           )  SH " .
            "ON         R.horseid = SH.horseid " .
            "AND        RE.racecourseid = SH.racecourseid " .
//            "AND        RA.distanceid = SH.distanceid " .
            "WHERE      RE.id=" . $reunionid . " " .
            "AND        RA.valid=0 " .
            $racefilter .
            //"AND        RE.number=49 " .
            "ORDER BY   RA.ord, R.number";
    if (!$rs = $db->query($sql))
        badEnd("500", array("sql"=>$sql, "msg"=>$db->error));

    $phpWord = new PhpWord();

    // medidas
    $pulgada = 1440;
    $height = 7.28*$pulgada;  // 1440 twip = 1 pulgada
    $width = 4.8*$pulgada;
    $top = 0;
    $bottom = 0;
    $left = 0;
    $right = 0;
    $columnspaces = 0;
    $blank = chr(194) . chr(160);

    // colores
    $negro = "000000";
    $gris = "CECECE";
    $verde = "849966";
    $verdeclaro = "dcdfcc";
    //if ($racecourseid == 4){
    //    $fondo = $verde;
    //    $fondoclaro = $verdeclaro;
    //}else{
        $fondo = $negro;
        $fondoclaro = $gris;
    //}

    // Ancho de las columnas
    $C1 =  0.04;
    $C2 =  0.23;
    $C3 =  0.11; //+C19
    $C4 =  0.03;
    $C5 =  0.04;
    $C6 =  0.03;
    $C7 =  0.04;
    $C8 =  0.04;
    $C9 =  0.02;
    $C10 = 0.03;
    $C11 = 0.03;
    $C12 = 0.09;
    $C13 = 0.09;
    $C14 = 0.03;
    $C15 = 0.04;
    $C16 = 0.04;
    $C17 = 0.04;
    $C18 = 0.03;
    $C19 = 0; //0.02;
    $anchoHistoria = $width*($C5+$C6+$C7+$C8+$C9+$C10+$C11+$C12+$C13+$C14+$C15+$C16+$C17+$C18+$C19);

    $borderwidth = 6;
    // ESTILOS
    // Estilos de celdas
    $headerCellFullBrdStyle = [
        "valign" => "bottom",
        "borderSize" => $borderwidth,
        "borderColor" => "000000",
    ];
    $headerCellTopDwnBrdStyle = [
        "valign" => "bottom",
        "borderBottomSize" => $borderwidth,
        "borderBottomColor" => "000000",
        "borderTopSize" => $borderwidth,
        "borderTopColor" => '000000',
        "borderRightSize" => $borderwidth,
        "borderRightColor" => 'FFFFFF',
        "borderLeftSize" => $borderwidth,
        "borderLeftColor" => 'FFFFFF',
    ];
    $headerCellRightBrdStyle = [
        "valign" => "bottom",
        "borderRightSize" => $borderwidth,
        "borderRightColor" => "000000",
        "borderTopSize" => $borderwidth,
        "borderTopColor" => "000000",
        "borderBottomSize" => $borderwidth,
        "borderBottomColor" => "000000",
        "borderLeftSize" => 0,
        "borderLeftStyle" => Border::NONE,
    ];
    $headerCellStyle = [
        //"bgColor"=>$fondoclaro,
        "valign" => "bottom",
        "borderRightSize" => $borderwidth,
        "borderRightColor" => "000000",
        "borderTopSize" => 0,
        "borderBottomSize" => 0,
        "borderLeftSize" => 0,
        "borderTopStyle" => Border::NONE,
        "borderBottomStyle" => Border::NONE,
        "borderLeftStyle" => Border::NONE,
    ];

    $betsAreaCellStyle = [
        "bgColor"=>"FFFFFF",
        "valign" => "center",
        "borderSize" => 0,
        "borderStyle" => Border::NONE,
    ];

    $betsInvAreaCellStyle = [
        "bgColor"=>"000000",
        "valign" => "center",
        "borderSize" => 0,
        "borderStyle" => Border::NONE,
    ];

    $detailCellStyle = [
        "valign" => "center",
        "borderSize" => $borderwidth,
        "borderColor" => "FFFFFF",
        //"borderStyle" => Border::NONE,
    ];

    $statsAreaCellStyle = [
        "valign" => "center",
        "borderSize" => 0,
        "borderStyle" => Border::NONE,
    ];

    $topRightBoxLeftCellStyle = [
        "valign" => "center",
        "borderLeftSize" => 6,
        "borderTopSize" => 6,
        "borderBottomSize" => 6,
        "borderRightSize" => 0,
        "borderRightStyle" => Border::NONE,
    ];
    $topRightBoxLeftInvCellStyle = [
        "valign" => "center",
        "bgColor" => "000000",
        "borderLeftSize" => 6,
        "borderTopSize" => 6,
        "borderBottomSize" => 6,
        "borderRightSize" => 0,
        "borderRightStyle" => Border::NONE,
    ];
    $topRightBoxRightCellStyle = [
        "valign" => "bottom",
        "borderRightSize" => 6,
        "borderTopSize" => 6,
        "borderBottomSize" => 6,
        "borderLeftSize" => 0,
        "borderLeftStyle" => Border::NONE,
    ];

    $detailCellSpanStyle = [
        "gridSpan" => 14,
        "valign" => "center",
        "borderSize" => 0,
        "borderStyle" => Border::NONE,
    ];

    $detailCellStyleFullBrd = [
        "valign" => "center",
        "borderSize" => $borderwidth,
        "borderColor" => '000000',
    ];
    $detailCellSpanStyleFullBrd = [
        "gridSpan" => 14,
        "valign" => "center",
        "borderSize" => $borderwidth,
        "borderColor" => '000000',
    ];
    $detailCellSpanStyle = [
        "gridSpan" => 14,
        "valign" => "center",
        "borderSize" => 0,
        "borderStyle" => Border::NONE,
    ];
    $defaultCellStyle = [
        "borderSize" => 0,
        "borderStyle" => Border::NONE
    ];
    $sloganCellStyle = [
        "valign" => "center",
        "bgColor" => "FFFFFF",
        "borderSize" => $borderwidth,
        //"borderStyle" => Border::NONE,
    ];

    // Estilos de Tablas
    $defaultTableFullWidthStyle = "defaultTableFullWidthStyle";
    $phpWord->addTableStyle($defaultTableFullWidthStyle,[
            "width" => $width,
            "borderSize" => 0,
            "borderStyle" => Border::NONE,
            "alignment" => \PhpOffice\PhpWord\SimpleType\JcTable::CENTER,
            "cellMargin" => 0,
            "cellSpacing" => 0,
        ], $defaultCellStyle, $defaultCellStyle);
    $defaultTableHalfWidthStyle = "defaultTableHalfWidthStyle";
    $phpWord->addTableStyle($defaultTableHalfWidthStyle,[
            "width" => $width/2,
            "borderSize" => 0,
            "borderStyle" => Border::NONE,
            "alignment" => \PhpOffice\PhpWord\SimpleType\JcTable::CENTER,
            "cellMargin"=>0,
            "cellSpacing" => 0,
    ], $defaultCellStyle, $defaultCellStyle);

    $betsTableStyle = "betsTableStyle";
    $phpWord->addTableStyle($betsTableStyle,[
            "width" => $width/2*0.17,
            "bgColor"=>"FFFFFF",
            "borderSize" => 0,
            "borderStyle" => Border::NONE,
            "alignment" => \PhpOffice\PhpWord\SimpleType\JcTable::CENTER,
            "cellMargin" => 0,
            "cellSpacing" => 0,
    ], $betsAreaCellStyle, $betsAreaCellStyle);
    $betsInvTableStyle = "betsInvTableStyle";
    $phpWord->addTableStyle($betsInvTableStyle,[
            "width" => $width/2*0.17,
            "bgColor"=>"000000",
            "borderSize" => 0,
            "borderStyle" => Border::NONE,
            "alignment" => \PhpOffice\PhpWord\SimpleType\JcTable::CENTER,
            "cellMargin" => 0,
            "cellSpacing" => 0,
    ], $betsInvAreaCellStyle, $betsInvAreaCellStyle);

    $defaultTableHstWidthStyle = "defaultTableHstWidthStyle";
    $phpWord->addTableStyle($defaultTableHstWidthStyle,[
            "width" => $anchoHistoria,
            "borderSize" => 0,
            "borderStyle" => Border::NONE,
            "alignment" => \PhpOffice\PhpWord\SimpleType\JcTable::CENTER,
            "cellMargin"=>0,
            "cellSpacing" => 0,
    ], $defaultCellStyle, $defaultCellStyle);


    // cintillo superior de premio en dolares
    $initialBannerText = "initialBannerText";
    $phpWord->addFontStyle($initialBannerText, [
        "name"=>"Univers 75 Black",
        "size"=>14,
        "italic"=>true,
        "bold"=>false,
        "color"=>"FFFFFF",
        "bgColor"=>$fondo
    ]);
    $initialBannerPar = "initialBannerPar";
    $phpWord->addParagraphStyle($initialBannerPar, [
        "alignment" => \PhpOffice\PhpWord\SimpleType\Jc::CENTER,
        "shading"=>["fill"=>$fondo],
        "spaceBefore"=>0,
        "spaceAfter"=>0,
    ]);
    // Clásico
    $classicText = "classicText";
    $phpWord->addFontStyle($classicText, [
        "name"=>"Univers 65",
        "size"=>14,
        "allCaps"=>false,
        "bold"=>false,
        "italic"=>true,
        "color"=>"000000"
    ]);
    $classicPar = "classicPar";
    $phpWord->addParagraphStyle($classicPar, [
        "alignment" => \PhpOffice\PhpWord\SimpleType\Jc::CENTER,
        "spacing"=>0,
        "spaceBefore"=>20,
        "spaceAfter"=>20,
    ]);
        // Jugadas
        $bets1Text = "bets1Text";
        $phpWord->addFontStyle($bets1Text, [
            "name"=>"Univers 65",
            "size"=>50,
            "spacing"=>-30,
            "scale"=>60,
            "allCaps"=>false,
            "bold"=>false,
            "color"=>"FFFFFF"
        ]);
        $bets1Par = "bets1Par";
        $phpWord->addParagraphStyle($bets1Par, [
            "alignment" => \PhpOffice\PhpWord\SimpleType\Jc::CENTER,
            "spacing"=>-50,
            "spaceBefore"=>0,
            "spaceAfter"=>0,
        ]);
        $bets1smlText = "bets1smlText";
        $phpWord->addFontStyle($bets1smlText, [
            "name"=>"Univers 65",
            "size"=>8,
            "spacing"=>-5,
            //"scale"=>60,
            "allCaps"=>false,
            "bold"=>false,
            "color"=>"FFFFFF"
        ]);
        $betssml1Par = "betssml1Par";
        $phpWord->addParagraphStyle($betssml1Par, [
            "alignment" => \PhpOffice\PhpWord\SimpleType\Jc::CENTER,
            "spacing"=>0,
            "spaceBefore"=>0,
            "spaceAfter"=>0,
        ]);
        $bets2smlText = "bets2smlText";
        $phpWord->addFontStyle($bets2smlText, [
            "name"=>"Univers 65",
            "size"=>11,
            "spacing"=>-10,
            "scale"=>60,
            "allCaps"=>false,
            "bold"=>false,
            "color"=>"000000"
        ]);
        $betssml2Par = "betssml2Par";
        $phpWord->addParagraphStyle($betssml2Par, [
            "alignment" => \PhpOffice\PhpWord\SimpleType\Jc::CENTER,
            "spacing"=>-20,
            "spaceBefore"=>40,
            "spaceAfter"=>40,
        ]);
    // nombre del hipodromo
    $racecourseText = "racecourseText";
    $phpWord->addFontStyle($racecourseText, [
        "name"=>"Univers Extra Black",
        "size"=>13,
        "allCaps"=>false,
        "bold"=>false,
        "color"=>"000000"
    ]);
    $racecoursePar = "racecoursePar";
    $phpWord->addParagraphStyle($racecoursePar, [
        "spacing"=>1,
        "spaceBefore"=>0,
        "spaceAfter"=>0,
        "tabs" => [
                    new \PhpOffice\PhpWord\Style\Tab('center', $width/4)
        ]
    ]);
    // fecha y hora de la carrera
    $dateText = "dateText";
    $phpWord->addFontStyle($dateText, [
        "name"=>"Univers 75 Black",
        "size"=>8,
        "allCaps"=>false,
        "bold"=>false,
        "color"=>"000000",
        //"scale" => 150
    ]);
    $datePar = "datePar";
    $phpWord->addParagraphStyle($datePar, [
        "spacing"=>1,
        "spaceBefore"=>0,
        "spaceAfter"=>0,
        "tabs" => [
                    new \PhpOffice\PhpWord\Style\Tab('center', $width/4)
        ]
    ]);


    // tablas de yuntas y los mejores
    $separadorText = "separadorText";
    $phpWord->addFontStyle($separadorText, [
        "name"=>"Univers 55",
        "size"=>3,
        "allCaps"=>false,
        "bold"=>false,
        "color"=>"000000"
    ]);
    $separadorPar = "separadorPar";
    $phpWord->addParagraphStyle($separadorPar, [
        "spacing"=>0,
        "spaceBefore"=>0,
        "spaceAfter"=>0,
        "alignment" => \PhpOffice\PhpWord\SimpleType\Jc::CENTER,
    ]);
    $recordsHdrLeftText = "recordsHdrLeftText";
    $phpWord->addFontStyle($recordsHdrLeftText, [
        "name"=>"Univers 55",
        "scale"=>80,
        "size"=>6,
        "allCaps"=>false,
        "bold"=>true,
        "color"=>"000000"
    ]);
    $recordsHdrLeftPar = "recordsHdrLeftPar";
    $phpWord->addParagraphStyle($recordsHdrLeftPar, [
        "spacing"=>1,
        "spaceBefore"=>0,
        "spaceAfter"=>0,
        "alignment" => \PhpOffice\PhpWord\SimpleType\Jc::LEFT,
    ]);
    $recordsHdrText = "recordsHdrText";
    $phpWord->addFontStyle($recordsHdrText, [
        "name"=>"Univers 55",
        "scale"=>60,
        "size"=>6,
        "allCaps"=>false,
        "bold"=>true,
        "color"=>"000000"
    ]);
    $recordsHdrPar = "recordsHdrPar";
    $phpWord->addParagraphStyle($recordsHdrPar, [
        "spacing"=>1,
        "spaceBefore"=>0,
        "spaceAfter"=>0,
        "alignment" => \PhpOffice\PhpWord\SimpleType\Jc::CENTER,
    ]);
    $recordsDetLeftText = "recordsDetLeftText";
    $phpWord->addFontStyle($recordsDetLeftText, [
        "name"=>"Univers 55",
        "scale"=>80,
        "size"=>6,
        "spacing" => -5,
        "allCaps"=>false,
        "bold"=>false,
        "color"=>"000000"
    ]);
    $recordsDetLeftPar = "recordsDetLeftPar";
    $phpWord->addParagraphStyle($recordsDetLeftPar, [
        "alignment" => \PhpOffice\PhpWord\SimpleType\Jc::LEFT,
        "spacing"=>1,
        "spaceBefore"=>0,
        "spaceAfter"=>0,
    ]);
    $recordsDetText = "recordsDetText";
    $phpWord->addFontStyle($recordsDetText, [
        "name"=>"Univers 55",
        "scale"=>80,
        "size"=>6,
        "allCaps"=>false,
        "bold"=>false,
        "color"=>"000000"
    ]);
    $recordsDetPar = "recordsDetPar";
    $phpWord->addParagraphStyle($recordsDetPar, [
        "alignment" => \PhpOffice\PhpWord\SimpleType\Jc::CENTER,
        "spacing"=>1,
        "spaceBefore"=>0,
        "spaceAfter"=>0,
    ]);

    // numero de carrera y dia de la semana
    $raceNmbrText = "raceNmbrText";
    $phpWord->addFontStyle($raceNmbrText, [
        "name"=>"Univers 55",  // Falta la "Univers 75"
        "scale"=>70,
        "size"=>18,
        "allCaps"=>false,
        "bold"=>false,
        "color"=>"FFFFFF"
    ]);
    $raceNmbrPar = "raceNmbrPar";
    $phpWord->addParagraphStyle($raceNmbrPar, [
        "spacing"=>1,
        "spaceBefore"=>0,
        "spaceAfter"=>0,
        "tabs" => [
                    new \PhpOffice\PhpWord\Style\Tab('left', 60),
                    new \PhpOffice\PhpWord\Style\Tab('right', $width/2-60)
        ],
        "shading"=>["fill"=>$fondo],
    ]);
    // condiciones linea uno
    $conditions1Text = "conditions1Text";
    $phpWord->addFontStyle($conditions1Text, [
        "name"=>"Univers 65 Bold",
        "size"=>7,
        "spacing"=>-5,
        "allCaps"=>false,
        "bold"=>false,
        "color"=>"000000"
    ]);
    $conditions1Par = "conditions1Par";
    $phpWord->addParagraphStyle($conditions1Par, [
        "spaceBefore"=>0,
        "spaceAfter"=>0,
        "tabs" => [
                    new \PhpOffice\PhpWord\Style\Tab('left', 60),
                    new \PhpOffice\PhpWord\Style\Tab('right', $width/2-60)
        ],
        "spacing"=>0,
    ]);
    // condiciones linea dos
    $conditions2Text = "conditions2Text";
    $phpWord->addFontStyle($conditions2Text, [
        "name"=>"Univers 55",
        "scale"=>90,
        "size"=>6,
        "allCaps"=>false,
        "bold"=>false,
        "color"=>"000000"
    ]);
    $conditions2Par = "conditions2Par";
    $phpWord->addParagraphStyle($conditions2Par, [
        "alignment" => \PhpOffice\PhpWord\SimpleType\Jc::CENTER,
        "spaceBefore"=>40,
        "spaceAfter"=>40,
        "spacing"=>-40,
    ]);
    // premios
    $pricesText = "pricesText";
    $phpWord->addFontStyle($pricesText, [
        "name"=>"Univers 55",
        "size"=>6,
        "allCaps"=>false,
        "bold"=>false,
        "color"=>"000000"
    ]);
    $pricesPar = "pricesPar";
    $phpWord->addParagraphStyle($pricesPar, [
        "alignment" => \PhpOffice\PhpWord\SimpleType\Jc::CENTER,
        "spaceBefore"=>0,
        "spaceAfter"=>40,
        "spacing"=>-40,
    ]);
    // distancia
    $distanceText = "distanceText";
    $phpWord->addFontStyle($distanceText, [
        "name"=>"Univers 65 Bold",
        //"scale"=>70,
        "size"=>10,
        "allCaps"=>false,
        "bold"=>false,
        "color"=>"000000"
    ]);
    $distancePar = "distancePar";
    $phpWord->addParagraphStyle($distancePar, [
        "alignment" => \PhpOffice\PhpWord\SimpleType\Jc::CENTER,
        "spaceBefore"=>60,
        "spaceAfter"=>60,
        "spacing"=>-50,
    ]);
    // record
    $recordText = "recordText";
    $phpWord->addFontStyle($recordText, [
        "name"=>"Univers 65 Bold",
        "scale"=>80,
        "size"=>6.50,
        "allCaps"=>false,
        "bold"=>false,
        "color"=>"000000"
    ]);
    $recordPar = "recordPar";
    $phpWord->addParagraphStyle($recordPar, [
        "alignment" => \PhpOffice\PhpWord\SimpleType\Jc::CENTER,
        "spacing"=>-10,
        "spaceBefore"=>0,
        "spaceAfter"=>0,
    ]);
    // DETALLE
    // header
    $headerText = "headerText";
    $phpWord->addFontStyle($headerText, [
        "name"=>"Univers LT 45 Light",
        "scale"=>80,
        "spacing"=>-5,
        "size"=>4.5,
        "allCaps"=>false,
        "bold"=>false,
        "color"=>"000000"
    ]);
    $headerC2Text = "headerC2Text";
    $phpWord->addFontStyle($headerC2Text, [
        "name"=>"Helvetica",
        "scale"=>90,
        "spacing"=>-5,
        "size"=>4.5,
        "allCaps"=>false,
        "bold"=>false,
        "color"=>"000000"
    ]);
    $headerPar = "headerPar";
    $phpWord->addParagraphStyle($headerPar, [
        "alignment" => \PhpOffice\PhpWord\SimpleType\Jc::CENTER,
        "spacing"=>0,
        "spaceBefore"=>0,
        "spaceAfter"=>0,
    ]);
    $headerLeftPar = "headerLeftPar";
    $phpWord->addParagraphStyle($headerLeftPar, [
        "alignment" => \PhpOffice\PhpWord\SimpleType\Jc::LEFT,
        "spacing"=>0,
        "spaceBefore"=>0,
        "spaceAfter"=>0,
    ]);
    $headerRightPar = "headerRightPar";
    $phpWord->addParagraphStyle($headerRightPar, [
        "alignment" => \PhpOffice\PhpWord\SimpleType\Jc::RIGHT,
        "spacing"=>0,
        "spaceBefore"=>0,
        "spaceAfter"=>0,
    ]);

    // Horse Number
    $horseNumberText = "horseNumberText";
    $phpWord->addFontStyle($horseNumberText, [
        "name"=>"Univers 65 Bold",
        "scale"=>50,
        "spacing"=>-10,
        "size"=>24,
        "allCaps"=>false,
        "bold"=>false,
        "color"=>"000000"
    ]);
    $horseNumberPar = "horseNumberPar";
    $phpWord->addParagraphStyle($horseNumberPar, [
        "alignment" => \PhpOffice\PhpWord\SimpleType\Jc::CENTER,
        "spacing"=>0,
        "spaceBefore"=>0,
        "spaceAfter"=>0,
    ]);
    // Horse Details
    $horsedetailsText = "horsedetailsText";
    $phpWord->addFontStyle($horsedetailsText, [
        "name"=>"Univers 55",
        "scale" => 80,
        "spacing" => -5,
        "size"=>5,
        "allCaps"=>false,
        "bold"=>false,
        "color"=>"000000"
    ]);
    $horsedetailsPar = "horsedetailsPar";
    $phpWord->addParagraphStyle($horsedetailsPar, [
        "alignment" => \PhpOffice\PhpWord\SimpleType\Jc::LEFT,
        "spaceBefore"=>0,
        "spaceAfter"=>0,
        "tabs" => [
            new \PhpOffice\PhpWord\Style\Tab('right', $width*$C2-80)
        ],
        "spacing" => -20,
    ]);
    // horse name
    $horsenameText = "horsenameText";
    $phpWord->addFontStyle($horsenameText, [
        "name"=>"Univers LT 45 Light",
        "scale" => 80,
        "spacing" => -10,
        "size"=>9,
        "allCaps"=>true,
        "bold"=>false,
        "color"=>"000000"
    ]);
    $horsenamePar = "horsenamePar";
    $phpWord->addParagraphStyle($horsenamePar, [
        "alignment" => \PhpOffice\PhpWord\SimpleType\Jc::LEFT,
        "spaceBefore"=>0,
        "spaceAfter"=>0,
        "spacing"=>-50,
    ]);
    // jockey name
    $jockeynameText = "jockeynameText";
    $phpWord->addFontStyle($jockeynameText, [
        "name"=>"Univers 65 Bold",
        //"scale" => 80,
        //"spacing" => 0.8,
        "size"=>5,
        "allCaps"=>false,
        "bold"=>false,
        "color"=>"000000"
    ]);
    $jockeynamePar = "jockeynamePar";
    $phpWord->addParagraphStyle($jockeynamePar, [
        "alignment" => \PhpOffice\PhpWord\SimpleType\Jc::CENTER,
        "spacing"=>0,
        "spaceBefore"=>0,
        "spaceAfter"=>0,
    ]);
    // jockey weight
    $jockeyweightText = "jockeyweightText";
    $phpWord->addFontStyle($jockeyweightText, [
        "name"=>"Univers LT 45 Light",
        "size"=>8,
        "allCaps"=>false,
        "bold"=>false,
        "color"=>"000000"
    ]);
    $jockeyweightPar = "jockeyweightPar";
    $phpWord->addParagraphStyle($jockeyweightPar, [
        "alignment" => \PhpOffice\PhpWord\SimpleType\Jc::CENTER,
        "spacing"=>0.8,
        "spaceBefore"=>0,
        "spaceAfter"=>0,
    ]);
    // implements
    $implementsText = "implementsText";
    $phpWord->addFontStyle($implementsText, [
        "name"=>"Univers 55",
        //"scale" => 90,
        //"spacing" => 0.8,
        "size"=>4.5,
        "allCaps"=>false,
        "bold"=>false,
        "color"=>"000000"
    ]);
    $implementsPar = "implementsPar";
    $phpWord->addParagraphStyle($implementsPar, [
        "alignment" => \PhpOffice\PhpWord\SimpleType\Jc::CENTER,
        "spacing"=>0,
        "spaceBefore"=>0,
        "spaceAfter"=>0,
    ]);
    // trainer
    $trainerText = "trainerText";
    $phpWord->addFontStyle($trainerText, [
        "name"=>"Univers 55",
        //"scale" => 80,
        //"spacing" => 0.8,
        "size"=>4.5,
        "allCaps"=>false,
        "bold"=>false,
        "color"=>"000000"
    ]);
    $trainerPar = "trainerPar";
    $phpWord->addParagraphStyle($trainerPar, [
        "alignment" => \PhpOffice\PhpWord\SimpleType\Jc::CENTER,
        "spacing"=>0,
        "spaceBefore"=>10,
        "spaceAfter"=>0,
    ]);
    // position
    $positionText = "positionText";
    $phpWord->addFontStyle($positionText, [
        "name"=>"Univers LT 45 Light",
        "scale"=>80,
        "spacing"=>-5,
        "size"=>7,
        "allCaps"=>false,
        "bold"=>true,
        "color"=>"000000"
    ]);
    $positionPar = "positionPar";
    $phpWord->addParagraphStyle($positionPar, [
        "alignment" => \PhpOffice\PhpWord\SimpleType\Jc::CENTER,
        "spacing"=>1,
        "spaceBefore"=>0,
        "spaceAfter"=>0,
    ]);
    // history data
    $historyText = "historyText";
    $phpWord->addFontStyle($historyText, [
        "name"=>"Univers 55",
        "size"=>5.1,
        "scale" => 70,
        "spacing"=>-5,
        "allCaps"=>false,
        "bold"=>false,
        "color"=>"000000"
    ]);
    $cposText = "cposText";
    $phpWord->addFontStyle($cposText, [
        "name"=>"Univers 55",
        "size"=>4,
        //"scale" => 60,
        "allCaps"=>false,
        "bold"=>false,
        "color"=>"000000"
    ]);
    $historyPar = "historyPar";
    $phpWord->addParagraphStyle($historyPar, [
        "alignment" => \PhpOffice\PhpWord\SimpleType\Jc::CENTER,
        "spacing"=>1,
        "spaceBefore"=>0,
        "spaceAfter"=>0,
    ]);
    $historyLeftPar = "historyLeftPar";
    $phpWord->addParagraphStyle($historyLeftPar, [
        "alignment" => \PhpOffice\PhpWord\SimpleType\Jc::LEFT,
        "spacing"=>1,
        "spaceBefore"=>0,
        "spaceAfter"=>0,
    ]);
    $historyRightPar = "historyRightPar";
    $phpWord->addParagraphStyle($historyRightPar, [
        "alignment" => \PhpOffice\PhpWord\SimpleType\Jc::RIGHT,
        "spacing"=>1,
        "spaceBefore"=>0,
        "spaceAfter"=>0,
    ]);
    // additional data
    $addDataText = "addDataText";
    $phpWord->addFontStyle($addDataText, [
        "name"=>"Univers LT 45 Light",
        "size"=>5.25,
        "allCaps"=>false,
        "bold"=>false,
        "color"=>"000000"
    ]);
    $addDataPar = "addDataPar";
    $phpWord->addParagraphStyle($addDataPar, [
        "alignment" => \PhpOffice\PhpWord\SimpleType\Jc::LEFT,
        "spacing"=>1,
        "spaceBefore"=>0,
        "spaceAfter"=>0,
        "tabs" => [
            new \PhpOffice\PhpWord\Style\Tab('right', $anchoHistoria-20)
        ],
    ]);
    // footer slogan
    $footSloganDataText = "footSloganDataText";
    $phpWord->addFontStyle($footSloganDataText, [
        "name"=>"Univers 65",
        "size"=>12,
        "scale" => 60,
        "spacing"=>-15,
        "allCaps"=>false,
        "bold"=>false,
        "color"=>"000000",
    ]);
    $footPoolDe4Text = "footPoolDe4Text";
    $phpWord->addFontStyle($footPoolDe4Text, [
        "name"=>"Univers 65",
        "size"=>12,
        //"scale" => 60,
        "spacing"=>-5,
        "allCaps"=>true,
        "bold"=>false,
        "color"=>"000000",
    ]);
    $footSloganDataPar = "footSloganDataPar";
    $phpWord->addParagraphStyle($footSloganDataPar, [
        "alignment" => \PhpOffice\PhpWord\SimpleType\Jc::CENTER,
        "spacing" =>1,
        "spaceBefore"=>0,
        "spaceAfter"=>0,
    ]);

    $footFavDataText = "footFavDataText";
    $phpWord->addFontStyle($footFavDataText, [
        "name"=>"Univers 65 Bold",
        "scale" => 90,
        "spacing" => -10,
        "size"=>9,
        "allCaps"=>false,
        "bold"=>false,
        "color"=>"000000",
    ]);
    $footFavDataPar = "footFavDataPar";
    $phpWord->addParagraphStyle($footFavDataPar, [
        "alignment" => \PhpOffice\PhpWord\SimpleType\Jc::LEFT,
        "spacing"=>1,
        "spaceBefore"=>0,
        "spaceAfter"=>0,
        "tabs" => [
            new \PhpOffice\PhpWord\Style\Tab('left', ($width/7*5)*0.05),
            new \PhpOffice\PhpWord\Style\Tab('left', ($width/7*5)*0.55),
        ],
    ]);
    $footFavNamText = "footFavNamText";
    $phpWord->addFontStyle($footFavNamText, [
        "name"=>"Univers 65 Bold",
        "size"=>9.5,
        "spacing"=>-5,
        "allCaps"=>true,
        "bold"=>true,
        "color"=>"000000",
    ]);
    $footFavNamPar = "footFavNamPar";
    $phpWord->addParagraphStyle($footFavNamPar, [
        "alignment" => \PhpOffice\PhpWord\SimpleType\Jc::LEFT,
        "spacing"=>1,
        "spaceBefore"=>0,
        "spaceAfter"=>0,
        "tabs" => [
            new \PhpOffice\PhpWord\Style\Tab('left', ($width/7*5)*0.1),
            new \PhpOffice\PhpWord\Style\Tab('left', ($width/7*5)*0.7),
        ],
    ]);

    $top3 = "";
    $actualrace = "";
    $validcnt = 0;
    while ($row = $rs->fetch_assoc()){
        if ($row["racenumber"] != $actualrace){
            $validcnt++;
            if ($actualrace != ""){
                $foottable = $section->addTable([$defaultTableFullWidthStyle]);
                $foottable->addRow();
                $cell = $foottable->addCell($width/7*2, $sloganCellStyle);
                if ($pool4[$actualrace] == "0")
                    $cell->addText($blank,
                                    $footSloganDataText,
                                    $footSloganDataPar
                    );
                else
                    $cell->addText($pool4[$actualrace] . "ª Pool de 4",
                                    $footPoolDe4Text,
                                    $footSloganDataPar
                    );
                $cell = $foottable->addCell($width/7*5);
                $cell->addText("Nuestros Favoritos: " . $top3 .
                                "\tFav. Gaceta Hípica: ",
                                $footFavDataText,
                                $footFavDataPar
                );
                $cell->addText("\t" . substr($forecastdsc, 0, -3),
                                $footFavNamText,
                                $footFavNamPar
                );
            }

            $actualrace = $row["racenumber"];

            // calcular los 5 mejores segun speedrating
            $sql =  "SELECT 	GROUP_CONCAT(`number` SEPARATOR '-') top5 " . 
                    "FROM 	    (SELECT number FROM racers WHERE raceid=" . $row["raceid"] . " ORDER BY speedr LIMIT 5) A";
            if (!$rs2 = $db->query($sql))
                badEnd("500", array("sql"=>$sql, "msg"=>$db->error));
            $srtop5="";
            if ($row2 = $rs2->fetch_assoc()){
                $srtop5 = $row2["top5"]; 
            }

            $section = $phpWord->addSection([
                "marginTop"=>$top,
                "marginBottom"=>$bottom,
                "marginLeft"=>$left+30,
                "marginRight"=>$right+30,
                "pageSizeH"=>$height,
                "pageSizeW"=>$width,
            ]);

            $forecastdsc = "";
            $lastfc = 0;

            // PREMIO ESPECIAL
            if ($row["extraprice"] != 0){
                $maintable = $section->addTable([$defaultTableFullWidthStyle]);
                $maintable->addRow();
                $cell = $maintable->addCell($width);

                $cell->addText("Premiación Especial Adicional: " . number_format($row["extraprice"], 2, ",", ".") . " " . $row["extrapricecurr"],
                                $initialBannerText,
                                $initialBannerPar
                );
            }
            // Clasico
            if ($row["racetypeid"] != -1){
                $maintable = $section->addTable([$defaultTableFullWidthStyle]);
                $maintable->addRow();
                $cell = $maintable->addCell($width);
                $cell->addText($row["racetypedsc"],
                                $classicText,
                                $classicPar
                );
            }

            // Agregar hipodromo y hora
            $maintable = $section->addTable([$defaultTableHalfWidthStyle]);
            $maintable->addRow();
            $cell = $maintable->addCell($width/2);
            $cell->addText("\t" . $row["racecourse"], $racecourseText, $racecoursePar);
            $cell->addText("\t" . "Hora: " . $row["hora"], $dateText, $datePar);

            // ENCABEZADO DE DOS COLUMNAS
            $headertable = $section->addTable([$defaultTableFullWidthStyle]);
            $headertable->addRow();
                // contenido izquierda
                $cell = $headertable->addCell($width/2, $statsAreaCellStyle);

                    $ordinal = ["Primera", "Segunda", "Tercera", "Cuarta", "Quinta", "Sexta", "Séptima", "Octava", "Novena", "Décima"];
                    $dow = ["Domingo", "Lunes", "Martes", "Miércoles", "Jueves", "Viernes", "Sábado"];
                    $cell->addText("\t" . $ordinal[$row["raceord"]-1] . " Carrera\t" . $dow[$row["dow"]-1] . $blank, $raceNmbrText, $raceNmbrPar);

                    $cell->addText("\t(" . $row["racenumber"] . ") " . mb_strtoupper($row["condicion2"]) . "\t" . "Premios: " . $row["pricecurr"] . ". " . number_format($row["mainprice"],2, ",", ".") . $blank,
                            $conditions1Text, $conditions1Par);

                    $cell->addText(str_replace(" (", "<w:br/>(", $row["conditiondsc"]), $conditions2Text, $conditions2Par);

                    $cell->addText( $row["pricecurr"] . ". " . number_format($row["mainprice"]*$row["firstplace"]/100, 2, ",", ".") . " al 1°, " .
                                    $row["pricecurr"] . ". " . number_format($row["mainprice"]*$row["secondplace"]/100, 2, ",", ".") . " al 2°, " .
                                    $row["pricecurr"] . ". " . number_format($row["mainprice"]*$row["thirdplace"]/100, 2, ",", ".") . " al 3°, " .
                                    "<w:br/>" . 
                                    $row["pricecurr"] . ". " . number_format($row["mainprice"]*$row["fourthplace"]/100, 2, ",", ".") . " al 4°, " .
                                    $row["pricecurr"] . ". " . number_format($row["mainprice"]*$row["fifthplace"]/100, 2, ",", ".") . " al 5°"
                            , $pricesText, $pricesPar);

                    $cell->addText( "DISTANCIA: " . $row["distancia"] . " METROS"
                            , $distanceText, $distancePar);
                    $cell->addText( "RECORD: " . mb_strtoupper($row["recordhorse"]) . " - " .
                                    $row["recordjockey"] . " - Ks." . $row["recordweight"] . " - " .
                                    $row["recordtime"] . " - " . $row["recorddate"]
                            , $recordText, $recordPar);

                // contenido medio iz
                $cell = $headertable->addCell(($width/2)*0.17, $statsAreaCellStyle);
                if ($tripleap[$actualrace] != 0){
                    $bettab = $cell->addTable([$betsTableStyle]);
                    $bettab->addRow();
                    $betcell = $bettab->addCell($width/2*0.17, $betsAreaCellStyle);
                    $betcell->addText("TRIPLE APUESTA", $bets2smlText, $betssml2Par);
                    $betcell->addText($validcnt . "-" . $validcnt+1 . "-" . $validcnt+2 . "<w:br />", $bets2smlText, $betssml2Par);
                }
                // contenido medio der
                // invertir el color de la celda en caso de ocurrir alguna de las jugadas
                $cellStyle = $topRightBoxLeftCellStyle;
                if ($lotohip[$actualrace] != 0)
                    $cellStyle = $topRightBoxLeftInvCellStyle;
                $cell = $headertable->addCell(($width/2)*0.17, $cellStyle);
                    // incluir jugada de loto hipico
                    if ($lotohip[$actualrace] != 0){
                        $bettab = $cell->addTable([$betsInvTableStyle]);
                        $bettab->addRow();
                        $betcell = $bettab->addCell($width/2*0.17, $betsInvAreaCellStyle);
                        $betcell->addText("LOTO HIPICO", $bets1smlText, $betssml1Par);
                    }


                // contenido derecha
                $statscell = $headertable->addCell(($width/2)*0.658, $topRightBoxRightCellStyle);

            // Agregar separador
            $maintable = $section->addTable([$defaultTableFullWidthStyle]);
            $maintable->addRow();
            $cell = $maintable->addCell($width);
            $cell->addText($blank, $separadorText, $separadorPar);

            // ENCABEZADO DEL DETALLE
            $detailtable = $section->addTable([$defaultTableFullWidthStyle]);
                $detailtable->addRow();
                $cell = $detailtable->addCell($width*$C1, $headerCellFullBrdStyle);
                $cell->addText( "N°", $headerText, $headerPar);

                $cell = $detailtable->addCell($width*$C2, $headerCellFullBrdStyle);
                $cell->addText( "Propietario, Divisa, Ejemplar, Sexo, Pelaje, Edad, Padres y Origen"
                        , $headerC2Text, $headerPar);

                $cell = $detailtable->addCell($width*$C3, $headerCellFullBrdStyle);
                $cell->addText( "Jinete, Ks, Imple-<w:br/>mentos, Prep."
                        , $headerText, $headerPar);

                $cell = $detailtable->addCell($width*$C4, $headerCellFullBrdStyle);
                $cell->addText( "PP"
                        , $headerText, $headerPar);

                $cell = $detailtable->addCell($width*$C16, $headerCellTopDwnBrdStyle);
                $cell->addText( "Ind<w:br/>Vel."
                        , $headerText, $headerPar);
                //$cell->addText( "Vel."
                //        , $headerText, $headerPar);

                $cell = $detailtable->addCell($width*$C5, $headerCellTopDwnBrdStyle);
                $cell->addText( "Fec."
                        , $headerText, $headerPar);

                $cell = $detailtable->addCell($width*$C6, $headerCellTopDwnBrdStyle);
                $cell->addText( "Carr.<w:br/>ant."
                        , $headerText, $headerRightPar);

                $cell = $detailtable->addCell($width*$C7, $headerCellTopDwnBrdStyle);
                $cell->addText( "Peso<w:br/>Ejem"
                        , $headerText, $headerPar);

                $cell = $detailtable->addCell($width*$C8, $headerCellTopDwnBrdStyle);
                $cell->addText( "Dtcia"
                        , $headerText, $headerPar);

                $cell = $detailtable->addCell($width*$C9, $headerCellTopDwnBrdStyle);
                $cell->addText( "PP"
                        , $headerText, $headerPar);

                $cell = $detailtable->addCell($width*$C10, $headerCellTopDwnBrdStyle);
                $cell->addText( "1000<w:br/>300"
                        , $headerText, $headerPar);

                $cell = $detailtable->addCell($width*$C11, $headerCellTopDwnBrdStyle);
                $cell->addText( "Lleg"
                        , $headerText, $headerPar);

                $cell = $detailtable->addCell($width*$C12, $headerCellTopDwnBrdStyle);
                $cell->addText( "Ks Jinete      Divid"
                        , $headerText, $headerLeftPar);

                $cell = $detailtable->addCell($width*$C13, $headerCellTopDwnBrdStyle);
                $cell->addText( "Ganador"
                        , $headerText, $headerPar);

                $cell = $detailtable->addCell($width*$C14, $headerCellTopDwnBrdStyle);
                $cell->addText( "Cpos"
                        , $headerText, $headerPar);

                $cell = $detailtable->addCell($width*$C15, $headerCellTopDwnBrdStyle);
                $cell->addText( "Serie"
                        , $headerText, $headerPar);

                $cell = $detailtable->addCell($width*$C17, $headerCellTopDwnBrdStyle);
                $cell->addText( "Tmpo Gndor"
                        , $headerText, $headerPar);

                $cell = $detailtable->addCell($width*$C18, $headerCellRightBrdStyle);
                $cell->addText( "Tmpo Ejem"
                        , $headerText, $headerPar);

//                $cell = $detailtable->addCell($width*$C19, $headerCellStyle);
//                $cell->addText( "# Ejs"
//                        , $headerText, $headerPar);

            $top3 = $row["top3"];
        }
        // RENGLONES

        // Calcular actuaciones

        // Verificar información de pronósticos
        $racersfc = array();
        if (strlen($row["forecastracers"]))
            $racersfc = json_decode($row["forecastracers"]);

        $proncmt = getHorseForecasts($row["racerid"], $racersfc);
        if ($proncmt->forecast > 0 && $proncmt->forecast <= 3){
            if ($lastfc < $proncmt->forecast)
                $forecastdsc .= $row["horsename"] . " - ";
            else
                $forecastdsc = $row["horsename"] . " - " . $forecastdsc;
            $lastfc = $proncmt->forecast;
        }

        $detailtable->addRow();
        $cell = $detailtable->addCell($width*$C1, $detailCellStyleFullBrd);
            $cell->addText( $row["horsenumber"]
                    , $horseNumberText, $horseNumberPar);

        $cell = $detailtable->addCell($width*$C2, $detailCellStyleFullBrd);
            $cell->addText( "Stud " . clnprn($row["studname"]) . " - " . clnprn($row["studabbr"])
                    , $horsedetailsText, $horsedetailsPar);
            $cell->addText( $row["horsename"], $horsenameText, $horsenamePar);
            $cell->addText( $row["horsefather"] . " - " . $row["horsemother"]
                    , $horsedetailsText, $horsedetailsPar);

        $cell = $detailtable->addCell($width*$C3, $detailCellStyleFullBrd);
            $cell->addText( $row["jockeyname"]
                    , $jockeynameText, $jockeynamePar);
            $cell->addText( "Ks. " . $row["jockeyweight"]
                , $jockeyweightText, $jockeyweightPar);
            // medicamentos
            $medicaments = [];
            if (strlen($row["medicaments"]))
                $medicaments = json_decode($row["medicaments"]);
            $meds = "";
            foreach($medicaments as $medicament)
                $meds .= $medicament->abbr . ".";
            if ($meds == "") $meds = "--";
            // implementos
            $implements = [];
            if (strlen($row["implements"]))
                $implements = json_decode($row["implements"]);
            $imps = "";
            foreach($implements as $implement)
                $imps .= $implement->abbr . ".";
            if ($imps == "") $imps = "--";
            $cell->addText( $imps
                , $implementsText, $implementsPar);
            $cell->addText( $row["trainername"]
                , $trainerText, $trainerPar);

        $cell = $detailtable->addCell($width*$C4, $detailCellStyleFullBrd);
            $cell->addText( $row["horseposition"]
                , $positionText, $positionPar);

        $cell = $detailtable->addCell($anchoHistoria, $detailCellSpanStyleFullBrd); //XX

            //$htsareatable = $cell->addTable([$defaultTableHstWidthStyle]);
            // historia
            $hsttable = $cell->addTable([$defaultTableHstWidthStyle]);
            $sql3 = "SELECT     * " .
                    "FROM       wrk_horsehistory " .
                    "WHERE      horseid = " . $row["horseid"] . " " .
                    "AND        raceid <> " . $row["raceid"] . " " .
                    "AND        date < '"   . $row["reuniondate"] . "' " .
                    "ORDER BY   date DESC " .
                    "LIMIT 4";
            if (!$rs3 = $db->query($sql3))
                badEnd("500", array("sql"=>$sql, "msg"=>$db->error));
            for  ($i=0; $i<4; $i++){
            //while ($row3 = $rs3->fetch_assoc()){
                if ($row3 = $rs3->fetch_assoc()){
                    $hsttable->addRow(-112);
                    $cell = $hsttable->addCell($width*$C16, $detailCellStyle);
                        $cell->addText(number_format($row3["srating"],0,",","."), $historyText, $historyPar);
                    $cell = $hsttable->addCell($width*$C5, $detailCellStyle);
                        $cell->addText(date_format(date_create($row3["date"]), 'd-y'), $historyText, $historyPar);
                    $cell = $hsttable->addCell($width*$C6, $detailCellStyle);
                        $cell->addText($row3["racecourseabbr"].$row3["racenumber"], $historyText, $historyRightPar);
                    $cell = $hsttable->addCell($width*$C7, $detailCellStyle);
                        $cell->addText($row3["weight"], $historyText, $historyPar);
                    $cell = $hsttable->addCell($width*$C8, $detailCellStyle);
                        $cell->addText($row3["distancename"], $historyText, $historyPar);
                    $cell = $hsttable->addCell($width*$C9, $detailCellStyle);
                        $cell->addText($row3["position"], $historyText, $historyPar);
                    $cell = $hsttable->addCell($width*$C10, $detailCellStyle);
                        $cell->addText($row3["pos400"]." ".$row3["pos800"], $historyText, $historyPar);
                    $cell = $hsttable->addCell($width*$C11, $detailCellStyle);
                        $cell->addText($row3["arrivalposition"], $historyText, $historyPar);
                    $cell = $hsttable->addCell($width*$C12, $detailCellStyle);
                        $cell->addText($row3["jockeyweight"]." ".str_replace(". ", ".", $row3["jockeyabbr"]).",".$row3["dividends"], $historyText, $historyLeftPar);
                    $cell = $hsttable->addCell($width*$C13, $detailCellStyle);
                        $cell->addText(norm($row3["winnerdsc"]), $historyText, $historyRightPar);
                    $cell = $hsttable->addCell($width*$C14, $detailCellStyle);
                        $cell->addText($row3["bodiesabbr"] == '' ? $blank : $row3["bodiesabbr"], $cposText, $historyPar);
                    $cell = $hsttable->addCell($width*$C15, $detailCellStyle);
                        $cell->addText(substr($row3["serie"], 0, 6), $historyText, $historyPar);
                    $cell = $hsttable->addCell($width*$C17, $detailCellStyle);
                        $cell->addText(number_format($row3["winnertime"],1,",","."), $historyText, $historyRightPar);
                    $cell = $hsttable->addCell($width*$C18, $detailCellStyle);
                        $cell->addText(number_format($row3["finishtime"],1,",","."), $historyText, $historyRightPar);
//                    $cell = $hsttable->addCell($width*$C19, $detailCellStyle);
//                        $cell->addText($row3["horsenumber"], $historyText, $historyPar);
                }else{
                    // si estamos en el primer renglon significa que no hay información del caballo así que se imprimen las observacones
                    if ($i==0){
                        $hsttable->addRow(-112*4);
                        $cell = $hsttable->addCell($anchoHistoria, $detailCellSpanStyle);
                            $cell->addText($row["horseobs"], $historyText, $historyLeftPar);
                        $i = 4;
                    }else{
                        $hsttable->addRow(-112);
                        $cell = $hsttable->addCell($width*$C16, $detailCellStyle);
                            $cell->addText($blank, $historyText, $historyPar);
                        $cell = $hsttable->addCell($width*$C5, $detailCellStyle);
                            $cell->addText($blank, $historyText, $historyPar);
                        $cell = $hsttable->addCell($width*$C6, $detailCellStyle);
                            $cell->addText($blank, $historyText, $historyPar);
                        $cell = $hsttable->addCell($width*$C7, $detailCellStyle);
                            $cell->addText($blank, $historyText, $historyPar);
                        $cell = $hsttable->addCell($width*$C8, $detailCellStyle);
                            $cell->addText($blank, $historyText, $historyPar);
                        $cell = $hsttable->addCell($width*$C9, $detailCellStyle);
                            $cell->addText($blank, $historyText, $historyPar);
                        $cell = $hsttable->addCell($width*$C10, $detailCellStyle);
                            $cell->addText($blank, $historyText, $historyPar);
                        $cell = $hsttable->addCell($width*$C11, $detailCellStyle);
                            $cell->addText($blank, $historyText, $historyPar);
                        $cell = $hsttable->addCell($width*$C12, $detailCellStyle);
                            $cell->addText($blank, $historyText, $historyPar);
                        $cell = $hsttable->addCell($width*$C13, $detailCellStyle);
                            $cell->addText($blank, $historyText, $historyPar);
                        $cell = $hsttable->addCell($width*$C14, $detailCellStyle);
                            $cell->addText($blank, $historyText, $historyPar);
                        $cell = $hsttable->addCell($width*$C15, $detailCellStyle);
                            $cell->addText($blank, $historyText, $historyPar);
                        $cell = $hsttable->addCell($width*$C17, $detailCellStyle);
                            $cell->addText($blank, $historyText, $historyPar);
                        $cell = $hsttable->addCell($width*$C18, $detailCellStyle);
                            $cell->addText($blank, $historyText, $historyPar);
//                        $cell = $hsttable->addCell($width*$C19, $detailCellStyle);
//                            $cell->addText($blank, $historyText, $historyPar);
                    }
                }
            }
            // addional info
            $hsttable->addRow(-120);
            $cell = $hsttable->addCell($anchoHistoria, $detailCellSpanStyle);
                $cell->addText( "De " . $row["totalraces"] . "-" . $row["totalwin"] . "(-)," 
//                                "De " . $row["totalracesyear"] . "-" . $row["totalwinyear"] . "(-) "
                                . $proncmt->comment . " " . $meds
                                . "\t" . clnprn($row["harasname"]) . " " . $row["pricecurr"] . ". " . number_format($row["harasbs"],2,",",".")
                                , $addDataText, $addDataPar);


    }
    if ($actualrace != ""){
        $foottable = $section->addTable([$defaultTableFullWidthStyle]);
        $foottable->addRow();
        $cell = $foottable->addCell($width/7*2, $sloganCellStyle);
        if ($pool4[$actualrace] == "0")
            $cell->addText($blank,
                            $footSloganDataText,
                            $footSloganDataPar
            );
        else
            $cell->addText($pool4[$actualrace] . "ª Pool de 4",
                            $footPoolDe4Text,
                            $footSloganDataPar
            );
        $cell = $foottable->addCell($width/7*5);
        $cell->addText("Nuestros Favoritos: " . $top3 .
                        "\tFav. Gaceta Hípica: " . $srtop5,
                        $footFavDataText,
                        $footFavDataPar
        );
        $cell->addText("\t" . substr($forecastdsc, 0, -3),
                        $footFavNamText,
                        $footFavNamPar
        );
    }


    switch ($outputformat){
        case "pdf":
            $domPdfPath = realpath(__DIR__ . '/../../../hooks/Dompdf/Dompdf');
            \PhpOffice\PhpWord\Settings::setPdfRendererPath($domPdfPath);
            \PhpOffice\PhpWord\Settings::setPdfRendererName('DomPDF');
            
            $objWriter = \PhpOffice\PhpWord\IOFactory::createWriter($phpWord , 'PDF');
            $temp_file = tempnam(sys_get_temp_dir(), 'PHPWord');
            $objWriter->save($temp_file);
            break;
        case "docx":
            $objWriter = \PhpOffice\PhpWord\IOFactory::createWriter($phpWord, 'Word2007');
            $temp_file = tempnam(sys_get_temp_dir(), 'PHPWord');
            $objWriter->save($temp_file);
            break;
        default:
            die ("FORMATO DE SALIDA INVALIDO");
    }

    header("Content-Disposition: attachment; filename=" . $filename);
    readfile($temp_file); // or echo file_get_contents($temp_file);
    unlink($temp_file);

    function norm($dsc){
        $out = ucwords(mb_strtolower($dsc, 'UTF-8'));
        $out = str_replace(" De ", " de ", $out);
        $out = str_replace(" La ", " la ", $out);
        $out = str_replace(" El ", " el ", $out);
        $out = str_replace(" En ", " en ", $out);
        return($out);
    }
    function getHorseForecasts($racerid, $json){
        $salida = json_decode(json_encode(["id"=>0, "number"=>0, "arrivalposition"=>0, "forecast"=>0, "comment"=>"--"]));

        foreach($json as $pron){
            if ($pron->id == $racerid){
                $salida = $pron;
            }
        }
        return($salida);
    }
    function clnprn($valor){
        return (trim(preg_replace("/[^a-zA-Z0-9 \"\'.,:\-()+*\/áéíóúñüÁÉÍÓÚÑÜ]+/", "", str_replace("&", "y", $valor))));
    }
?>