<?php
    header("Content-Type:application/json");
    header("Access-Control-Allow-Origin: http://localhost:5500");
    include("../../../settings/dbconn.php");
    include("../../../settings/utils.php");

    // forzar a que se haga un GET
    if ($_SERVER['REQUEST_METHOD']!= "POST")
        badEnd("400", array("msg"=>"Debe llamarse al servicio usando un POST"));

    // parametros obligatorios
    $parmsob = array("id", "sessionid", "names", "lastnames", "abbr", "gender", "status");
    if (!parametrosValidos($_REQUEST, $parmsob))
        badEnd("400", array("msg"=>"Parametros obligatorios " . implode(", ", $parmsob)));
    
    $sessionid = preg_replace("/[^a-zA-Z0-9]+/", "", $_REQUEST["sessionid"]);
    $id = intval($_REQUEST["id"]);
    $names = preg_replace("/[^a-zA-Z0-9 .,:\-()+*\/áéíóúñüÁÉÍÓÚÑÜ]+/", "", $_REQUEST["names"]);
    $lastnames = preg_replace("/[^a-zA-Z0-9 .,:\-()+*\/áéíóúñüÁÉÍÓÚÑÜ]+/", "", $_REQUEST["lastnames"]);
    $abbr = preg_replace("/[^a-zA-Z0-9 .,:\-()+*\/áéíóúñüÁÉÍÓÚÑÜ]+/", "", $_REQUEST["abbr"]);
    $gender = preg_replace("/[^MF]+/", "", $_REQUEST["gender"]);
    $status = intval($_REQUEST["status"]);

    // corregir decodificar apóstrofes y comillas en el nombre
    $names = str_replace("/*.*/", "\'", $names);
    $names = str_replace("/*:*/", "\`", $names);
    $lastnames = str_replace("/*.*/", "\'", $lastnames);
    $lastnames = str_replace("/*:*/", "\`", $lastnames);

    if($status!=0 && $status!=1)
        badEnd("400", array("msg"=>"El parámetro status puede ser 0 o 1"));
    if($gender!="M" && $gender!="F")
        badEnd("400", array("msg"=>"El parámetro gender puede ser 'M' o 'F'"));

    // parametros opcionales
    $birthdate = "NULL";
    if (isset($_REQUEST["birthdate"])){
        $birthdate = "'" . preg_replace("/[^0-9-]+/", "", $_REQUEST["birthdate"]) . "'";
    }
    $ref = "NULL";
    if (isset($_REQUEST["ref"])){
        $ref = "'" . preg_replace("/[^a-zA-Z0-9]+/", "", $_REQUEST["ref"]) . "'";
    }


    isSessionValid($db, $sessionid);

    if ($id==0){    // incluir registro
        if (!tienePrivilegio($db, $sessionid, 432, false))
            badEnd("403", array("msg"=>"No tiene privilegios para ejecutar esta acción"));
            
        // validación de campos únicos para evitar el salto del autoincement XP
        $sql =  "SELECT id " .
                "FROM   trainers " . 
                "WHERE  abbr='" . $abbr . "'";
        if (!$rs = $db->query($sql))
            badEnd("500", array("sql"=>$sql,"msg"=>$db->error));
        if ($row = $rs->fetch_assoc())
            badEnd("409", array("msg"=>"Registro Duplicado"));

        $sql =  "INSERT INTO trainers " .
                "       (names, lastnames, abbr, birthdate, gender, ref, status) " .
                "VALUES (" .
                "        '" . $names . "'," .
                "        '" . $lastnames . "'," .
                "        '" . $abbr . "'," .
                "         " . $birthdate . "," .
                "        '" . $gender . "'," .
                "         " . $ref . "," .
                "        '" . $status . "' " .
                "        )";
        if (!$db->query($sql)){
            if ($db->errno == 1062){
                badEnd("409", array("msg"=>"Registro Duplicado"));
            }else{
                badEnd("500", array("msg"=>$db->error));
            }
        }

        $id = $db->insert_id;
        
        setAudit($db, "Entrenadores", $sessionid, "Se incluyó el entrenador \'" . $names . " " . $lastnames . "\' (" . $id . ")");
    }else{          // modificar registro
        if (!tienePrivilegio($db, $sessionid, 431, false))
            badEnd("403", array("msg"=>"No tiene privilegios para ejecutar esta acción"));
            
        $sql =  "UPDATE trainers " .
                "SET    names = '" . $names . "'," .
                "       lastnames = '" . $lastnames . "', " .
                "       abbr = '" . $abbr . "', " .
                "       birthdate =  " . $birthdate . ", " .
                "       gender = '" . $gender . "', " .
                "       ref = " . $ref . ", " .
                "       status = '" . $status . "' " .
                "WHERE  id=" . $id;
        if (!$db->query($sql))
            if ($db->errno == 1062){
                badEnd("409", array("msg"=>"Registro Duplicado"));
            }else{
                badEnd("500", array("id"=>0,"sql"=>$sql,"msg"=>$db->error));
            }
            
        setAudit($db, "Entrenadores", $sessionid, "Se actualizó el entrenador \'" . $names . " " . $lastnames . "\' (" . $id . ")");

    }

    $out = new stdClass;
    $out->id = $id;
    
    header("HTTP/1.1 200");
    echo (json_encode($out));
    die();
?>