<?php
    header("Content-Type:application/json");
    header("Access-Control-Allow-Origin: http://localhost:5500");
    include("../../../settings/dbconn.php");
    include("../../../settings/utils.php");

    // forzar a que se haga un POST y no un GET
    if ($_SERVER['REQUEST_METHOD']!= "POST")
        badEnd("400", array("msg"=>"Debe llamarse al servicio usando un POST"));

    // parametros obligatorios
    $parmsob = array("order", "offset", "numofrec", "sessionid");
    if (!parametrosValidos($_REQUEST, $parmsob))
        badEnd("400", array("msg"=>"Parametros obligatorios " . implode(", ", $parmsob)));
    
    $sessionid = preg_replace("/[^a-zA-Z0-9]+/", "", $_REQUEST["sessionid"]);
    $orderpar = intval($_REQUEST["order"]);
    $offset = intval($_REQUEST["offset"]);
    $numofrec = intval($_REQUEST["numofrec"]);

    // parametros opcionales
    $filtro = "";
    if (isset($_REQUEST["filter"])){
        $filtro = preg_replace("/[^a-zA-Z0-9 .,:\-()+*\/áéíóúñüÁÉÍÓÚÑÜ]+/", "", $_REQUEST["filter"]);
    }
    $statusid = 0;
    if (isset($_REQUEST["statusid"])){
        $statusid = intval($_REQUEST["statusid"]);
    }
    $genderid = "";
    if (isset($_REQUEST["genderid"])){
        $genderid = preg_replace("/[^MF]+/", "", $_REQUEST["genderid"]);
    }
    $fullsearch = 1;
    if (isset($_REQUEST["fullsearch"])){
        $fullsearch = intval($_REQUEST["fullsearch"]);
    }

    isSessionValid($db, $sessionid);

    if (!tienePrivilegio($db, $sessionid, 430, false))
        badEnd("403", array("msg"=>"No tiene privilegios para ejecutar esta acción"));
    
    // busqueda
    $filter = "";
    if (strlen($filtro) > 0){
        if ($fullsearch == 1){
            $filter .= "(";
            $filter .= "    CONCAT(T.names, ' ', T.lastnames) like '%" . $filtro . "%' ";
            $filter .= " OR abbr like '%" . $filtro . "%' ";
            $filter .= " OR  IF(T.status='1', ' Activo', ' Inactivo') like '% " . $filtro . "%' ";
            $filter .= " OR  IF(T.gender='M', 'Masculino', 'Femenino') like '%" . $filtro . "%' ";
            $filter .= ")";
        }else{
            $filter .= "(";
            $filter .= "    CONCAT(T.names, ' ', T.lastnames) like '%" . $filtro . "%' ";
            $filter .= "OR  T.abbr like '%" . $filtro . "%' ";
            $filter .= "OR  T.ref like '%" . $filtro . "%' ";
            $filter .= "OR  T.id like '%" . $filtro . "%' ";
            $filter .= ")";
        }
    }
    // filtro de status
    if ($statusid != 0){
        if (strlen($filter) > 0){
            $filter .= " AND ";
        }
        $filter .= " status = " . ($statusid == 1 ? "1" : "0");
    }

    // filtro de sexo
    if (strlen($genderid) > 0){
        if (strlen($filter) > 0){
            $filter .= " AND ";
        }
        $filter .= " gender = '" . $genderid . "' ";
    }

    if (strlen($filter) > 0){
        $filter = " WHERE " . $filter;
    }

    // orden
    $order = "";
    switch (abs($orderpar)){
        case 1:
            $order = " createdat ";
            break;
        case 2:
            $order = " modifiedat ";
            break;
        case 3:
            $order = " CONCAT(names, lastnames) ";
            break;
        case 4:
            $order = " abbr ";
            break;
        case 5:
            $order = " birthdate ";
            break;
        case 6:
            $order = " gender ";
            break;
        case 7:
            $order = " ref ";
            break;
        case 8:
            $order = " status ";
            break;
        case 9:
            $order = " status DESC, CONCAT(names, lastnames) ";
            break;
    }
    if (strlen($order) > 0){
        if ($orderpar < 0)
            $order .= " DESC ";
        $order = " ORDER BY " . $order;
    }

    $sql =  "SELECT     T.id, CONCAT(T.names, ' ', T.lastnames) fullname, T.status, " .
            "           T.birthdate, DATE_FORMAT(T.birthdate, '%d/%m/%Y') birthdatefmt, " .
            "           T.abbr, T.gender, T.ref " .
            "FROM       trainers T " .
            $filter .
            $order;
    // calcular numero de registros
    if (!$rs = $db->query("SELECT COUNT(*) cnt FROM (" . $sql . ") A "))
        badEnd("500", array("errlog"=>1, "sql"=>$sql, "msg"=>$db->error));
    $row = $rs->fetch_assoc();
    $out = new stdClass;
    $out->numofrecords = (integer) $row["cnt"];

    // limitar número de
    $sql =  "SELECT A.* FROM (" . $sql . ") A " .
            "LIMIT " . $offset . "," . $numofrec;
    if (!$rs = $db->query($sql))
        badEnd("500", array("errlog"=>2, "msg"=>$db->error));

    $out->records = array();
    while ($row = $rs->fetch_assoc()){
        $record = new stdClass;
        $record->id = (integer) $row["id"];
        $record->fullname = $row["fullname"];
        $record->abbr = $row["abbr"];
        $record->gender = new stdClass;
        $record->gender->id = $row["gender"];
        $record->gender->name = $record->gender->id=="M" ? "Masculino" : "Femenino";
        $record->status = new stdClass;
        $record->status->id = (integer) $row["status"];
        $record->status->name = $record->status->id==0 ? "Inactivo" : "Activo";
        $record->birthdate = new stdClass;
        $record->birthdate->date = nvl($row["birthdate"], "");
        $record->birthdate->formatted = nvl($row["birthdatefmt"], "");

        $out->records[] = $record;
    }

    $access = array();
    $access["read"] = tienePrivilegio($db, $sessionid, 430);
    $access["update"] = tienePrivilegio($db, $sessionid, 431);
    $access["create"] = tienePrivilegio($db, $sessionid, 432);
    $access["delete"] =   tienePrivilegio($db, $sessionid, 433);
    $out->privileges = $access;

    header("HTTP/1.1 200");
    echo (json_encode($out));
    die();
?>