<?php
    header("Content-Type:application/json");
    header("Access-Control-Allow-Origin: http://localhost:5500");
    include("../../../settings/dbconn.php");
    include("../../../settings/utils.php");

    // forzar a que se haga un GET
    if ($_SERVER['REQUEST_METHOD']!= "GET")
        badEnd("400", array("msg"=>"Debe llamarse al servicio usando un GET"));

    // parametros obligatorios
    $parmsob = array("id", "sessionid");
    if (!parametrosValidos($_REQUEST, $parmsob))
        badEnd("400", array("msg"=>"Parametros obligatorios " . implode(", ", $parmsob)));
    
    $sessionid = preg_replace("/[^a-zA-Z0-9]+/", "", $_REQUEST["sessionid"]);
    $id = intval($_REQUEST["id"]);

    isSessionValid($db, $sessionid);

    if (!tienePrivilegio($db, $sessionid, 430, false))
        badEnd("403", array("msg"=>"No tiene privilegios para ejecutar esta acción"));
    
    $sql =  "SELECT     T.id, T.names, T.lastnames, T.status, T.abbr, T.gender, T.ref, " .
            "           T.birthdate, DATE_FORMAT(T.birthdate, '%d/%m/%Y') birthdatefmt, " .
            "           T.createdat created, DATE_FORMAT(T.createdat, '%d/%m/%Y %h:%i %p') createdfmt, " .
            "           T.modifiedat modified, DATE_FORMAT(T.modifiedat, '%d/%m/%Y %h:%i %p') modifiedfmt " .
            "FROM       trainers T " .
            "WHERE      T.id = " . $id;
    if (!$rs = $db->query($sql))
        badEnd("500", array("sql"=>$sql,"msg"=>$db->error));

    if ($row = $rs->fetch_assoc()){
        $entry = new stdClass;
        $entry->id = (integer) $row["id"];
        $entry->names = $row["names"];
        $entry->lastnames = $row["lastnames"];
        $entry->abbr = $row["abbr"];
        $entry->ref = $row["ref"];
        $entry->gender = new stdClass;
        $entry->gender->id = $row["gender"];
        $entry->gender->name = $entry->gender->id=="M" ? "Masculino" : "Femenino";
        $entry->status = new stdClass;
        $entry->status->id = (integer) $row["status"];
        $entry->status->name = $entry->status->id==0 ? "Inactivo" : "Activo";
        $entry->birthdate = new stdClass;
        $entry->birthdate->date = $row["birthdate"];
        $entry->birthdate->formatted = $row["birthdatefmt"];
        $entry->created = new stdClass;
        $entry->created->date = $row["created"];
        $entry->created->formatted = $row["createdfmt"];
        $entry->modified = new stdClass;
        $entry->modified->date = $row["modified"];
        $entry->modified->formatted = $row["modifiedfmt"];
    }else{
        badEnd("204", array("msg"=>"No se encuentra el registro"));
    }

    $out = new stdClass;
    $out->entry = $entry;

    $access = array();
    $access["read"] = tienePrivilegio($db, $sessionid, 430);
    $access["update"] = tienePrivilegio($db, $sessionid, 431);
    $access["create"] = tienePrivilegio($db, $sessionid, 432);
    $access["delete"] =   tienePrivilegio($db, $sessionid, 433);
    $out->privileges = $access;

    header("HTTP/1.1 200");
    echo (json_encode($out));
    die();
?>