<?php
    header("Content-Type:application/json");
    header("Access-Control-Allow-Origin: http://localhost:5500");
    include("../../../settings/dbconn.php");
    include("../../../settings/utils.php");

    // forzar a que se haga un GET
    if ($_SERVER['REQUEST_METHOD']!= "GET")
        badEnd("400", array("msg"=>"Debe llamarse al servicio usando un GET"));

    // parametros obligatorios
    $parmsob = array("id", "sessionid");
    if (!parametrosValidos($_REQUEST, $parmsob))
        badEnd("400", array("msg"=>"Parametros obligatorios " . implode(", ", $parmsob)));
    
    $sessionid = preg_replace("/[^a-zA-Z0-9]+/", "", $_REQUEST["sessionid"]);
    $id = intval($_REQUEST["id"]);

    isSessionValid($db, $sessionid);

    if (!tienePrivilegio($db, $sessionid, 450, false))
        badEnd("403", array("msg"=>"No tiene privilegios para ejecutar esta acción"));
    
    $sql =  "SELECT     H.id, H.dsc, H.status, H.abbr, H.initialpricesbs, H.initialpricesusd, H.initialraces, " .
            "           M.id munid, M.dsc mundsc, S.id staid, S.dsc stadsc, H.initialwinraces, " .
            "           H.createdat created, DATE_FORMAT(H.createdat, '%d/%m/%Y %h:%i %p') createdfmt, " .
            "           H.modifiedat modified, DATE_FORMAT(H.modifiedat, '%d/%m/%Y %h:%i %p') modifiedfmt, " .
            "           ST.winraces, ST.pricesusd, ST.pricesbs, ST.races " .
            "FROM       haras H " .
            "INNER JOIN municipalities M " .
            "ON         H.municipalityid=M.id " .
            "INNER JOIN states S " . 
            "ON         M.stateid=S.id " .
            "LEFT JOIN  stats_haras ST " . 
            "ON         H.id=ST.harasid " . 
            "WHERE      H.id = " . $id;
    if (!$rs = $db->query($sql))
        badEnd("500", array("sql"=>$sql,"msg"=>$db->error));

    if ($row = $rs->fetch_assoc()){
        $entry = new stdClass;
        $entry->id = (integer) $row["id"];
        $entry->name = $row["dsc"];
        $entry->abbr = $row["abbr"];
        $entry->status = new stdClass;
        $entry->status->id = (integer) $row["status"];
        $entry->status->name = $entry->status->id==0 ? "Inactivo" : "Activo";
        $entry->municipality = new stdClass;
        $entry->municipality->id = (integer) $row["munid"];
        $entry->municipality->name = $row["mundsc"];
        $entry->state = new stdClass;
        $entry->state->id = (integer) $row["staid"];
        $entry->state->name = $row["stadsc"];
        $entry->initialpricesusd = new stdClass;
        $entry->initialpricesusd->number = (float) $row["initialpricesusd"];
        $entry->initialpricesusd->formatted = number_format($entry->initialpricesusd->number, 2, ",", ".");
        $entry->initialpricesbs = new stdClass;
        $entry->initialpricesbs->number = (float) $row["initialpricesbs"];
        $entry->initialpricesbs->formatted = number_format($entry->initialpricesbs->number, 2, ",", ".");
        $entry->initialraces = new stdClass;
        $entry->initialraces->number = (integer) $row["initialraces"];
        $entry->initialraces->formatted = number_format($entry->initialraces->number, 0, ",", ".");
        $entry->initialwinraces = new stdClass;
        $entry->initialwinraces->number = (integer) $row["initialwinraces"];
        $entry->initialwinraces->formatted = number_format($entry->initialwinraces->number, 0, ",", ".");
        $entry->acumulatedwinraces = new stdClass;
        $entry->acumulatedwinraces->number = (integer) $row["winraces"];
        $entry->acumulatedwinraces->formatted = number_format($entry->acumulatedwinraces->number, 0, ",", ".");
        $entry->acumulatedpricesusd = new stdClass;
        $entry->acumulatedpricesusd->number = (float) $row["pricesusd"];
        $entry->acumulatedpricesusd->formatted = number_format($entry->acumulatedpricesusd->number, 2, ",", ".");
        $entry->acumulatedpricesbs = new stdClass;
        $entry->acumulatedpricesbs->number = (float) $row["pricesbs"];
        $entry->acumulatedpricesbs->formatted = number_format($entry->acumulatedpricesbs->number, 2, ",", ".");
        $entry->acumulatedraces = new stdClass;
        $entry->acumulatedraces->number = (integer) $row["races"];
        $entry->acumulatedraces->formatted = number_format($entry->acumulatedraces->number, 0, ",", ".");
        $entry->state->name = $row["stadsc"];
        $entry->created = new stdClass;
        $entry->created->date = $row["created"];
        $entry->created->formatted = $row["createdfmt"];
        $entry->modified = new stdClass;
        $entry->modified->date = $row["modified"];
        $entry->modified->formatted = $row["modifiedfmt"];
    }else{
        badEnd("204", array("sql"=>$sql, "msg"=>"No se encuentra el registro"));
    }

    $out = new stdClass;
    $out->entry = $entry;

    $access = array();
    $access["read"] = tienePrivilegio($db, $sessionid, 450);
    $access["update"] = tienePrivilegio($db, $sessionid, 451);
    $access["create"] = tienePrivilegio($db, $sessionid, 452);
    $access["delete"] =   tienePrivilegio($db, $sessionid, 453);
    $out->privileges = $access;

    header("HTTP/1.1 200");
    echo (json_encode($out));
    die();
?>