<?php
    header("Content-Type:application/json");
    header("Access-Control-Allow-Origin: http://localhost:5500");
    include("../../../settings/dbconn.php");
    include("../../../settings/utils.php");

    // forzar a que se haga con GET
    if ($_SERVER['REQUEST_METHOD']!= "GET")
        badEnd("400", array("msg"=>"Debe llamarse al servicio usando un GET"));

    // parametros obligatorios
    $parmsob = array("id","sessionid");
    if (!parametrosValidos($_REQUEST, $parmsob))
        badEnd("400", array("msg"=>"Parametros obligatorios " . implode(", ", $parmsob)));
    
    $id = (integer) $_REQUEST["id"];
    $sessionid = preg_replace("/[^a-zA-Z0-9]+/", "", $_REQUEST["sessionid"]);

    isSessionValid($db, $sessionid);

    if (!tienePrivilegio($db, $sessionid, 320, false))
        badEnd("403", array("msg"=>"No tiene privilegios para ejecutar esta acción"));
    
    $sql =  "SELECT     R.id, R.dsc, R.abbr, R.status, M.id munid, M.dsc mundsc, S.id staid, S.dsc stadsc, " . 
            "           IFNULL(R.distances, '[]') distances, " .
            "           R.createdat created, DATE_FORMAT(R.createdat, '%d/%m/%Y %h:%i %p') createdfmt, " .
            "           R.modifiedat modified, DATE_FORMAT(R.modifiedat, '%d/%m/%Y %h:%i %p') modifiedfmt " .
            "FROM       racecourses R " .
            "INNER JOIN municipalities M " .
            "ON         R.municipalityid = M.id " . 
            "INNER JOIN states S " .
            "ON         M.stateid = S.id " . 
            "WHERE      R.id=  " . $id;
    if (!$rs = $db->query($sql))
        badEnd("500", array("sql"=>$sql, "msg"=>$db->error));

    $out = new stdClass;
    if ($row = $rs->fetch_assoc()){
        // completar distancias
        $distances = (array) json_decode($row["distances"]);
        $distnew = array();
        foreach($distances as $distance){
            // revisar que no exista en ninguna carrera para permitir su borrado
            $sql2 = "SELECT     1 " .
                    "FROM       races R " . 
                    "INNER JOIN reunions RE " .
                    "ON         R.reunionid=RE.id " . 
                    "WHERE      RE.racecourseid=" . $id . " " . 
                    "AND        R.distanceid=" . $distance->id;
            if (!$rs2 = $db->query($sql2))
                badEnd("500", array("sql"=>$sql2, "msg"=>$db->error));
            if ($row2 = $rs2->fetch_assoc()){
                $deletable = false;
            }else{
                $deletable = true;
            }

            // buscar nombre de la distancia
            $sql2 = "SELECT dsc, status FROM distances WHERE id='" . $distance->id . "'";
            if (!$rs2 = $db->query($sql2))
                badEnd("500", array("sql"=>$sql2, "msg"=>$db->error));
            if ($row2 = $rs2->fetch_assoc())
                $distnew[] = array( "id"=>$distance->id,
                                    "name"=>$row2["dsc"],
                                    "besttime"=>$distance->besttime*1,
                                    "recorddate"=>$distance->recorddate,
                                    "status"=>(boolean)$row2["status"]=="1",
                                    "deletable"=>(boolean)$deletable,
                                );
            else
                $distnew[] = array("id"=>$distance->id,"name"=>"No encontrado","besttime"=>0,"recorddate"=>"2000-01-01","status"=>false,"deletable"=>(boolean)$deletable);
        }

        $entry = new stdClass;
        $entry->id = (integer) $row["id"];
        $entry->name = $row["dsc"];
        $entry->abbr = $row["abbr"];
        $entry->status = new stdClass;
        $entry->status->id = (integer) $row["status"];
        $entry->status->name = $entry->status->id==0 ? "Inactivo" : "Activo";
        $entry->municipality = new stdClass;
        $entry->municipality->id = (integer) $row["munid"];
        $entry->municipality->name = $row["mundsc"];
        $entry->state = new stdClass;
        $entry->state->id = (integer) $row["staid"];
        $entry->state->name = $row["stadsc"];
        $entry->created = new stdClass;
        $entry->created->date = $row["created"];
        $entry->created->formatted = $row["createdfmt"];
        $entry->modified = new stdClass;
        $entry->modified->date = $row["modified"];
        $entry->modified->formatted = $row["modifiedfmt"];
        $entry->distances = $distnew; //json_decode($row["distances"]);
    }else{
        badEnd("204", array("msg"=>"No se encuentra el registro"));
    }

    $out->entry = $entry;

    $access = array();
    $access["create"] = tienePrivilegio($db, $sessionid, 322);
    $access["delete"] = tienePrivilegio($db, $sessionid, 323);
    $access["update"] = tienePrivilegio($db, $sessionid, 321);
    $access["read"] =   tienePrivilegio($db, $sessionid, 320);
    $out->privileges = $access;

    header("HTTP/1.1 200");
    echo (json_encode($out));
    die();
?>