<?php
    header("Content-Type:application/json");
    header("Access-Control-Allow-Origin: http://localhost:5500");
    include("../../settings/dbconn.php");
    include("../../settings/utils.php");

    // forzar a que se haga un POST y no un GET
    if ($_SERVER['REQUEST_METHOD']!= "POST")
        badEnd("400", array("msg"=>"Debe llamarse al servicio usando un POST"));

    // parametros obligatorios
    $parmsob = array("magazineid", "sessionid");
    if (!parametrosValidos($_REQUEST, $parmsob))
        badEnd("400", array("msg"=>"Parametros obligatorios " . implode(", ", $parmsob)));
    
    $sessionid = preg_replace("/[^a-zA-Z0-9]+/", "", $_REQUEST["sessionid"]);
    $magazineid = intval($_REQUEST["magazineid"]);

    isSessionValid($db, $sessionid);

    //if (!tienePrivilegio($db, $sessionid, 710, false))
    //    badEnd("403", array("msg"=>"No tiene privilegios para ejecutar esta acción"));

    // buscar directorio de la revista
    $sql =  "SELECT     M.dir " .
            "FROM       magazines M " .
            "WHERE      id=" . $magazineid;
    if (!$rs = $db->query($sql))
        badEnd("500", array("errlog"=>1, "sql"=>$sql, "msg"=>$db->error));
    if (!$row = $rs->fetch_assoc())
        badEnd("409", array("msg"=>"No se encontró la revista"));
    if (strlen($row["dir"])==0)
        badEnd("404", array("msg"=>"Revista sin formatos"));

    $out = new stdClass;
    //$out->scan = "../outputs/" . $row["dir"] . "/";
    $files = scandir("../outputs/" . $row["dir"] . "/");
    $formats = array();
    foreach($files as $file){
        $format = new stdClass;
        $format->dsc = str_replace(".php", "", str_replace("_", " ", $file));
        $format->call = "outputs/" . $row["dir"] . "/" . $file;
        if ($file != "." && $file != ".." && $file != "error_log" && $file != "test.php")
            $formats[] = $format;
    }


    $out->records = $formats;

    header("HTTP/1.1 200");
    echo (json_encode($out));
    die();
?>